// Generated by SolidPython 1.0.5 on 2021-06-01 16:29:02


union() {
	linear_extrude(center = true, height = 1) {
		polygon(points = [[0.0000000000, 0.0000000000], [-0.0215000000, 0.1045000000], [0.0080000000, 0.2160000000], [0.0795000000, 0.3315000000], [0.1840000000, 0.4480000000], [0.3125000000, 0.5625000000], [0.4560000000, 0.6720000000], [0.6055000000, 0.7735000000], [0.7520000000, 0.8640000000], [0.8865000000, 0.9405000000], [1.0000000000, 1.0000000000], [1.1045000000, 1.0495000000], [1.2160000000, 1.0960000000], [1.3315000000, 1.1365000000], [1.4480000000, 1.1680000000], [1.5625000000, 1.1875000000], [1.6720000000, 1.1920000000], [1.7735000000, 1.1785000000], [1.8640000000, 1.1440000000], [1.9405000000, 1.0855000000], [2.0000000000, 1.0000000000], [2.0495000000, 0.8675000000], [2.0960000000, 0.6800000000], [2.1365000000, 0.4525000000], [2.1680000000, 0.2000000000], [2.1875000000, -0.0625000000], [2.1920000000, -0.3200000000], [2.1785000000, -0.5575000000], [2.1440000000, -0.7600000000], [2.0855000000, -0.9125000000], [2.0000000000, -1.0000000000], [1.8675000000, -1.0215000000], [1.6800000000, -0.9920000000], [1.4525000000, -0.9205000000], [1.2000000000, -0.8160000000], [0.9375000000, -0.6875000000], [0.6800000000, -0.5440000000], [0.4425000000, -0.3945000000], [0.2400000000, -0.2480000000], [0.0875000000, -0.1135000000], [0.0000000000, 0.0000000000]]);
	}
	translate(v = [3, 0, 0]) {
		union() {
			linear_extrude(center = true, height = 5) {
				polygon(points = [[0.0000000000, 0.0000000000], [-0.0176875000, 0.0511875000], [-0.0215000000, 0.1045000000], [-0.0125625000, 0.1595625000], [0.0080000000, 0.2160000000], [0.0390625000, 0.2734375000], [0.0795000000, 0.3315000000], [0.1281875000, 0.3898125000], [0.1840000000, 0.4480000000], [0.2458125000, 0.5056875000], [0.3125000000, 0.5625000000], [0.3829375000, 0.6180625000], [0.4560000000, 0.6720000000], [0.5305625000, 0.7239375000], [0.6055000000, 0.7735000000], [0.6796875000, 0.8203125000], [0.7520000000, 0.8640000000], [0.8213125000, 0.9041875000], [0.8865000000, 0.9405000000], [0.9464375000, 0.9725625000], [1.0000000000, 1.0000000000], [1.0511875000, 1.0249375000], [1.1045000000, 1.0495000000], [1.1595625000, 1.0733125000], [1.2160000000, 1.0960000000], [1.2734375000, 1.1171875000], [1.3315000000, 1.1365000000], [1.3898125000, 1.1535625000], [1.4480000000, 1.1680000000], [1.5056875000, 1.1794375000], [1.5625000000, 1.1875000000], [1.6180625000, 1.1918125000], [1.6720000000, 1.1920000000], [1.7239375000, 1.1876875000], [1.7735000000, 1.1785000000], [1.8203125000, 1.1640625000], [1.8640000000, 1.1440000000], [1.9041875000, 1.1179375000], [1.9405000000, 1.0855000000], [1.9725625000, 1.0463125000], [2.0000000000, 1.0000000000], [2.0249375000, 0.9415625000], [2.0495000000, 0.8675000000], [2.0733125000, 0.7796875000], [2.0960000000, 0.6800000000], [2.1171875000, 0.5703125000], [2.1365000000, 0.4525000000], [2.1535625000, 0.3284375000], [2.1680000000, 0.2000000000], [2.1794375000, 0.0690625000], [2.1875000000, -0.0625000000], [2.1918125000, -0.1928125000], [2.1920000000, -0.3200000000], [2.1876875000, -0.4421875000], [2.1785000000, -0.5575000000], [2.1640625000, -0.6640625000], [2.1440000000, -0.7600000000], [2.1179375000, -0.8434375000], [2.0855000000, -0.9125000000], [2.0463125000, -0.9653125000], [2.0000000000, -1.0000000000], [1.9415625000, -1.0176875000], [1.8675000000, -1.0215000000], [1.7796875000, -1.0125625000], [1.6800000000, -0.9920000000], [1.5703125000, -0.9609375000], [1.4525000000, -0.9205000000], [1.3284375000, -0.8718125000], [1.2000000000, -0.8160000000], [1.0690625000, -0.7541875000], [0.9375000000, -0.6875000000], [0.8071875000, -0.6170625000], [0.6800000000, -0.5440000000], [0.5578125000, -0.4694375000], [0.4425000000, -0.3945000000], [0.3359375000, -0.3203125000], [0.2400000000, -0.2480000000], [0.1565625000, -0.1786875000], [0.0875000000, -0.1135000000], [0.0346875000, -0.0535625000], [0.0000000000, 0.0000000000]]);
			}
			color(alpha = 1.0000000000, c = [1, 0, 0]) {
				translate(v = [0, 0, 0]) {
					cylinder(center = true, h = 5.5000000000, r = 0.1000000000);
				}
				translate(v = [1, 1, 0]) {
					cylinder(center = true, h = 5.5000000000, r = 0.1000000000);
				}
				translate(v = [2, 1, 0]) {
					cylinder(center = true, h = 5.5000000000, r = 0.1000000000);
				}
				translate(v = [2, -1, 0]) {
					cylinder(center = true, h = 5.5000000000, r = 0.1000000000);
				}
			}
		}
	}
	translate(v = [0, -4, 0]) {
		union() {
			polygon(points = [[0.0000000000, 0.0000000000], [-0.0215000000, 0.1045000000], [0.0080000000, 0.2160000000], [0.0795000000, 0.3315000000], [0.1840000000, 0.4480000000], [0.3125000000, 0.5625000000], [0.4560000000, 0.6720000000], [0.6055000000, 0.7735000000], [0.7520000000, 0.8640000000], [0.8865000000, 0.9405000000], [1.0000000000, 1.0000000000], [1.1045000000, 1.0495000000], [1.2160000000, 1.0960000000], [1.3315000000, 1.1365000000], [1.4480000000, 1.1680000000], [1.5625000000, 1.1875000000], [1.6720000000, 1.1920000000], [1.7735000000, 1.1785000000], [1.8640000000, 1.1440000000], [1.9405000000, 1.0855000000], [2.0000000000, 1.0000000000], [2.0495000000, 0.8675000000], [2.0960000000, 0.6800000000], [2.1365000000, 0.4525000000], [2.1680000000, 0.2000000000], [2.1875000000, -0.0625000000], [2.1920000000, -0.3200000000], [2.1785000000, -0.5575000000], [2.1440000000, -0.7600000000], [2.0855000000, -0.9125000000], [2.0000000000, -1.0000000000], [1.8675000000, -1.0215000000], [1.6800000000, -0.9920000000], [1.4525000000, -0.9205000000], [1.2000000000, -0.8160000000], [0.9375000000, -0.6875000000], [0.6800000000, -0.5440000000], [0.4425000000, -0.3945000000], [0.2400000000, -0.2480000000], [0.0875000000, -0.1135000000], [0.0000000000, 0.0000000000]]);
			color(alpha = 1.0000000000, c = [1, 0, 0]) {
				translate(v = [0, 0, 0]) {
					circle(r = 0.1000000000);
				}
				translate(v = [1, 1, 0]) {
					circle(r = 0.1000000000);
				}
				translate(v = [2, 1, 0]) {
					circle(r = 0.1000000000);
				}
				translate(v = [2, -1, 0]) {
					circle(r = 0.1000000000);
				}
			}
			translate(v = [3, 0, 0]) {
				union() {
					polygon(points = [[0.0000000000, 0.0000000000], [0.0190000000, 0.0235000000], [0.0720000000, 0.0880000000], [0.1530000000, 0.1845000000], [0.2560000000, 0.3040000000], [0.3750000000, 0.4375000000], [0.5040000000, 0.5760000000], [0.6370000000, 0.7105000000], [0.7680000000, 0.8320000000], [0.8910000000, 0.9315000000], [1.0000000000, 1.0000000000], [1.1045000000, 1.0495000000], [1.2160000000, 1.0960000000], [1.3315000000, 1.1365000000], [1.4480000000, 1.1680000000], [1.5625000000, 1.1875000000], [1.6720000000, 1.1920000000], [1.7735000000, 1.1785000000], [1.8640000000, 1.1440000000], [1.9405000000, 1.0855000000], [2.0000000000, 1.0000000000], [2.0405000000, 0.8630000000], [2.0640000000, 0.6640000000], [2.0735000000, 0.4210000000], [2.0720000000, 0.1520000000], [2.0625000000, -0.1250000000], [2.0480000000, -0.3920000000], [2.0315000000, -0.6310000000], [2.0160000000, -0.8240000000], [2.0045000000, -0.9530000000], [2.0000000000, -1.0000000000]]);
					color(alpha = 1.0000000000, c = [1, 0, 0]) {
						translate(v = [0, 0, 0]) {
							circle(r = 0.1000000000);
						}
						translate(v = [1, 1, 0]) {
							circle(r = 0.1000000000);
						}
						translate(v = [2, 1, 0]) {
							circle(r = 0.1000000000);
						}
						translate(v = [2, -1, 0]) {
							circle(r = 0.1000000000);
						}
					}
				}
			}
			translate(v = [10, 0, 0]) {
				union() {
					polygon(points = [[0.0000000000, 0.0000000000], [0.1405000000, 0.0640000000], [0.2640000000, 0.1520000000], [0.3735000000, 0.2580000000], [0.4720000000, 0.3760000000], [0.5625000000, 0.5000000000], [0.6480000000, 0.6240000000], [0.7315000000, 0.7420000000], [0.8160000000, 0.8480000000], [0.9045000000, 0.9360000000], [1.0000000000, 1.0000000000], [1.1045000000, 1.0495000000], [1.2160000000, 1.0960000000], [1.3315000000, 1.1365000000], [1.4480000000, 1.1680000000], [1.5625000000, 1.1875000000], [1.6720000000, 1.1920000000], [1.7735000000, 1.1785000000], [1.8640000000, 1.1440000000], [1.9405000000, 1.0855000000], [2.0000000000, 1.0000000000], [2.0270000000, 0.8720000000], [2.0160000000, 0.6960000000], [1.9790000000, 0.4840000000], [1.9280000000, 0.2480000000], [1.8750000000, 0.0000000000], [1.8320000000, -0.2480000000], [1.8110000000, -0.4840000000], [1.8240000000, -0.6960000000], [1.8830000000, -0.8720000000], [2.0000000000, -1.0000000000]]);
					color(alpha = 1.0000000000, c = [1, 0, 0]) {
						translate(v = [-2, 0, 0]) {
							circle(r = 0.1000000000);
						}
						translate(v = [0, 0, 0]) {
							circle(r = 0.1000000000);
						}
						translate(v = [1, 1, 0]) {
							circle(r = 0.1000000000);
						}
						translate(v = [2, 1, 0]) {
							circle(r = 0.1000000000);
						}
						translate(v = [2, -1, 0]) {
							circle(r = 0.1000000000);
						}
						translate(v = [5, -1, 0]) {
							circle(r = 0.1000000000);
						}
					}
				}
			}
		}
	}
	translate(v = [0, -12, 0]) {
		union() {
			polygon(points = [[0, 6], [0.4000000000, 6.0000000000], [0.4000000000, 5.9998000000], [0.4000000000, 5.9984000000], [0.4000000000, 5.9946000000], [0.4000000000, 5.9872000000], [0.4000000000, 5.9750000000], [0.4000000000, 5.9568000000], [0.4000000000, 5.9314000000], [0.4000000000, 5.8976000000], [0.4000000000, 5.8542000000], [0.4000000000, 5.8000000000], [0.3973000000, 5.7324000000], [0.3904000000, 5.6512000000], [0.3811000000, 5.5588000000], [0.3712000000, 5.4576000000], [0.3625000000, 5.3500000000], [0.3568000000, 5.2384000000], [0.3559000000, 5.1252000000], [0.3616000000, 5.0128000000], [0.3757000000, 4.9036000000], [0.4000000000, 4.8000000000], [0.4384000000, 4.7058500000], [0.4912000000, 4.6208000000], [0.5548000000, 4.5409500000], [0.6256000000, 4.4624000000], [0.7000000000, 4.3812500000], [0.7744000000, 4.2936000000], [0.8452000000, 4.1955500000], [0.9088000000, 4.0832000000], [0.9616000000, 3.9526500000], [1.0000000000, 3.8000000000], [1.0243000000, 3.6168000000], [1.0384000000, 3.4024000000], [1.0441000000, 3.1646000000], [1.0432000000, 2.9112000000], [1.0375000000, 2.6500000000], [1.0288000000, 2.3888000000], [1.0189000000, 2.1354000000], [1.0096000000, 1.8976000000], [1.0027000000, 1.6832000000], [1.0000000000, 1.5000000000], [1.0022500000, 1.3451000000], [1.0080000000, 1.2088000000], [1.0157500000, 1.0887000000], [1.0240000000, 0.9824000000], [1.0312500000, 0.8875000000], [1.0360000000, 0.8016000000], [1.0367500000, 0.7223000000], [1.0320000000, 0.6472000000], [1.0202500000, 0.5739000000], [1.0000000000, 0.5000000000], [0.9702500000, 0.4275000000], [0.9320000000, 0.3600000000], [0.8867500000, 0.2975000000], [0.8360000000, 0.2400000000], [0.7812500000, 0.1875000000], [0.7240000000, 0.1400000000], [0.6657500000, 0.0975000000], [0.6080000000, 0.0600000000], [0.5522500000, 0.0275000000], [0.5000000000, 0.0000000000], [0.4455000000, -0.0202500000], [0.3840000000, -0.0320000000], [0.3185000000, -0.0367500000], [0.2520000000, -0.0360000000], [0.1875000000, -0.0312500000], [0.1280000000, -0.0240000000], [0.0765000000, -0.0157500000], [0.0360000000, -0.0080000000], [0.0095000000, -0.0022500000], [0.0000000000, 0.0000000000]]);
			mirror(v = [1, 0]) {
				polygon(points = [[0, 6], [0.4000000000, 6.0000000000], [0.4000000000, 5.9998000000], [0.4000000000, 5.9984000000], [0.4000000000, 5.9946000000], [0.4000000000, 5.9872000000], [0.4000000000, 5.9750000000], [0.4000000000, 5.9568000000], [0.4000000000, 5.9314000000], [0.4000000000, 5.8976000000], [0.4000000000, 5.8542000000], [0.4000000000, 5.8000000000], [0.3973000000, 5.7324000000], [0.3904000000, 5.6512000000], [0.3811000000, 5.5588000000], [0.3712000000, 5.4576000000], [0.3625000000, 5.3500000000], [0.3568000000, 5.2384000000], [0.3559000000, 5.1252000000], [0.3616000000, 5.0128000000], [0.3757000000, 4.9036000000], [0.4000000000, 4.8000000000], [0.4384000000, 4.7058500000], [0.4912000000, 4.6208000000], [0.5548000000, 4.5409500000], [0.6256000000, 4.4624000000], [0.7000000000, 4.3812500000], [0.7744000000, 4.2936000000], [0.8452000000, 4.1955500000], [0.9088000000, 4.0832000000], [0.9616000000, 3.9526500000], [1.0000000000, 3.8000000000], [1.0243000000, 3.6168000000], [1.0384000000, 3.4024000000], [1.0441000000, 3.1646000000], [1.0432000000, 2.9112000000], [1.0375000000, 2.6500000000], [1.0288000000, 2.3888000000], [1.0189000000, 2.1354000000], [1.0096000000, 1.8976000000], [1.0027000000, 1.6832000000], [1.0000000000, 1.5000000000], [1.0022500000, 1.3451000000], [1.0080000000, 1.2088000000], [1.0157500000, 1.0887000000], [1.0240000000, 0.9824000000], [1.0312500000, 0.8875000000], [1.0360000000, 0.8016000000], [1.0367500000, 0.7223000000], [1.0320000000, 0.6472000000], [1.0202500000, 0.5739000000], [1.0000000000, 0.5000000000], [0.9702500000, 0.4275000000], [0.9320000000, 0.3600000000], [0.8867500000, 0.2975000000], [0.8360000000, 0.2400000000], [0.7812500000, 0.1875000000], [0.7240000000, 0.1400000000], [0.6657500000, 0.0975000000], [0.6080000000, 0.0600000000], [0.5522500000, 0.0275000000], [0.5000000000, 0.0000000000], [0.4455000000, -0.0202500000], [0.3840000000, -0.0320000000], [0.3185000000, -0.0367500000], [0.2520000000, -0.0360000000], [0.1875000000, -0.0312500000], [0.1280000000, -0.0240000000], [0.0765000000, -0.0157500000], [0.0360000000, -0.0080000000], [0.0095000000, -0.0022500000], [0.0000000000, 0.0000000000]]);
			}
			color(alpha = 1.0000000000, c = [1, 0, 0]) {
				translate(v = [0.4000000000, 6, 0]) {
					circle(r = 0.0500000000);
				}
				translate(v = [0.4000000000, 5.8000000000, 0]) {
					circle(r = 0.0500000000);
				}
				translate(v = [0.4000000000, 4.8000000000, 0]) {
					circle(r = 0.0500000000);
				}
				translate(v = [1.0000000000, 3.8000000000, 0]) {
					circle(r = 0.0500000000);
				}
				translate(v = [1.0000000000, 1.5000000000, 0]) {
					circle(r = 0.0500000000);
				}
				translate(v = [1.0000000000, 0.5000000000, 0]) {
					circle(r = 0.0500000000);
				}
				translate(v = [0.5000000000, 0, 0]) {
					circle(r = 0.0500000000);
				}
				translate(v = [0, 0, 0]) {
					circle(r = 0.0500000000);
				}
			}
		}
	}
	translate(v = [0, -16, 0]) {
		union() {
			linear_extrude(center = true, height = 1) {
				polygon(points = [[0.0000000000, 3.0000000000], [0.3000000000, 2.4600000000], [0.6000000000, 2.0400000000], [0.9000000000, 1.7400000000], [1.2000000000, 1.5600000000], [1.5000000000, 1.5000000000], [1.8000000000, 1.5600000000], [2.1000000000, 1.7400000000], [2.4000000000, 2.0400000000], [2.7000000000, 2.4600000000], [3.0000000000, 3.0000000000]]);
			}
			color(alpha = 1.0000000000, c = [1, 0, 0]) {
				translate(v = [0, 3, 0]) {
					cylinder(center = true, h = 1.1000000000, r = 0.1000000000);
				}
				translate(v = [1, 1, 0]) {
					cylinder(center = true, h = 1.1000000000, r = 0.1000000000);
				}
				translate(v = [2, 1, 0]) {
					cylinder(center = true, h = 1.1000000000, r = 0.1000000000);
				}
				translate(v = [3, 3, 0]) {
					cylinder(center = true, h = 1.1000000000, r = 0.1000000000);
				}
			}
		}
	}
	translate(v = [0, -20, 0]) {
		union() {
			polygon(points = [[0.0000000000, 0.0000000000], [0.1500000000, 0.2636250000], [0.3000000000, 0.4590000000], [0.4500000000, 0.5928750000], [0.6000000000, 0.6720000000], [0.7500000000, 0.7031250000], [0.9000000000, 0.6930000000], [1.0500000000, 0.6483750000], [1.2000000000, 0.5760000000], [1.3500000000, 0.4826250000], [1.5000000000, 0.3750000000], [1.6500000000, 0.2598750000], [1.8000000000, 0.1440000000], [1.9500000000, 0.0341250000], [2.1000000000, -0.0630000000], [2.2500000000, -0.1406250000], [2.4000000000, -0.1920000000], [2.5500000000, -0.2103750000], [2.7000000000, -0.1890000000], [2.8500000000, -0.1211250000], [3.0000000000, 0.0000000000], [2, -2], [1, -2]]);
			color(alpha = 1.0000000000, c = [1, 0, 0]) {
				translate(v = [0, 0, 0]) {
					circle(r = 0.1500000000);
				}
				translate(v = [1, 2, 0]) {
					circle(r = 0.1500000000);
				}
				translate(v = [2, -1, 0]) {
					circle(r = 0.1500000000);
				}
				translate(v = [3, 0, 0]) {
					circle(r = 0.1500000000);
				}
			}
		}
	}
}
/***********************************************
*********      SolidPython code:      **********
************************************************
 
#! /usr/bin/env python
import os
import sys
from solid import *
from solid.utils import Red, right, forward, back

from solid.splines import catmull_rom_points, catmull_rom_polygon, control_points
from solid.splines import bezier_polygon, bezier_points
from euclid3 import Vector2, Vector3, Point2, Point3

def assembly():
    # Catmull-Rom Splines
    a = basic_catmull_rom()                         # Top row in OpenSCAD output
    a += back(4)(catmull_rom_spline_variants())     # Row 2
    a += back(12)(bottle_shape(width=2, height=6))  # Row 3, the bottle shape

    # # TODO: include examples for 3D surfaces:
    # a += back(16)(catmull_rom_patches())
    # a += back(20)(catmull_rom_prism())
    # a += back(24)(catmull_rom_prism_smooth())

    # Bezier Splines
    a += back(16)(basic_bezier())                   # Row 4
    a += back(20)(bezier_points_variants())         # Row 5
    return a

def basic_catmull_rom():
    points = [
        Point2(0,0),
        Point2(1,1),
        Point2(2,1),
        Point2(2,-1),
    ]
    # In its simplest form, catmull_rom_polygon() will just make a C1-continuous
    # closed shape. Easy.
    shape_easy = catmull_rom_polygon(points)
    # There are some other options as well...
    shape = catmull_rom_polygon(points, subdivisions=20, extrude_height=5, show_controls=True)
    return shape_easy + right(3)(shape)

def catmull_rom_spline_variants():
    points = [
        Point2(0,0),
        Point2(1,1),
        Point2(2,1),
        Point2(2,-1),
    ]
    controls = control_points(points)

    # By default, catmull_rom_points() will return a closed smooth shape
    curve_points_closed = catmull_rom_points(points, close_loop=True)

    # If `close_loop` is False, it will return only points between the start and
    # end control points, and make a best guess about tangents for the first and last segments
    curve_points_open   = catmull_rom_points(points, close_loop=False)
    
    # By specifying start_tangent and end_tangent, you can change a shape 
    # significantly. This is similar to what you might do with Illustrator's Pen Tool.
    # Try changing these vectors to see the effects this has on the rightmost curve in the example
    start_tangent = Vector2(-2, 0)
    end_tangent = Vector2(3, 0)
    tangent_pts = [points[0] + start_tangent, *points, points[-1] + end_tangent]
    tangent_controls = control_points(tangent_pts)
    curve_points_tangents = catmull_rom_points(points, close_loop=False, 
                                start_tangent=start_tangent, end_tangent=end_tangent)

    closed = polygon(curve_points_closed) + controls
    opened = polygon(curve_points_open) + controls
    tangents = polygon(curve_points_tangents) + tangent_controls

    a = closed + right(3)(opened) + right(10)(tangents)

    return a

def catmull_rom_patches():
    # TODO: write this
    pass

def catmull_rom_prism():
    # TODO: write this
    pass

def catmull_rom_prism_smooth():
    # TODO: write this
    pass

def bottle_shape(width: float, height: float, neck_width:float=None, neck_height:float=None):
    if neck_width == None:
        neck_width = width * 0.4
    
    if neck_height == None:
        neck_height = height * 0.2

    w2 = width/2
    nw2 = neck_width/2
    h = height
    nh = neck_height

    corner_rad = 0.5

    # Add extra tangent points near curves to keep cubics from going crazy. 
    # Try taking some of these out and see how this affects the final shape
    points = [
        Point2(nw2, h),
        Point2(nw2, h-nh + 1),      # <- extra tangent
        Point2(nw2, h - nh),    
        Point2(w2, h-nh-h/6),       # <- extra tangent
        Point2(w2, corner_rad + 1), # <- extra tangent
        Point2(w2, corner_rad),
        Point2(w2-corner_rad, 0),
        Point2(0,0),
    ]
    # Use catmull_rom_points() when you don't want all corners in a polygon 
    # smoothed out or want to combine the curve with other shapes. 
    # Extra points can then be added to the list you get back
    cr_points = catmull_rom_points(points)

    # Insert a point at the top center of the bottle at the beginning of the 
    # points list. This is how the bottle has a sharp right angle corner at the 
    # sides of the neck; otherwise we'd have to insert several extra control 
    # points to make a sharp corner
    cr_points.insert(0, (0,h))
    
    # Make OpenSCAD polygons out of the shapes once all points are calculated
    a = polygon(cr_points) 
    a += mirror(v=(1,0))(a)

    # Show control points. These aren't required for anything, but seeing them
    # makes refining a curve much easier
    controls = control_points(points)
    a += controls
    return a

def basic_bezier():
    # A basic cubic Bezier curve will pass through its first and last 
    # points, but not through the central control points
    controls = [
        Point2(0, 3),
        Point2(1, 1),
        Point2(2, 1),
        Point2(3, 3)
    ]
    shape = bezier_polygon(controls, show_controls=True)
    return shape

def bezier_points_variants():
    controls = [
        Point2(0,0),
        Point2(1,2),
        Point2(2, -1),
        Point2(3,0),
    ]
    points = bezier_points(controls, subdivisions=20)
    # For non-smooth curves, add extra points
    points += [
        Point2(2, -2),
        Point2(1, -2)
    ]
    shape = polygon(points) + control_points(controls, extrude_height=0)
    return shape


if __name__ == '__main__':
    out_dir = sys.argv[1] if len(sys.argv) > 1 else os.curdir

    a = assembly()

    out_path = scad_render_to_file(a, out_dir=out_dir, include_orig_code=True)
    print(f"{__file__}: SCAD file written to: \n{out_path}")

 
 
************************************************/
