#! /usr/bin/env python

from solid2 import cube, sphere

# Since I don't like the OpenSCAD syntax I added "access-style" syntax. This
# allows to call all OpenSCAD builtin transformations, the convenience
# functions (up, down, left,...) and the modifiers (debug, background, ...) as
# if you would call a member function.
#
#       cube(10).up(5)
#
# is equivalent to
#
#       up(5)(cube(10))

c = cube(10, 20, 30).\
        down(5).\
            rotate(45, 45, 45)

s = ~sphere(10).forward(5)

(c-s).save_as_scad()

# generates exactly the same code as 04-convenience.py:
#
#    // Generated by ExpSolidPython
#
#    difference() {
#            rotate(a = [45, 45, 45]) {
#                    translate(v = [0, 0, -5]) {
#                            cube(size = [10, 20, 30]);
#                    };
#            };
#            #translate(v = [0, 5, 0]) {
#                    sphere(r = 10);
#            };
#    };

