# songtradr-api-client-python
This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.

You can also use the API to manage your account and musicube cloud data.

**Authentication**

1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.

2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.

3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.

**Rate Limiting**

The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.

**Getting Started with auto-tagging**

1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file.
2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint.
3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.

**Getting Started with search**

You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.

1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters.
2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.12.21
- Package version: 0.0.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://songtradr.com](https://songtradr.com)

## Requirements.

Python &gt;&#x3D;3.7

## Migration from other generators like python and python-legacy

### Changes
1. This generator uses spec case for all (object) property names and parameter names.
    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case
    - So you will need to update how you input and read properties to use spec case
2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)
    - So you will need to update how you pass data in to endpoints
3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers
    - So you will need to update your code to use response.body to access deserialized data
4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO
    - This means that you can use isinstance to check if a payload validated against a schema class
    - This means that no data will be of type None/True/False
        - ingested None will subclass NoneClass
        - ingested True will subclass BoolClass
        - ingested False will subclass BoolClass
        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()
5. All validated class instances are immutable except for ones based on io.File
    - This is because if properties were changed after validation, that validation would no longer apply
    - So no changing values or property values after a class has been instantiated
6. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use accessor functions on the instance
    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg
    - type number + format: See .as_float_oapg, .as_int_oapg
    - this was done because openapi/json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg
    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg
7. Property access on AnyType(type unset) or object(dict) schemas
    - Only required keys with valid python names are properties like .someProp and have type hints
    - All optional keys may not exist, so properties are not defined for them
    - One can access optional values with dict_instance['optionalProp'] and KeyError will be raised if it does not exist
    - Use get_item_oapg if you need a way to always get a value whether or not the key exists
        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg('optionalProp')
        - All required and optional keys have type hints for this method, and @typing.overload is used
        - A type hint is also generated for additionalProperties accessed using this method
    - So you will need to update you code to use some_instance['optionalProp'] to access optional property
    and additionalProperty values
8. The location of the api classes has changed
    - Api classes are located in your_package.apis.tags.some_api
    - This change was made to eliminate redundant code generation
    - Legacy generators generated the same endpoint twice if it had > 1 tag on it
    - This generator defines an endpoint in one class, then inherits that class to generate
      apis by tags and by paths
    - This change reduces code and allows quicker run time if you use the path apis
        - path apis are at your_package.apis.paths.some_path
    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api
    - So you will need to update your import paths to the api classes

### Why are Oapg and _oapg used in class and method names?
Classes can have arbitrarily named properties set on them
Endpoints can have arbitrary operationId method names set
For those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions
on protected + public classes/methods.
oapg stands for OpenApi Python Generator.

### Object property spec case
This was done because when payloads are ingested, they can be validated against N number of schemas.
If the input signature used a different property name then that has mutated the payload.
So SchemaA and SchemaB must both see the camelCase spec named variable.
Also it is possible to send in two properties, named camelCase and camel_case in the same payload.
That use case should be support so spec case is used.

### Parameter spec case
Parameters can be included in different locations including:
- query
- path
- header
- cookie

Any of those parameters could use the same parameter names, so if every parameter
was included as an endpoint parameter in a function signature, they would collide.
For that reason, each of those inputs have been separated out into separate typed dictionaries:
- query_params
- path_params
- header_params
- cookie_params

So when updating your code, you will need to pass endpoint parameters in using those
dictionaries.

### Endpoint responses
Endpoint responses have been enriched to now include more information.
Any response reom an endpoint will now include the following properties:
response: urllib3.HTTPResponse
body: typing.Union[Unset, Schema]
headers: typing.Union[Unset, TODO]
Note: response header deserialization has not yet been added


## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import songtradr_api_client_python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import songtradr_api_client_python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import songtradr_api_client_python
from pprint import pprint
from songtradr_api_client_python.apis.tags import allowed_values_api
from songtradr_api_client_python.model.category_medium_dto import CategoryMediumDTO
from songtradr_api_client_python.model.error_response import ErrorResponse
from songtradr_api_client_python.model.genre_dto import GenreDTO
from songtradr_api_client_python.model.search_filter_values_dto import SearchFilterValuesDTO
# Defining the host is optional and defaults to https://api.songtradr.com
# See configuration.py for a list of all supported configuration parameters.
configuration = songtradr_api_client_python.Configuration(
    host = "https://api.songtradr.com"
)


# Enter a context with an instance of the API client
with songtradr_api_client_python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = allowed_values_api.AllowedValuesApi(api_client)
    response_size = "s" # str | Size the response should have. (optional) (default to CodegenParameter{isFormParam=false, isQueryParam=true, isPathParam=false, isHeaderParam=false, isCookieParam=false, isBodyParam=false, isContainer=false, isCollectionFormatMulti=false, isPrimitiveType=true, isModel=false, isExplode=true, baseName='responseSize', paramName='response_size', dataType='str', datatypeWithEnum='Response_sizeEnum', dataFormat='null', collectionFormat='null', description='Size the response should have.', unescapedDescription='Size the response should have.', baseType='null', defaultValue='"s"', enumDefaultValue='"s"', enumName='Response_sizeEnum', style='FORM', deepObject='false', allowEmptyValue='false', example='"s"', jsonSchema='{
  "name" : "responseSize",
  "in" : "query",
  "description" : "Size the response should have.",
  "required" : false,
  "style" : "form",
  "explode" : true,
  "schema" : {
    "type" : "string",
    "default" : "s",
    "enum" : [ "s", "l" ]
  }
}', isString=true, isNumeric=false, isInteger=false, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isPassword=false, isFreeFormObject=false, isAnyType=false, isArray=false, isMap=false, isFile=false, isEnum=true, isEnumRef=true, _enum=[s, l], allowableValues={values=[s, l], enumVars=[{name=S, isString=true, value="s"}, {name=L, isString=true, value="l"}]}, items=null, mostInnerItems=null, additionalProperties=null, vars=[], requiredVars=[], vendorExtensions={}, hasValidation=false, maxProperties=null, minProperties=null, isNullable=false, isDeprecated=false, required=false, maximum='null', exclusiveMaximum=false, minimum='null', exclusiveMinimum=false, maxLength=null, minLength=null, pattern='null', maxItems=null, minItems=null, uniqueItems=false, uniqueItemsBoolean=null, contentType=null, multipleOf=null, isNull=false, isVoid=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, schema=CodegenProperty{openApiType='string', baseName='ResponseSizeSchema', complexType='null', getter='getResponseSize', setter='setResponseSize', description='null', dataType='str', datatypeWithEnum='Response_sizeEnum', dataFormat='null', name='response_size', min='null', max='null', defaultValue='"s"', defaultValueWithParam=' = data.responseSize;', baseType='str', containerType='null', title='null', unescapedDescription='null', maxLength=null, minLength=null, pattern='null', example='"s"', jsonSchema='{
  "type" : "string",
  "default" : "s",
  "enum" : [ "s", "l" ]
}', minimum='null', maximum='null', exclusiveMinimum=false, exclusiveMaximum=false, required=false, deprecated=false, hasMoreNonReadOnly=false, isPrimitiveType=true, isModel=false, isContainer=false, isString=true, isNumeric=false, isInteger=false, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isFile=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isPassword=false, isFreeFormObject=false, isArray=false, isMap=false, isEnum=true, isInnerEnum=true, isEnumRef=true, isAnyType=false, isReadOnly=false, isWriteOnly=false, isNullable=false, isSelfReference=false, isCircularReference=false, isDiscriminator=false, isNew=false, isOverridden=null, _enum=[s, l], allowableValues={enumVars=[{name=S, isString=true, value="s"}, {name=L, isString=true, value="l"}], values=[s, l]}, items=null, additionalProperties=null, vars=[], requiredVars=[], mostInnerItems=null, vendorExtensions={}, hasValidation=false, isInherited=false, discriminatorValue='null', nameInCamelCase='ResponseSize', nameInSnakeCase='null', enumName='Response_sizeEnum', maxItems=null, minItems=null, maxProperties=null, minProperties=null, uniqueItems=false, uniqueItemsBoolean=null, multipleOf=null, isXmlAttribute=false, xmlPrefix='null', xmlName='null', xmlNamespace='null', isXmlWrapped=false, isNull=false, isVoid=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false, isBooleanSchemaTrue=false, isBooleanSchemaFalse=false, format=null, dependentRequired=null, contains=null}, content=null, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false})

    try:
        # Allowed values for music descriptive parameters to be used in the searchAll endpoint.
        api_response = api_instance.allowed_musical_features(response_size=response_size)
        pprint(api_response)
    except songtradr_api_client_python.ApiException as e:
        print("Exception when calling AllowedValuesApi->allowed_musical_features: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.songtradr.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AllowedValuesApi* | [**allowed_musical_features**](docs/apis/tags/AllowedValuesApi.md#allowed_musical_features) | **get** /api/v1/allowedValues/musicalFeatures | Allowed values for music descriptive parameters to be used in the searchAll endpoint.
*AllowedValuesApi* | [**genres**](docs/apis/tags/AllowedValuesApi.md#genres) | **get** /api/v1/allowedValues/genre | Allowed values for genres.
*AllowedValuesApi* | [**tags**](docs/apis/tags/AllowedValuesApi.md#tags) | **get** /api/v1/allowedValues/tag | All descriptive tags inside of tag-categories.
*PartyApi* | [**party**](docs/apis/tags/PartyApi.md#party) | **get** /api/v1/party | Information on a person, group or company.
*PlaylistApi* | [**all_playlists**](docs/apis/tags/PlaylistApi.md#all_playlists) | **get** /api/v1/playlist | All playlists.
*PlaylistApi* | [**create_or_update_playlist**](docs/apis/tags/PlaylistApi.md#create_or_update_playlist) | **post** /api/v1/playlist | Create and edit playlist.
*PlaylistApi* | [**delete_playlist**](docs/apis/tags/PlaylistApi.md#delete_playlist) | **delete** /api/v1/playlist/{songtradrPlaylistGuid} | Delete playlist.
*RecordingApi* | [**recordings_by_ids_with_musical_features**](docs/apis/tags/RecordingApi.md#recordings_by_ids_with_musical_features) | **get** /api/v1/public/recording/{ids}/musicalFeatures | AI generated moods, musical features and more for recordings.
*RecordingApi* | [**recordings_by_ids_with_similarities**](docs/apis/tags/RecordingApi.md#recordings_by_ids_with_similarities) | **get** /api/v1/public/recording/{ids}/similarities | Similar recordings for a list of recordings.
*RecordingApi* | [**recordings_by_ids_with_taggrams**](docs/apis/tags/RecordingApi.md#recordings_by_ids_with_taggrams) | **get** /api/v1/public/recording/{ids}/taggrams | Timeseries of AI generated moods, musical features and more for a list of recordings.
*RecordingApi* | [**recordings_by_ids_with_tagstrengths**](docs/apis/tags/RecordingApi.md#recordings_by_ids_with_tagstrengths) | **get** /api/v1/public/recording/{ids}/tagstrengths | Strengths as numerical representations for AI generated moods, musical features and more for recordings.
*RecordingApi* | [**recordings_large_by_ids**](docs/apis/tags/RecordingApi.md#recordings_large_by_ids) | **get** /api/v1/public/recording/l/{ids} | Recordings by IDs with a large response.
*RecordingApi* | [**recordings_medium_by_ids**](docs/apis/tags/RecordingApi.md#recordings_medium_by_ids) | **get** /api/v1/public/recording/m/{ids} | Recordings by IDs with a medium sized response.
*RecordingApi* | [**recordings_small_by_ids**](docs/apis/tags/RecordingApi.md#recordings_small_by_ids) | **get** /api/v1/public/recording/s/{ids} | Recordings by IDs with a small response.
*RecordingApi* | [**search_recordings**](docs/apis/tags/RecordingApi.md#search_recordings) | **get** /api/v1/public/recording/search | Recordings by contributors, moods, musical features and more.
*RecordingApi* | [**search_recordings_granular**](docs/apis/tags/RecordingApi.md#search_recordings_granular) | **post** /api/v1/public/recording/searchGranular | Recordings by granular search options.
*RecordingApi* | [**search_recordings_granular_abstraction**](docs/apis/tags/RecordingApi.md#search_recordings_granular_abstraction) | **post** /api/v1/public/recording/searchGranularAbstraction | Recordings by abstracted wordings and granular search options.
*UserApi* | [**create_user_referrer**](docs/apis/tags/UserApi.md#create_user_referrer) | **post** /api/v1/user/referrers/new | 
*UserApi* | [**delete_user_file**](docs/apis/tags/UserApi.md#delete_user_file) | **delete** /api/v1/user/file/{objectKey} | Delete file.
*UserApi* | [**edit_me**](docs/apis/tags/UserApi.md#edit_me) | **post** /api/v1/user/me | Edit details for a logged-in user
*UserApi* | [**forgot_password**](docs/apis/tags/UserApi.md#forgot_password) | **post** /api/v1/user/forgot-password | Send a password reset email
*UserApi* | [**initiate_user_file_upload**](docs/apis/tags/UserApi.md#initiate_user_file_upload) | **post** /api/v1/user/file/{name}/initUpload | Initialize a file upload. Responds with an URL where the file can be uploaded.
*UserApi* | [**login**](docs/apis/tags/UserApi.md#login) | **post** /api/v1/user/login | Login to generate a bearer token.
*UserApi* | [**me**](docs/apis/tags/UserApi.md#me) | **get** /api/v1/user/me | Details for a logged-in user
*UserApi* | [**recordings_by_folder_with_taggrams**](docs/apis/tags/UserApi.md#recordings_by_folder_with_taggrams) | **get** /api/v1/user/folder/{folderName}/taggrams | Timeseries of AI generated moods, musical features and more for recordings in your folder.
*UserApi* | [**recordings_by_folder_with_tagstrengths**](docs/apis/tags/UserApi.md#recordings_by_folder_with_tagstrengths) | **get** /api/v1/user/folder/{folderName}/tagstrengths | Strengths as numerical representations for AI generated moods, musical features and more for recordings in your folder.
*UserApi* | [**save_playlist**](docs/apis/tags/UserApi.md#save_playlist) | **post** /api/v1/user/savePlaylist | List, search and create playlist of your own files.
*UserApi* | [**sign_up**](docs/apis/tags/UserApi.md#sign_up) | **post** /api/v1/user/sign-up | Sign up a new user.
*UserApi* | [**token**](docs/apis/tags/UserApi.md#token) | **post** /api/v1/user/token | Generates a new JWT token for the given refresh token
*UserApi* | [**update_password**](docs/apis/tags/UserApi.md#update_password) | **post** /api/v1/user/update-password | Update password by using the password reset token
*UserApi* | [**update_user_file_recording**](docs/apis/tags/UserApi.md#update_user_file_recording) | **post** /api/v1/user/file/{objectKey} | Create and edit metadata of your files.
*UserApi* | [**user_file**](docs/apis/tags/UserApi.md#user_file) | **get** /api/v1/user/file/{objectKey} | Details and a download link for a file.
*UserApi* | [**user_files**](docs/apis/tags/UserApi.md#user_files) | **get** /api/v1/user/files | List and search your own files.
*UserApi* | [**user_files_download**](docs/apis/tags/UserApi.md#user_files_download) | **get** /api/v1/user/filesDownload | Download links for your files
*UserApi* | [**user_files_status**](docs/apis/tags/UserApi.md#user_files_status) | **get** /api/v1/user/filesStatus | Status details for files.
*UserApi* | [**user_files_summary**](docs/apis/tags/UserApi.md#user_files_summary) | **get** /api/v1/user/filesSummary | Summary fo your files.
*UserApi* | [**user_folders**](docs/apis/tags/UserApi.md#user_folders) | **get** /api/v1/user/folders | Your Folders
*UserApi* | [**user_referrers**](docs/apis/tags/UserApi.md#user_referrers) | **get** /api/v1/user/referrers/{username} | 

## Documentation For Models

 - [CategoryMediumDTO](docs/models/CategoryMediumDTO.md)
 - [CategoryMinimalDTO](docs/models/CategoryMinimalDTO.md)
 - [ConfigAccessDTO](docs/models/ConfigAccessDTO.md)
 - [ConfigIdentifierDTO](docs/models/ConfigIdentifierDTO.md)
 - [ContributorTypeDTO](docs/models/ContributorTypeDTO.md)
 - [ErrorResponse](docs/models/ErrorResponse.md)
 - [FieldSummaryDTO](docs/models/FieldSummaryDTO.md)
 - [FileDTO](docs/models/FileDTO.md)
 - [FileListDTO](docs/models/FileListDTO.md)
 - [FileMinimalWithUrlDTO](docs/models/FileMinimalWithUrlDTO.md)
 - [FileSmallDTO](docs/models/FileSmallDTO.md)
 - [FileUploadDTO](docs/models/FileUploadDTO.md)
 - [FileWIthUrlDTO](docs/models/FileWIthUrlDTO.md)
 - [FilesSummaryDTO](docs/models/FilesSummaryDTO.md)
 - [ForgotPasswordDTO](docs/models/ForgotPasswordDTO.md)
 - [GenreDTO](docs/models/GenreDTO.md)
 - [GenreMinimalDTO](docs/models/GenreMinimalDTO.md)
 - [GenresSummaryDTO](docs/models/GenresSummaryDTO.md)
 - [InitPutRecordingAudioDTO](docs/models/InitPutRecordingAudioDTO.md)
 - [JwtTokenDTO](docs/models/JwtTokenDTO.md)
 - [LoginDTO](docs/models/LoginDTO.md)
 - [MusicalFeaturesDTO](docs/models/MusicalFeaturesDTO.md)
 - [PLineDTO](docs/models/PLineDTO.md)
 - [PartyLargeDTO](docs/models/PartyLargeDTO.md)
 - [PartySmallDTO](docs/models/PartySmallDTO.md)
 - [PlaylistLargeDTO](docs/models/PlaylistLargeDTO.md)
 - [ProductMediumDTO](docs/models/ProductMediumDTO.md)
 - [ProductPartyDTO](docs/models/ProductPartyDTO.md)
 - [RecordingForSimilaritySearchDTO](docs/models/RecordingForSimilaritySearchDTO.md)
 - [RecordingGenrePredictionDTO](docs/models/RecordingGenrePredictionDTO.md)
 - [RecordingLargeDTO](docs/models/RecordingLargeDTO.md)
 - [RecordingListDTO](docs/models/RecordingListDTO.md)
 - [RecordingMediumDTO](docs/models/RecordingMediumDTO.md)
 - [RecordingMinimalWithMusicalFeaturesDTO](docs/models/RecordingMinimalWithMusicalFeaturesDTO.md)
 - [RecordingMinimalWithTaggramsDTO](docs/models/RecordingMinimalWithTaggramsDTO.md)
 - [RecordingMinimalWithTagstrengthsDTO](docs/models/RecordingMinimalWithTagstrengthsDTO.md)
 - [RecordingPartyDTO](docs/models/RecordingPartyDTO.md)
 - [RecordingPlaylistDTO](docs/models/RecordingPlaylistDTO.md)
 - [RecordingSmallDTO](docs/models/RecordingSmallDTO.md)
 - [RecordingTagSmallDTO](docs/models/RecordingTagSmallDTO.md)
 - [SaveFileRecordingDTO](docs/models/SaveFileRecordingDTO.md)
 - [SavePlaylistDTO](docs/models/SavePlaylistDTO.md)
 - [SaveRecordingGenreDTO](docs/models/SaveRecordingGenreDTO.md)
 - [SaveRecordingPartyDTO](docs/models/SaveRecordingPartyDTO.md)
 - [SaveRecordingPlaylistDTO](docs/models/SaveRecordingPlaylistDTO.md)
 - [SaveRecordingTagDTO](docs/models/SaveRecordingTagDTO.md)
 - [SaveReferrerDTO](docs/models/SaveReferrerDTO.md)
 - [SaveTaggramsDTO](docs/models/SaveTaggramsDTO.md)
 - [SaveUserDTO](docs/models/SaveUserDTO.md)
 - [SearchFilterValuesDTO](docs/models/SearchFilterValuesDTO.md)
 - [SearchRecordingGranularAbstractionDTO](docs/models/SearchRecordingGranularAbstractionDTO.md)
 - [SearchRecordingGranularDTO](docs/models/SearchRecordingGranularDTO.md)
 - [SignUpDTO](docs/models/SignUpDTO.md)
 - [TagDTO](docs/models/TagDTO.md)
 - [TagSmallDTO](docs/models/TagSmallDTO.md)
 - [TaggramDTO](docs/models/TaggramDTO.md)
 - [TagsSummaryDTO](docs/models/TagsSummaryDTO.md)
 - [TagstrengthDTO](docs/models/TagstrengthDTO.md)
 - [TitleDTO](docs/models/TitleDTO.md)
 - [TokenRequest](docs/models/TokenRequest.md)
 - [TrackToMediumProductDTO](docs/models/TrackToMediumProductDTO.md)
 - [UpdatePasswordDTO](docs/models/UpdatePasswordDTO.md)
 - [UsageDTO](docs/models/UsageDTO.md)
 - [UserDTO](docs/models/UserDTO.md)

## Documentation For Authorization

Authentication schemes defined for the API:
<a id="bearer-jwt"></a>
### bearer-jwt

- **Type**: Bearer authentication (JWT)


## Author

info@songtradr.com
info@songtradr.com
info@songtradr.com
info@songtradr.com
info@songtradr.com

## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in songtradr_api_client_python.apis and songtradr_api_client_python.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from songtradr_api_client_python.apis.default_api import DefaultApi`
- `from songtradr_api_client_python.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import songtradr_api_client_python
from songtradr_api_client_python.apis import *
from songtradr_api_client_python.models import *
```
