# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.  # noqa: E501

    The version of the OpenAPI document: 1.12.21
    Contact: info@songtradr.com
    Generated by: https://openapi-generator.tech
"""

from songtradr_api_client_python.paths.api_v1_user_referrers_new.post import CreateUserReferrer
from songtradr_api_client_python.paths.api_v1_user_file_object_key.delete import DeleteUserFile
from songtradr_api_client_python.paths.api_v1_user_me.post import EditMe
from songtradr_api_client_python.paths.api_v1_user_forgot_password.post import ForgotPassword
from songtradr_api_client_python.paths.api_v1_user_file_name_init_upload.post import InitiateUserFileUpload
from songtradr_api_client_python.paths.api_v1_user_login.post import Login
from songtradr_api_client_python.paths.api_v1_user_me.get import Me
from songtradr_api_client_python.paths.api_v1_user_folder_folder_name_taggrams.get import RecordingsByFolderWithTaggrams
from songtradr_api_client_python.paths.api_v1_user_folder_folder_name_tagstrengths.get import RecordingsByFolderWithTagstrengths
from songtradr_api_client_python.paths.api_v1_user_save_playlist.post import SavePlaylist
from songtradr_api_client_python.paths.api_v1_user_sign_up.post import SignUp
from songtradr_api_client_python.paths.api_v1_user_token.post import Token
from songtradr_api_client_python.paths.api_v1_user_update_password.post import UpdatePassword
from songtradr_api_client_python.paths.api_v1_user_file_object_key.post import UpdateUserFileRecording
from songtradr_api_client_python.paths.api_v1_user_file_object_key.get import UserFile
from songtradr_api_client_python.paths.api_v1_user_files.get import UserFiles
from songtradr_api_client_python.paths.api_v1_user_files_download.get import UserFilesDownload
from songtradr_api_client_python.paths.api_v1_user_files_status.get import UserFilesStatus
from songtradr_api_client_python.paths.api_v1_user_files_summary.get import UserFilesSummary
from songtradr_api_client_python.paths.api_v1_user_folders.get import UserFolders
from songtradr_api_client_python.paths.api_v1_user_referrers_username.get import UserReferrers


class UserApi(
    CreateUserReferrer,
    DeleteUserFile,
    EditMe,
    ForgotPassword,
    InitiateUserFileUpload,
    Login,
    Me,
    RecordingsByFolderWithTaggrams,
    RecordingsByFolderWithTagstrengths,
    SavePlaylist,
    SignUp,
    Token,
    UpdatePassword,
    UpdateUserFileRecording,
    UserFile,
    UserFiles,
    UserFilesDownload,
    UserFilesStatus,
    UserFilesSummary,
    UserFolders,
    UserReferrers,
):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    pass
