# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.  # noqa: E501

    The version of the OpenAPI document: 1.12.21
    Contact: info@songtradr.com
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from songtradr_api_client_python import schemas  # noqa: F401


class SearchRecordingGranularAbstractionDTO(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Timeseries of tags.
    """


    class MetaOapg:
        required = {
            "abstractionName",
        }
        
        class properties:
            
            
            class abstractionName(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "brandarchetypeInnocent": "BRANDARCHETYPE_INNOCENT",
                        "brandarchetypeSage": "BRANDARCHETYPE_SAGE",
                        "brandarchetypeExplorer": "BRANDARCHETYPE_EXPLORER",
                        "brandarchetypeOutlaw": "BRANDARCHETYPE_OUTLAW",
                        "brandarchetypeMagician": "BRANDARCHETYPE_MAGICIAN",
                        "brandarchetypeHero": "BRANDARCHETYPE_HERO",
                        "brandarchetypeLover": "BRANDARCHETYPE_LOVER",
                        "brandarchetypeJester": "BRANDARCHETYPE_JESTER",
                        "brandarchetypeEveryman": "BRANDARCHETYPE_EVERYMAN",
                        "brandarchetypeCaregiver": "BRANDARCHETYPE_CAREGIVER",
                        "brandarchetypeRuler": "BRANDARCHETYPE_RULER",
                        "brandarchetypeCreator": "BRANDARCHETYPE_CREATOR",
                        "brandAttributeCollaborative": "BRAND_ATTRIBUTE_COLLABORATIVE",
                        "brandAttributeHonest": "BRAND_ATTRIBUTE_HONEST",
                        "brandAttributeInnovative": "BRAND_ATTRIBUTE_INNOVATIVE",
                        "brandAttributeCaring": "BRAND_ATTRIBUTE_CARING",
                        "brandAttributeDiverse": "BRAND_ATTRIBUTE_DIVERSE",
                        "brandAttributeTrustworthy": "BRAND_ATTRIBUTE_TRUSTWORTHY",
                        "brandAttributeBold": "BRAND_ATTRIBUTE_BOLD",
                        "brandAttributeFun": "BRAND_ATTRIBUTE_FUN",
                        "brandAttributeCommitted": "BRAND_ATTRIBUTE_COMMITTED",
                        "brandAttributePositive": "BRAND_ATTRIBUTE_POSITIVE",
                        "brandAttributeHuman": "BRAND_ATTRIBUTE_HUMAN",
                        "brandAttributeExcellence": "BRAND_ATTRIBUTE_EXCELLENCE",
                        "brandAttributeCreativity": "BRAND_ATTRIBUTE_CREATIVITY",
                        "brandAttributeRespectful": "BRAND_ATTRIBUTE_RESPECTFUL",
                        "brandAttributeAuthentic": "BRAND_ATTRIBUTE_AUTHENTIC",
                        "brandAttributeConfident": "BRAND_ATTRIBUTE_CONFIDENT",
                        "brandAttributeSafety": "BRAND_ATTRIBUTE_SAFETY",
                        "brandAttributeEncouraging": "BRAND_ATTRIBUTE_ENCOURAGING",
                        "brandAttributeEmpowering": "BRAND_ATTRIBUTE_EMPOWERING",
                        "brandAttributeFamily": "BRAND_ATTRIBUTE_FAMILY",
                        "brandAttributeBalanced": "BRAND_ATTRIBUTE_BALANCED",
                        "brandAttributeUplifting": "BRAND_ATTRIBUTE_UPLIFTING",
                        "brandAttributeFearlessness": "BRAND_ATTRIBUTE_FEARLESSNESS",
                        "brandAttributeImpulsive": "BRAND_ATTRIBUTE_IMPULSIVE",
                    }
                
                @schemas.classproperty
                def BRANDARCHETYPE_INNOCENT(cls):
                    return cls("brandarchetypeInnocent")
                
                @schemas.classproperty
                def BRANDARCHETYPE_SAGE(cls):
                    return cls("brandarchetypeSage")
                
                @schemas.classproperty
                def BRANDARCHETYPE_EXPLORER(cls):
                    return cls("brandarchetypeExplorer")
                
                @schemas.classproperty
                def BRANDARCHETYPE_OUTLAW(cls):
                    return cls("brandarchetypeOutlaw")
                
                @schemas.classproperty
                def BRANDARCHETYPE_MAGICIAN(cls):
                    return cls("brandarchetypeMagician")
                
                @schemas.classproperty
                def BRANDARCHETYPE_HERO(cls):
                    return cls("brandarchetypeHero")
                
                @schemas.classproperty
                def BRANDARCHETYPE_LOVER(cls):
                    return cls("brandarchetypeLover")
                
                @schemas.classproperty
                def BRANDARCHETYPE_JESTER(cls):
                    return cls("brandarchetypeJester")
                
                @schemas.classproperty
                def BRANDARCHETYPE_EVERYMAN(cls):
                    return cls("brandarchetypeEveryman")
                
                @schemas.classproperty
                def BRANDARCHETYPE_CAREGIVER(cls):
                    return cls("brandarchetypeCaregiver")
                
                @schemas.classproperty
                def BRANDARCHETYPE_RULER(cls):
                    return cls("brandarchetypeRuler")
                
                @schemas.classproperty
                def BRANDARCHETYPE_CREATOR(cls):
                    return cls("brandarchetypeCreator")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_COLLABORATIVE(cls):
                    return cls("brandAttributeCollaborative")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_HONEST(cls):
                    return cls("brandAttributeHonest")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_INNOVATIVE(cls):
                    return cls("brandAttributeInnovative")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_CARING(cls):
                    return cls("brandAttributeCaring")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_DIVERSE(cls):
                    return cls("brandAttributeDiverse")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_TRUSTWORTHY(cls):
                    return cls("brandAttributeTrustworthy")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_BOLD(cls):
                    return cls("brandAttributeBold")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_FUN(cls):
                    return cls("brandAttributeFun")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_COMMITTED(cls):
                    return cls("brandAttributeCommitted")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_POSITIVE(cls):
                    return cls("brandAttributePositive")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_HUMAN(cls):
                    return cls("brandAttributeHuman")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_EXCELLENCE(cls):
                    return cls("brandAttributeExcellence")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_CREATIVITY(cls):
                    return cls("brandAttributeCreativity")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_RESPECTFUL(cls):
                    return cls("brandAttributeRespectful")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_AUTHENTIC(cls):
                    return cls("brandAttributeAuthentic")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_CONFIDENT(cls):
                    return cls("brandAttributeConfident")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_SAFETY(cls):
                    return cls("brandAttributeSafety")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_ENCOURAGING(cls):
                    return cls("brandAttributeEncouraging")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_EMPOWERING(cls):
                    return cls("brandAttributeEmpowering")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_FAMILY(cls):
                    return cls("brandAttributeFamily")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_BALANCED(cls):
                    return cls("brandAttributeBalanced")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_UPLIFTING(cls):
                    return cls("brandAttributeUplifting")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_FEARLESSNESS(cls):
                    return cls("brandAttributeFearlessness")
                
                @schemas.classproperty
                def BRAND_ATTRIBUTE_IMPULSIVE(cls):
                    return cls("brandAttributeImpulsive")
            strength = schemas.Float32Schema
            __annotations__ = {
                "abstractionName": abstractionName,
                "strength": strength,
            }
    
    abstractionName: MetaOapg.properties.abstractionName
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["abstractionName"]) -> MetaOapg.properties.abstractionName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["strength"]) -> MetaOapg.properties.strength: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["abstractionName", "strength", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["abstractionName"]) -> MetaOapg.properties.abstractionName: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["strength"]) -> typing.Union[MetaOapg.properties.strength, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["abstractionName", "strength", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        abstractionName: typing.Union[MetaOapg.properties.abstractionName, str, ],
        strength: typing.Union[MetaOapg.properties.strength, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'SearchRecordingGranularAbstractionDTO':
        return super().__new__(
            cls,
            *_args,
            abstractionName=abstractionName,
            strength=strength,
            _configuration=_configuration,
            **kwargs,
        )
