# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.  # noqa: E501

    The version of the OpenAPI document: 1.12.21
    Contact: info@songtradr.com
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from songtradr_api_client_python import schemas  # noqa: F401


class FileSmallDTO(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Reduced details on a file that has been uploaded for auto-tagging or audio-recognition purposes.
    """


    class MetaOapg:
        required = {
            "extension",
            "folder",
            "objectKey",
            "name",
            "id",
        }
        
        class properties:
            name = schemas.StrSchema
            id = schemas.Int32Schema
            
            
            class extension(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "mp3": "MP3",
                        "wav": "WAV",
                        "flac": "FLAC",
                    }
                
                @schemas.classproperty
                def MP3(cls):
                    return cls("mp3")
                
                @schemas.classproperty
                def WAV(cls):
                    return cls("wav")
                
                @schemas.classproperty
                def FLAC(cls):
                    return cls("flac")
            folder = schemas.StrSchema
            objectKey = schemas.StrSchema
            error_message = schemas.StrSchema
            uploadStartTime = schemas.DateTimeSchema
            uploadEndTime = schemas.DateTimeSchema
            
            
            class fingerprintStatus(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "processing": "PROCESSING",
                        "error": "ERROR",
                        "found": "FOUND",
                        "not_found": "NOT_FOUND",
                        "not_started": "NOT_STARTED",
                    }
                
                @schemas.classproperty
                def PROCESSING(cls):
                    return cls("processing")
                
                @schemas.classproperty
                def ERROR(cls):
                    return cls("error")
                
                @schemas.classproperty
                def FOUND(cls):
                    return cls("found")
                
                @schemas.classproperty
                def NOT_FOUND(cls):
                    return cls("not_found")
                
                @schemas.classproperty
                def NOT_STARTED(cls):
                    return cls("not_started")
            fingerprintStartTime = schemas.DateTimeSchema
            fingerprintEndTime = schemas.DateTimeSchema
            
            
            class inferenceStatus(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "processing": "PROCESSING",
                        "error": "ERROR",
                        "done": "DONE",
                        "not_started": "NOT_STARTED",
                    }
                
                @schemas.classproperty
                def PROCESSING(cls):
                    return cls("processing")
                
                @schemas.classproperty
                def ERROR(cls):
                    return cls("error")
                
                @schemas.classproperty
                def DONE(cls):
                    return cls("done")
                
                @schemas.classproperty
                def NOT_STARTED(cls):
                    return cls("not_started")
            inferenceStartTime = schemas.DateTimeSchema
            inferenceEndTime = schemas.DateTimeSchema
            error_time = schemas.DateTimeSchema
            __annotations__ = {
                "name": name,
                "id": id,
                "extension": extension,
                "folder": folder,
                "objectKey": objectKey,
                "error_message": error_message,
                "uploadStartTime": uploadStartTime,
                "uploadEndTime": uploadEndTime,
                "fingerprintStatus": fingerprintStatus,
                "fingerprintStartTime": fingerprintStartTime,
                "fingerprintEndTime": fingerprintEndTime,
                "inferenceStatus": inferenceStatus,
                "inferenceStartTime": inferenceStartTime,
                "inferenceEndTime": inferenceEndTime,
                "error_time": error_time,
            }
    
    extension: MetaOapg.properties.extension
    folder: MetaOapg.properties.folder
    objectKey: MetaOapg.properties.objectKey
    name: MetaOapg.properties.name
    id: MetaOapg.properties.id
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["extension"]) -> MetaOapg.properties.extension: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["folder"]) -> MetaOapg.properties.folder: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["objectKey"]) -> MetaOapg.properties.objectKey: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["error_message"]) -> MetaOapg.properties.error_message: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["uploadStartTime"]) -> MetaOapg.properties.uploadStartTime: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["uploadEndTime"]) -> MetaOapg.properties.uploadEndTime: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["fingerprintStatus"]) -> MetaOapg.properties.fingerprintStatus: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["fingerprintStartTime"]) -> MetaOapg.properties.fingerprintStartTime: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["fingerprintEndTime"]) -> MetaOapg.properties.fingerprintEndTime: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["inferenceStatus"]) -> MetaOapg.properties.inferenceStatus: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["inferenceStartTime"]) -> MetaOapg.properties.inferenceStartTime: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["inferenceEndTime"]) -> MetaOapg.properties.inferenceEndTime: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["error_time"]) -> MetaOapg.properties.error_time: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["name", "id", "extension", "folder", "objectKey", "error_message", "uploadStartTime", "uploadEndTime", "fingerprintStatus", "fingerprintStartTime", "fingerprintEndTime", "inferenceStatus", "inferenceStartTime", "inferenceEndTime", "error_time", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["extension"]) -> MetaOapg.properties.extension: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["folder"]) -> MetaOapg.properties.folder: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["objectKey"]) -> MetaOapg.properties.objectKey: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["error_message"]) -> typing.Union[MetaOapg.properties.error_message, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["uploadStartTime"]) -> typing.Union[MetaOapg.properties.uploadStartTime, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["uploadEndTime"]) -> typing.Union[MetaOapg.properties.uploadEndTime, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["fingerprintStatus"]) -> typing.Union[MetaOapg.properties.fingerprintStatus, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["fingerprintStartTime"]) -> typing.Union[MetaOapg.properties.fingerprintStartTime, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["fingerprintEndTime"]) -> typing.Union[MetaOapg.properties.fingerprintEndTime, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["inferenceStatus"]) -> typing.Union[MetaOapg.properties.inferenceStatus, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["inferenceStartTime"]) -> typing.Union[MetaOapg.properties.inferenceStartTime, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["inferenceEndTime"]) -> typing.Union[MetaOapg.properties.inferenceEndTime, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["error_time"]) -> typing.Union[MetaOapg.properties.error_time, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["name", "id", "extension", "folder", "objectKey", "error_message", "uploadStartTime", "uploadEndTime", "fingerprintStatus", "fingerprintStartTime", "fingerprintEndTime", "inferenceStatus", "inferenceStartTime", "inferenceEndTime", "error_time", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        extension: typing.Union[MetaOapg.properties.extension, str, ],
        folder: typing.Union[MetaOapg.properties.folder, str, ],
        objectKey: typing.Union[MetaOapg.properties.objectKey, str, ],
        name: typing.Union[MetaOapg.properties.name, str, ],
        id: typing.Union[MetaOapg.properties.id, decimal.Decimal, int, ],
        error_message: typing.Union[MetaOapg.properties.error_message, str, schemas.Unset] = schemas.unset,
        uploadStartTime: typing.Union[MetaOapg.properties.uploadStartTime, str, datetime, schemas.Unset] = schemas.unset,
        uploadEndTime: typing.Union[MetaOapg.properties.uploadEndTime, str, datetime, schemas.Unset] = schemas.unset,
        fingerprintStatus: typing.Union[MetaOapg.properties.fingerprintStatus, str, schemas.Unset] = schemas.unset,
        fingerprintStartTime: typing.Union[MetaOapg.properties.fingerprintStartTime, str, datetime, schemas.Unset] = schemas.unset,
        fingerprintEndTime: typing.Union[MetaOapg.properties.fingerprintEndTime, str, datetime, schemas.Unset] = schemas.unset,
        inferenceStatus: typing.Union[MetaOapg.properties.inferenceStatus, str, schemas.Unset] = schemas.unset,
        inferenceStartTime: typing.Union[MetaOapg.properties.inferenceStartTime, str, datetime, schemas.Unset] = schemas.unset,
        inferenceEndTime: typing.Union[MetaOapg.properties.inferenceEndTime, str, datetime, schemas.Unset] = schemas.unset,
        error_time: typing.Union[MetaOapg.properties.error_time, str, datetime, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'FileSmallDTO':
        return super().__new__(
            cls,
            *_args,
            extension=extension,
            folder=folder,
            objectKey=objectKey,
            name=name,
            id=id,
            error_message=error_message,
            uploadStartTime=uploadStartTime,
            uploadEndTime=uploadEndTime,
            fingerprintStatus=fingerprintStatus,
            fingerprintStartTime=fingerprintStartTime,
            fingerprintEndTime=fingerprintEndTime,
            inferenceStatus=inferenceStatus,
            inferenceStartTime=inferenceStartTime,
            inferenceEndTime=inferenceEndTime,
            error_time=error_time,
            _configuration=_configuration,
            **kwargs,
        )
