# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.  # noqa: E501

    The version of the OpenAPI document: 1.12.21
    Contact: info@songtradr.com
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from songtradr_api_client_python import schemas  # noqa: F401


class RecordingLargeDTO(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Recording with a large field set.
    """


    class MetaOapg:
        required = {
            "isrc",
        }
        
        class properties:
            isrc = schemas.StrSchema
            duration = schemas.Int32Schema
            spotifyId = schemas.StrSchema
            
            
            class genrePredictions(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    unique_items = True
                    
                    @staticmethod
                    def items() -> typing.Type['RecordingGenrePredictionDTO']:
                        return RecordingGenrePredictionDTO
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple['RecordingGenrePredictionDTO'], typing.List['RecordingGenrePredictionDTO']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'genrePredictions':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'RecordingGenrePredictionDTO':
                    return super().__getitem__(i)
        
            @staticmethod
            def pline() -> typing.Type['PLineDTO']:
                return PLineDTO
            
            
            class tags(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['RecordingTagSmallDTO']:
                        return RecordingTagSmallDTO
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple['RecordingTagSmallDTO'], typing.List['RecordingTagSmallDTO']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'tags':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'RecordingTagSmallDTO':
                    return super().__getitem__(i)
            
            
            class titles(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    unique_items = True
                    
                    @staticmethod
                    def items() -> typing.Type['TitleDTO']:
                        return TitleDTO
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple['TitleDTO'], typing.List['TitleDTO']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'titles':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'TitleDTO':
                    return super().__getitem__(i)
            
            
            class tracks(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    unique_items = True
                    
                    @staticmethod
                    def items() -> typing.Type['TrackToMediumProductDTO']:
                        return TrackToMediumProductDTO
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple['TrackToMediumProductDTO'], typing.List['TrackToMediumProductDTO']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'tracks':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'TrackToMediumProductDTO':
                    return super().__getitem__(i)
        
            @staticmethod
            def musicalFeatures() -> typing.Type['MusicalFeaturesDTO']:
                return MusicalFeaturesDTO
            
            
            class parties(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    unique_items = True
                    
                    @staticmethod
                    def items() -> typing.Type['RecordingPartyDTO']:
                        return RecordingPartyDTO
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple['RecordingPartyDTO'], typing.List['RecordingPartyDTO']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'parties':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'RecordingPartyDTO':
                    return super().__getitem__(i)
            
            
            class genres(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    unique_items = True
                    
                    @staticmethod
                    def items() -> typing.Type['GenreDTO']:
                        return GenreDTO
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple['GenreDTO'], typing.List['GenreDTO']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'genres':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'GenreDTO':
                    return super().__getitem__(i)
            languageOfPerformance = schemas.StrSchema
            __annotations__ = {
                "isrc": isrc,
                "duration": duration,
                "spotifyId": spotifyId,
                "genrePredictions": genrePredictions,
                "pline": pline,
                "tags": tags,
                "titles": titles,
                "tracks": tracks,
                "musicalFeatures": musicalFeatures,
                "parties": parties,
                "genres": genres,
                "languageOfPerformance": languageOfPerformance,
            }
    
    isrc: MetaOapg.properties.isrc
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["isrc"]) -> MetaOapg.properties.isrc: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["duration"]) -> MetaOapg.properties.duration: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["spotifyId"]) -> MetaOapg.properties.spotifyId: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["genrePredictions"]) -> MetaOapg.properties.genrePredictions: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["pline"]) -> 'PLineDTO': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tags"]) -> MetaOapg.properties.tags: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["titles"]) -> MetaOapg.properties.titles: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tracks"]) -> MetaOapg.properties.tracks: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["musicalFeatures"]) -> 'MusicalFeaturesDTO': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["parties"]) -> MetaOapg.properties.parties: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["genres"]) -> MetaOapg.properties.genres: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["languageOfPerformance"]) -> MetaOapg.properties.languageOfPerformance: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["isrc", "duration", "spotifyId", "genrePredictions", "pline", "tags", "titles", "tracks", "musicalFeatures", "parties", "genres", "languageOfPerformance", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["isrc"]) -> MetaOapg.properties.isrc: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["duration"]) -> typing.Union[MetaOapg.properties.duration, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["spotifyId"]) -> typing.Union[MetaOapg.properties.spotifyId, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["genrePredictions"]) -> typing.Union[MetaOapg.properties.genrePredictions, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["pline"]) -> typing.Union['PLineDTO', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tags"]) -> typing.Union[MetaOapg.properties.tags, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["titles"]) -> typing.Union[MetaOapg.properties.titles, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tracks"]) -> typing.Union[MetaOapg.properties.tracks, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["musicalFeatures"]) -> typing.Union['MusicalFeaturesDTO', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["parties"]) -> typing.Union[MetaOapg.properties.parties, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["genres"]) -> typing.Union[MetaOapg.properties.genres, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["languageOfPerformance"]) -> typing.Union[MetaOapg.properties.languageOfPerformance, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["isrc", "duration", "spotifyId", "genrePredictions", "pline", "tags", "titles", "tracks", "musicalFeatures", "parties", "genres", "languageOfPerformance", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        isrc: typing.Union[MetaOapg.properties.isrc, str, ],
        duration: typing.Union[MetaOapg.properties.duration, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        spotifyId: typing.Union[MetaOapg.properties.spotifyId, str, schemas.Unset] = schemas.unset,
        genrePredictions: typing.Union[MetaOapg.properties.genrePredictions, list, tuple, schemas.Unset] = schemas.unset,
        pline: typing.Union['PLineDTO', schemas.Unset] = schemas.unset,
        tags: typing.Union[MetaOapg.properties.tags, list, tuple, schemas.Unset] = schemas.unset,
        titles: typing.Union[MetaOapg.properties.titles, list, tuple, schemas.Unset] = schemas.unset,
        tracks: typing.Union[MetaOapg.properties.tracks, list, tuple, schemas.Unset] = schemas.unset,
        musicalFeatures: typing.Union['MusicalFeaturesDTO', schemas.Unset] = schemas.unset,
        parties: typing.Union[MetaOapg.properties.parties, list, tuple, schemas.Unset] = schemas.unset,
        genres: typing.Union[MetaOapg.properties.genres, list, tuple, schemas.Unset] = schemas.unset,
        languageOfPerformance: typing.Union[MetaOapg.properties.languageOfPerformance, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'RecordingLargeDTO':
        return super().__new__(
            cls,
            *_args,
            isrc=isrc,
            duration=duration,
            spotifyId=spotifyId,
            genrePredictions=genrePredictions,
            pline=pline,
            tags=tags,
            titles=titles,
            tracks=tracks,
            musicalFeatures=musicalFeatures,
            parties=parties,
            genres=genres,
            languageOfPerformance=languageOfPerformance,
            _configuration=_configuration,
            **kwargs,
        )

from songtradr_api_client_python.model.genre_dto import GenreDTO
from songtradr_api_client_python.model.musical_features_dto import MusicalFeaturesDTO
from songtradr_api_client_python.model.p_line_dto import PLineDTO
from songtradr_api_client_python.model.recording_genre_prediction_dto import RecordingGenrePredictionDTO
from songtradr_api_client_python.model.recording_party_dto import RecordingPartyDTO
from songtradr_api_client_python.model.recording_tag_small_dto import RecordingTagSmallDTO
from songtradr_api_client_python.model.title_dto import TitleDTO
from songtradr_api_client_python.model.track_to_medium_product_dto import TrackToMediumProductDTO
