# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.  # noqa: E501

    The version of the OpenAPI document: 1.12.21
    Contact: info@songtradr.com
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from songtradr_api_client_python import schemas  # noqa: F401


class TagstrengthDTO(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    A TaggramDTO for recordings.
    """


    class MetaOapg:
        required = {
            "strength",
            "categoryName",
        }
        
        class properties:
            strength = schemas.Float32Schema
            categoryName = schemas.StrSchema
            tagName = schemas.StrSchema
            genreName = schemas.StrSchema
            
            
            class scale(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.Int32Schema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, decimal.Decimal, int, ]], typing.List[typing.Union[MetaOapg.items, decimal.Decimal, int, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'scale':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            __annotations__ = {
                "strength": strength,
                "categoryName": categoryName,
                "tagName": tagName,
                "genreName": genreName,
                "scale": scale,
            }
    
    strength: MetaOapg.properties.strength
    categoryName: MetaOapg.properties.categoryName
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["strength"]) -> MetaOapg.properties.strength: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["categoryName"]) -> MetaOapg.properties.categoryName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tagName"]) -> MetaOapg.properties.tagName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["genreName"]) -> MetaOapg.properties.genreName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["scale"]) -> MetaOapg.properties.scale: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["strength", "categoryName", "tagName", "genreName", "scale", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["strength"]) -> MetaOapg.properties.strength: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["categoryName"]) -> MetaOapg.properties.categoryName: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tagName"]) -> typing.Union[MetaOapg.properties.tagName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["genreName"]) -> typing.Union[MetaOapg.properties.genreName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["scale"]) -> typing.Union[MetaOapg.properties.scale, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["strength", "categoryName", "tagName", "genreName", "scale", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        strength: typing.Union[MetaOapg.properties.strength, decimal.Decimal, int, float, ],
        categoryName: typing.Union[MetaOapg.properties.categoryName, str, ],
        tagName: typing.Union[MetaOapg.properties.tagName, str, schemas.Unset] = schemas.unset,
        genreName: typing.Union[MetaOapg.properties.genreName, str, schemas.Unset] = schemas.unset,
        scale: typing.Union[MetaOapg.properties.scale, list, tuple, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'TagstrengthDTO':
        return super().__new__(
            cls,
            *_args,
            strength=strength,
            categoryName=categoryName,
            tagName=tagName,
            genreName=genreName,
            scale=scale,
            _configuration=_configuration,
            **kwargs,
        )
