# coding: utf-8

"""


    Generated by: https://openapi-generator.tech
"""

from dataclasses import dataclass
import typing_extensions
import urllib3
from urllib3._collections import HTTPHeaderDict

from songtradr_api_client_python import api_client, exceptions
from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from songtradr_api_client_python import schemas  # noqa: F401

from songtradr_api_client_python.model.error_response import ErrorResponse
from songtradr_api_client_python.model.recording_list_dto import RecordingListDTO

from . import path

# Query params
SimilarToRecordingSchema = schemas.StrSchema
ContributorSchema = schemas.StrSchema
MainArtistSchema = schemas.StrSchema
ComposerSchema = schemas.StrSchema
TitleSchema = schemas.StrSchema


class LanguageSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "en": "EN",
            "es": "ES",
            "fr": "FR",
            "de": "DE",
            "jp": "JP",
            "cn": "CN",
            "IT": "IT",
            "RU": "RU",
        }
    
    @schemas.classproperty
    def EN(cls):
        return cls("en")
    
    @schemas.classproperty
    def ES(cls):
        return cls("es")
    
    @schemas.classproperty
    def FR(cls):
        return cls("fr")
    
    @schemas.classproperty
    def DE(cls):
        return cls("de")
    
    @schemas.classproperty
    def JP(cls):
        return cls("jp")
    
    @schemas.classproperty
    def CN(cls):
        return cls("cn")
    
    @schemas.classproperty
    def IT(cls):
        return cls("IT")
    
    @schemas.classproperty
    def RU(cls):
        return cls("RU")
GenreSchema = schemas.StrSchema


class PrimaryMoodClusterSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "aggressive": "AGGRESSIVE",
            "amusing": "AMUSING",
            "anxious": "ANXIOUS",
            "calm": "CALM",
            "devotional": "DEVOTIONAL",
            "dreamy": "DREAMY",
            "energetic": "ENERGETIC",
            "enigmatic": "ENIGMATIC",
            "epic": "EPIC",
            "erotic": "EROTIC",
            "positive": "POSITIVE",
            "sad": "SAD",
            "scary": "SCARY",
            "wild": "WILD",
        }
    
    @schemas.classproperty
    def AGGRESSIVE(cls):
        return cls("aggressive")
    
    @schemas.classproperty
    def AMUSING(cls):
        return cls("amusing")
    
    @schemas.classproperty
    def ANXIOUS(cls):
        return cls("anxious")
    
    @schemas.classproperty
    def CALM(cls):
        return cls("calm")
    
    @schemas.classproperty
    def DEVOTIONAL(cls):
        return cls("devotional")
    
    @schemas.classproperty
    def DREAMY(cls):
        return cls("dreamy")
    
    @schemas.classproperty
    def ENERGETIC(cls):
        return cls("energetic")
    
    @schemas.classproperty
    def ENIGMATIC(cls):
        return cls("enigmatic")
    
    @schemas.classproperty
    def EPIC(cls):
        return cls("epic")
    
    @schemas.classproperty
    def EROTIC(cls):
        return cls("erotic")
    
    @schemas.classproperty
    def POSITIVE(cls):
        return cls("positive")
    
    @schemas.classproperty
    def SAD(cls):
        return cls("sad")
    
    @schemas.classproperty
    def SCARY(cls):
        return cls("scary")
    
    @schemas.classproperty
    def WILD(cls):
        return cls("wild")


class ValenceSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "very sad": "VERY_SAD",
            "sad": "SAD",
            "moderate valence": "MODERATE_VALENCE",
            "positive": "POSITIVE",
            "very positive": "VERY_POSITIVE",
            "varying valence": "VARYING_VALENCE",
        }
    
    @schemas.classproperty
    def VERY_SAD(cls):
        return cls("very sad")
    
    @schemas.classproperty
    def SAD(cls):
        return cls("sad")
    
    @schemas.classproperty
    def MODERATE_VALENCE(cls):
        return cls("moderate valence")
    
    @schemas.classproperty
    def POSITIVE(cls):
        return cls("positive")
    
    @schemas.classproperty
    def VERY_POSITIVE(cls):
        return cls("very positive")
    
    @schemas.classproperty
    def VARYING_VALENCE(cls):
        return cls("varying valence")


class ArousalSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "very calm": "VERY_CALM",
            "calm": "CALM",
            "moderate arousal": "MODERATE_AROUSAL",
            "energetic": "ENERGETIC",
            "very energetic": "VERY_ENERGETIC",
            "varying arousal": "VARYING_AROUSAL",
        }
    
    @schemas.classproperty
    def VERY_CALM(cls):
        return cls("very calm")
    
    @schemas.classproperty
    def CALM(cls):
        return cls("calm")
    
    @schemas.classproperty
    def MODERATE_AROUSAL(cls):
        return cls("moderate arousal")
    
    @schemas.classproperty
    def ENERGETIC(cls):
        return cls("energetic")
    
    @schemas.classproperty
    def VERY_ENERGETIC(cls):
        return cls("very energetic")
    
    @schemas.classproperty
    def VARYING_AROUSAL(cls):
        return cls("varying arousal")


class PleasantnessSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "very unpleasant": "VERY_UNPLEASANT",
            "unpleasant": "UNPLEASANT",
            "neutral pleasantness": "NEUTRAL_PLEASANTNESS",
            "pleasant": "PLEASANT",
            "very pleasant": "VERY_PLEASANT",
            "varying pleasantness": "VARYING_PLEASANTNESS",
        }
    
    @schemas.classproperty
    def VERY_UNPLEASANT(cls):
        return cls("very unpleasant")
    
    @schemas.classproperty
    def UNPLEASANT(cls):
        return cls("unpleasant")
    
    @schemas.classproperty
    def NEUTRAL_PLEASANTNESS(cls):
        return cls("neutral pleasantness")
    
    @schemas.classproperty
    def PLEASANT(cls):
        return cls("pleasant")
    
    @schemas.classproperty
    def VERY_PLEASANT(cls):
        return cls("very pleasant")
    
    @schemas.classproperty
    def VARYING_PLEASANTNESS(cls):
        return cls("varying pleasantness")


class EngagementSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "very unengaging": "VERY_UNENGAGING",
            "unengaging": "UNENGAGING",
            "neutral engagement": "NEUTRAL_ENGAGEMENT",
            "engaging": "ENGAGING",
            "very engaging": "VERY_ENGAGING",
            "varying engagement": "VARYING_ENGAGEMENT",
        }
    
    @schemas.classproperty
    def VERY_UNENGAGING(cls):
        return cls("very unengaging")
    
    @schemas.classproperty
    def UNENGAGING(cls):
        return cls("unengaging")
    
    @schemas.classproperty
    def NEUTRAL_ENGAGEMENT(cls):
        return cls("neutral engagement")
    
    @schemas.classproperty
    def ENGAGING(cls):
        return cls("engaging")
    
    @schemas.classproperty
    def VERY_ENGAGING(cls):
        return cls("very engaging")
    
    @schemas.classproperty
    def VARYING_ENGAGEMENT(cls):
        return cls("varying engagement")


class VocalsSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "instrumental": "INSTRUMENTAL",
            "female vocals": "FEMALE_VOCALS",
            "male vocals": "MALE_VOCALS",
            "mixed vocals": "MIXED_VOCALS",
            "diverse gender vocals": "DIVERSE_GENDER_VOCALS",
        }
    
    @schemas.classproperty
    def INSTRUMENTAL(cls):
        return cls("instrumental")
    
    @schemas.classproperty
    def FEMALE_VOCALS(cls):
        return cls("female vocals")
    
    @schemas.classproperty
    def MALE_VOCALS(cls):
        return cls("male vocals")
    
    @schemas.classproperty
    def MIXED_VOCALS(cls):
        return cls("mixed vocals")
    
    @schemas.classproperty
    def DIVERSE_GENDER_VOCALS(cls):
        return cls("diverse gender vocals")


class DominantInstrumentSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "electric guitar": "ELECTRIC_GUITAR",
            "piano": "PIANO",
            "electronics": "ELECTRONICS",
            "guitar": "GUITAR",
            "strings": "STRINGS",
            "synthesizer": "SYNTHESIZER",
            "wind": "WIND",
            "saxophone": "SAXOPHONE",
            "flute": "FLUTE",
            "trumpet": "TRUMPET",
            "drum kit": "DRUM_KIT",
            "keys": "KEYS",
            "accordion": "ACCORDION",
            "violin": "VIOLIN",
            "harpsichord": "HARPSICHORD",
            "choir": "CHOIR",
            "cello": "CELLO",
            "electric bass": "ELECTRIC_BASS",
            "organ": "ORGAN",
            "brass": "BRASS",
            "percussion": "PERCUSSION",
            "vocals": "VOCALS",
            "double bass": "DOUBLE_BASS",
            "harp": "HARP",
        }
    
    @schemas.classproperty
    def ELECTRIC_GUITAR(cls):
        return cls("electric guitar")
    
    @schemas.classproperty
    def PIANO(cls):
        return cls("piano")
    
    @schemas.classproperty
    def ELECTRONICS(cls):
        return cls("electronics")
    
    @schemas.classproperty
    def GUITAR(cls):
        return cls("guitar")
    
    @schemas.classproperty
    def STRINGS(cls):
        return cls("strings")
    
    @schemas.classproperty
    def SYNTHESIZER(cls):
        return cls("synthesizer")
    
    @schemas.classproperty
    def WIND(cls):
        return cls("wind")
    
    @schemas.classproperty
    def SAXOPHONE(cls):
        return cls("saxophone")
    
    @schemas.classproperty
    def FLUTE(cls):
        return cls("flute")
    
    @schemas.classproperty
    def TRUMPET(cls):
        return cls("trumpet")
    
    @schemas.classproperty
    def DRUM_KIT(cls):
        return cls("drum kit")
    
    @schemas.classproperty
    def KEYS(cls):
        return cls("keys")
    
    @schemas.classproperty
    def ACCORDION(cls):
        return cls("accordion")
    
    @schemas.classproperty
    def VIOLIN(cls):
        return cls("violin")
    
    @schemas.classproperty
    def HARPSICHORD(cls):
        return cls("harpsichord")
    
    @schemas.classproperty
    def CHOIR(cls):
        return cls("choir")
    
    @schemas.classproperty
    def CELLO(cls):
        return cls("cello")
    
    @schemas.classproperty
    def ELECTRIC_BASS(cls):
        return cls("electric bass")
    
    @schemas.classproperty
    def ORGAN(cls):
        return cls("organ")
    
    @schemas.classproperty
    def BRASS(cls):
        return cls("brass")
    
    @schemas.classproperty
    def PERCUSSION(cls):
        return cls("percussion")
    
    @schemas.classproperty
    def VOCALS(cls):
        return cls("vocals")
    
    @schemas.classproperty
    def DOUBLE_BASS(cls):
        return cls("double bass")
    
    @schemas.classproperty
    def HARP(cls):
        return cls("harp")


class EnergySchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "very quiet": "VERY_QUIET",
            "quiet": "QUIET",
            "moderate": "MODERATE",
            "loud": "LOUD",
            "very loud": "VERY_LOUD",
            "dynamic": "DYNAMIC",
        }
    
    @schemas.classproperty
    def VERY_QUIET(cls):
        return cls("very quiet")
    
    @schemas.classproperty
    def QUIET(cls):
        return cls("quiet")
    
    @schemas.classproperty
    def MODERATE(cls):
        return cls("moderate")
    
    @schemas.classproperty
    def LOUD(cls):
        return cls("loud")
    
    @schemas.classproperty
    def VERY_LOUD(cls):
        return cls("very loud")
    
    @schemas.classproperty
    def DYNAMIC(cls):
        return cls("dynamic")


class SoundGenerationSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "acoustic": "ACOUSTIC",
            "electric": "ELECTRIC",
            "electronic": "ELECTRONIC",
            "mixed sound generation": "MIXED_SOUND_GENERATION",
        }
    
    @schemas.classproperty
    def ACOUSTIC(cls):
        return cls("acoustic")
    
    @schemas.classproperty
    def ELECTRIC(cls):
        return cls("electric")
    
    @schemas.classproperty
    def ELECTRONIC(cls):
        return cls("electronic")
    
    @schemas.classproperty
    def MIXED_SOUND_GENERATION(cls):
        return cls("mixed sound generation")


class TempoSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "very slow": "VERY_SLOW",
            "slow": "SLOW",
            "mid-tempo": "MIDTEMPO",
            "fast": "FAST",
            "very fast": "VERY_FAST",
            "varying tempo": "VARYING_TEMPO",
        }
    
    @schemas.classproperty
    def VERY_SLOW(cls):
        return cls("very slow")
    
    @schemas.classproperty
    def SLOW(cls):
        return cls("slow")
    
    @schemas.classproperty
    def MIDTEMPO(cls):
        return cls("mid-tempo")
    
    @schemas.classproperty
    def FAST(cls):
        return cls("fast")
    
    @schemas.classproperty
    def VERY_FAST(cls):
        return cls("very fast")
    
    @schemas.classproperty
    def VARYING_TEMPO(cls):
        return cls("varying tempo")


class ScaleSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "major key": "MAJOR_KEY",
            "minor key": "MINOR_KEY",
            "neutral key": "NEUTRAL_KEY",
        }
    
    @schemas.classproperty
    def MAJOR_KEY(cls):
        return cls("major key")
    
    @schemas.classproperty
    def MINOR_KEY(cls):
        return cls("minor key")
    
    @schemas.classproperty
    def NEUTRAL_KEY(cls):
        return cls("neutral key")


class KeySchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "C": "C",
            "C#": "C",
            "D": "D",
            "D#": "D",
            "E": "E",
            "F": "F",
            "F#": "F",
            "G": "G",
            "G#": "G",
            "A": "A",
            "A#": "A",
            "B": "B",
            "unclear": "UNCLEAR",
        }
    
    @schemas.classproperty
    def C(cls):
        return cls("C")
    
    @schemas.classproperty
    def C(cls):
        return cls("C#")
    
    @schemas.classproperty
    def D(cls):
        return cls("D")
    
    @schemas.classproperty
    def D(cls):
        return cls("D#")
    
    @schemas.classproperty
    def E(cls):
        return cls("E")
    
    @schemas.classproperty
    def F(cls):
        return cls("F")
    
    @schemas.classproperty
    def F(cls):
        return cls("F#")
    
    @schemas.classproperty
    def G(cls):
        return cls("G")
    
    @schemas.classproperty
    def G(cls):
        return cls("G#")
    
    @schemas.classproperty
    def A(cls):
        return cls("A")
    
    @schemas.classproperty
    def A(cls):
        return cls("A#")
    
    @schemas.classproperty
    def B(cls):
        return cls("B")
    
    @schemas.classproperty
    def UNCLEAR(cls):
        return cls("unclear")


class RhythmSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "common time": "COMMON_TIME",
            "triple meter": "TRIPLE_METER",
            "complex time signature": "COMPLEX_TIME_SIGNATURE",
            "binary rhythm": "BINARY_RHYTHM",
            "ternary rhythm": "TERNARY_RHYTHM",
        }
    
    @schemas.classproperty
    def COMMON_TIME(cls):
        return cls("common time")
    
    @schemas.classproperty
    def TRIPLE_METER(cls):
        return cls("triple meter")
    
    @schemas.classproperty
    def COMPLEX_TIME_SIGNATURE(cls):
        return cls("complex time signature")
    
    @schemas.classproperty
    def BINARY_RHYTHM(cls):
        return cls("binary rhythm")
    
    @schemas.classproperty
    def TERNARY_RHYTHM(cls):
        return cls("ternary rhythm")


class PrimarySoundCharacterSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "brassy": "BRASSY",
            "bright": "BRIGHT",
            "clear": "CLEAR",
            "deep": "DEEP",
            "distorted": "DISTORTED",
            "flat": "FLAT",
            "full": "FULL",
            "groovy": "GROOVY",
            "melodious": "MELODIOUS",
            "natural": "NATURAL",
            "resonant": "RESONANT",
            "shrill": "SHRILL",
            "steady": "STEADY",
            "thin": "THIN",
            "warm": "WARM",
        }
    
    @schemas.classproperty
    def BRASSY(cls):
        return cls("brassy")
    
    @schemas.classproperty
    def BRIGHT(cls):
        return cls("bright")
    
    @schemas.classproperty
    def CLEAR(cls):
        return cls("clear")
    
    @schemas.classproperty
    def DEEP(cls):
        return cls("deep")
    
    @schemas.classproperty
    def DISTORTED(cls):
        return cls("distorted")
    
    @schemas.classproperty
    def FLAT(cls):
        return cls("flat")
    
    @schemas.classproperty
    def FULL(cls):
        return cls("full")
    
    @schemas.classproperty
    def GROOVY(cls):
        return cls("groovy")
    
    @schemas.classproperty
    def MELODIOUS(cls):
        return cls("melodious")
    
    @schemas.classproperty
    def NATURAL(cls):
        return cls("natural")
    
    @schemas.classproperty
    def RESONANT(cls):
        return cls("resonant")
    
    @schemas.classproperty
    def SHRILL(cls):
        return cls("shrill")
    
    @schemas.classproperty
    def STEADY(cls):
        return cls("steady")
    
    @schemas.classproperty
    def THIN(cls):
        return cls("thin")
    
    @schemas.classproperty
    def WARM(cls):
        return cls("warm")


class TimbreSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "very warm": "VERY_WARM",
            "warm": "WARM",
            "moderate timbre": "MODERATE_TIMBRE",
            "bright": "BRIGHT",
            "very bright": "VERY_BRIGHT",
        }
    
    @schemas.classproperty
    def VERY_WARM(cls):
        return cls("very warm")
    
    @schemas.classproperty
    def WARM(cls):
        return cls("warm")
    
    @schemas.classproperty
    def MODERATE_TIMBRE(cls):
        return cls("moderate timbre")
    
    @schemas.classproperty
    def BRIGHT(cls):
        return cls("bright")
    
    @schemas.classproperty
    def VERY_BRIGHT(cls):
        return cls("very bright")


class RoughnessSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "very clear": "VERY_CLEAR",
            "clear": "CLEAR",
            "moderate roughness": "MODERATE_ROUGHNESS",
            "distorted": "DISTORTED",
            "very distorted": "VERY_DISTORTED",
        }
    
    @schemas.classproperty
    def VERY_CLEAR(cls):
        return cls("very clear")
    
    @schemas.classproperty
    def CLEAR(cls):
        return cls("clear")
    
    @schemas.classproperty
    def MODERATE_ROUGHNESS(cls):
        return cls("moderate roughness")
    
    @schemas.classproperty
    def DISTORTED(cls):
        return cls("distorted")
    
    @schemas.classproperty
    def VERY_DISTORTED(cls):
        return cls("very distorted")


class TonalitySchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "monotonous": "MONOTONOUS",
            "moderate melodiousness": "MODERATE_MELODIOUSNESS",
            "melodious": "MELODIOUS",
            "atonal": "ATONAL",
        }
    
    @schemas.classproperty
    def MONOTONOUS(cls):
        return cls("monotonous")
    
    @schemas.classproperty
    def MODERATE_MELODIOUSNESS(cls):
        return cls("moderate melodiousness")
    
    @schemas.classproperty
    def MELODIOUS(cls):
        return cls("melodious")
    
    @schemas.classproperty
    def ATONAL(cls):
        return cls("atonal")


class HarmonySchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "very dissonant": "VERY_DISSONANT",
            "dissonant": "DISSONANT",
            "moderate harmonies": "MODERATE_HARMONIES",
            "harmonious": "HARMONIOUS",
            "very harmonious": "VERY_HARMONIOUS",
        }
    
    @schemas.classproperty
    def VERY_DISSONANT(cls):
        return cls("very dissonant")
    
    @schemas.classproperty
    def DISSONANT(cls):
        return cls("dissonant")
    
    @schemas.classproperty
    def MODERATE_HARMONIES(cls):
        return cls("moderate harmonies")
    
    @schemas.classproperty
    def HARMONIOUS(cls):
        return cls("harmonious")
    
    @schemas.classproperty
    def VERY_HARMONIOUS(cls):
        return cls("very harmonious")


class TextureSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "very thin": "VERY_THIN",
            "thin": "THIN",
            "moderate texture": "MODERATE_TEXTURE",
            "full": "FULL",
            "very full": "VERY_FULL",
        }
    
    @schemas.classproperty
    def VERY_THIN(cls):
        return cls("very thin")
    
    @schemas.classproperty
    def THIN(cls):
        return cls("thin")
    
    @schemas.classproperty
    def MODERATE_TEXTURE(cls):
        return cls("moderate texture")
    
    @schemas.classproperty
    def FULL(cls):
        return cls("full")
    
    @schemas.classproperty
    def VERY_FULL(cls):
        return cls("very full")


class GroovynessSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "very steady": "VERY_STEADY",
            "steady": "STEADY",
            "moderate rhythm feel": "MODERATE_RHYTHM_FEEL",
            "groovy": "GROOVY",
            "very groovy": "VERY_GROOVY",
        }
    
    @schemas.classproperty
    def VERY_STEADY(cls):
        return cls("very steady")
    
    @schemas.classproperty
    def STEADY(cls):
        return cls("steady")
    
    @schemas.classproperty
    def MODERATE_RHYTHM_FEEL(cls):
        return cls("moderate rhythm feel")
    
    @schemas.classproperty
    def GROOVY(cls):
        return cls("groovy")
    
    @schemas.classproperty
    def VERY_GROOVY(cls):
        return cls("very groovy")


class SpaceSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "very compact": "VERY_COMPACT",
            "compact": "COMPACT",
            "moderate space": "MODERATE_SPACE",
            "wide": "WIDE",
            "very wide": "VERY_WIDE",
        }
    
    @schemas.classproperty
    def VERY_COMPACT(cls):
        return cls("very compact")
    
    @schemas.classproperty
    def COMPACT(cls):
        return cls("compact")
    
    @schemas.classproperty
    def MODERATE_SPACE(cls):
        return cls("moderate space")
    
    @schemas.classproperty
    def WIDE(cls):
        return cls("wide")
    
    @schemas.classproperty
    def VERY_WIDE(cls):
        return cls("very wide")


class OriginDecadeSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "pre-1950s": "PRE1950S",
            "1950s": "DIGIT_ONE_950S",
            "1960s": "DIGIT_ONE_960S",
            "1970s": "DIGIT_ONE_970S",
            "1980s": "DIGIT_ONE_980S",
            "1990s": "DIGIT_ONE_990S",
            "2000s": "DIGIT_TWO_000S",
            "2010s": "DIGIT_TWO_010S",
            "2020s": "DIGIT_TWO_020S",
        }
    
    @schemas.classproperty
    def PRE1950S(cls):
        return cls("pre-1950s")
    
    @schemas.classproperty
    def DIGIT_ONE_950S(cls):
        return cls("1950s")
    
    @schemas.classproperty
    def DIGIT_ONE_960S(cls):
        return cls("1960s")
    
    @schemas.classproperty
    def DIGIT_ONE_970S(cls):
        return cls("1970s")
    
    @schemas.classproperty
    def DIGIT_ONE_980S(cls):
        return cls("1980s")
    
    @schemas.classproperty
    def DIGIT_ONE_990S(cls):
        return cls("1990s")
    
    @schemas.classproperty
    def DIGIT_TWO_000S(cls):
        return cls("2000s")
    
    @schemas.classproperty
    def DIGIT_TWO_010S(cls):
        return cls("2010s")
    
    @schemas.classproperty
    def DIGIT_TWO_020S(cls):
        return cls("2020s")


class CurateabilitySchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "curateable": "CURATEABLE",
            "uncurateable": "UNCURATEABLE",
        }
    
    @schemas.classproperty
    def CURATEABLE(cls):
        return cls("curateable")
    
    @schemas.classproperty
    def UNCURATEABLE(cls):
        return cls("uncurateable")


class UseCaseSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "background": "BACKGROUND",
            "sport": "SPORT",
            "focus": "FOCUS",
            "christmas": "CHRISTMAS",
            "film": "FILM",
            "summer": "SUMMER",
            "adverts": "ADVERTS",
            "party": "PARTY",
            "relax": "RELAX",
        }
    
    @schemas.classproperty
    def BACKGROUND(cls):
        return cls("background")
    
    @schemas.classproperty
    def SPORT(cls):
        return cls("sport")
    
    @schemas.classproperty
    def FOCUS(cls):
        return cls("focus")
    
    @schemas.classproperty
    def CHRISTMAS(cls):
        return cls("christmas")
    
    @schemas.classproperty
    def FILM(cls):
        return cls("film")
    
    @schemas.classproperty
    def SUMMER(cls):
        return cls("summer")
    
    @schemas.classproperty
    def ADVERTS(cls):
        return cls("adverts")
    
    @schemas.classproperty
    def PARTY(cls):
        return cls("party")
    
    @schemas.classproperty
    def RELAX(cls):
        return cls("relax")


class ChannelSuitabilitySchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "Spotify": "SPOTIFY",
            "TikTok": "TIK_TOK",
            "Unfitting": "UNFITTING",
            "YouTube": "YOU_TUBE",
        }
    
    @schemas.classproperty
    def SPOTIFY(cls):
        return cls("Spotify")
    
    @schemas.classproperty
    def TIK_TOK(cls):
        return cls("TikTok")
    
    @schemas.classproperty
    def UNFITTING(cls):
        return cls("Unfitting")
    
    @schemas.classproperty
    def YOU_TUBE(cls):
        return cls("YouTube")
SongtradrTrackIdSchema = schemas.StrSchema


class ShuffledSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "true": "TRUE",
            "false": "FALSE",
        }
    
    @schemas.classproperty
    def TRUE(cls):
        return cls("true")
    
    @schemas.classproperty
    def FALSE(cls):
        return cls("false")


class SortSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "popularityDesc": "POPULARITY_DESC",
            "popularityAsc": "POPULARITY_ASC",
            "releaseDateDesc": "RELEASE_DATE_DESC",
            "releaseDateAsc": "RELEASE_DATE_ASC",
        }
    
    @schemas.classproperty
    def POPULARITY_DESC(cls):
        return cls("popularityDesc")
    
    @schemas.classproperty
    def POPULARITY_ASC(cls):
        return cls("popularityAsc")
    
    @schemas.classproperty
    def RELEASE_DATE_DESC(cls):
        return cls("releaseDateDesc")
    
    @schemas.classproperty
    def RELEASE_DATE_ASC(cls):
        return cls("releaseDateAsc")
PageSchema = schemas.IntSchema
SizeSchema = schemas.IntSchema
RequestRequiredQueryParams = typing_extensions.TypedDict(
    'RequestRequiredQueryParams',
    {
    }
)
RequestOptionalQueryParams = typing_extensions.TypedDict(
    'RequestOptionalQueryParams',
    {
        'similarToRecording': typing.Union[SimilarToRecordingSchema, str, ],
        'contributor': typing.Union[ContributorSchema, str, ],
        'mainArtist': typing.Union[MainArtistSchema, str, ],
        'composer': typing.Union[ComposerSchema, str, ],
        'title': typing.Union[TitleSchema, str, ],
        'language': typing.Union[LanguageSchema, str, ],
        'genre': typing.Union[GenreSchema, str, ],
        'primaryMoodCluster': typing.Union[PrimaryMoodClusterSchema, str, ],
        'valence': typing.Union[ValenceSchema, str, ],
        'arousal': typing.Union[ArousalSchema, str, ],
        'pleasantness': typing.Union[PleasantnessSchema, str, ],
        'engagement': typing.Union[EngagementSchema, str, ],
        'vocals': typing.Union[VocalsSchema, str, ],
        'dominantInstrument': typing.Union[DominantInstrumentSchema, str, ],
        'energy': typing.Union[EnergySchema, str, ],
        'soundGeneration': typing.Union[SoundGenerationSchema, str, ],
        'tempo': typing.Union[TempoSchema, str, ],
        'scale': typing.Union[ScaleSchema, str, ],
        'key': typing.Union[KeySchema, str, ],
        'rhythm': typing.Union[RhythmSchema, str, ],
        'primarySoundCharacter': typing.Union[PrimarySoundCharacterSchema, str, ],
        'timbre': typing.Union[TimbreSchema, str, ],
        'roughness': typing.Union[RoughnessSchema, str, ],
        'tonality': typing.Union[TonalitySchema, str, ],
        'harmony': typing.Union[HarmonySchema, str, ],
        'texture': typing.Union[TextureSchema, str, ],
        'groovyness': typing.Union[GroovynessSchema, str, ],
        'space': typing.Union[SpaceSchema, str, ],
        'originDecade': typing.Union[OriginDecadeSchema, str, ],
        'curateability': typing.Union[CurateabilitySchema, str, ],
        'useCase': typing.Union[UseCaseSchema, str, ],
        'channelSuitability': typing.Union[ChannelSuitabilitySchema, str, ],
        'songtradrTrackId': typing.Union[SongtradrTrackIdSchema, str, ],
        'shuffled': typing.Union[ShuffledSchema, str, ],
        'sort': typing.Union[SortSchema, str, ],
        'page': typing.Union[PageSchema, decimal.Decimal, int, ],
        'size': typing.Union[SizeSchema, decimal.Decimal, int, ],
    },
    total=False
)


class RequestQueryParams(RequestRequiredQueryParams, RequestOptionalQueryParams):
    pass


request_query_similar_to_recording = api_client.QueryParameter(
    name="similarToRecording",
    style=api_client.ParameterStyle.FORM,
    schema=SimilarToRecordingSchema,
    explode=True,
)
request_query_contributor = api_client.QueryParameter(
    name="contributor",
    style=api_client.ParameterStyle.FORM,
    schema=ContributorSchema,
    explode=True,
)
request_query_main_artist = api_client.QueryParameter(
    name="mainArtist",
    style=api_client.ParameterStyle.FORM,
    schema=MainArtistSchema,
    explode=True,
)
request_query_composer = api_client.QueryParameter(
    name="composer",
    style=api_client.ParameterStyle.FORM,
    schema=ComposerSchema,
    explode=True,
)
request_query_title = api_client.QueryParameter(
    name="title",
    style=api_client.ParameterStyle.FORM,
    schema=TitleSchema,
    explode=True,
)
request_query_language = api_client.QueryParameter(
    name="language",
    style=api_client.ParameterStyle.FORM,
    schema=LanguageSchema,
    explode=True,
)
request_query_genre = api_client.QueryParameter(
    name="genre",
    style=api_client.ParameterStyle.FORM,
    schema=GenreSchema,
    explode=True,
)
request_query_primary_mood_cluster = api_client.QueryParameter(
    name="primaryMoodCluster",
    style=api_client.ParameterStyle.FORM,
    schema=PrimaryMoodClusterSchema,
    explode=True,
)
request_query_valence = api_client.QueryParameter(
    name="valence",
    style=api_client.ParameterStyle.FORM,
    schema=ValenceSchema,
    explode=True,
)
request_query_arousal = api_client.QueryParameter(
    name="arousal",
    style=api_client.ParameterStyle.FORM,
    schema=ArousalSchema,
    explode=True,
)
request_query_pleasantness = api_client.QueryParameter(
    name="pleasantness",
    style=api_client.ParameterStyle.FORM,
    schema=PleasantnessSchema,
    explode=True,
)
request_query_engagement = api_client.QueryParameter(
    name="engagement",
    style=api_client.ParameterStyle.FORM,
    schema=EngagementSchema,
    explode=True,
)
request_query_vocals = api_client.QueryParameter(
    name="vocals",
    style=api_client.ParameterStyle.FORM,
    schema=VocalsSchema,
    explode=True,
)
request_query_dominant_instrument = api_client.QueryParameter(
    name="dominantInstrument",
    style=api_client.ParameterStyle.FORM,
    schema=DominantInstrumentSchema,
    explode=True,
)
request_query_energy = api_client.QueryParameter(
    name="energy",
    style=api_client.ParameterStyle.FORM,
    schema=EnergySchema,
    explode=True,
)
request_query_sound_generation = api_client.QueryParameter(
    name="soundGeneration",
    style=api_client.ParameterStyle.FORM,
    schema=SoundGenerationSchema,
    explode=True,
)
request_query_tempo = api_client.QueryParameter(
    name="tempo",
    style=api_client.ParameterStyle.FORM,
    schema=TempoSchema,
    explode=True,
)
request_query_scale = api_client.QueryParameter(
    name="scale",
    style=api_client.ParameterStyle.FORM,
    schema=ScaleSchema,
    explode=True,
)
request_query_key = api_client.QueryParameter(
    name="key",
    style=api_client.ParameterStyle.FORM,
    schema=KeySchema,
    explode=True,
)
request_query_rhythm = api_client.QueryParameter(
    name="rhythm",
    style=api_client.ParameterStyle.FORM,
    schema=RhythmSchema,
    explode=True,
)
request_query_primary_sound_character = api_client.QueryParameter(
    name="primarySoundCharacter",
    style=api_client.ParameterStyle.FORM,
    schema=PrimarySoundCharacterSchema,
    explode=True,
)
request_query_timbre = api_client.QueryParameter(
    name="timbre",
    style=api_client.ParameterStyle.FORM,
    schema=TimbreSchema,
    explode=True,
)
request_query_roughness = api_client.QueryParameter(
    name="roughness",
    style=api_client.ParameterStyle.FORM,
    schema=RoughnessSchema,
    explode=True,
)
request_query_tonality = api_client.QueryParameter(
    name="tonality",
    style=api_client.ParameterStyle.FORM,
    schema=TonalitySchema,
    explode=True,
)
request_query_harmony = api_client.QueryParameter(
    name="harmony",
    style=api_client.ParameterStyle.FORM,
    schema=HarmonySchema,
    explode=True,
)
request_query_texture = api_client.QueryParameter(
    name="texture",
    style=api_client.ParameterStyle.FORM,
    schema=TextureSchema,
    explode=True,
)
request_query_groovyness = api_client.QueryParameter(
    name="groovyness",
    style=api_client.ParameterStyle.FORM,
    schema=GroovynessSchema,
    explode=True,
)
request_query_space = api_client.QueryParameter(
    name="space",
    style=api_client.ParameterStyle.FORM,
    schema=SpaceSchema,
    explode=True,
)
request_query_origin_decade = api_client.QueryParameter(
    name="originDecade",
    style=api_client.ParameterStyle.FORM,
    schema=OriginDecadeSchema,
    explode=True,
)
request_query_curateability = api_client.QueryParameter(
    name="curateability",
    style=api_client.ParameterStyle.FORM,
    schema=CurateabilitySchema,
    explode=True,
)
request_query_use_case = api_client.QueryParameter(
    name="useCase",
    style=api_client.ParameterStyle.FORM,
    schema=UseCaseSchema,
    explode=True,
)
request_query_channel_suitability = api_client.QueryParameter(
    name="channelSuitability",
    style=api_client.ParameterStyle.FORM,
    schema=ChannelSuitabilitySchema,
    explode=True,
)
request_query_songtradr_track_id = api_client.QueryParameter(
    name="songtradrTrackId",
    style=api_client.ParameterStyle.FORM,
    schema=SongtradrTrackIdSchema,
    explode=True,
)
request_query_shuffled = api_client.QueryParameter(
    name="shuffled",
    style=api_client.ParameterStyle.FORM,
    schema=ShuffledSchema,
    explode=True,
)
request_query_sort = api_client.QueryParameter(
    name="sort",
    style=api_client.ParameterStyle.FORM,
    schema=SortSchema,
    explode=True,
)
request_query_page = api_client.QueryParameter(
    name="page",
    style=api_client.ParameterStyle.FORM,
    schema=PageSchema,
    explode=True,
)
request_query_size = api_client.QueryParameter(
    name="size",
    style=api_client.ParameterStyle.FORM,
    schema=SizeSchema,
    explode=True,
)
_auth = [
    'bearer-jwt',
]
SchemaFor200ResponseBodyApplicationJson = RecordingListDTO


@dataclass
class ApiResponseFor200(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[
        SchemaFor200ResponseBodyApplicationJson,
    ]
    headers: schemas.Unset = schemas.unset


_response_for_200 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor200,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor200ResponseBodyApplicationJson),
    },
)
SchemaFor401ResponseBodyApplicationJson = ErrorResponse


@dataclass
class ApiResponseFor401(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[
        SchemaFor401ResponseBodyApplicationJson,
    ]
    headers: schemas.Unset = schemas.unset


_response_for_401 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor401,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor401ResponseBodyApplicationJson),
    },
)
SchemaFor429ResponseBodyApplicationJson = ErrorResponse


@dataclass
class ApiResponseFor429(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[
        SchemaFor429ResponseBodyApplicationJson,
    ]
    headers: schemas.Unset = schemas.unset


_response_for_429 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor429,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor429ResponseBodyApplicationJson),
    },
)
SchemaFor500ResponseBodyApplicationJson = ErrorResponse


@dataclass
class ApiResponseFor500(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[
        SchemaFor500ResponseBodyApplicationJson,
    ]
    headers: schemas.Unset = schemas.unset


_response_for_500 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor500,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor500ResponseBodyApplicationJson),
    },
)
_status_code_to_response = {
    '200': _response_for_200,
    '401': _response_for_401,
    '429': _response_for_429,
    '500': _response_for_500,
}
_all_accept_content_types = (
    'application/json',
)


class BaseApi(api_client.Api):
    @typing.overload
    def _search_recordings_oapg(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[
        ApiResponseFor200,
    ]: ...

    @typing.overload
    def _search_recordings_oapg(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization: ...

    @typing.overload
    def _search_recordings_oapg(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]: ...

    def _search_recordings_oapg(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        """
        Recordings by contributors, moods, musical features and more.
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestQueryParams, query_params)
        used_path = path.value

        prefix_separator_iterator = None
        for parameter in (
            request_query_similar_to_recording,
            request_query_contributor,
            request_query_main_artist,
            request_query_composer,
            request_query_title,
            request_query_language,
            request_query_genre,
            request_query_primary_mood_cluster,
            request_query_valence,
            request_query_arousal,
            request_query_pleasantness,
            request_query_engagement,
            request_query_vocals,
            request_query_dominant_instrument,
            request_query_energy,
            request_query_sound_generation,
            request_query_tempo,
            request_query_scale,
            request_query_key,
            request_query_rhythm,
            request_query_primary_sound_character,
            request_query_timbre,
            request_query_roughness,
            request_query_tonality,
            request_query_harmony,
            request_query_texture,
            request_query_groovyness,
            request_query_space,
            request_query_origin_decade,
            request_query_curateability,
            request_query_use_case,
            request_query_channel_suitability,
            request_query_songtradr_track_id,
            request_query_shuffled,
            request_query_sort,
            request_query_page,
            request_query_size,
        ):
            parameter_data = query_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            if prefix_separator_iterator is None:
                prefix_separator_iterator = parameter.get_prefix_separator_iterator()
            serialized_data = parameter.serialize(parameter_data, prefix_separator_iterator)
            for serialized_value in serialized_data.values():
                used_path += serialized_value

        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add('Accept', accept_content_type)

        response = self.api_client.call_api(
            resource_path=used_path,
            method='get'.upper(),
            headers=_headers,
            auth_settings=_auth,
            stream=stream,
            timeout=timeout,
        )

        if skip_deserialization:
            api_response = api_client.ApiResponseWithoutDeserialization(response=response)
        else:
            response_for_status = _status_code_to_response.get(str(response.status))
            if response_for_status:
                api_response = response_for_status.deserialize(response, self.api_client.configuration)
            else:
                api_response = api_client.ApiResponseWithoutDeserialization(response=response)

        if not 200 <= response.status <= 299:
            raise exceptions.ApiException(
                status=response.status,
                reason=response.reason,
                api_response=api_response
            )

        return api_response


class SearchRecordings(BaseApi):
    # this class is used by api classes that refer to endpoints with operationId fn names

    @typing.overload
    def search_recordings(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[
        ApiResponseFor200,
    ]: ...

    @typing.overload
    def search_recordings(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization: ...

    @typing.overload
    def search_recordings(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]: ...

    def search_recordings(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        return self._search_recordings_oapg(
            query_params=query_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization
        )


class ApiForget(BaseApi):
    # this class is used by api classes that refer to endpoints by path and http method names

    @typing.overload
    def get(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[
        ApiResponseFor200,
    ]: ...

    @typing.overload
    def get(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization: ...

    @typing.overload
    def get(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]: ...

    def get(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        return self._search_recordings_oapg(
            query_params=query_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization
        )


