# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.  # noqa: E501

    The version of the OpenAPI document: 1.12.21
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, conlist

class SaveTaggramsDTO(BaseModel):
    """
    Timeseries of tags.
    """
    timestamps: Optional[conlist(Union[StrictFloat, StrictInt])] = None
    level1_genre: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="level1Genre")
    level2_genre: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="level2Genre")
    song_rating: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="songRating")
    performance_rating: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="performanceRating")
    production_rating: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="productionRating")
    mood_cluster: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="moodCluster")
    vocals: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    dominant_instrument: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="dominantInstrument")
    sound_generation: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="soundGeneration")
    rhythm: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    tonality: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    audience_age: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="audienceAge")
    audience_gender: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="audienceGender")
    audience_region: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="audienceRegion")
    origin_region: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="originRegion")
    origin_decade: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="originDecade")
    language_of_performance: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="languageOfPerformance")
    arousal: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    valence: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    pleasantness: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    engagement: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    energy: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    timbre: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    roughness: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    harmony: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    texture: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    groovyness: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    space: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    curateability: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    use_case: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="useCase")
    social_media: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="socialMedia")
    industry_suitability: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="industrySuitability")
    __properties = ["timestamps", "level1Genre", "level2Genre", "songRating", "performanceRating", "productionRating", "moodCluster", "vocals", "dominantInstrument", "soundGeneration", "rhythm", "tonality", "audienceAge", "audienceGender", "audienceRegion", "originRegion", "originDecade", "languageOfPerformance", "arousal", "valence", "pleasantness", "engagement", "energy", "timbre", "roughness", "harmony", "texture", "groovyness", "space", "curateability", "useCase", "socialMedia", "industrySuitability"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SaveTaggramsDTO:
        """Create an instance of SaveTaggramsDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SaveTaggramsDTO:
        """Create an instance of SaveTaggramsDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SaveTaggramsDTO.parse_obj(obj)

        _obj = SaveTaggramsDTO.parse_obj({
            "timestamps": obj.get("timestamps"),
            "level1_genre": obj.get("level1Genre"),
            "level2_genre": obj.get("level2Genre"),
            "song_rating": obj.get("songRating"),
            "performance_rating": obj.get("performanceRating"),
            "production_rating": obj.get("productionRating"),
            "mood_cluster": obj.get("moodCluster"),
            "vocals": obj.get("vocals"),
            "dominant_instrument": obj.get("dominantInstrument"),
            "sound_generation": obj.get("soundGeneration"),
            "rhythm": obj.get("rhythm"),
            "tonality": obj.get("tonality"),
            "audience_age": obj.get("audienceAge"),
            "audience_gender": obj.get("audienceGender"),
            "audience_region": obj.get("audienceRegion"),
            "origin_region": obj.get("originRegion"),
            "origin_decade": obj.get("originDecade"),
            "language_of_performance": obj.get("languageOfPerformance"),
            "arousal": obj.get("arousal"),
            "valence": obj.get("valence"),
            "pleasantness": obj.get("pleasantness"),
            "engagement": obj.get("engagement"),
            "energy": obj.get("energy"),
            "timbre": obj.get("timbre"),
            "roughness": obj.get("roughness"),
            "harmony": obj.get("harmony"),
            "texture": obj.get("texture"),
            "groovyness": obj.get("groovyness"),
            "space": obj.get("space"),
            "curateability": obj.get("curateability"),
            "use_case": obj.get("useCase"),
            "social_media": obj.get("socialMedia"),
            "industry_suitability": obj.get("industrySuitability")
        })
        return _obj

