# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.  # noqa: E501

    The version of the OpenAPI document: 1.12.22
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import unittest

import songtradr_api_client_python
from songtradr_api_client_python.api.recording_api import RecordingApi  # noqa: E501
from songtradr_api_client_python.rest import ApiException


class TestRecordingApi(unittest.TestCase):
    """RecordingApi unit test stubs"""

    def setUp(self):
        self.api = songtradr_api_client_python.api.recording_api.RecordingApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_recordings_by_ids_with_musical_features(self):
        """Test case for recordings_by_ids_with_musical_features

        AI generated moods, musical features and more for recordings.  # noqa: E501
        """
        pass

    def test_recordings_by_ids_with_similarities(self):
        """Test case for recordings_by_ids_with_similarities

        Similar recordings for a list of recordings.  # noqa: E501
        """
        pass

    def test_recordings_by_ids_with_taggrams(self):
        """Test case for recordings_by_ids_with_taggrams

        Timeseries of AI generated moods, musical features and more for a list of recordings.  # noqa: E501
        """
        pass

    def test_recordings_by_ids_with_tagstrengths(self):
        """Test case for recordings_by_ids_with_tagstrengths

        Strengths as numerical representations for AI generated moods, musical features and more for recordings.  # noqa: E501
        """
        pass

    def test_recordings_large_by_ids(self):
        """Test case for recordings_large_by_ids

        Recordings by IDs with a large response.  # noqa: E501
        """
        pass

    def test_recordings_medium_by_ids(self):
        """Test case for recordings_medium_by_ids

        Recordings by IDs with a medium sized response.  # noqa: E501
        """
        pass

    def test_recordings_small_by_ids(self):
        """Test case for recordings_small_by_ids

        Recordings by IDs with a small response.  # noqa: E501
        """
        pass

    def test_search_recordings(self):
        """Test case for search_recordings

        Recordings by contributors, moods, musical features and more.  # noqa: E501
        """
        pass

    def test_search_recordings_granular(self):
        """Test case for search_recordings_granular

        Recordings by granular search options.  # noqa: E501
        """
        pass

    def test_search_recordings_granular_abstraction(self):
        """Test case for search_recordings_granular_abstraction

        Recordings by abstracted wordings and granular search options.  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
