# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.  # noqa: E501

    The version of the OpenAPI document: 1.12.24
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import datetime

from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr, conint, conlist

from typing import Any, Dict, List, Optional, Union

from songtradr_api_client_python.models.file_list_dto import FileListDTO
from songtradr_api_client_python.models.file_minimal_with_url_dto import FileMinimalWithUrlDTO
from songtradr_api_client_python.models.file_small_dto import FileSmallDTO
from songtradr_api_client_python.models.file_upload_dto import FileUploadDTO
from songtradr_api_client_python.models.file_w_ith_url_dto import FileWIthUrlDTO
from songtradr_api_client_python.models.files_summary_dto import FilesSummaryDTO
from songtradr_api_client_python.models.forgot_password_dto import ForgotPasswordDTO
from songtradr_api_client_python.models.init_put_recording_audio_dto import InitPutRecordingAudioDTO
from songtradr_api_client_python.models.jwt_token_dto import JwtTokenDTO
from songtradr_api_client_python.models.login_dto import LoginDTO
from songtradr_api_client_python.models.recording_minimal_with_taggrams_dto import RecordingMinimalWithTaggramsDTO
from songtradr_api_client_python.models.recording_minimal_with_tagstrengths_dto import RecordingMinimalWithTagstrengthsDTO
from songtradr_api_client_python.models.save_file_recording_dto import SaveFileRecordingDTO
from songtradr_api_client_python.models.save_referrer_dto import SaveReferrerDTO
from songtradr_api_client_python.models.save_user_dto import SaveUserDTO
from songtradr_api_client_python.models.sign_up_dto import SignUpDTO
from songtradr_api_client_python.models.token_request import TokenRequest
from songtradr_api_client_python.models.update_password_dto import UpdatePasswordDTO
from songtradr_api_client_python.models.user_dto import UserDTO

from songtradr_api_client_python.api_client import ApiClient
from songtradr_api_client_python.api_response import ApiResponse
from songtradr_api_client_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class UserApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_user_referrer(self, save_referrer_dto : SaveReferrerDTO, **kwargs) -> object:  # noqa: E501
        """(Deprecated) create_user_referrer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_user_referrer(save_referrer_dto, async_req=True)
        >>> result = thread.get()

        :param save_referrer_dto: (required)
        :type save_referrer_dto: SaveReferrerDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_user_referrer_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_user_referrer_with_http_info(save_referrer_dto, **kwargs)  # noqa: E501

    @validate_arguments
    def create_user_referrer_with_http_info(self, save_referrer_dto : SaveReferrerDTO, **kwargs) -> ApiResponse:  # noqa: E501
        """(Deprecated) create_user_referrer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_user_referrer_with_http_info(save_referrer_dto, async_req=True)
        >>> result = thread.get()

        :param save_referrer_dto: (required)
        :type save_referrer_dto: SaveReferrerDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        warnings.warn("POST /api/v1/user/referrers/new is deprecated.", DeprecationWarning)

        _params = locals()

        _all_params = [
            'save_referrer_dto'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_user_referrer" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['save_referrer_dto'] is not None:
            _body_params = _params['save_referrer_dto']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/referrers/new', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_user_file(self, object_key : Annotated[StrictStr, Field(..., description="ObjectKey of the file that should be deleted.")], **kwargs) -> object:  # noqa: E501
        """Delete file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user_file(object_key, async_req=True)
        >>> result = thread.get()

        :param object_key: ObjectKey of the file that should be deleted. (required)
        :type object_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_user_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_user_file_with_http_info(object_key, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_user_file_with_http_info(self, object_key : Annotated[StrictStr, Field(..., description="ObjectKey of the file that should be deleted.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user_file_with_http_info(object_key, async_req=True)
        >>> result = thread.get()

        :param object_key: ObjectKey of the file that should be deleted. (required)
        :type object_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'object_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['object_key']:
            _path_params['objectKey'] = _params['object_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/file/{objectKey}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def edit_me(self, save_user_dto : SaveUserDTO, **kwargs) -> object:  # noqa: E501
        """Edit details for a logged-in user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_me(save_user_dto, async_req=True)
        >>> result = thread.get()

        :param save_user_dto: (required)
        :type save_user_dto: SaveUserDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the edit_me_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.edit_me_with_http_info(save_user_dto, **kwargs)  # noqa: E501

    @validate_arguments
    def edit_me_with_http_info(self, save_user_dto : SaveUserDTO, **kwargs) -> ApiResponse:  # noqa: E501
        """Edit details for a logged-in user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_me_with_http_info(save_user_dto, async_req=True)
        >>> result = thread.get()

        :param save_user_dto: (required)
        :type save_user_dto: SaveUserDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'save_user_dto'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_me" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['save_user_dto'] is not None:
            _body_params = _params['save_user_dto']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/me', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def forgot_password(self, forgot_password_dto : ForgotPasswordDTO, **kwargs) -> object:  # noqa: E501
        """Send a password reset email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.forgot_password(forgot_password_dto, async_req=True)
        >>> result = thread.get()

        :param forgot_password_dto: (required)
        :type forgot_password_dto: ForgotPasswordDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the forgot_password_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.forgot_password_with_http_info(forgot_password_dto, **kwargs)  # noqa: E501

    @validate_arguments
    def forgot_password_with_http_info(self, forgot_password_dto : ForgotPasswordDTO, **kwargs) -> ApiResponse:  # noqa: E501
        """Send a password reset email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.forgot_password_with_http_info(forgot_password_dto, async_req=True)
        >>> result = thread.get()

        :param forgot_password_dto: (required)
        :type forgot_password_dto: ForgotPasswordDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'forgot_password_dto'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method forgot_password" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['forgot_password_dto'] is not None:
            _body_params = _params['forgot_password_dto']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json', 'application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/forgot-password', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def initiate_user_file_upload(self, name : Annotated[StrictStr, Field(..., description="The Name of the file that will be uploaded")], folder : Annotated[StrictStr, Field(..., description="The Name of the folder that the file will be placed in")], file_upload_dto : Optional[FileUploadDTO] = None, **kwargs) -> InitPutRecordingAudioDTO:  # noqa: E501
        """Initialize a file upload. Responds with an URL where the file can be uploaded.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.initiate_user_file_upload(name, folder, file_upload_dto, async_req=True)
        >>> result = thread.get()

        :param name: The Name of the file that will be uploaded (required)
        :type name: str
        :param folder: The Name of the folder that the file will be placed in (required)
        :type folder: str
        :param file_upload_dto:
        :type file_upload_dto: FileUploadDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InitPutRecordingAudioDTO
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the initiate_user_file_upload_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.initiate_user_file_upload_with_http_info(name, folder, file_upload_dto, **kwargs)  # noqa: E501

    @validate_arguments
    def initiate_user_file_upload_with_http_info(self, name : Annotated[StrictStr, Field(..., description="The Name of the file that will be uploaded")], folder : Annotated[StrictStr, Field(..., description="The Name of the folder that the file will be placed in")], file_upload_dto : Optional[FileUploadDTO] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Initialize a file upload. Responds with an URL where the file can be uploaded.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.initiate_user_file_upload_with_http_info(name, folder, file_upload_dto, async_req=True)
        >>> result = thread.get()

        :param name: The Name of the file that will be uploaded (required)
        :type name: str
        :param folder: The Name of the folder that the file will be placed in (required)
        :type folder: str
        :param file_upload_dto:
        :type file_upload_dto: FileUploadDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InitPutRecordingAudioDTO, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'name',
            'folder',
            'file_upload_dto'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method initiate_user_file_upload" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['name']:
            _path_params['name'] = _params['name']


        # process the query parameters
        _query_params = []
        if _params.get('folder') is not None:  # noqa: E501
            _query_params.append(('folder', _params['folder']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['file_upload_dto'] is not None:
            _body_params = _params['file_upload_dto']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "InitPutRecordingAudioDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/file/{name}/initUpload', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def login(self, login_dto : LoginDTO, **kwargs) -> JwtTokenDTO:  # noqa: E501
        """Login to generate a bearer token.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.login(login_dto, async_req=True)
        >>> result = thread.get()

        :param login_dto: (required)
        :type login_dto: LoginDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JwtTokenDTO
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the login_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.login_with_http_info(login_dto, **kwargs)  # noqa: E501

    @validate_arguments
    def login_with_http_info(self, login_dto : LoginDTO, **kwargs) -> ApiResponse:  # noqa: E501
        """Login to generate a bearer token.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.login_with_http_info(login_dto, async_req=True)
        >>> result = thread.get()

        :param login_dto: (required)
        :type login_dto: LoginDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JwtTokenDTO, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'login_dto'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method login" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['login_dto'] is not None:
            _body_params = _params['login_dto']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "JwtTokenDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/login', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def me(self, **kwargs) -> UserDTO:  # noqa: E501
        """Details for a logged-in user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.me(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserDTO
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the me_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.me_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def me_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Details for a logged-in user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.me_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UserDTO, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method me" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "UserDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/me', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def recordings_by_folder_with_taggrams(self, folder_name : Annotated[StrictStr, Field(..., description="Folder name")], category_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None, tag_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None, genre_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None, from_timestamp : Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data starting from from this timestamp in seconds.")] = None, fill_with_zero : Annotated[Optional[StrictBool], Field(description="If set to true, empty timeseries are filled with timeseries of 0.0 values.")] = None, page : Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None, sort : Annotated[Optional[conlist(StrictStr)], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None, **kwargs) -> List[RecordingMinimalWithTaggramsDTO]:  # noqa: E501
        """Timeseries of AI generated moods, musical features and more for recordings in your folder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_by_folder_with_taggrams(folder_name, category_name, tag_name, genre_name, from_timestamp, fill_with_zero, page, size, sort, async_req=True)
        >>> result = thread.get()

        :param folder_name: Folder name (required)
        :type folder_name: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param from_timestamp: Show only taggrams data starting from from this timestamp in seconds.
        :type from_timestamp: float
        :param fill_with_zero: If set to true, empty timeseries are filled with timeseries of 0.0 values.
        :type fill_with_zero: bool
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[RecordingMinimalWithTaggramsDTO]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the recordings_by_folder_with_taggrams_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.recordings_by_folder_with_taggrams_with_http_info(folder_name, category_name, tag_name, genre_name, from_timestamp, fill_with_zero, page, size, sort, **kwargs)  # noqa: E501

    @validate_arguments
    def recordings_by_folder_with_taggrams_with_http_info(self, folder_name : Annotated[StrictStr, Field(..., description="Folder name")], category_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None, tag_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None, genre_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None, from_timestamp : Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data starting from from this timestamp in seconds.")] = None, fill_with_zero : Annotated[Optional[StrictBool], Field(description="If set to true, empty timeseries are filled with timeseries of 0.0 values.")] = None, page : Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None, sort : Annotated[Optional[conlist(StrictStr)], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Timeseries of AI generated moods, musical features and more for recordings in your folder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_by_folder_with_taggrams_with_http_info(folder_name, category_name, tag_name, genre_name, from_timestamp, fill_with_zero, page, size, sort, async_req=True)
        >>> result = thread.get()

        :param folder_name: Folder name (required)
        :type folder_name: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param from_timestamp: Show only taggrams data starting from from this timestamp in seconds.
        :type from_timestamp: float
        :param fill_with_zero: If set to true, empty timeseries are filled with timeseries of 0.0 values.
        :type fill_with_zero: bool
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[RecordingMinimalWithTaggramsDTO], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'folder_name',
            'category_name',
            'tag_name',
            'genre_name',
            'from_timestamp',
            'fill_with_zero',
            'page',
            'size',
            'sort'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recordings_by_folder_with_taggrams" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['folder_name']:
            _path_params['folderName'] = _params['folder_name']


        # process the query parameters
        _query_params = []
        if _params.get('category_name') is not None:  # noqa: E501
            _query_params.append(('categoryName', _params['category_name']))

        if _params.get('tag_name') is not None:  # noqa: E501
            _query_params.append(('tagName', _params['tag_name']))

        if _params.get('genre_name') is not None:  # noqa: E501
            _query_params.append(('genreName', _params['genre_name']))

        if _params.get('from_timestamp') is not None:  # noqa: E501
            _query_params.append(('fromTimestamp', _params['from_timestamp']))

        if _params.get('fill_with_zero') is not None:  # noqa: E501
            _query_params.append(('fillWithZero', _params['fill_with_zero']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('size') is not None:  # noqa: E501
            _query_params.append(('size', _params['size']))

        if _params.get('sort') is not None:  # noqa: E501
            _query_params.append(('sort', _params['sort']))
            _collection_formats['sort'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "List[RecordingMinimalWithTaggramsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/folder/{folderName}/taggrams', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def recordings_by_folder_with_tagstrengths(self, folder_name : Annotated[StrictStr, Field(..., description="Folder name")], category_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None, tag_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None, genre_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None, page : Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None, sort : Annotated[Optional[conlist(StrictStr)], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None, **kwargs) -> List[RecordingMinimalWithTagstrengthsDTO]:  # noqa: E501
        """Strengths as numerical representations for AI generated moods, musical features and more for recordings in your folder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_by_folder_with_tagstrengths(folder_name, category_name, tag_name, genre_name, page, size, sort, async_req=True)
        >>> result = thread.get()

        :param folder_name: Folder name (required)
        :type folder_name: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[RecordingMinimalWithTagstrengthsDTO]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the recordings_by_folder_with_tagstrengths_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.recordings_by_folder_with_tagstrengths_with_http_info(folder_name, category_name, tag_name, genre_name, page, size, sort, **kwargs)  # noqa: E501

    @validate_arguments
    def recordings_by_folder_with_tagstrengths_with_http_info(self, folder_name : Annotated[StrictStr, Field(..., description="Folder name")], category_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None, tag_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None, genre_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None, page : Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None, sort : Annotated[Optional[conlist(StrictStr)], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Strengths as numerical representations for AI generated moods, musical features and more for recordings in your folder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_by_folder_with_tagstrengths_with_http_info(folder_name, category_name, tag_name, genre_name, page, size, sort, async_req=True)
        >>> result = thread.get()

        :param folder_name: Folder name (required)
        :type folder_name: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[RecordingMinimalWithTagstrengthsDTO], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'folder_name',
            'category_name',
            'tag_name',
            'genre_name',
            'page',
            'size',
            'sort'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recordings_by_folder_with_tagstrengths" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['folder_name']:
            _path_params['folderName'] = _params['folder_name']


        # process the query parameters
        _query_params = []
        if _params.get('category_name') is not None:  # noqa: E501
            _query_params.append(('categoryName', _params['category_name']))

        if _params.get('tag_name') is not None:  # noqa: E501
            _query_params.append(('tagName', _params['tag_name']))

        if _params.get('genre_name') is not None:  # noqa: E501
            _query_params.append(('genreName', _params['genre_name']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('size') is not None:  # noqa: E501
            _query_params.append(('size', _params['size']))

        if _params.get('sort') is not None:  # noqa: E501
            _query_params.append(('sort', _params['sort']))
            _collection_formats['sort'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "List[RecordingMinimalWithTagstrengthsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/folder/{folderName}/tagstrengths', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def save_playlist(self, isrc : Annotated[Optional[StrictStr], Field(description="Search for a ISRC")] = None, contributor : Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None, main_artist : Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None, composer : Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None, title : Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None, party_and_title : Annotated[Optional[StrictStr], Field(description="Search for party and title.")] = None, language : Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None, genre_names : Optional[conlist(StrictStr)] = None, tag_names : Optional[conlist(StrictStr)] = None, release_date : Optional[datetime] = None, primary_mood_cluster : Optional[StrictStr] = None, secondary_mood_cluster : Optional[StrictStr] = None, tertiary_mood_cluster : Optional[StrictStr] = None, valence : Optional[StrictStr] = None, arousal : Optional[StrictStr] = None, pleasantness : Optional[StrictStr] = None, engagement : Optional[StrictStr] = None, vocals : Optional[StrictStr] = None, dominant_instrument : Optional[StrictStr] = None, secondary_instrument : Optional[StrictStr] = None, tertiary_instrument : Optional[StrictStr] = None, energy : Optional[StrictStr] = None, sound_generation : Optional[StrictStr] = None, tempo : Optional[StrictStr] = None, scale : Optional[StrictStr] = None, rhythm : Optional[StrictStr] = None, primary_sound_character : Optional[StrictStr] = None, timbre : Optional[StrictStr] = None, roughness : Optional[StrictStr] = None, tonality : Optional[StrictStr] = None, harmony : Optional[StrictStr] = None, texture : Optional[StrictStr] = None, groovyness : Optional[StrictStr] = None, space : Optional[StrictStr] = None, production_rating : Optional[StrictStr] = None, performance_rating : Optional[StrictStr] = None, song_rating : Optional[StrictStr] = None, audience_age : Optional[StrictStr] = None, audience_region : Optional[StrictStr] = None, audience_gender : Optional[StrictStr] = None, origin_decade : Optional[StrictStr] = None, curateability : Optional[StrictStr] = None, use_case : Optional[StrictStr] = None, channel_suitability : Optional[StrictStr] = None, similar_to_recording : Optional[StrictStr] = None, create_playlist_with_name : Optional[StrictStr] = None, songtradr_track_id : Optional[StrictStr] = None, usage_name : Optional[StrictStr] = None, bpm_min : Annotated[Optional[StrictInt], Field(description="Search for a minimal bpm.")] = None, bpm_max : Annotated[Optional[StrictInt], Field(description="Search for a maximal bpm.")] = None, name : Annotated[Optional[StrictStr], Field(description="Search for a file name.")] = None, folder : Annotated[Optional[StrictStr], Field(description="Search for a folder.")] = None, extension : Annotated[Optional[StrictStr], Field(description="Search for a file extension.")] = None, upload_end_time : Optional[datetime] = None, min_upload_end_time : Optional[datetime] = None, max_upload_end_time : Optional[datetime] = None, fingerprint_status : Annotated[Optional[StrictStr], Field(description="Search for a fingerprint status.")] = None, inference_status : Annotated[Optional[StrictStr], Field(description="Search for a inference status.")] = None, page : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[conint(strict=True, ge=1)], Field(description="The size of the page to be returned")] = None, sort : Annotated[Optional[conlist(StrictStr)], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None, **kwargs) -> FileListDTO:  # noqa: E501
        """List, search and create playlist of your own files.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_playlist(isrc, contributor, main_artist, composer, title, party_and_title, language, genre_names, tag_names, release_date, primary_mood_cluster, secondary_mood_cluster, tertiary_mood_cluster, valence, arousal, pleasantness, engagement, vocals, dominant_instrument, secondary_instrument, tertiary_instrument, energy, sound_generation, tempo, scale, rhythm, primary_sound_character, timbre, roughness, tonality, harmony, texture, groovyness, space, production_rating, performance_rating, song_rating, audience_age, audience_region, audience_gender, origin_decade, curateability, use_case, channel_suitability, similar_to_recording, create_playlist_with_name, songtradr_track_id, usage_name, bpm_min, bpm_max, name, folder, extension, upload_end_time, min_upload_end_time, max_upload_end_time, fingerprint_status, inference_status, page, size, sort, async_req=True)
        >>> result = thread.get()

        :param isrc: Search for a ISRC
        :type isrc: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param party_and_title: Search for party and title.
        :type party_and_title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param origin_decade:
        :type origin_decade: str
        :param curateability:
        :type curateability: str
        :param use_case:
        :type use_case: str
        :param channel_suitability:
        :type channel_suitability: str
        :param similar_to_recording:
        :type similar_to_recording: str
        :param create_playlist_with_name:
        :type create_playlist_with_name: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min: Search for a minimal bpm.
        :type bpm_min: int
        :param bpm_max: Search for a maximal bpm.
        :type bpm_max: int
        :param name: Search for a file name.
        :type name: str
        :param folder: Search for a folder.
        :type folder: str
        :param extension: Search for a file extension.
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status: Search for a fingerprint status.
        :type fingerprint_status: str
        :param inference_status: Search for a inference status.
        :type inference_status: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FileListDTO
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the save_playlist_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.save_playlist_with_http_info(isrc, contributor, main_artist, composer, title, party_and_title, language, genre_names, tag_names, release_date, primary_mood_cluster, secondary_mood_cluster, tertiary_mood_cluster, valence, arousal, pleasantness, engagement, vocals, dominant_instrument, secondary_instrument, tertiary_instrument, energy, sound_generation, tempo, scale, rhythm, primary_sound_character, timbre, roughness, tonality, harmony, texture, groovyness, space, production_rating, performance_rating, song_rating, audience_age, audience_region, audience_gender, origin_decade, curateability, use_case, channel_suitability, similar_to_recording, create_playlist_with_name, songtradr_track_id, usage_name, bpm_min, bpm_max, name, folder, extension, upload_end_time, min_upload_end_time, max_upload_end_time, fingerprint_status, inference_status, page, size, sort, **kwargs)  # noqa: E501

    @validate_arguments
    def save_playlist_with_http_info(self, isrc : Annotated[Optional[StrictStr], Field(description="Search for a ISRC")] = None, contributor : Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None, main_artist : Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None, composer : Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None, title : Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None, party_and_title : Annotated[Optional[StrictStr], Field(description="Search for party and title.")] = None, language : Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None, genre_names : Optional[conlist(StrictStr)] = None, tag_names : Optional[conlist(StrictStr)] = None, release_date : Optional[datetime] = None, primary_mood_cluster : Optional[StrictStr] = None, secondary_mood_cluster : Optional[StrictStr] = None, tertiary_mood_cluster : Optional[StrictStr] = None, valence : Optional[StrictStr] = None, arousal : Optional[StrictStr] = None, pleasantness : Optional[StrictStr] = None, engagement : Optional[StrictStr] = None, vocals : Optional[StrictStr] = None, dominant_instrument : Optional[StrictStr] = None, secondary_instrument : Optional[StrictStr] = None, tertiary_instrument : Optional[StrictStr] = None, energy : Optional[StrictStr] = None, sound_generation : Optional[StrictStr] = None, tempo : Optional[StrictStr] = None, scale : Optional[StrictStr] = None, rhythm : Optional[StrictStr] = None, primary_sound_character : Optional[StrictStr] = None, timbre : Optional[StrictStr] = None, roughness : Optional[StrictStr] = None, tonality : Optional[StrictStr] = None, harmony : Optional[StrictStr] = None, texture : Optional[StrictStr] = None, groovyness : Optional[StrictStr] = None, space : Optional[StrictStr] = None, production_rating : Optional[StrictStr] = None, performance_rating : Optional[StrictStr] = None, song_rating : Optional[StrictStr] = None, audience_age : Optional[StrictStr] = None, audience_region : Optional[StrictStr] = None, audience_gender : Optional[StrictStr] = None, origin_decade : Optional[StrictStr] = None, curateability : Optional[StrictStr] = None, use_case : Optional[StrictStr] = None, channel_suitability : Optional[StrictStr] = None, similar_to_recording : Optional[StrictStr] = None, create_playlist_with_name : Optional[StrictStr] = None, songtradr_track_id : Optional[StrictStr] = None, usage_name : Optional[StrictStr] = None, bpm_min : Annotated[Optional[StrictInt], Field(description="Search for a minimal bpm.")] = None, bpm_max : Annotated[Optional[StrictInt], Field(description="Search for a maximal bpm.")] = None, name : Annotated[Optional[StrictStr], Field(description="Search for a file name.")] = None, folder : Annotated[Optional[StrictStr], Field(description="Search for a folder.")] = None, extension : Annotated[Optional[StrictStr], Field(description="Search for a file extension.")] = None, upload_end_time : Optional[datetime] = None, min_upload_end_time : Optional[datetime] = None, max_upload_end_time : Optional[datetime] = None, fingerprint_status : Annotated[Optional[StrictStr], Field(description="Search for a fingerprint status.")] = None, inference_status : Annotated[Optional[StrictStr], Field(description="Search for a inference status.")] = None, page : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[conint(strict=True, ge=1)], Field(description="The size of the page to be returned")] = None, sort : Annotated[Optional[conlist(StrictStr)], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List, search and create playlist of your own files.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_playlist_with_http_info(isrc, contributor, main_artist, composer, title, party_and_title, language, genre_names, tag_names, release_date, primary_mood_cluster, secondary_mood_cluster, tertiary_mood_cluster, valence, arousal, pleasantness, engagement, vocals, dominant_instrument, secondary_instrument, tertiary_instrument, energy, sound_generation, tempo, scale, rhythm, primary_sound_character, timbre, roughness, tonality, harmony, texture, groovyness, space, production_rating, performance_rating, song_rating, audience_age, audience_region, audience_gender, origin_decade, curateability, use_case, channel_suitability, similar_to_recording, create_playlist_with_name, songtradr_track_id, usage_name, bpm_min, bpm_max, name, folder, extension, upload_end_time, min_upload_end_time, max_upload_end_time, fingerprint_status, inference_status, page, size, sort, async_req=True)
        >>> result = thread.get()

        :param isrc: Search for a ISRC
        :type isrc: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param party_and_title: Search for party and title.
        :type party_and_title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param origin_decade:
        :type origin_decade: str
        :param curateability:
        :type curateability: str
        :param use_case:
        :type use_case: str
        :param channel_suitability:
        :type channel_suitability: str
        :param similar_to_recording:
        :type similar_to_recording: str
        :param create_playlist_with_name:
        :type create_playlist_with_name: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min: Search for a minimal bpm.
        :type bpm_min: int
        :param bpm_max: Search for a maximal bpm.
        :type bpm_max: int
        :param name: Search for a file name.
        :type name: str
        :param folder: Search for a folder.
        :type folder: str
        :param extension: Search for a file extension.
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status: Search for a fingerprint status.
        :type fingerprint_status: str
        :param inference_status: Search for a inference status.
        :type inference_status: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FileListDTO, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'isrc',
            'contributor',
            'main_artist',
            'composer',
            'title',
            'party_and_title',
            'language',
            'genre_names',
            'tag_names',
            'release_date',
            'primary_mood_cluster',
            'secondary_mood_cluster',
            'tertiary_mood_cluster',
            'valence',
            'arousal',
            'pleasantness',
            'engagement',
            'vocals',
            'dominant_instrument',
            'secondary_instrument',
            'tertiary_instrument',
            'energy',
            'sound_generation',
            'tempo',
            'scale',
            'rhythm',
            'primary_sound_character',
            'timbre',
            'roughness',
            'tonality',
            'harmony',
            'texture',
            'groovyness',
            'space',
            'production_rating',
            'performance_rating',
            'song_rating',
            'audience_age',
            'audience_region',
            'audience_gender',
            'origin_decade',
            'curateability',
            'use_case',
            'channel_suitability',
            'similar_to_recording',
            'create_playlist_with_name',
            'songtradr_track_id',
            'usage_name',
            'bpm_min',
            'bpm_max',
            'name',
            'folder',
            'extension',
            'upload_end_time',
            'min_upload_end_time',
            'max_upload_end_time',
            'fingerprint_status',
            'inference_status',
            'page',
            'size',
            'sort'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_playlist" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('isrc') is not None:  # noqa: E501
            _query_params.append(('ISRC', _params['isrc']))

        if _params.get('contributor') is not None:  # noqa: E501
            _query_params.append(('contributor', _params['contributor']))

        if _params.get('main_artist') is not None:  # noqa: E501
            _query_params.append(('mainArtist', _params['main_artist']))

        if _params.get('composer') is not None:  # noqa: E501
            _query_params.append(('composer', _params['composer']))

        if _params.get('title') is not None:  # noqa: E501
            _query_params.append(('title', _params['title']))

        if _params.get('party_and_title') is not None:  # noqa: E501
            _query_params.append(('partyAndTitle', _params['party_and_title']))

        if _params.get('language') is not None:  # noqa: E501
            _query_params.append(('language', _params['language']))

        if _params.get('genre_names') is not None:  # noqa: E501
            _query_params.append(('genreNames', _params['genre_names']))
            _collection_formats['genreNames'] = 'multi'

        if _params.get('tag_names') is not None:  # noqa: E501
            _query_params.append(('tagNames', _params['tag_names']))
            _collection_formats['tagNames'] = 'multi'

        if _params.get('release_date') is not None:  # noqa: E501
            if isinstance(_params['release_date'], datetime):
                _query_params.append(('releaseDate', _params['release_date'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('releaseDate', _params['release_date']))

        if _params.get('primary_mood_cluster') is not None:  # noqa: E501
            _query_params.append(('primaryMoodCluster', _params['primary_mood_cluster']))

        if _params.get('secondary_mood_cluster') is not None:  # noqa: E501
            _query_params.append(('secondaryMoodCluster', _params['secondary_mood_cluster']))

        if _params.get('tertiary_mood_cluster') is not None:  # noqa: E501
            _query_params.append(('tertiaryMoodCluster', _params['tertiary_mood_cluster']))

        if _params.get('valence') is not None:  # noqa: E501
            _query_params.append(('valence', _params['valence']))

        if _params.get('arousal') is not None:  # noqa: E501
            _query_params.append(('arousal', _params['arousal']))

        if _params.get('pleasantness') is not None:  # noqa: E501
            _query_params.append(('pleasantness', _params['pleasantness']))

        if _params.get('engagement') is not None:  # noqa: E501
            _query_params.append(('engagement', _params['engagement']))

        if _params.get('vocals') is not None:  # noqa: E501
            _query_params.append(('vocals', _params['vocals']))

        if _params.get('dominant_instrument') is not None:  # noqa: E501
            _query_params.append(('dominantInstrument', _params['dominant_instrument']))

        if _params.get('secondary_instrument') is not None:  # noqa: E501
            _query_params.append(('secondaryInstrument', _params['secondary_instrument']))

        if _params.get('tertiary_instrument') is not None:  # noqa: E501
            _query_params.append(('tertiaryInstrument', _params['tertiary_instrument']))

        if _params.get('energy') is not None:  # noqa: E501
            _query_params.append(('energy', _params['energy']))

        if _params.get('sound_generation') is not None:  # noqa: E501
            _query_params.append(('soundGeneration', _params['sound_generation']))

        if _params.get('tempo') is not None:  # noqa: E501
            _query_params.append(('tempo', _params['tempo']))

        if _params.get('scale') is not None:  # noqa: E501
            _query_params.append(('scale', _params['scale']))

        if _params.get('rhythm') is not None:  # noqa: E501
            _query_params.append(('rhythm', _params['rhythm']))

        if _params.get('primary_sound_character') is not None:  # noqa: E501
            _query_params.append(('primarySoundCharacter', _params['primary_sound_character']))

        if _params.get('timbre') is not None:  # noqa: E501
            _query_params.append(('timbre', _params['timbre']))

        if _params.get('roughness') is not None:  # noqa: E501
            _query_params.append(('roughness', _params['roughness']))

        if _params.get('tonality') is not None:  # noqa: E501
            _query_params.append(('tonality', _params['tonality']))

        if _params.get('harmony') is not None:  # noqa: E501
            _query_params.append(('harmony', _params['harmony']))

        if _params.get('texture') is not None:  # noqa: E501
            _query_params.append(('texture', _params['texture']))

        if _params.get('groovyness') is not None:  # noqa: E501
            _query_params.append(('groovyness', _params['groovyness']))

        if _params.get('space') is not None:  # noqa: E501
            _query_params.append(('space', _params['space']))

        if _params.get('production_rating') is not None:  # noqa: E501
            _query_params.append(('productionRating', _params['production_rating']))

        if _params.get('performance_rating') is not None:  # noqa: E501
            _query_params.append(('performanceRating', _params['performance_rating']))

        if _params.get('song_rating') is not None:  # noqa: E501
            _query_params.append(('songRating', _params['song_rating']))

        if _params.get('audience_age') is not None:  # noqa: E501
            _query_params.append(('audienceAge', _params['audience_age']))

        if _params.get('audience_region') is not None:  # noqa: E501
            _query_params.append(('audienceRegion', _params['audience_region']))

        if _params.get('audience_gender') is not None:  # noqa: E501
            _query_params.append(('audienceGender', _params['audience_gender']))

        if _params.get('origin_decade') is not None:  # noqa: E501
            _query_params.append(('originDecade', _params['origin_decade']))

        if _params.get('curateability') is not None:  # noqa: E501
            _query_params.append(('curateability', _params['curateability']))

        if _params.get('use_case') is not None:  # noqa: E501
            _query_params.append(('useCase', _params['use_case']))

        if _params.get('channel_suitability') is not None:  # noqa: E501
            _query_params.append(('channelSuitability', _params['channel_suitability']))

        if _params.get('similar_to_recording') is not None:  # noqa: E501
            _query_params.append(('similarToRecording', _params['similar_to_recording']))

        if _params.get('create_playlist_with_name') is not None:  # noqa: E501
            _query_params.append(('createPlaylistWithName', _params['create_playlist_with_name']))

        if _params.get('songtradr_track_id') is not None:  # noqa: E501
            _query_params.append(('songtradrTrackId', _params['songtradr_track_id']))

        if _params.get('usage_name') is not None:  # noqa: E501
            _query_params.append(('usageName', _params['usage_name']))

        if _params.get('bpm_min') is not None:  # noqa: E501
            _query_params.append(('bpmMin', _params['bpm_min']))

        if _params.get('bpm_max') is not None:  # noqa: E501
            _query_params.append(('bpmMax', _params['bpm_max']))

        if _params.get('name') is not None:  # noqa: E501
            _query_params.append(('name', _params['name']))

        if _params.get('folder') is not None:  # noqa: E501
            _query_params.append(('folder', _params['folder']))

        if _params.get('extension') is not None:  # noqa: E501
            _query_params.append(('extension', _params['extension']))

        if _params.get('upload_end_time') is not None:  # noqa: E501
            if isinstance(_params['upload_end_time'], datetime):
                _query_params.append(('uploadEndTime', _params['upload_end_time'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('uploadEndTime', _params['upload_end_time']))

        if _params.get('min_upload_end_time') is not None:  # noqa: E501
            if isinstance(_params['min_upload_end_time'], datetime):
                _query_params.append(('minUploadEndTime', _params['min_upload_end_time'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('minUploadEndTime', _params['min_upload_end_time']))

        if _params.get('max_upload_end_time') is not None:  # noqa: E501
            if isinstance(_params['max_upload_end_time'], datetime):
                _query_params.append(('maxUploadEndTime', _params['max_upload_end_time'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('maxUploadEndTime', _params['max_upload_end_time']))

        if _params.get('fingerprint_status') is not None:  # noqa: E501
            _query_params.append(('fingerprintStatus', _params['fingerprint_status']))

        if _params.get('inference_status') is not None:  # noqa: E501
            _query_params.append(('inferenceStatus', _params['inference_status']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('size') is not None:  # noqa: E501
            _query_params.append(('size', _params['size']))

        if _params.get('sort') is not None:  # noqa: E501
            _query_params.append(('sort', _params['sort']))
            _collection_formats['sort'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "FileListDTO",
            '403': "ErrorResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/savePlaylist', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def sign_up(self, save_user_dto : SaveUserDTO, **kwargs) -> SignUpDTO:  # noqa: E501
        """Sign up a new user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sign_up(save_user_dto, async_req=True)
        >>> result = thread.get()

        :param save_user_dto: (required)
        :type save_user_dto: SaveUserDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignUpDTO
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the sign_up_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.sign_up_with_http_info(save_user_dto, **kwargs)  # noqa: E501

    @validate_arguments
    def sign_up_with_http_info(self, save_user_dto : SaveUserDTO, **kwargs) -> ApiResponse:  # noqa: E501
        """Sign up a new user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sign_up_with_http_info(save_user_dto, async_req=True)
        >>> result = thread.get()

        :param save_user_dto: (required)
        :type save_user_dto: SaveUserDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SignUpDTO, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'save_user_dto'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sign_up" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['save_user_dto'] is not None:
            _body_params = _params['save_user_dto']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '409': "ErrorResponse",
            '200': "SignUpDTO",
            '403': "ErrorResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/sign-up', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def token(self, token_request : TokenRequest, **kwargs) -> JwtTokenDTO:  # noqa: E501
        """Generates a new JWT token for the given refresh token  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.token(token_request, async_req=True)
        >>> result = thread.get()

        :param token_request: (required)
        :type token_request: TokenRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JwtTokenDTO
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the token_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.token_with_http_info(token_request, **kwargs)  # noqa: E501

    @validate_arguments
    def token_with_http_info(self, token_request : TokenRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """Generates a new JWT token for the given refresh token  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.token_with_http_info(token_request, async_req=True)
        >>> result = thread.get()

        :param token_request: (required)
        :type token_request: TokenRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JwtTokenDTO, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'token_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method token" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['token_request'] is not None:
            _body_params = _params['token_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "JwtTokenDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/token', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_password(self, update_password_dto : UpdatePasswordDTO, **kwargs) -> object:  # noqa: E501
        """Update password by using the password reset token  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_password(update_password_dto, async_req=True)
        >>> result = thread.get()

        :param update_password_dto: (required)
        :type update_password_dto: UpdatePasswordDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_password_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_password_with_http_info(update_password_dto, **kwargs)  # noqa: E501

    @validate_arguments
    def update_password_with_http_info(self, update_password_dto : UpdatePasswordDTO, **kwargs) -> ApiResponse:  # noqa: E501
        """Update password by using the password reset token  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_password_with_http_info(update_password_dto, async_req=True)
        >>> result = thread.get()

        :param update_password_dto: (required)
        :type update_password_dto: UpdatePasswordDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'update_password_dto'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_password" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_password_dto'] is not None:
            _body_params = _params['update_password_dto']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json', 'application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '204': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/update-password', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_user_file_recording(self, object_key : Annotated[StrictStr, Field(..., description="ObjectKey of the file that should be edited.")], save_file_recording_dto : SaveFileRecordingDTO, **kwargs) -> object:  # noqa: E501
        """(Deprecated) Create and edit metadata of your files.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_file_recording(object_key, save_file_recording_dto, async_req=True)
        >>> result = thread.get()

        :param object_key: ObjectKey of the file that should be edited. (required)
        :type object_key: str
        :param save_file_recording_dto: (required)
        :type save_file_recording_dto: SaveFileRecordingDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_user_file_recording_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_user_file_recording_with_http_info(object_key, save_file_recording_dto, **kwargs)  # noqa: E501

    @validate_arguments
    def update_user_file_recording_with_http_info(self, object_key : Annotated[StrictStr, Field(..., description="ObjectKey of the file that should be edited.")], save_file_recording_dto : SaveFileRecordingDTO, **kwargs) -> ApiResponse:  # noqa: E501
        """(Deprecated) Create and edit metadata of your files.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_file_recording_with_http_info(object_key, save_file_recording_dto, async_req=True)
        >>> result = thread.get()

        :param object_key: ObjectKey of the file that should be edited. (required)
        :type object_key: str
        :param save_file_recording_dto: (required)
        :type save_file_recording_dto: SaveFileRecordingDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        warnings.warn("POST /api/v1/user/file/{objectKey} is deprecated.", DeprecationWarning)

        _params = locals()

        _all_params = [
            'object_key',
            'save_file_recording_dto'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user_file_recording" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['object_key']:
            _path_params['objectKey'] = _params['object_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['save_file_recording_dto'] is not None:
            _body_params = _params['save_file_recording_dto']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '403': "ErrorResponse",
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/file/{objectKey}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def user_file(self, object_key : Annotated[StrictStr, Field(..., description="ObjectKey of the file that should be edited.")], **kwargs) -> FileWIthUrlDTO:  # noqa: E501
        """Details and a download link for a file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_file(object_key, async_req=True)
        >>> result = thread.get()

        :param object_key: ObjectKey of the file that should be edited. (required)
        :type object_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FileWIthUrlDTO
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the user_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.user_file_with_http_info(object_key, **kwargs)  # noqa: E501

    @validate_arguments
    def user_file_with_http_info(self, object_key : Annotated[StrictStr, Field(..., description="ObjectKey of the file that should be edited.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Details and a download link for a file.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_file_with_http_info(object_key, async_req=True)
        >>> result = thread.get()

        :param object_key: ObjectKey of the file that should be edited. (required)
        :type object_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FileWIthUrlDTO, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'object_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['object_key']:
            _path_params['objectKey'] = _params['object_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "FileWIthUrlDTO",
            '404': "ErrorResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/file/{objectKey}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def user_files(self, isrc : Annotated[Optional[StrictStr], Field(description="Search for a ISRC")] = None, contributor : Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None, main_artist : Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None, composer : Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None, title : Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None, party_and_title : Annotated[Optional[StrictStr], Field(description="Search for party and title.")] = None, language : Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None, genre_names : Optional[conlist(StrictStr)] = None, tag_names : Optional[conlist(StrictStr)] = None, release_date : Optional[datetime] = None, primary_mood_cluster : Optional[StrictStr] = None, secondary_mood_cluster : Optional[StrictStr] = None, tertiary_mood_cluster : Optional[StrictStr] = None, valence : Optional[StrictStr] = None, arousal : Optional[StrictStr] = None, pleasantness : Optional[StrictStr] = None, engagement : Optional[StrictStr] = None, vocals : Optional[StrictStr] = None, dominant_instrument : Optional[StrictStr] = None, secondary_instrument : Optional[StrictStr] = None, tertiary_instrument : Optional[StrictStr] = None, energy : Optional[StrictStr] = None, sound_generation : Optional[StrictStr] = None, tempo : Optional[StrictStr] = None, scale : Optional[StrictStr] = None, rhythm : Optional[StrictStr] = None, primary_sound_character : Optional[StrictStr] = None, timbre : Optional[StrictStr] = None, roughness : Optional[StrictStr] = None, tonality : Optional[StrictStr] = None, harmony : Optional[StrictStr] = None, texture : Optional[StrictStr] = None, groovyness : Optional[StrictStr] = None, space : Optional[StrictStr] = None, production_rating : Optional[StrictStr] = None, performance_rating : Optional[StrictStr] = None, song_rating : Optional[StrictStr] = None, audience_age : Optional[StrictStr] = None, audience_region : Optional[StrictStr] = None, audience_gender : Optional[StrictStr] = None, origin_decade : Optional[StrictStr] = None, curateability : Optional[StrictStr] = None, use_case : Optional[StrictStr] = None, channel_suitability : Optional[StrictStr] = None, similar_to_recording : Optional[StrictStr] = None, songtradr_track_id : Optional[StrictStr] = None, usage_name : Optional[StrictStr] = None, bpm_min : Annotated[Optional[StrictInt], Field(description="Search for a minimal bpm.")] = None, bpm_max : Annotated[Optional[StrictInt], Field(description="Search for a maximal bpm.")] = None, name : Annotated[Optional[StrictStr], Field(description="Search for a file name.")] = None, folder : Annotated[Optional[StrictStr], Field(description="Search for a folder.")] = None, extension : Annotated[Optional[StrictStr], Field(description="Search for a file extension.")] = None, upload_end_time : Optional[datetime] = None, min_upload_end_time : Optional[datetime] = None, max_upload_end_time : Optional[datetime] = None, fingerprint_status : Annotated[Optional[StrictStr], Field(description="Search for a fingerprint status.")] = None, inference_status : Annotated[Optional[StrictStr], Field(description="Search for a inference status.")] = None, page : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[conint(strict=True, ge=1)], Field(description="The size of the page to be returned")] = None, sort : Annotated[Optional[conlist(StrictStr)], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None, **kwargs) -> FileListDTO:  # noqa: E501
        """List and search your own files.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_files(isrc, contributor, main_artist, composer, title, party_and_title, language, genre_names, tag_names, release_date, primary_mood_cluster, secondary_mood_cluster, tertiary_mood_cluster, valence, arousal, pleasantness, engagement, vocals, dominant_instrument, secondary_instrument, tertiary_instrument, energy, sound_generation, tempo, scale, rhythm, primary_sound_character, timbre, roughness, tonality, harmony, texture, groovyness, space, production_rating, performance_rating, song_rating, audience_age, audience_region, audience_gender, origin_decade, curateability, use_case, channel_suitability, similar_to_recording, songtradr_track_id, usage_name, bpm_min, bpm_max, name, folder, extension, upload_end_time, min_upload_end_time, max_upload_end_time, fingerprint_status, inference_status, page, size, sort, async_req=True)
        >>> result = thread.get()

        :param isrc: Search for a ISRC
        :type isrc: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param party_and_title: Search for party and title.
        :type party_and_title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param origin_decade:
        :type origin_decade: str
        :param curateability:
        :type curateability: str
        :param use_case:
        :type use_case: str
        :param channel_suitability:
        :type channel_suitability: str
        :param similar_to_recording:
        :type similar_to_recording: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min: Search for a minimal bpm.
        :type bpm_min: int
        :param bpm_max: Search for a maximal bpm.
        :type bpm_max: int
        :param name: Search for a file name.
        :type name: str
        :param folder: Search for a folder.
        :type folder: str
        :param extension: Search for a file extension.
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status: Search for a fingerprint status.
        :type fingerprint_status: str
        :param inference_status: Search for a inference status.
        :type inference_status: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FileListDTO
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the user_files_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.user_files_with_http_info(isrc, contributor, main_artist, composer, title, party_and_title, language, genre_names, tag_names, release_date, primary_mood_cluster, secondary_mood_cluster, tertiary_mood_cluster, valence, arousal, pleasantness, engagement, vocals, dominant_instrument, secondary_instrument, tertiary_instrument, energy, sound_generation, tempo, scale, rhythm, primary_sound_character, timbre, roughness, tonality, harmony, texture, groovyness, space, production_rating, performance_rating, song_rating, audience_age, audience_region, audience_gender, origin_decade, curateability, use_case, channel_suitability, similar_to_recording, songtradr_track_id, usage_name, bpm_min, bpm_max, name, folder, extension, upload_end_time, min_upload_end_time, max_upload_end_time, fingerprint_status, inference_status, page, size, sort, **kwargs)  # noqa: E501

    @validate_arguments
    def user_files_with_http_info(self, isrc : Annotated[Optional[StrictStr], Field(description="Search for a ISRC")] = None, contributor : Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None, main_artist : Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None, composer : Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None, title : Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None, party_and_title : Annotated[Optional[StrictStr], Field(description="Search for party and title.")] = None, language : Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None, genre_names : Optional[conlist(StrictStr)] = None, tag_names : Optional[conlist(StrictStr)] = None, release_date : Optional[datetime] = None, primary_mood_cluster : Optional[StrictStr] = None, secondary_mood_cluster : Optional[StrictStr] = None, tertiary_mood_cluster : Optional[StrictStr] = None, valence : Optional[StrictStr] = None, arousal : Optional[StrictStr] = None, pleasantness : Optional[StrictStr] = None, engagement : Optional[StrictStr] = None, vocals : Optional[StrictStr] = None, dominant_instrument : Optional[StrictStr] = None, secondary_instrument : Optional[StrictStr] = None, tertiary_instrument : Optional[StrictStr] = None, energy : Optional[StrictStr] = None, sound_generation : Optional[StrictStr] = None, tempo : Optional[StrictStr] = None, scale : Optional[StrictStr] = None, rhythm : Optional[StrictStr] = None, primary_sound_character : Optional[StrictStr] = None, timbre : Optional[StrictStr] = None, roughness : Optional[StrictStr] = None, tonality : Optional[StrictStr] = None, harmony : Optional[StrictStr] = None, texture : Optional[StrictStr] = None, groovyness : Optional[StrictStr] = None, space : Optional[StrictStr] = None, production_rating : Optional[StrictStr] = None, performance_rating : Optional[StrictStr] = None, song_rating : Optional[StrictStr] = None, audience_age : Optional[StrictStr] = None, audience_region : Optional[StrictStr] = None, audience_gender : Optional[StrictStr] = None, origin_decade : Optional[StrictStr] = None, curateability : Optional[StrictStr] = None, use_case : Optional[StrictStr] = None, channel_suitability : Optional[StrictStr] = None, similar_to_recording : Optional[StrictStr] = None, songtradr_track_id : Optional[StrictStr] = None, usage_name : Optional[StrictStr] = None, bpm_min : Annotated[Optional[StrictInt], Field(description="Search for a minimal bpm.")] = None, bpm_max : Annotated[Optional[StrictInt], Field(description="Search for a maximal bpm.")] = None, name : Annotated[Optional[StrictStr], Field(description="Search for a file name.")] = None, folder : Annotated[Optional[StrictStr], Field(description="Search for a folder.")] = None, extension : Annotated[Optional[StrictStr], Field(description="Search for a file extension.")] = None, upload_end_time : Optional[datetime] = None, min_upload_end_time : Optional[datetime] = None, max_upload_end_time : Optional[datetime] = None, fingerprint_status : Annotated[Optional[StrictStr], Field(description="Search for a fingerprint status.")] = None, inference_status : Annotated[Optional[StrictStr], Field(description="Search for a inference status.")] = None, page : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[conint(strict=True, ge=1)], Field(description="The size of the page to be returned")] = None, sort : Annotated[Optional[conlist(StrictStr)], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List and search your own files.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_files_with_http_info(isrc, contributor, main_artist, composer, title, party_and_title, language, genre_names, tag_names, release_date, primary_mood_cluster, secondary_mood_cluster, tertiary_mood_cluster, valence, arousal, pleasantness, engagement, vocals, dominant_instrument, secondary_instrument, tertiary_instrument, energy, sound_generation, tempo, scale, rhythm, primary_sound_character, timbre, roughness, tonality, harmony, texture, groovyness, space, production_rating, performance_rating, song_rating, audience_age, audience_region, audience_gender, origin_decade, curateability, use_case, channel_suitability, similar_to_recording, songtradr_track_id, usage_name, bpm_min, bpm_max, name, folder, extension, upload_end_time, min_upload_end_time, max_upload_end_time, fingerprint_status, inference_status, page, size, sort, async_req=True)
        >>> result = thread.get()

        :param isrc: Search for a ISRC
        :type isrc: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param party_and_title: Search for party and title.
        :type party_and_title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param origin_decade:
        :type origin_decade: str
        :param curateability:
        :type curateability: str
        :param use_case:
        :type use_case: str
        :param channel_suitability:
        :type channel_suitability: str
        :param similar_to_recording:
        :type similar_to_recording: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min: Search for a minimal bpm.
        :type bpm_min: int
        :param bpm_max: Search for a maximal bpm.
        :type bpm_max: int
        :param name: Search for a file name.
        :type name: str
        :param folder: Search for a folder.
        :type folder: str
        :param extension: Search for a file extension.
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status: Search for a fingerprint status.
        :type fingerprint_status: str
        :param inference_status: Search for a inference status.
        :type inference_status: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FileListDTO, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'isrc',
            'contributor',
            'main_artist',
            'composer',
            'title',
            'party_and_title',
            'language',
            'genre_names',
            'tag_names',
            'release_date',
            'primary_mood_cluster',
            'secondary_mood_cluster',
            'tertiary_mood_cluster',
            'valence',
            'arousal',
            'pleasantness',
            'engagement',
            'vocals',
            'dominant_instrument',
            'secondary_instrument',
            'tertiary_instrument',
            'energy',
            'sound_generation',
            'tempo',
            'scale',
            'rhythm',
            'primary_sound_character',
            'timbre',
            'roughness',
            'tonality',
            'harmony',
            'texture',
            'groovyness',
            'space',
            'production_rating',
            'performance_rating',
            'song_rating',
            'audience_age',
            'audience_region',
            'audience_gender',
            'origin_decade',
            'curateability',
            'use_case',
            'channel_suitability',
            'similar_to_recording',
            'songtradr_track_id',
            'usage_name',
            'bpm_min',
            'bpm_max',
            'name',
            'folder',
            'extension',
            'upload_end_time',
            'min_upload_end_time',
            'max_upload_end_time',
            'fingerprint_status',
            'inference_status',
            'page',
            'size',
            'sort'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_files" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('isrc') is not None:  # noqa: E501
            _query_params.append(('ISRC', _params['isrc']))

        if _params.get('contributor') is not None:  # noqa: E501
            _query_params.append(('contributor', _params['contributor']))

        if _params.get('main_artist') is not None:  # noqa: E501
            _query_params.append(('mainArtist', _params['main_artist']))

        if _params.get('composer') is not None:  # noqa: E501
            _query_params.append(('composer', _params['composer']))

        if _params.get('title') is not None:  # noqa: E501
            _query_params.append(('title', _params['title']))

        if _params.get('party_and_title') is not None:  # noqa: E501
            _query_params.append(('partyAndTitle', _params['party_and_title']))

        if _params.get('language') is not None:  # noqa: E501
            _query_params.append(('language', _params['language']))

        if _params.get('genre_names') is not None:  # noqa: E501
            _query_params.append(('genreNames', _params['genre_names']))
            _collection_formats['genreNames'] = 'multi'

        if _params.get('tag_names') is not None:  # noqa: E501
            _query_params.append(('tagNames', _params['tag_names']))
            _collection_formats['tagNames'] = 'multi'

        if _params.get('release_date') is not None:  # noqa: E501
            if isinstance(_params['release_date'], datetime):
                _query_params.append(('releaseDate', _params['release_date'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('releaseDate', _params['release_date']))

        if _params.get('primary_mood_cluster') is not None:  # noqa: E501
            _query_params.append(('primaryMoodCluster', _params['primary_mood_cluster']))

        if _params.get('secondary_mood_cluster') is not None:  # noqa: E501
            _query_params.append(('secondaryMoodCluster', _params['secondary_mood_cluster']))

        if _params.get('tertiary_mood_cluster') is not None:  # noqa: E501
            _query_params.append(('tertiaryMoodCluster', _params['tertiary_mood_cluster']))

        if _params.get('valence') is not None:  # noqa: E501
            _query_params.append(('valence', _params['valence']))

        if _params.get('arousal') is not None:  # noqa: E501
            _query_params.append(('arousal', _params['arousal']))

        if _params.get('pleasantness') is not None:  # noqa: E501
            _query_params.append(('pleasantness', _params['pleasantness']))

        if _params.get('engagement') is not None:  # noqa: E501
            _query_params.append(('engagement', _params['engagement']))

        if _params.get('vocals') is not None:  # noqa: E501
            _query_params.append(('vocals', _params['vocals']))

        if _params.get('dominant_instrument') is not None:  # noqa: E501
            _query_params.append(('dominantInstrument', _params['dominant_instrument']))

        if _params.get('secondary_instrument') is not None:  # noqa: E501
            _query_params.append(('secondaryInstrument', _params['secondary_instrument']))

        if _params.get('tertiary_instrument') is not None:  # noqa: E501
            _query_params.append(('tertiaryInstrument', _params['tertiary_instrument']))

        if _params.get('energy') is not None:  # noqa: E501
            _query_params.append(('energy', _params['energy']))

        if _params.get('sound_generation') is not None:  # noqa: E501
            _query_params.append(('soundGeneration', _params['sound_generation']))

        if _params.get('tempo') is not None:  # noqa: E501
            _query_params.append(('tempo', _params['tempo']))

        if _params.get('scale') is not None:  # noqa: E501
            _query_params.append(('scale', _params['scale']))

        if _params.get('rhythm') is not None:  # noqa: E501
            _query_params.append(('rhythm', _params['rhythm']))

        if _params.get('primary_sound_character') is not None:  # noqa: E501
            _query_params.append(('primarySoundCharacter', _params['primary_sound_character']))

        if _params.get('timbre') is not None:  # noqa: E501
            _query_params.append(('timbre', _params['timbre']))

        if _params.get('roughness') is not None:  # noqa: E501
            _query_params.append(('roughness', _params['roughness']))

        if _params.get('tonality') is not None:  # noqa: E501
            _query_params.append(('tonality', _params['tonality']))

        if _params.get('harmony') is not None:  # noqa: E501
            _query_params.append(('harmony', _params['harmony']))

        if _params.get('texture') is not None:  # noqa: E501
            _query_params.append(('texture', _params['texture']))

        if _params.get('groovyness') is not None:  # noqa: E501
            _query_params.append(('groovyness', _params['groovyness']))

        if _params.get('space') is not None:  # noqa: E501
            _query_params.append(('space', _params['space']))

        if _params.get('production_rating') is not None:  # noqa: E501
            _query_params.append(('productionRating', _params['production_rating']))

        if _params.get('performance_rating') is not None:  # noqa: E501
            _query_params.append(('performanceRating', _params['performance_rating']))

        if _params.get('song_rating') is not None:  # noqa: E501
            _query_params.append(('songRating', _params['song_rating']))

        if _params.get('audience_age') is not None:  # noqa: E501
            _query_params.append(('audienceAge', _params['audience_age']))

        if _params.get('audience_region') is not None:  # noqa: E501
            _query_params.append(('audienceRegion', _params['audience_region']))

        if _params.get('audience_gender') is not None:  # noqa: E501
            _query_params.append(('audienceGender', _params['audience_gender']))

        if _params.get('origin_decade') is not None:  # noqa: E501
            _query_params.append(('originDecade', _params['origin_decade']))

        if _params.get('curateability') is not None:  # noqa: E501
            _query_params.append(('curateability', _params['curateability']))

        if _params.get('use_case') is not None:  # noqa: E501
            _query_params.append(('useCase', _params['use_case']))

        if _params.get('channel_suitability') is not None:  # noqa: E501
            _query_params.append(('channelSuitability', _params['channel_suitability']))

        if _params.get('similar_to_recording') is not None:  # noqa: E501
            _query_params.append(('similarToRecording', _params['similar_to_recording']))

        if _params.get('songtradr_track_id') is not None:  # noqa: E501
            _query_params.append(('songtradrTrackId', _params['songtradr_track_id']))

        if _params.get('usage_name') is not None:  # noqa: E501
            _query_params.append(('usageName', _params['usage_name']))

        if _params.get('bpm_min') is not None:  # noqa: E501
            _query_params.append(('bpmMin', _params['bpm_min']))

        if _params.get('bpm_max') is not None:  # noqa: E501
            _query_params.append(('bpmMax', _params['bpm_max']))

        if _params.get('name') is not None:  # noqa: E501
            _query_params.append(('name', _params['name']))

        if _params.get('folder') is not None:  # noqa: E501
            _query_params.append(('folder', _params['folder']))

        if _params.get('extension') is not None:  # noqa: E501
            _query_params.append(('extension', _params['extension']))

        if _params.get('upload_end_time') is not None:  # noqa: E501
            if isinstance(_params['upload_end_time'], datetime):
                _query_params.append(('uploadEndTime', _params['upload_end_time'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('uploadEndTime', _params['upload_end_time']))

        if _params.get('min_upload_end_time') is not None:  # noqa: E501
            if isinstance(_params['min_upload_end_time'], datetime):
                _query_params.append(('minUploadEndTime', _params['min_upload_end_time'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('minUploadEndTime', _params['min_upload_end_time']))

        if _params.get('max_upload_end_time') is not None:  # noqa: E501
            if isinstance(_params['max_upload_end_time'], datetime):
                _query_params.append(('maxUploadEndTime', _params['max_upload_end_time'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('maxUploadEndTime', _params['max_upload_end_time']))

        if _params.get('fingerprint_status') is not None:  # noqa: E501
            _query_params.append(('fingerprintStatus', _params['fingerprint_status']))

        if _params.get('inference_status') is not None:  # noqa: E501
            _query_params.append(('inferenceStatus', _params['inference_status']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('size') is not None:  # noqa: E501
            _query_params.append(('size', _params['size']))

        if _params.get('sort') is not None:  # noqa: E501
            _query_params.append(('sort', _params['sort']))
            _collection_formats['sort'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "FileListDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/files', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def user_files_download(self, isrc : Optional[StrictStr] = None, contributor : Optional[StrictStr] = None, main_artist : Optional[StrictStr] = None, composer : Optional[StrictStr] = None, title : Optional[StrictStr] = None, language : Optional[StrictStr] = None, genre_names : Optional[conlist(StrictStr)] = None, tag_names : Optional[conlist(StrictStr)] = None, release_date : Optional[datetime] = None, primary_mood_cluster : Optional[StrictStr] = None, secondary_mood_cluster : Optional[StrictStr] = None, tertiary_mood_cluster : Optional[StrictStr] = None, valence : Optional[StrictStr] = None, arousal : Optional[StrictStr] = None, pleasantness : Optional[StrictStr] = None, engagement : Optional[StrictStr] = None, vocals : Optional[StrictStr] = None, dominant_instrument : Optional[StrictStr] = None, secondary_instrument : Optional[StrictStr] = None, tertiary_instrument : Optional[StrictStr] = None, energy : Optional[StrictStr] = None, sound_generation : Optional[StrictStr] = None, tempo : Optional[StrictStr] = None, scale : Optional[StrictStr] = None, rhythm : Optional[StrictStr] = None, primary_sound_character : Optional[StrictStr] = None, timbre : Optional[StrictStr] = None, roughness : Optional[StrictStr] = None, tonality : Optional[StrictStr] = None, harmony : Optional[StrictStr] = None, texture : Optional[StrictStr] = None, groovyness : Optional[StrictStr] = None, space : Optional[StrictStr] = None, production_rating : Optional[StrictStr] = None, performance_rating : Optional[StrictStr] = None, song_rating : Optional[StrictStr] = None, audience_age : Optional[StrictStr] = None, audience_region : Optional[StrictStr] = None, audience_gender : Optional[StrictStr] = None, songtradr_track_id : Optional[StrictStr] = None, usage_name : Optional[StrictStr] = None, bpm_min : Optional[StrictInt] = None, bpm_max : Optional[StrictInt] = None, name : Optional[StrictStr] = None, folder : Optional[StrictStr] = None, extension : Optional[StrictStr] = None, upload_end_time : Optional[datetime] = None, min_upload_end_time : Optional[datetime] = None, max_upload_end_time : Optional[datetime] = None, fingerprint_status : Optional[StrictStr] = None, inference_status : Optional[StrictStr] = None, page : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[conint(strict=True, ge=1)], Field(description="The size of the page to be returned")] = None, sort : Annotated[Optional[conlist(StrictStr)], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None, **kwargs) -> List[FileMinimalWithUrlDTO]:  # noqa: E501
        """(Deprecated) Download links for your files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_files_download(isrc, contributor, main_artist, composer, title, language, genre_names, tag_names, release_date, primary_mood_cluster, secondary_mood_cluster, tertiary_mood_cluster, valence, arousal, pleasantness, engagement, vocals, dominant_instrument, secondary_instrument, tertiary_instrument, energy, sound_generation, tempo, scale, rhythm, primary_sound_character, timbre, roughness, tonality, harmony, texture, groovyness, space, production_rating, performance_rating, song_rating, audience_age, audience_region, audience_gender, songtradr_track_id, usage_name, bpm_min, bpm_max, name, folder, extension, upload_end_time, min_upload_end_time, max_upload_end_time, fingerprint_status, inference_status, page, size, sort, async_req=True)
        >>> result = thread.get()

        :param isrc:
        :type isrc: str
        :param contributor:
        :type contributor: str
        :param main_artist:
        :type main_artist: str
        :param composer:
        :type composer: str
        :param title:
        :type title: str
        :param language:
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min:
        :type bpm_min: int
        :param bpm_max:
        :type bpm_max: int
        :param name:
        :type name: str
        :param folder:
        :type folder: str
        :param extension:
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status:
        :type fingerprint_status: str
        :param inference_status:
        :type inference_status: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[FileMinimalWithUrlDTO]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the user_files_download_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.user_files_download_with_http_info(isrc, contributor, main_artist, composer, title, language, genre_names, tag_names, release_date, primary_mood_cluster, secondary_mood_cluster, tertiary_mood_cluster, valence, arousal, pleasantness, engagement, vocals, dominant_instrument, secondary_instrument, tertiary_instrument, energy, sound_generation, tempo, scale, rhythm, primary_sound_character, timbre, roughness, tonality, harmony, texture, groovyness, space, production_rating, performance_rating, song_rating, audience_age, audience_region, audience_gender, songtradr_track_id, usage_name, bpm_min, bpm_max, name, folder, extension, upload_end_time, min_upload_end_time, max_upload_end_time, fingerprint_status, inference_status, page, size, sort, **kwargs)  # noqa: E501

    @validate_arguments
    def user_files_download_with_http_info(self, isrc : Optional[StrictStr] = None, contributor : Optional[StrictStr] = None, main_artist : Optional[StrictStr] = None, composer : Optional[StrictStr] = None, title : Optional[StrictStr] = None, language : Optional[StrictStr] = None, genre_names : Optional[conlist(StrictStr)] = None, tag_names : Optional[conlist(StrictStr)] = None, release_date : Optional[datetime] = None, primary_mood_cluster : Optional[StrictStr] = None, secondary_mood_cluster : Optional[StrictStr] = None, tertiary_mood_cluster : Optional[StrictStr] = None, valence : Optional[StrictStr] = None, arousal : Optional[StrictStr] = None, pleasantness : Optional[StrictStr] = None, engagement : Optional[StrictStr] = None, vocals : Optional[StrictStr] = None, dominant_instrument : Optional[StrictStr] = None, secondary_instrument : Optional[StrictStr] = None, tertiary_instrument : Optional[StrictStr] = None, energy : Optional[StrictStr] = None, sound_generation : Optional[StrictStr] = None, tempo : Optional[StrictStr] = None, scale : Optional[StrictStr] = None, rhythm : Optional[StrictStr] = None, primary_sound_character : Optional[StrictStr] = None, timbre : Optional[StrictStr] = None, roughness : Optional[StrictStr] = None, tonality : Optional[StrictStr] = None, harmony : Optional[StrictStr] = None, texture : Optional[StrictStr] = None, groovyness : Optional[StrictStr] = None, space : Optional[StrictStr] = None, production_rating : Optional[StrictStr] = None, performance_rating : Optional[StrictStr] = None, song_rating : Optional[StrictStr] = None, audience_age : Optional[StrictStr] = None, audience_region : Optional[StrictStr] = None, audience_gender : Optional[StrictStr] = None, songtradr_track_id : Optional[StrictStr] = None, usage_name : Optional[StrictStr] = None, bpm_min : Optional[StrictInt] = None, bpm_max : Optional[StrictInt] = None, name : Optional[StrictStr] = None, folder : Optional[StrictStr] = None, extension : Optional[StrictStr] = None, upload_end_time : Optional[datetime] = None, min_upload_end_time : Optional[datetime] = None, max_upload_end_time : Optional[datetime] = None, fingerprint_status : Optional[StrictStr] = None, inference_status : Optional[StrictStr] = None, page : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[conint(strict=True, ge=1)], Field(description="The size of the page to be returned")] = None, sort : Annotated[Optional[conlist(StrictStr)], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """(Deprecated) Download links for your files  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_files_download_with_http_info(isrc, contributor, main_artist, composer, title, language, genre_names, tag_names, release_date, primary_mood_cluster, secondary_mood_cluster, tertiary_mood_cluster, valence, arousal, pleasantness, engagement, vocals, dominant_instrument, secondary_instrument, tertiary_instrument, energy, sound_generation, tempo, scale, rhythm, primary_sound_character, timbre, roughness, tonality, harmony, texture, groovyness, space, production_rating, performance_rating, song_rating, audience_age, audience_region, audience_gender, songtradr_track_id, usage_name, bpm_min, bpm_max, name, folder, extension, upload_end_time, min_upload_end_time, max_upload_end_time, fingerprint_status, inference_status, page, size, sort, async_req=True)
        >>> result = thread.get()

        :param isrc:
        :type isrc: str
        :param contributor:
        :type contributor: str
        :param main_artist:
        :type main_artist: str
        :param composer:
        :type composer: str
        :param title:
        :type title: str
        :param language:
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min:
        :type bpm_min: int
        :param bpm_max:
        :type bpm_max: int
        :param name:
        :type name: str
        :param folder:
        :type folder: str
        :param extension:
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status:
        :type fingerprint_status: str
        :param inference_status:
        :type inference_status: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[FileMinimalWithUrlDTO], status_code(int), headers(HTTPHeaderDict))
        """

        warnings.warn("GET /api/v1/user/filesDownload is deprecated.", DeprecationWarning)

        _params = locals()

        _all_params = [
            'isrc',
            'contributor',
            'main_artist',
            'composer',
            'title',
            'language',
            'genre_names',
            'tag_names',
            'release_date',
            'primary_mood_cluster',
            'secondary_mood_cluster',
            'tertiary_mood_cluster',
            'valence',
            'arousal',
            'pleasantness',
            'engagement',
            'vocals',
            'dominant_instrument',
            'secondary_instrument',
            'tertiary_instrument',
            'energy',
            'sound_generation',
            'tempo',
            'scale',
            'rhythm',
            'primary_sound_character',
            'timbre',
            'roughness',
            'tonality',
            'harmony',
            'texture',
            'groovyness',
            'space',
            'production_rating',
            'performance_rating',
            'song_rating',
            'audience_age',
            'audience_region',
            'audience_gender',
            'songtradr_track_id',
            'usage_name',
            'bpm_min',
            'bpm_max',
            'name',
            'folder',
            'extension',
            'upload_end_time',
            'min_upload_end_time',
            'max_upload_end_time',
            'fingerprint_status',
            'inference_status',
            'page',
            'size',
            'sort'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_files_download" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('isrc') is not None:  # noqa: E501
            _query_params.append(('isrc', _params['isrc']))

        if _params.get('contributor') is not None:  # noqa: E501
            _query_params.append(('contributor', _params['contributor']))

        if _params.get('main_artist') is not None:  # noqa: E501
            _query_params.append(('mainArtist', _params['main_artist']))

        if _params.get('composer') is not None:  # noqa: E501
            _query_params.append(('composer', _params['composer']))

        if _params.get('title') is not None:  # noqa: E501
            _query_params.append(('title', _params['title']))

        if _params.get('language') is not None:  # noqa: E501
            _query_params.append(('language', _params['language']))

        if _params.get('genre_names') is not None:  # noqa: E501
            _query_params.append(('genreNames', _params['genre_names']))
            _collection_formats['genreNames'] = 'multi'

        if _params.get('tag_names') is not None:  # noqa: E501
            _query_params.append(('tagNames', _params['tag_names']))
            _collection_formats['tagNames'] = 'multi'

        if _params.get('release_date') is not None:  # noqa: E501
            if isinstance(_params['release_date'], datetime):
                _query_params.append(('releaseDate', _params['release_date'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('releaseDate', _params['release_date']))

        if _params.get('primary_mood_cluster') is not None:  # noqa: E501
            _query_params.append(('primaryMoodCluster', _params['primary_mood_cluster']))

        if _params.get('secondary_mood_cluster') is not None:  # noqa: E501
            _query_params.append(('secondaryMoodCluster', _params['secondary_mood_cluster']))

        if _params.get('tertiary_mood_cluster') is not None:  # noqa: E501
            _query_params.append(('tertiaryMoodCluster', _params['tertiary_mood_cluster']))

        if _params.get('valence') is not None:  # noqa: E501
            _query_params.append(('valence', _params['valence']))

        if _params.get('arousal') is not None:  # noqa: E501
            _query_params.append(('arousal', _params['arousal']))

        if _params.get('pleasantness') is not None:  # noqa: E501
            _query_params.append(('pleasantness', _params['pleasantness']))

        if _params.get('engagement') is not None:  # noqa: E501
            _query_params.append(('engagement', _params['engagement']))

        if _params.get('vocals') is not None:  # noqa: E501
            _query_params.append(('vocals', _params['vocals']))

        if _params.get('dominant_instrument') is not None:  # noqa: E501
            _query_params.append(('dominantInstrument', _params['dominant_instrument']))

        if _params.get('secondary_instrument') is not None:  # noqa: E501
            _query_params.append(('secondaryInstrument', _params['secondary_instrument']))

        if _params.get('tertiary_instrument') is not None:  # noqa: E501
            _query_params.append(('tertiaryInstrument', _params['tertiary_instrument']))

        if _params.get('energy') is not None:  # noqa: E501
            _query_params.append(('energy', _params['energy']))

        if _params.get('sound_generation') is not None:  # noqa: E501
            _query_params.append(('soundGeneration', _params['sound_generation']))

        if _params.get('tempo') is not None:  # noqa: E501
            _query_params.append(('tempo', _params['tempo']))

        if _params.get('scale') is not None:  # noqa: E501
            _query_params.append(('scale', _params['scale']))

        if _params.get('rhythm') is not None:  # noqa: E501
            _query_params.append(('rhythm', _params['rhythm']))

        if _params.get('primary_sound_character') is not None:  # noqa: E501
            _query_params.append(('primarySoundCharacter', _params['primary_sound_character']))

        if _params.get('timbre') is not None:  # noqa: E501
            _query_params.append(('timbre', _params['timbre']))

        if _params.get('roughness') is not None:  # noqa: E501
            _query_params.append(('roughness', _params['roughness']))

        if _params.get('tonality') is not None:  # noqa: E501
            _query_params.append(('tonality', _params['tonality']))

        if _params.get('harmony') is not None:  # noqa: E501
            _query_params.append(('harmony', _params['harmony']))

        if _params.get('texture') is not None:  # noqa: E501
            _query_params.append(('texture', _params['texture']))

        if _params.get('groovyness') is not None:  # noqa: E501
            _query_params.append(('groovyness', _params['groovyness']))

        if _params.get('space') is not None:  # noqa: E501
            _query_params.append(('space', _params['space']))

        if _params.get('production_rating') is not None:  # noqa: E501
            _query_params.append(('productionRating', _params['production_rating']))

        if _params.get('performance_rating') is not None:  # noqa: E501
            _query_params.append(('performanceRating', _params['performance_rating']))

        if _params.get('song_rating') is not None:  # noqa: E501
            _query_params.append(('songRating', _params['song_rating']))

        if _params.get('audience_age') is not None:  # noqa: E501
            _query_params.append(('audienceAge', _params['audience_age']))

        if _params.get('audience_region') is not None:  # noqa: E501
            _query_params.append(('audienceRegion', _params['audience_region']))

        if _params.get('audience_gender') is not None:  # noqa: E501
            _query_params.append(('audienceGender', _params['audience_gender']))

        if _params.get('songtradr_track_id') is not None:  # noqa: E501
            _query_params.append(('songtradrTrackId', _params['songtradr_track_id']))

        if _params.get('usage_name') is not None:  # noqa: E501
            _query_params.append(('usageName', _params['usage_name']))

        if _params.get('bpm_min') is not None:  # noqa: E501
            _query_params.append(('bpmMin', _params['bpm_min']))

        if _params.get('bpm_max') is not None:  # noqa: E501
            _query_params.append(('bpmMax', _params['bpm_max']))

        if _params.get('name') is not None:  # noqa: E501
            _query_params.append(('name', _params['name']))

        if _params.get('folder') is not None:  # noqa: E501
            _query_params.append(('folder', _params['folder']))

        if _params.get('extension') is not None:  # noqa: E501
            _query_params.append(('extension', _params['extension']))

        if _params.get('upload_end_time') is not None:  # noqa: E501
            if isinstance(_params['upload_end_time'], datetime):
                _query_params.append(('uploadEndTime', _params['upload_end_time'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('uploadEndTime', _params['upload_end_time']))

        if _params.get('min_upload_end_time') is not None:  # noqa: E501
            if isinstance(_params['min_upload_end_time'], datetime):
                _query_params.append(('minUploadEndTime', _params['min_upload_end_time'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('minUploadEndTime', _params['min_upload_end_time']))

        if _params.get('max_upload_end_time') is not None:  # noqa: E501
            if isinstance(_params['max_upload_end_time'], datetime):
                _query_params.append(('maxUploadEndTime', _params['max_upload_end_time'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('maxUploadEndTime', _params['max_upload_end_time']))

        if _params.get('fingerprint_status') is not None:  # noqa: E501
            _query_params.append(('fingerprintStatus', _params['fingerprint_status']))

        if _params.get('inference_status') is not None:  # noqa: E501
            _query_params.append(('inferenceStatus', _params['inference_status']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('size') is not None:  # noqa: E501
            _query_params.append(('size', _params['size']))

        if _params.get('sort') is not None:  # noqa: E501
            _query_params.append(('sort', _params['sort']))
            _collection_formats['sort'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "List[FileMinimalWithUrlDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/filesDownload', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def user_files_status(self, object_keys : Annotated[StrictStr, Field(..., description="Comma-separated  list of objectKeys of the files.")], **kwargs) -> List[FileSmallDTO]:  # noqa: E501
        """Status details for files.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_files_status(object_keys, async_req=True)
        >>> result = thread.get()

        :param object_keys: Comma-separated  list of objectKeys of the files. (required)
        :type object_keys: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[FileSmallDTO]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the user_files_status_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.user_files_status_with_http_info(object_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def user_files_status_with_http_info(self, object_keys : Annotated[StrictStr, Field(..., description="Comma-separated  list of objectKeys of the files.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Status details for files.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_files_status_with_http_info(object_keys, async_req=True)
        >>> result = thread.get()

        :param object_keys: Comma-separated  list of objectKeys of the files. (required)
        :type object_keys: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[FileSmallDTO], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'object_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_files_status" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('object_keys') is not None:  # noqa: E501
            _query_params.append(('objectKeys', _params['object_keys']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "List[FileSmallDTO]",
            '404': "ErrorResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/filesStatus', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def user_files_summary(self, isrc : Annotated[Optional[StrictStr], Field(description="Search for a ISRC")] = None, contributor : Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None, main_artist : Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None, composer : Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None, title : Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None, language : Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None, genre_names : Optional[conlist(StrictStr)] = None, tag_names : Optional[conlist(StrictStr)] = None, release_date : Optional[datetime] = None, primary_mood_cluster : Optional[StrictStr] = None, secondary_mood_cluster : Optional[StrictStr] = None, tertiary_mood_cluster : Optional[StrictStr] = None, valence : Optional[StrictStr] = None, arousal : Optional[StrictStr] = None, pleasantness : Optional[StrictStr] = None, engagement : Optional[StrictStr] = None, vocals : Optional[StrictStr] = None, dominant_instrument : Optional[StrictStr] = None, secondary_instrument : Optional[StrictStr] = None, tertiary_instrument : Optional[StrictStr] = None, energy : Optional[StrictStr] = None, sound_generation : Optional[StrictStr] = None, tempo : Optional[StrictStr] = None, scale : Optional[StrictStr] = None, rhythm : Optional[StrictStr] = None, primary_sound_character : Optional[StrictStr] = None, timbre : Optional[StrictStr] = None, roughness : Optional[StrictStr] = None, tonality : Optional[StrictStr] = None, harmony : Optional[StrictStr] = None, texture : Optional[StrictStr] = None, groovyness : Optional[StrictStr] = None, space : Optional[StrictStr] = None, production_rating : Optional[StrictStr] = None, performance_rating : Optional[StrictStr] = None, song_rating : Optional[StrictStr] = None, audience_age : Optional[StrictStr] = None, audience_region : Optional[StrictStr] = None, audience_gender : Optional[StrictStr] = None, origin_decade : Optional[StrictStr] = None, curateability : Optional[StrictStr] = None, use_case : Optional[StrictStr] = None, channel_suitability : Optional[StrictStr] = None, similar_to_recording : Optional[StrictStr] = None, songtradr_track_id : Optional[StrictStr] = None, usage_name : Optional[StrictStr] = None, bpm_min : Annotated[Optional[StrictInt], Field(description="Search for a minimal bpm.")] = None, bpm_max : Annotated[Optional[StrictInt], Field(description="Search for a maximal bpm.")] = None, name : Annotated[Optional[StrictStr], Field(description="Search for a file name.")] = None, folder : Annotated[Optional[StrictStr], Field(description="Search for a folder.")] = None, extension : Annotated[Optional[StrictStr], Field(description="Search for a file extension.")] = None, upload_end_time : Optional[datetime] = None, min_upload_end_time : Optional[datetime] = None, max_upload_end_time : Optional[datetime] = None, fingerprint_status : Annotated[Optional[StrictStr], Field(description="Search for a fingerprint status.")] = None, inference_status : Annotated[Optional[StrictStr], Field(description="Search for a inference status.")] = None, **kwargs) -> FilesSummaryDTO:  # noqa: E501
        """Summary fo your files.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_files_summary(isrc, contributor, main_artist, composer, title, language, genre_names, tag_names, release_date, primary_mood_cluster, secondary_mood_cluster, tertiary_mood_cluster, valence, arousal, pleasantness, engagement, vocals, dominant_instrument, secondary_instrument, tertiary_instrument, energy, sound_generation, tempo, scale, rhythm, primary_sound_character, timbre, roughness, tonality, harmony, texture, groovyness, space, production_rating, performance_rating, song_rating, audience_age, audience_region, audience_gender, origin_decade, curateability, use_case, channel_suitability, similar_to_recording, songtradr_track_id, usage_name, bpm_min, bpm_max, name, folder, extension, upload_end_time, min_upload_end_time, max_upload_end_time, fingerprint_status, inference_status, async_req=True)
        >>> result = thread.get()

        :param isrc: Search for a ISRC
        :type isrc: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param origin_decade:
        :type origin_decade: str
        :param curateability:
        :type curateability: str
        :param use_case:
        :type use_case: str
        :param channel_suitability:
        :type channel_suitability: str
        :param similar_to_recording:
        :type similar_to_recording: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min: Search for a minimal bpm.
        :type bpm_min: int
        :param bpm_max: Search for a maximal bpm.
        :type bpm_max: int
        :param name: Search for a file name.
        :type name: str
        :param folder: Search for a folder.
        :type folder: str
        :param extension: Search for a file extension.
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status: Search for a fingerprint status.
        :type fingerprint_status: str
        :param inference_status: Search for a inference status.
        :type inference_status: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FilesSummaryDTO
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the user_files_summary_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.user_files_summary_with_http_info(isrc, contributor, main_artist, composer, title, language, genre_names, tag_names, release_date, primary_mood_cluster, secondary_mood_cluster, tertiary_mood_cluster, valence, arousal, pleasantness, engagement, vocals, dominant_instrument, secondary_instrument, tertiary_instrument, energy, sound_generation, tempo, scale, rhythm, primary_sound_character, timbre, roughness, tonality, harmony, texture, groovyness, space, production_rating, performance_rating, song_rating, audience_age, audience_region, audience_gender, origin_decade, curateability, use_case, channel_suitability, similar_to_recording, songtradr_track_id, usage_name, bpm_min, bpm_max, name, folder, extension, upload_end_time, min_upload_end_time, max_upload_end_time, fingerprint_status, inference_status, **kwargs)  # noqa: E501

    @validate_arguments
    def user_files_summary_with_http_info(self, isrc : Annotated[Optional[StrictStr], Field(description="Search for a ISRC")] = None, contributor : Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None, main_artist : Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None, composer : Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None, title : Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None, language : Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None, genre_names : Optional[conlist(StrictStr)] = None, tag_names : Optional[conlist(StrictStr)] = None, release_date : Optional[datetime] = None, primary_mood_cluster : Optional[StrictStr] = None, secondary_mood_cluster : Optional[StrictStr] = None, tertiary_mood_cluster : Optional[StrictStr] = None, valence : Optional[StrictStr] = None, arousal : Optional[StrictStr] = None, pleasantness : Optional[StrictStr] = None, engagement : Optional[StrictStr] = None, vocals : Optional[StrictStr] = None, dominant_instrument : Optional[StrictStr] = None, secondary_instrument : Optional[StrictStr] = None, tertiary_instrument : Optional[StrictStr] = None, energy : Optional[StrictStr] = None, sound_generation : Optional[StrictStr] = None, tempo : Optional[StrictStr] = None, scale : Optional[StrictStr] = None, rhythm : Optional[StrictStr] = None, primary_sound_character : Optional[StrictStr] = None, timbre : Optional[StrictStr] = None, roughness : Optional[StrictStr] = None, tonality : Optional[StrictStr] = None, harmony : Optional[StrictStr] = None, texture : Optional[StrictStr] = None, groovyness : Optional[StrictStr] = None, space : Optional[StrictStr] = None, production_rating : Optional[StrictStr] = None, performance_rating : Optional[StrictStr] = None, song_rating : Optional[StrictStr] = None, audience_age : Optional[StrictStr] = None, audience_region : Optional[StrictStr] = None, audience_gender : Optional[StrictStr] = None, origin_decade : Optional[StrictStr] = None, curateability : Optional[StrictStr] = None, use_case : Optional[StrictStr] = None, channel_suitability : Optional[StrictStr] = None, similar_to_recording : Optional[StrictStr] = None, songtradr_track_id : Optional[StrictStr] = None, usage_name : Optional[StrictStr] = None, bpm_min : Annotated[Optional[StrictInt], Field(description="Search for a minimal bpm.")] = None, bpm_max : Annotated[Optional[StrictInt], Field(description="Search for a maximal bpm.")] = None, name : Annotated[Optional[StrictStr], Field(description="Search for a file name.")] = None, folder : Annotated[Optional[StrictStr], Field(description="Search for a folder.")] = None, extension : Annotated[Optional[StrictStr], Field(description="Search for a file extension.")] = None, upload_end_time : Optional[datetime] = None, min_upload_end_time : Optional[datetime] = None, max_upload_end_time : Optional[datetime] = None, fingerprint_status : Annotated[Optional[StrictStr], Field(description="Search for a fingerprint status.")] = None, inference_status : Annotated[Optional[StrictStr], Field(description="Search for a inference status.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Summary fo your files.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_files_summary_with_http_info(isrc, contributor, main_artist, composer, title, language, genre_names, tag_names, release_date, primary_mood_cluster, secondary_mood_cluster, tertiary_mood_cluster, valence, arousal, pleasantness, engagement, vocals, dominant_instrument, secondary_instrument, tertiary_instrument, energy, sound_generation, tempo, scale, rhythm, primary_sound_character, timbre, roughness, tonality, harmony, texture, groovyness, space, production_rating, performance_rating, song_rating, audience_age, audience_region, audience_gender, origin_decade, curateability, use_case, channel_suitability, similar_to_recording, songtradr_track_id, usage_name, bpm_min, bpm_max, name, folder, extension, upload_end_time, min_upload_end_time, max_upload_end_time, fingerprint_status, inference_status, async_req=True)
        >>> result = thread.get()

        :param isrc: Search for a ISRC
        :type isrc: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param origin_decade:
        :type origin_decade: str
        :param curateability:
        :type curateability: str
        :param use_case:
        :type use_case: str
        :param channel_suitability:
        :type channel_suitability: str
        :param similar_to_recording:
        :type similar_to_recording: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min: Search for a minimal bpm.
        :type bpm_min: int
        :param bpm_max: Search for a maximal bpm.
        :type bpm_max: int
        :param name: Search for a file name.
        :type name: str
        :param folder: Search for a folder.
        :type folder: str
        :param extension: Search for a file extension.
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status: Search for a fingerprint status.
        :type fingerprint_status: str
        :param inference_status: Search for a inference status.
        :type inference_status: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FilesSummaryDTO, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'isrc',
            'contributor',
            'main_artist',
            'composer',
            'title',
            'language',
            'genre_names',
            'tag_names',
            'release_date',
            'primary_mood_cluster',
            'secondary_mood_cluster',
            'tertiary_mood_cluster',
            'valence',
            'arousal',
            'pleasantness',
            'engagement',
            'vocals',
            'dominant_instrument',
            'secondary_instrument',
            'tertiary_instrument',
            'energy',
            'sound_generation',
            'tempo',
            'scale',
            'rhythm',
            'primary_sound_character',
            'timbre',
            'roughness',
            'tonality',
            'harmony',
            'texture',
            'groovyness',
            'space',
            'production_rating',
            'performance_rating',
            'song_rating',
            'audience_age',
            'audience_region',
            'audience_gender',
            'origin_decade',
            'curateability',
            'use_case',
            'channel_suitability',
            'similar_to_recording',
            'songtradr_track_id',
            'usage_name',
            'bpm_min',
            'bpm_max',
            'name',
            'folder',
            'extension',
            'upload_end_time',
            'min_upload_end_time',
            'max_upload_end_time',
            'fingerprint_status',
            'inference_status'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_files_summary" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('isrc') is not None:  # noqa: E501
            _query_params.append(('ISRC', _params['isrc']))

        if _params.get('contributor') is not None:  # noqa: E501
            _query_params.append(('contributor', _params['contributor']))

        if _params.get('main_artist') is not None:  # noqa: E501
            _query_params.append(('mainArtist', _params['main_artist']))

        if _params.get('composer') is not None:  # noqa: E501
            _query_params.append(('composer', _params['composer']))

        if _params.get('title') is not None:  # noqa: E501
            _query_params.append(('title', _params['title']))

        if _params.get('language') is not None:  # noqa: E501
            _query_params.append(('language', _params['language']))

        if _params.get('genre_names') is not None:  # noqa: E501
            _query_params.append(('genreNames', _params['genre_names']))
            _collection_formats['genreNames'] = 'multi'

        if _params.get('tag_names') is not None:  # noqa: E501
            _query_params.append(('tagNames', _params['tag_names']))
            _collection_formats['tagNames'] = 'multi'

        if _params.get('release_date') is not None:  # noqa: E501
            if isinstance(_params['release_date'], datetime):
                _query_params.append(('releaseDate', _params['release_date'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('releaseDate', _params['release_date']))

        if _params.get('primary_mood_cluster') is not None:  # noqa: E501
            _query_params.append(('primaryMoodCluster', _params['primary_mood_cluster']))

        if _params.get('secondary_mood_cluster') is not None:  # noqa: E501
            _query_params.append(('secondaryMoodCluster', _params['secondary_mood_cluster']))

        if _params.get('tertiary_mood_cluster') is not None:  # noqa: E501
            _query_params.append(('tertiaryMoodCluster', _params['tertiary_mood_cluster']))

        if _params.get('valence') is not None:  # noqa: E501
            _query_params.append(('valence', _params['valence']))

        if _params.get('arousal') is not None:  # noqa: E501
            _query_params.append(('arousal', _params['arousal']))

        if _params.get('pleasantness') is not None:  # noqa: E501
            _query_params.append(('pleasantness', _params['pleasantness']))

        if _params.get('engagement') is not None:  # noqa: E501
            _query_params.append(('engagement', _params['engagement']))

        if _params.get('vocals') is not None:  # noqa: E501
            _query_params.append(('vocals', _params['vocals']))

        if _params.get('dominant_instrument') is not None:  # noqa: E501
            _query_params.append(('dominantInstrument', _params['dominant_instrument']))

        if _params.get('secondary_instrument') is not None:  # noqa: E501
            _query_params.append(('secondaryInstrument', _params['secondary_instrument']))

        if _params.get('tertiary_instrument') is not None:  # noqa: E501
            _query_params.append(('tertiaryInstrument', _params['tertiary_instrument']))

        if _params.get('energy') is not None:  # noqa: E501
            _query_params.append(('energy', _params['energy']))

        if _params.get('sound_generation') is not None:  # noqa: E501
            _query_params.append(('soundGeneration', _params['sound_generation']))

        if _params.get('tempo') is not None:  # noqa: E501
            _query_params.append(('tempo', _params['tempo']))

        if _params.get('scale') is not None:  # noqa: E501
            _query_params.append(('scale', _params['scale']))

        if _params.get('rhythm') is not None:  # noqa: E501
            _query_params.append(('rhythm', _params['rhythm']))

        if _params.get('primary_sound_character') is not None:  # noqa: E501
            _query_params.append(('primarySoundCharacter', _params['primary_sound_character']))

        if _params.get('timbre') is not None:  # noqa: E501
            _query_params.append(('timbre', _params['timbre']))

        if _params.get('roughness') is not None:  # noqa: E501
            _query_params.append(('roughness', _params['roughness']))

        if _params.get('tonality') is not None:  # noqa: E501
            _query_params.append(('tonality', _params['tonality']))

        if _params.get('harmony') is not None:  # noqa: E501
            _query_params.append(('harmony', _params['harmony']))

        if _params.get('texture') is not None:  # noqa: E501
            _query_params.append(('texture', _params['texture']))

        if _params.get('groovyness') is not None:  # noqa: E501
            _query_params.append(('groovyness', _params['groovyness']))

        if _params.get('space') is not None:  # noqa: E501
            _query_params.append(('space', _params['space']))

        if _params.get('production_rating') is not None:  # noqa: E501
            _query_params.append(('productionRating', _params['production_rating']))

        if _params.get('performance_rating') is not None:  # noqa: E501
            _query_params.append(('performanceRating', _params['performance_rating']))

        if _params.get('song_rating') is not None:  # noqa: E501
            _query_params.append(('songRating', _params['song_rating']))

        if _params.get('audience_age') is not None:  # noqa: E501
            _query_params.append(('audienceAge', _params['audience_age']))

        if _params.get('audience_region') is not None:  # noqa: E501
            _query_params.append(('audienceRegion', _params['audience_region']))

        if _params.get('audience_gender') is not None:  # noqa: E501
            _query_params.append(('audienceGender', _params['audience_gender']))

        if _params.get('origin_decade') is not None:  # noqa: E501
            _query_params.append(('originDecade', _params['origin_decade']))

        if _params.get('curateability') is not None:  # noqa: E501
            _query_params.append(('curateability', _params['curateability']))

        if _params.get('use_case') is not None:  # noqa: E501
            _query_params.append(('useCase', _params['use_case']))

        if _params.get('channel_suitability') is not None:  # noqa: E501
            _query_params.append(('channelSuitability', _params['channel_suitability']))

        if _params.get('similar_to_recording') is not None:  # noqa: E501
            _query_params.append(('similarToRecording', _params['similar_to_recording']))

        if _params.get('songtradr_track_id') is not None:  # noqa: E501
            _query_params.append(('songtradrTrackId', _params['songtradr_track_id']))

        if _params.get('usage_name') is not None:  # noqa: E501
            _query_params.append(('usageName', _params['usage_name']))

        if _params.get('bpm_min') is not None:  # noqa: E501
            _query_params.append(('bpmMin', _params['bpm_min']))

        if _params.get('bpm_max') is not None:  # noqa: E501
            _query_params.append(('bpmMax', _params['bpm_max']))

        if _params.get('name') is not None:  # noqa: E501
            _query_params.append(('name', _params['name']))

        if _params.get('folder') is not None:  # noqa: E501
            _query_params.append(('folder', _params['folder']))

        if _params.get('extension') is not None:  # noqa: E501
            _query_params.append(('extension', _params['extension']))

        if _params.get('upload_end_time') is not None:  # noqa: E501
            if isinstance(_params['upload_end_time'], datetime):
                _query_params.append(('uploadEndTime', _params['upload_end_time'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('uploadEndTime', _params['upload_end_time']))

        if _params.get('min_upload_end_time') is not None:  # noqa: E501
            if isinstance(_params['min_upload_end_time'], datetime):
                _query_params.append(('minUploadEndTime', _params['min_upload_end_time'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('minUploadEndTime', _params['min_upload_end_time']))

        if _params.get('max_upload_end_time') is not None:  # noqa: E501
            if isinstance(_params['max_upload_end_time'], datetime):
                _query_params.append(('maxUploadEndTime', _params['max_upload_end_time'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('maxUploadEndTime', _params['max_upload_end_time']))

        if _params.get('fingerprint_status') is not None:  # noqa: E501
            _query_params.append(('fingerprintStatus', _params['fingerprint_status']))

        if _params.get('inference_status') is not None:  # noqa: E501
            _query_params.append(('inferenceStatus', _params['inference_status']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "FilesSummaryDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/filesSummary', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def user_folders(self, page : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[conint(strict=True, ge=1)], Field(description="The size of the page to be returned")] = None, sort : Annotated[Optional[conlist(StrictStr)], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None, **kwargs) -> List[str]:  # noqa: E501
        """Your Folders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_folders(page, size, sort, async_req=True)
        >>> result = thread.get()

        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[str]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the user_folders_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.user_folders_with_http_info(page, size, sort, **kwargs)  # noqa: E501

    @validate_arguments
    def user_folders_with_http_info(self, page : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[conint(strict=True, ge=1)], Field(description="The size of the page to be returned")] = None, sort : Annotated[Optional[conlist(StrictStr)], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Your Folders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_folders_with_http_info(page, size, sort, async_req=True)
        >>> result = thread.get()

        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[str], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'page',
            'size',
            'sort'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_folders" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('size') is not None:  # noqa: E501
            _query_params.append(('size', _params['size']))

        if _params.get('sort') is not None:  # noqa: E501
            _query_params.append(('sort', _params['sort']))
            _collection_formats['sort'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "List[str]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/folders', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def user_referrers(self, username : StrictStr, **kwargs) -> List[str]:  # noqa: E501
        """(Deprecated) user_referrers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_referrers(username, async_req=True)
        >>> result = thread.get()

        :param username: (required)
        :type username: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[str]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the user_referrers_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.user_referrers_with_http_info(username, **kwargs)  # noqa: E501

    @validate_arguments
    def user_referrers_with_http_info(self, username : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """(Deprecated) user_referrers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_referrers_with_http_info(username, async_req=True)
        >>> result = thread.get()

        :param username: (required)
        :type username: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[str], status_code(int), headers(HTTPHeaderDict))
        """

        warnings.warn("GET /api/v1/user/referrers/{username} is deprecated.", DeprecationWarning)

        _params = locals()

        _all_params = [
            'username'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_referrers" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['username']:
            _path_params['username'] = _params['username']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "List[str]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/user/referrers/{username}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
