# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.  # noqa: E501

    The version of the OpenAPI document: 1.12.24
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist, validator
from songtradr_api_client_python.models.save_recording_genre_dto import SaveRecordingGenreDTO
from songtradr_api_client_python.models.save_recording_party_dto import SaveRecordingPartyDTO
from songtradr_api_client_python.models.save_recording_tag_dto import SaveRecordingTagDTO
from songtradr_api_client_python.models.save_taggrams_dto import SaveTaggramsDTO

class SaveFileRecordingDTO(BaseModel):
    """
    Data crafted by AI or users.
    """
    isrc: StrictStr = Field(...)
    name: Optional[StrictStr] = None
    folder: Optional[StrictStr] = None
    primary_mood_cluster_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="primaryMoodClusterAffinity")
    primary_mood_cluster: Optional[StrictStr] = Field(None, alias="primaryMoodCluster", description="Search for a language of the lyrics")
    secondary_mood_cluster_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="secondaryMoodClusterAffinity")
    secondary_mood_cluster: Optional[StrictStr] = Field(None, alias="secondaryMoodCluster", description="Search for a language of the lyrics")
    tertiary_mood_cluster_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="tertiaryMoodClusterAffinity")
    tertiary_mood_cluster: Optional[StrictStr] = Field(None, alias="tertiaryMoodCluster", description="Search for a language of the lyrics")
    valence_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="valenceAffinity")
    arousal_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="arousalAffinity")
    pleasantness_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="pleasantnessAffinity")
    engagement_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="engagementAffinity")
    valence: Optional[StrictStr] = Field(None, description="Search for a valence")
    arousal: Optional[StrictStr] = Field(None, description="Search for an arousal")
    pleasantness: Optional[StrictStr] = Field(None, description="Search for pleasantness")
    engagement: Optional[StrictStr] = Field(None, description="Search for an engagement")
    vocals: Optional[StrictStr] = Field(None, description="Search for a vocal gender or instrumental songs")
    vocals_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="vocalsAffinity")
    dominant_instrument: Optional[StrictStr] = Field(None, alias="dominantInstrument", description="Search for a dominant instrument")
    dominant_instrument_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="dominantInstrumentAffinity")
    secondary_instrument_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="secondaryInstrumentAffinity")
    secondary_instrument: Optional[StrictStr] = Field(None, alias="secondaryInstrument", description="Search for a dominant instrument")
    tertiary_instrument_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="tertiaryInstrumentAffinity")
    tertiary_instrument: Optional[StrictStr] = Field(None, alias="tertiaryInstrument", description="Search for a dominant instrument")
    energy: Optional[StrictStr] = Field(None, description="Search for energy")
    energy_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="energyAffinity")
    sound_generation: Optional[StrictStr] = Field(None, alias="soundGeneration", description="Search for type of sound generation")
    sound_generation_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="soundGenerationAffinity")
    tempo: Optional[StrictStr] = Field(None, description="Search for tempo")
    tempo_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="tempoAffinity")
    scale: Optional[StrictStr] = Field(None, description="Search for a tonal scale")
    scale_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="scaleAffinity")
    rhythm: Optional[StrictStr] = Field(None, description="Search for rhythm")
    rhythm_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="rhythmAffinity")
    primary_sound_character: Optional[StrictStr] = Field(None, alias="primarySoundCharacter", description="Search for a sound character")
    primary_sound_character_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="primarySoundCharacterAffinity")
    timbre_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="timbreAffinity")
    roughness_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="roughnessAffinity")
    tonality_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="tonalityAffinity")
    harmony_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="harmonyAffinity")
    texture_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="textureAffinity")
    groovyness_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="groovynessAffinity")
    space_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="spaceAffinity")
    timbre: Optional[StrictStr] = Field(None, description="Search for timbre")
    roughness: Optional[StrictStr] = Field(None, description="Search for roughness")
    tonality: Optional[StrictStr] = Field(None, description="Search for tonality")
    harmony: Optional[StrictStr] = Field(None, description="Search for a degree of harmoniousness")
    texture: Optional[StrictStr] = Field(None, description="Search for texture")
    groovyness: Optional[StrictStr] = Field(None, description="Search for groovyness")
    space: Optional[StrictStr] = Field(None, description="Search for space")
    bpm: Optional[Union[StrictFloat, StrictInt]] = None
    key: Optional[StrictStr] = Field(None, description="Search for a harmonic key")
    key_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="keyAffinity")
    production_rating: Optional[StrictStr] = Field(None, alias="productionRating")
    production_rating_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="productionRatingAffinity")
    performance_rating: Optional[StrictStr] = Field(None, alias="performanceRating")
    performance_rating_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="performanceRatingAffinity")
    song_rating: Optional[StrictStr] = Field(None, alias="songRating")
    song_rating_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="songRatingAffinity")
    audience_gender: Optional[StrictStr] = Field(None, alias="audienceGender")
    audience_gender_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="audienceGenderAffinity")
    audience_region: Optional[StrictStr] = Field(None, alias="audienceRegion")
    audience_region_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="audienceRegionAffinity")
    secondary_audience_region_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="secondaryAudienceRegionAffinity")
    secondary_audience_region: Optional[StrictStr] = Field(None, alias="secondaryAudienceRegion")
    tertiary_audience_region_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="tertiaryAudienceRegionAffinity")
    tertiary_audience_region: Optional[StrictStr] = Field(None, alias="tertiaryAudienceRegion")
    audience_age: Optional[StrictStr] = Field(None, alias="audienceAge")
    audience_age_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="audienceAgeAffinity")
    secondary_audience_age: Optional[StrictStr] = Field(None, alias="secondaryAudienceAge")
    secondary_audience_age_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="secondaryAudienceAgeAffinity")
    tertiary_audience_age: Optional[StrictStr] = Field(None, alias="tertiaryAudienceAge")
    tertiary_audience_age_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="tertiaryAudienceAgeAffinity")
    origin_decade: Optional[StrictStr] = Field(None, alias="originDecade", description="Search for origin decade")
    origin_decade_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="originDecadeAffinity")
    language_of_performance: Optional[StrictStr] = Field(None, alias="languageOfPerformance")
    language_of_performance_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="languageOfPerformanceAffinity")
    origin_region: Optional[StrictStr] = Field(None, alias="originRegion")
    origin_region_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="originRegionAffinity")
    taggrams: Optional[SaveTaggramsDTO] = None
    embeddings: Optional[conlist(Union[StrictFloat, StrictInt])] = None
    level1_genre: Optional[StrictStr] = Field(None, alias="level1Genre")
    level1_genre_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="level1GenreAffinity")
    secondary_level1_genre: Optional[StrictStr] = Field(None, alias="secondaryLevel1Genre")
    secondary_level1_genre_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="secondaryLevel1GenreAffinity")
    tertiary_level1_genre: Optional[StrictStr] = Field(None, alias="tertiaryLevel1Genre")
    tertiary_level1_genre_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="tertiaryLevel1GenreAffinity")
    level2_genre: Optional[StrictStr] = Field(None, alias="level2Genre")
    level2_genre_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="level2GenreAffinity")
    secondary_level2_genre: Optional[StrictStr] = Field(None, alias="secondaryLevel2Genre")
    secondary_level2_genre_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="secondaryLevel2GenreAffinity")
    tertiary_level2_genre: Optional[StrictStr] = Field(None, alias="tertiaryLevel2Genre")
    tertiary_level2_genre_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="tertiaryLevel2GenreAffinity")
    curateability: Optional[StrictStr] = Field(None, description="Search for curatebility")
    curateability_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="curateabilityAffinity")
    use_case: Optional[StrictStr] = Field(None, alias="useCase", description="Search for use case")
    use_case_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="useCaseAffinity")
    social_media: Optional[StrictStr] = Field(None, alias="socialMedia", description="Search for social media suitability")
    social_media_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="socialMediaAffinity")
    industry_suitability: Optional[StrictStr] = Field(None, alias="industrySuitability", description="Search for Industry suitability")
    industry_suitability_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="industrySuitabilityAffinity")
    created_by_version: StrictStr = Field(..., alias="createdByVersion")
    tags: Optional[conlist(SaveRecordingTagDTO)] = None
    genres: Optional[conlist(SaveRecordingGenreDTO)] = None
    parties: Optional[conlist(SaveRecordingPartyDTO)] = None
    iswc: Optional[StrictStr] = None
    proprietary_id_gema: Optional[StrictStr] = Field(None, alias="proprietaryIdGema")
    title: Optional[StrictStr] = None
    version_title: Optional[StrictStr] = Field(None, alias="versionTitle")
    __properties = ["isrc", "name", "folder", "primaryMoodClusterAffinity", "primaryMoodCluster", "secondaryMoodClusterAffinity", "secondaryMoodCluster", "tertiaryMoodClusterAffinity", "tertiaryMoodCluster", "valenceAffinity", "arousalAffinity", "pleasantnessAffinity", "engagementAffinity", "valence", "arousal", "pleasantness", "engagement", "vocals", "vocalsAffinity", "dominantInstrument", "dominantInstrumentAffinity", "secondaryInstrumentAffinity", "secondaryInstrument", "tertiaryInstrumentAffinity", "tertiaryInstrument", "energy", "energyAffinity", "soundGeneration", "soundGenerationAffinity", "tempo", "tempoAffinity", "scale", "scaleAffinity", "rhythm", "rhythmAffinity", "primarySoundCharacter", "primarySoundCharacterAffinity", "timbreAffinity", "roughnessAffinity", "tonalityAffinity", "harmonyAffinity", "textureAffinity", "groovynessAffinity", "spaceAffinity", "timbre", "roughness", "tonality", "harmony", "texture", "groovyness", "space", "bpm", "key", "keyAffinity", "productionRating", "productionRatingAffinity", "performanceRating", "performanceRatingAffinity", "songRating", "songRatingAffinity", "audienceGender", "audienceGenderAffinity", "audienceRegion", "audienceRegionAffinity", "secondaryAudienceRegionAffinity", "secondaryAudienceRegion", "tertiaryAudienceRegionAffinity", "tertiaryAudienceRegion", "audienceAge", "audienceAgeAffinity", "secondaryAudienceAge", "secondaryAudienceAgeAffinity", "tertiaryAudienceAge", "tertiaryAudienceAgeAffinity", "originDecade", "originDecadeAffinity", "languageOfPerformance", "languageOfPerformanceAffinity", "originRegion", "originRegionAffinity", "taggrams", "embeddings", "level1Genre", "level1GenreAffinity", "secondaryLevel1Genre", "secondaryLevel1GenreAffinity", "tertiaryLevel1Genre", "tertiaryLevel1GenreAffinity", "level2Genre", "level2GenreAffinity", "secondaryLevel2Genre", "secondaryLevel2GenreAffinity", "tertiaryLevel2Genre", "tertiaryLevel2GenreAffinity", "curateability", "curateabilityAffinity", "useCase", "useCaseAffinity", "socialMedia", "socialMediaAffinity", "industrySuitability", "industrySuitabilityAffinity", "createdByVersion", "tags", "genres", "parties", "iswc", "proprietaryIdGema", "title", "versionTitle"]

    @validator('primary_mood_cluster')
    def primary_mood_cluster_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild'):
            raise ValueError("must be one of enum values ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild')")
        return value

    @validator('secondary_mood_cluster')
    def secondary_mood_cluster_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild'):
            raise ValueError("must be one of enum values ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild')")
        return value

    @validator('tertiary_mood_cluster')
    def tertiary_mood_cluster_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild'):
            raise ValueError("must be one of enum values ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild')")
        return value

    @validator('valence')
    def valence_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very sad', 'sad', 'moderate valence', 'positive', 'very positive', 'varying valence'):
            raise ValueError("must be one of enum values ('very sad', 'sad', 'moderate valence', 'positive', 'very positive', 'varying valence')")
        return value

    @validator('arousal')
    def arousal_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very calm', 'calm', 'moderate arousal', 'energetic', 'very energetic', 'varying arousal'):
            raise ValueError("must be one of enum values ('very calm', 'calm', 'moderate arousal', 'energetic', 'very energetic', 'varying arousal')")
        return value

    @validator('pleasantness')
    def pleasantness_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very unpleasant', 'unpleasant', 'neutral pleasantness', 'pleasant', 'very pleasant', 'varying pleasantness'):
            raise ValueError("must be one of enum values ('very unpleasant', 'unpleasant', 'neutral pleasantness', 'pleasant', 'very pleasant', 'varying pleasantness')")
        return value

    @validator('engagement')
    def engagement_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very unengaging', 'unengaging', 'neutral engagement', 'engaging', 'very engaging', 'varying engagement'):
            raise ValueError("must be one of enum values ('very unengaging', 'unengaging', 'neutral engagement', 'engaging', 'very engaging', 'varying engagement')")
        return value

    @validator('vocals')
    def vocals_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('instrumental', 'female vocals', 'male vocals', 'mixed vocals', 'diverse gender vocals'):
            raise ValueError("must be one of enum values ('instrumental', 'female vocals', 'male vocals', 'mixed vocals', 'diverse gender vocals')")
        return value

    @validator('dominant_instrument')
    def dominant_instrument_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp'):
            raise ValueError("must be one of enum values ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp')")
        return value

    @validator('secondary_instrument')
    def secondary_instrument_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp'):
            raise ValueError("must be one of enum values ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp')")
        return value

    @validator('tertiary_instrument')
    def tertiary_instrument_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp'):
            raise ValueError("must be one of enum values ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp')")
        return value

    @validator('energy')
    def energy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very quiet', 'quiet', 'moderate', 'loud', 'very loud', 'dynamic'):
            raise ValueError("must be one of enum values ('very quiet', 'quiet', 'moderate', 'loud', 'very loud', 'dynamic')")
        return value

    @validator('sound_generation')
    def sound_generation_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('acoustic', 'electric', 'electronic', 'mixed sound generation'):
            raise ValueError("must be one of enum values ('acoustic', 'electric', 'electronic', 'mixed sound generation')")
        return value

    @validator('tempo')
    def tempo_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very slow', 'slow', 'mid-tempo', 'fast', 'very fast', 'varying tempo'):
            raise ValueError("must be one of enum values ('very slow', 'slow', 'mid-tempo', 'fast', 'very fast', 'varying tempo')")
        return value

    @validator('scale')
    def scale_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('major key', 'minor key', 'neutral key'):
            raise ValueError("must be one of enum values ('major key', 'minor key', 'neutral key')")
        return value

    @validator('rhythm')
    def rhythm_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('common time', 'triple meter', 'complex time signature', 'binary rhythm', 'ternary rhythm'):
            raise ValueError("must be one of enum values ('common time', 'triple meter', 'complex time signature', 'binary rhythm', 'ternary rhythm')")
        return value

    @validator('primary_sound_character')
    def primary_sound_character_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('brassy', 'bright', 'clear', 'deep', 'distorted', 'flat', 'full', 'groovy', 'melodious', 'natural', 'resonant', 'shrill', 'steady', 'thin', 'warm'):
            raise ValueError("must be one of enum values ('brassy', 'bright', 'clear', 'deep', 'distorted', 'flat', 'full', 'groovy', 'melodious', 'natural', 'resonant', 'shrill', 'steady', 'thin', 'warm')")
        return value

    @validator('timbre')
    def timbre_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very warm', 'warm', 'moderate timbre', 'bright', 'very bright'):
            raise ValueError("must be one of enum values ('very warm', 'warm', 'moderate timbre', 'bright', 'very bright')")
        return value

    @validator('roughness')
    def roughness_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very clear', 'clear', 'moderate roughness', 'distorted', 'very distorted'):
            raise ValueError("must be one of enum values ('very clear', 'clear', 'moderate roughness', 'distorted', 'very distorted')")
        return value

    @validator('tonality')
    def tonality_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('monotonous', 'moderate melodiousness', 'melodious', 'atonal'):
            raise ValueError("must be one of enum values ('monotonous', 'moderate melodiousness', 'melodious', 'atonal')")
        return value

    @validator('harmony')
    def harmony_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very dissonant', 'dissonant', 'moderate harmonies', 'harmonious', 'very harmonious'):
            raise ValueError("must be one of enum values ('very dissonant', 'dissonant', 'moderate harmonies', 'harmonious', 'very harmonious')")
        return value

    @validator('texture')
    def texture_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very thin', 'thin', 'moderate texture', 'full', 'very full'):
            raise ValueError("must be one of enum values ('very thin', 'thin', 'moderate texture', 'full', 'very full')")
        return value

    @validator('groovyness')
    def groovyness_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very steady', 'steady', 'moderate rhythm feel', 'groovy', 'very groovy'):
            raise ValueError("must be one of enum values ('very steady', 'steady', 'moderate rhythm feel', 'groovy', 'very groovy')")
        return value

    @validator('space')
    def space_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very compact', 'compact', 'moderate space', 'wide', 'very wide'):
            raise ValueError("must be one of enum values ('very compact', 'compact', 'moderate space', 'wide', 'very wide')")
        return value

    @validator('key')
    def key_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('C', 'C#', 'D', 'D#', 'E', 'F', 'F#', 'G', 'G#', 'A', 'A#', 'B', 'unclear'):
            raise ValueError("must be one of enum values ('C', 'C#', 'D', 'D#', 'E', 'F', 'F#', 'G', 'G#', 'A', 'A#', 'B', 'unclear')")
        return value

    @validator('production_rating')
    def production_rating_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('low production quality', 'medium production quality', 'high production quality'):
            raise ValueError("must be one of enum values ('low production quality', 'medium production quality', 'high production quality')")
        return value

    @validator('performance_rating')
    def performance_rating_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('low performance quality', 'medium performance quality', 'high performance quality'):
            raise ValueError("must be one of enum values ('low performance quality', 'medium performance quality', 'high performance quality')")
        return value

    @validator('song_rating')
    def song_rating_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('low song quality', 'medium song quality', 'high song quality'):
            raise ValueError("must be one of enum values ('low song quality', 'medium song quality', 'high song quality')")
        return value

    @validator('audience_gender')
    def audience_gender_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('male', 'female'):
            raise ValueError("must be one of enum values ('male', 'female')")
        return value

    @validator('audience_region')
    def audience_region_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe'):
            raise ValueError("must be one of enum values ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe')")
        return value

    @validator('secondary_audience_region')
    def secondary_audience_region_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe'):
            raise ValueError("must be one of enum values ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe')")
        return value

    @validator('tertiary_audience_region')
    def tertiary_audience_region_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe'):
            raise ValueError("must be one of enum values ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe')")
        return value

    @validator('audience_age')
    def audience_age_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B'):
            raise ValueError("must be one of enum values ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B')")
        return value

    @validator('secondary_audience_age')
    def secondary_audience_age_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B'):
            raise ValueError("must be one of enum values ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B')")
        return value

    @validator('tertiary_audience_age')
    def tertiary_audience_age_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B'):
            raise ValueError("must be one of enum values ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B')")
        return value

    @validator('origin_decade')
    def origin_decade_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('pre-1950s', '1950s', '1960s', '1970s', '1980s', '1990s', '2000s', '2010s', '2020s'):
            raise ValueError("must be one of enum values ('pre-1950s', '1950s', '1960s', '1970s', '1980s', '1990s', '2000s', '2010s', '2020s')")
        return value

    @validator('language_of_performance')
    def language_of_performance_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('en', 'de', 'no', 'fr', 'es', 'pt', 'fi', 'ru', 'it', 'la', 'el', 'ar', 'nl', 'ja', 'pl', 'sv', 'zu', 'da', 'cs', 'hu', 'af', 'hi', 'tr', 'zh', 'ms', 'pa', 'id', 'ko', 'vi'):
            raise ValueError("must be one of enum values ('en', 'de', 'no', 'fr', 'es', 'pt', 'fi', 'ru', 'it', 'la', 'el', 'ar', 'nl', 'ja', 'pl', 'sv', 'zu', 'da', 'cs', 'hu', 'af', 'hi', 'tr', 'zh', 'ms', 'pa', 'id', 'ko', 'vi')")
        return value

    @validator('origin_region')
    def origin_region_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe'):
            raise ValueError("must be one of enum values ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe')")
        return value

    @validator('level1_genre')
    def level1_genre_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Pop', 'Rock', 'Metal', 'Jazz', 'World', 'Country', 'Functional Music', 'Classical', 'Alternative', 'R&B', 'Blues', 'Hip Hop', 'Reggae', 'Electronic', 'Spoken Word', 'Folk'):
            raise ValueError("must be one of enum values ('Pop', 'Rock', 'Metal', 'Jazz', 'World', 'Country', 'Functional Music', 'Classical', 'Alternative', 'R&B', 'Blues', 'Hip Hop', 'Reggae', 'Electronic', 'Spoken Word', 'Folk')")
        return value

    @validator('secondary_level1_genre')
    def secondary_level1_genre_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Pop', 'Rock', 'Metal', 'Jazz', 'World', 'Country', 'Functional Music', 'Classical', 'Alternative', 'R&B', 'Blues', 'Hip Hop', 'Reggae', 'Electronic', 'Spoken Word', 'Folk'):
            raise ValueError("must be one of enum values ('Pop', 'Rock', 'Metal', 'Jazz', 'World', 'Country', 'Functional Music', 'Classical', 'Alternative', 'R&B', 'Blues', 'Hip Hop', 'Reggae', 'Electronic', 'Spoken Word', 'Folk')")
        return value

    @validator('tertiary_level1_genre')
    def tertiary_level1_genre_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Pop', 'Rock', 'Metal', 'Jazz', 'World', 'Country', 'Functional Music', 'Classical', 'Alternative', 'R&B', 'Blues', 'Hip Hop', 'Reggae', 'Electronic', 'Spoken Word', 'Folk'):
            raise ValueError("must be one of enum values ('Pop', 'Rock', 'Metal', 'Jazz', 'World', 'Country', 'Functional Music', 'Classical', 'Alternative', 'R&B', 'Blues', 'Hip Hop', 'Reggae', 'Electronic', 'Spoken Word', 'Folk')")
        return value

    @validator('level2_genre')
    def level2_genre_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Electro Pop', 'Indie Pop', 'Indie Rock', 'Electroclash', 'Adult Contemporary', 'Easy Listening', 'Comedy Music', 'New Age', 'Chanson', 'Singer/Songwriter', 'Schlager', 'Volksmusik', 'Rock'n'Roll', 'Rockabilly', 'Psychobilly', 'Surf', 'Doo Wop', 'Mainstream Rock', 'Mersey Beat', 'Glamrock', 'Latin Rock', 'Melodic Rock', 'Progressive Rock', 'Psychedelic Rock', 'Hard Rock', 'Krautrock', 'Power Metal', 'Nu Metal', 'Grind Core', 'Gothic Metal', 'Death Metal', 'Melodic Death Metal', 'Thrash Metal', 'Black Metal', 'Glam Metal', 'Sleaze Metal', 'Metalcore', 'Progressive Metal', 'Screamo', 'Symphonic Metal', 'Swing', 'Ragtime', 'Dixieland', 'Boogie Woogie', 'Bebop', 'Cool Jazz', 'Free Jazz', 'Fusion', 'Smooth Jazz', 'Acid Jazz', 'Bossa Nova', 'Latin Jazz', 'Nu-Jazz', 'Tango', 'Samba', 'Salsa', 'Axé', 'Sertanejo', 'Forró', 'Choro', 'Fado', 'Flamenco', 'Blasmusik', 'American Folk', 'Irish Folk', 'Americana', 'Bluegrass', 'Red Dirt', 'Outlaw Country', 'Nashville', 'Honkytonk', 'Production Music', 'Soundtrack', 'Musical', 'Medieval', 'Renaissance', 'Baroque', 'Classical Period', 'Romanticism', 'Neue Musik', 'Minimal Music', 'Neoklassik', 'Postmoderne Musik', 'Punk', 'Noise Rock', 'Garage', 'Grunge', 'Industrial', 'New Wave', 'Post Punk', 'Gothic Rock', 'Stoner Rock', 'Pop Punk', 'Post Hardcore', 'Post Rock', 'Post Metal', 'Post-Grunge', 'Britpop', 'Ska Punk', 'Math Rock', 'Dreampop', 'Shoegaze', 'Contemporary R&B', 'Rhythm And Blues', 'Disco', 'Chicago Soul', 'Detroit Soul', 'Urban', 'Nu R&B', 'Neo Soul', 'Early Funk', 'Funk Rock', 'Folk Blues', 'Classics Blues', 'Blues Rock', 'Trap Music', 'Electro-hop', 'Hardcore Rap', 'Miami Bass & Bounce', 'Dirty South Rap', 'Turntablism', 'West Coast Gangsta Rap', 'East Coast Gangsta Rap', 'Roots-Reggae', 'Dub', 'Raggamuffin', 'Ska', 'Dancehall', 'Chicago House', 'Ambient House', 'Deep House', 'Tech House', 'Acid House', 'Dutch House', 'Progressive House', 'Funky House', 'Nu Disco', 'Minimal Techno', 'Hardcore Techno', 'IDM', 'Trance', 'Psytrance', 'Progressive Trance', 'Grime', 'Big Beat', 'Dub Step', 'Liquid Funk', 'Hard Step', 'Jump Up', 'Old School Jungle', 'Trip Hop', 'Gospel', 'Dancepop', 'Indietronica', 'Nu Rave', 'Emo-Rock', 'Post-Punk Revival', 'Nu Prog', 'Indie Folk', 'Audiobook', 'Audioplay', 'Relaxation', 'Ambient House / Chill-Out', 'Chemical Breaks & Big Beat', 'Chicago House & Garage House', 'Chicago Soul & Detroit Soul', 'Comedy', 'Dark Wave', 'Dreampop & Shoegaze', 'Electro House & Dutch House', 'French House & Funky House', 'Golden Age Rad & Hardcore Rap', 'Hard Step & Tech Step', 'Indietronica & Chillwave', 'Nu Disco & Funktronica', 'Doom Metal', 'Mathcore', 'Psy Trance', 'Roots Rock'):
            raise ValueError("must be one of enum values ('Electro Pop', 'Indie Pop', 'Indie Rock', 'Electroclash', 'Adult Contemporary', 'Easy Listening', 'Comedy Music', 'New Age', 'Chanson', 'Singer/Songwriter', 'Schlager', 'Volksmusik', 'Rock'n'Roll', 'Rockabilly', 'Psychobilly', 'Surf', 'Doo Wop', 'Mainstream Rock', 'Mersey Beat', 'Glamrock', 'Latin Rock', 'Melodic Rock', 'Progressive Rock', 'Psychedelic Rock', 'Hard Rock', 'Krautrock', 'Power Metal', 'Nu Metal', 'Grind Core', 'Gothic Metal', 'Death Metal', 'Melodic Death Metal', 'Thrash Metal', 'Black Metal', 'Glam Metal', 'Sleaze Metal', 'Metalcore', 'Progressive Metal', 'Screamo', 'Symphonic Metal', 'Swing', 'Ragtime', 'Dixieland', 'Boogie Woogie', 'Bebop', 'Cool Jazz', 'Free Jazz', 'Fusion', 'Smooth Jazz', 'Acid Jazz', 'Bossa Nova', 'Latin Jazz', 'Nu-Jazz', 'Tango', 'Samba', 'Salsa', 'Axé', 'Sertanejo', 'Forró', 'Choro', 'Fado', 'Flamenco', 'Blasmusik', 'American Folk', 'Irish Folk', 'Americana', 'Bluegrass', 'Red Dirt', 'Outlaw Country', 'Nashville', 'Honkytonk', 'Production Music', 'Soundtrack', 'Musical', 'Medieval', 'Renaissance', 'Baroque', 'Classical Period', 'Romanticism', 'Neue Musik', 'Minimal Music', 'Neoklassik', 'Postmoderne Musik', 'Punk', 'Noise Rock', 'Garage', 'Grunge', 'Industrial', 'New Wave', 'Post Punk', 'Gothic Rock', 'Stoner Rock', 'Pop Punk', 'Post Hardcore', 'Post Rock', 'Post Metal', 'Post-Grunge', 'Britpop', 'Ska Punk', 'Math Rock', 'Dreampop', 'Shoegaze', 'Contemporary R&B', 'Rhythm And Blues', 'Disco', 'Chicago Soul', 'Detroit Soul', 'Urban', 'Nu R&B', 'Neo Soul', 'Early Funk', 'Funk Rock', 'Folk Blues', 'Classics Blues', 'Blues Rock', 'Trap Music', 'Electro-hop', 'Hardcore Rap', 'Miami Bass & Bounce', 'Dirty South Rap', 'Turntablism', 'West Coast Gangsta Rap', 'East Coast Gangsta Rap', 'Roots-Reggae', 'Dub', 'Raggamuffin', 'Ska', 'Dancehall', 'Chicago House', 'Ambient House', 'Deep House', 'Tech House', 'Acid House', 'Dutch House', 'Progressive House', 'Funky House', 'Nu Disco', 'Minimal Techno', 'Hardcore Techno', 'IDM', 'Trance', 'Psytrance', 'Progressive Trance', 'Grime', 'Big Beat', 'Dub Step', 'Liquid Funk', 'Hard Step', 'Jump Up', 'Old School Jungle', 'Trip Hop', 'Gospel', 'Dancepop', 'Indietronica', 'Nu Rave', 'Emo-Rock', 'Post-Punk Revival', 'Nu Prog', 'Indie Folk', 'Audiobook', 'Audioplay', 'Relaxation', 'Ambient House / Chill-Out', 'Chemical Breaks & Big Beat', 'Chicago House & Garage House', 'Chicago Soul & Detroit Soul', 'Comedy', 'Dark Wave', 'Dreampop & Shoegaze', 'Electro House & Dutch House', 'French House & Funky House', 'Golden Age Rad & Hardcore Rap', 'Hard Step & Tech Step', 'Indietronica & Chillwave', 'Nu Disco & Funktronica', 'Doom Metal', 'Mathcore', 'Psy Trance', 'Roots Rock')")
        return value

    @validator('secondary_level2_genre')
    def secondary_level2_genre_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Electro Pop', 'Indie Pop', 'Indie Rock', 'Electroclash', 'Adult Contemporary', 'Easy Listening', 'Comedy Music', 'New Age', 'Chanson', 'Singer/Songwriter', 'Schlager', 'Volksmusik', 'Rock'n'Roll', 'Rockabilly', 'Psychobilly', 'Surf', 'Doo Wop', 'Mainstream Rock', 'Mersey Beat', 'Glamrock', 'Latin Rock', 'Melodic Rock', 'Progressive Rock', 'Psychedelic Rock', 'Hard Rock', 'Krautrock', 'Power Metal', 'Nu Metal', 'Grind Core', 'Gothic Metal', 'Death Metal', 'Melodic Death Metal', 'Thrash Metal', 'Black Metal', 'Glam Metal', 'Sleaze Metal', 'Metalcore', 'Progressive Metal', 'Screamo', 'Symphonic Metal', 'Swing', 'Ragtime', 'Dixieland', 'Boogie Woogie', 'Bebop', 'Cool Jazz', 'Free Jazz', 'Fusion', 'Smooth Jazz', 'Acid Jazz', 'Bossa Nova', 'Latin Jazz', 'Nu-Jazz', 'Tango', 'Samba', 'Salsa', 'Axé', 'Sertanejo', 'Forró', 'Choro', 'Fado', 'Flamenco', 'Blasmusik', 'American Folk', 'Irish Folk', 'Americana', 'Bluegrass', 'Red Dirt', 'Outlaw Country', 'Nashville', 'Honkytonk', 'Production Music', 'Soundtrack', 'Musical', 'Medieval', 'Renaissance', 'Baroque', 'Classical Period', 'Romanticism', 'Neue Musik', 'Minimal Music', 'Neoklassik', 'Postmoderne Musik', 'Punk', 'Noise Rock', 'Garage', 'Grunge', 'Industrial', 'New Wave', 'Post Punk', 'Gothic Rock', 'Stoner Rock', 'Pop Punk', 'Post Hardcore', 'Post Rock', 'Post Metal', 'Post-Grunge', 'Britpop', 'Ska Punk', 'Math Rock', 'Dreampop', 'Shoegaze', 'Contemporary R&B', 'Rhythm And Blues', 'Disco', 'Chicago Soul', 'Detroit Soul', 'Urban', 'Nu R&B', 'Neo Soul', 'Early Funk', 'Funk Rock', 'Folk Blues', 'Classics Blues', 'Blues Rock', 'Trap Music', 'Electro-hop', 'Hardcore Rap', 'Miami Bass & Bounce', 'Dirty South Rap', 'Turntablism', 'West Coast Gangsta Rap', 'East Coast Gangsta Rap', 'Roots-Reggae', 'Dub', 'Raggamuffin', 'Ska', 'Dancehall', 'Chicago House', 'Ambient House', 'Deep House', 'Tech House', 'Acid House', 'Dutch House', 'Progressive House', 'Funky House', 'Nu Disco', 'Minimal Techno', 'Hardcore Techno', 'IDM', 'Trance', 'Psytrance', 'Progressive Trance', 'Grime', 'Big Beat', 'Dub Step', 'Liquid Funk', 'Hard Step', 'Jump Up', 'Old School Jungle', 'Trip Hop', 'Gospel', 'Dancepop', 'Indietronica', 'Nu Rave', 'Emo-Rock', 'Post-Punk Revival', 'Nu Prog', 'Indie Folk', 'Audiobook', 'Audioplay', 'Relaxation', 'Ambient House / Chill-Out', 'Chemical Breaks & Big Beat', 'Chicago House & Garage House', 'Chicago Soul & Detroit Soul', 'Comedy', 'Dark Wave', 'Dreampop & Shoegaze', 'Electro House & Dutch House', 'French House & Funky House', 'Golden Age Rad & Hardcore Rap', 'Hard Step & Tech Step', 'Indietronica & Chillwave', 'Nu Disco & Funktronica', 'Doom Metal', 'Mathcore', 'Psy Trance', 'Roots Rock'):
            raise ValueError("must be one of enum values ('Electro Pop', 'Indie Pop', 'Indie Rock', 'Electroclash', 'Adult Contemporary', 'Easy Listening', 'Comedy Music', 'New Age', 'Chanson', 'Singer/Songwriter', 'Schlager', 'Volksmusik', 'Rock'n'Roll', 'Rockabilly', 'Psychobilly', 'Surf', 'Doo Wop', 'Mainstream Rock', 'Mersey Beat', 'Glamrock', 'Latin Rock', 'Melodic Rock', 'Progressive Rock', 'Psychedelic Rock', 'Hard Rock', 'Krautrock', 'Power Metal', 'Nu Metal', 'Grind Core', 'Gothic Metal', 'Death Metal', 'Melodic Death Metal', 'Thrash Metal', 'Black Metal', 'Glam Metal', 'Sleaze Metal', 'Metalcore', 'Progressive Metal', 'Screamo', 'Symphonic Metal', 'Swing', 'Ragtime', 'Dixieland', 'Boogie Woogie', 'Bebop', 'Cool Jazz', 'Free Jazz', 'Fusion', 'Smooth Jazz', 'Acid Jazz', 'Bossa Nova', 'Latin Jazz', 'Nu-Jazz', 'Tango', 'Samba', 'Salsa', 'Axé', 'Sertanejo', 'Forró', 'Choro', 'Fado', 'Flamenco', 'Blasmusik', 'American Folk', 'Irish Folk', 'Americana', 'Bluegrass', 'Red Dirt', 'Outlaw Country', 'Nashville', 'Honkytonk', 'Production Music', 'Soundtrack', 'Musical', 'Medieval', 'Renaissance', 'Baroque', 'Classical Period', 'Romanticism', 'Neue Musik', 'Minimal Music', 'Neoklassik', 'Postmoderne Musik', 'Punk', 'Noise Rock', 'Garage', 'Grunge', 'Industrial', 'New Wave', 'Post Punk', 'Gothic Rock', 'Stoner Rock', 'Pop Punk', 'Post Hardcore', 'Post Rock', 'Post Metal', 'Post-Grunge', 'Britpop', 'Ska Punk', 'Math Rock', 'Dreampop', 'Shoegaze', 'Contemporary R&B', 'Rhythm And Blues', 'Disco', 'Chicago Soul', 'Detroit Soul', 'Urban', 'Nu R&B', 'Neo Soul', 'Early Funk', 'Funk Rock', 'Folk Blues', 'Classics Blues', 'Blues Rock', 'Trap Music', 'Electro-hop', 'Hardcore Rap', 'Miami Bass & Bounce', 'Dirty South Rap', 'Turntablism', 'West Coast Gangsta Rap', 'East Coast Gangsta Rap', 'Roots-Reggae', 'Dub', 'Raggamuffin', 'Ska', 'Dancehall', 'Chicago House', 'Ambient House', 'Deep House', 'Tech House', 'Acid House', 'Dutch House', 'Progressive House', 'Funky House', 'Nu Disco', 'Minimal Techno', 'Hardcore Techno', 'IDM', 'Trance', 'Psytrance', 'Progressive Trance', 'Grime', 'Big Beat', 'Dub Step', 'Liquid Funk', 'Hard Step', 'Jump Up', 'Old School Jungle', 'Trip Hop', 'Gospel', 'Dancepop', 'Indietronica', 'Nu Rave', 'Emo-Rock', 'Post-Punk Revival', 'Nu Prog', 'Indie Folk', 'Audiobook', 'Audioplay', 'Relaxation', 'Ambient House / Chill-Out', 'Chemical Breaks & Big Beat', 'Chicago House & Garage House', 'Chicago Soul & Detroit Soul', 'Comedy', 'Dark Wave', 'Dreampop & Shoegaze', 'Electro House & Dutch House', 'French House & Funky House', 'Golden Age Rad & Hardcore Rap', 'Hard Step & Tech Step', 'Indietronica & Chillwave', 'Nu Disco & Funktronica', 'Doom Metal', 'Mathcore', 'Psy Trance', 'Roots Rock')")
        return value

    @validator('tertiary_level2_genre')
    def tertiary_level2_genre_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Electro Pop', 'Indie Pop', 'Indie Rock', 'Electroclash', 'Adult Contemporary', 'Easy Listening', 'Comedy Music', 'New Age', 'Chanson', 'Singer/Songwriter', 'Schlager', 'Volksmusik', 'Rock'n'Roll', 'Rockabilly', 'Psychobilly', 'Surf', 'Doo Wop', 'Mainstream Rock', 'Mersey Beat', 'Glamrock', 'Latin Rock', 'Melodic Rock', 'Progressive Rock', 'Psychedelic Rock', 'Hard Rock', 'Krautrock', 'Power Metal', 'Nu Metal', 'Grind Core', 'Gothic Metal', 'Death Metal', 'Melodic Death Metal', 'Thrash Metal', 'Black Metal', 'Glam Metal', 'Sleaze Metal', 'Metalcore', 'Progressive Metal', 'Screamo', 'Symphonic Metal', 'Swing', 'Ragtime', 'Dixieland', 'Boogie Woogie', 'Bebop', 'Cool Jazz', 'Free Jazz', 'Fusion', 'Smooth Jazz', 'Acid Jazz', 'Bossa Nova', 'Latin Jazz', 'Nu-Jazz', 'Tango', 'Samba', 'Salsa', 'Axé', 'Sertanejo', 'Forró', 'Choro', 'Fado', 'Flamenco', 'Blasmusik', 'American Folk', 'Irish Folk', 'Americana', 'Bluegrass', 'Red Dirt', 'Outlaw Country', 'Nashville', 'Honkytonk', 'Production Music', 'Soundtrack', 'Musical', 'Medieval', 'Renaissance', 'Baroque', 'Classical Period', 'Romanticism', 'Neue Musik', 'Minimal Music', 'Neoklassik', 'Postmoderne Musik', 'Punk', 'Noise Rock', 'Garage', 'Grunge', 'Industrial', 'New Wave', 'Post Punk', 'Gothic Rock', 'Stoner Rock', 'Pop Punk', 'Post Hardcore', 'Post Rock', 'Post Metal', 'Post-Grunge', 'Britpop', 'Ska Punk', 'Math Rock', 'Dreampop', 'Shoegaze', 'Contemporary R&B', 'Rhythm And Blues', 'Disco', 'Chicago Soul', 'Detroit Soul', 'Urban', 'Nu R&B', 'Neo Soul', 'Early Funk', 'Funk Rock', 'Folk Blues', 'Classics Blues', 'Blues Rock', 'Trap Music', 'Electro-hop', 'Hardcore Rap', 'Miami Bass & Bounce', 'Dirty South Rap', 'Turntablism', 'West Coast Gangsta Rap', 'East Coast Gangsta Rap', 'Roots-Reggae', 'Dub', 'Raggamuffin', 'Ska', 'Dancehall', 'Chicago House', 'Ambient House', 'Deep House', 'Tech House', 'Acid House', 'Dutch House', 'Progressive House', 'Funky House', 'Nu Disco', 'Minimal Techno', 'Hardcore Techno', 'IDM', 'Trance', 'Psytrance', 'Progressive Trance', 'Grime', 'Big Beat', 'Dub Step', 'Liquid Funk', 'Hard Step', 'Jump Up', 'Old School Jungle', 'Trip Hop', 'Gospel', 'Dancepop', 'Indietronica', 'Nu Rave', 'Emo-Rock', 'Post-Punk Revival', 'Nu Prog', 'Indie Folk', 'Audiobook', 'Audioplay', 'Relaxation', 'Ambient House / Chill-Out', 'Chemical Breaks & Big Beat', 'Chicago House & Garage House', 'Chicago Soul & Detroit Soul', 'Comedy', 'Dark Wave', 'Dreampop & Shoegaze', 'Electro House & Dutch House', 'French House & Funky House', 'Golden Age Rad & Hardcore Rap', 'Hard Step & Tech Step', 'Indietronica & Chillwave', 'Nu Disco & Funktronica', 'Doom Metal', 'Mathcore', 'Psy Trance', 'Roots Rock'):
            raise ValueError("must be one of enum values ('Electro Pop', 'Indie Pop', 'Indie Rock', 'Electroclash', 'Adult Contemporary', 'Easy Listening', 'Comedy Music', 'New Age', 'Chanson', 'Singer/Songwriter', 'Schlager', 'Volksmusik', 'Rock'n'Roll', 'Rockabilly', 'Psychobilly', 'Surf', 'Doo Wop', 'Mainstream Rock', 'Mersey Beat', 'Glamrock', 'Latin Rock', 'Melodic Rock', 'Progressive Rock', 'Psychedelic Rock', 'Hard Rock', 'Krautrock', 'Power Metal', 'Nu Metal', 'Grind Core', 'Gothic Metal', 'Death Metal', 'Melodic Death Metal', 'Thrash Metal', 'Black Metal', 'Glam Metal', 'Sleaze Metal', 'Metalcore', 'Progressive Metal', 'Screamo', 'Symphonic Metal', 'Swing', 'Ragtime', 'Dixieland', 'Boogie Woogie', 'Bebop', 'Cool Jazz', 'Free Jazz', 'Fusion', 'Smooth Jazz', 'Acid Jazz', 'Bossa Nova', 'Latin Jazz', 'Nu-Jazz', 'Tango', 'Samba', 'Salsa', 'Axé', 'Sertanejo', 'Forró', 'Choro', 'Fado', 'Flamenco', 'Blasmusik', 'American Folk', 'Irish Folk', 'Americana', 'Bluegrass', 'Red Dirt', 'Outlaw Country', 'Nashville', 'Honkytonk', 'Production Music', 'Soundtrack', 'Musical', 'Medieval', 'Renaissance', 'Baroque', 'Classical Period', 'Romanticism', 'Neue Musik', 'Minimal Music', 'Neoklassik', 'Postmoderne Musik', 'Punk', 'Noise Rock', 'Garage', 'Grunge', 'Industrial', 'New Wave', 'Post Punk', 'Gothic Rock', 'Stoner Rock', 'Pop Punk', 'Post Hardcore', 'Post Rock', 'Post Metal', 'Post-Grunge', 'Britpop', 'Ska Punk', 'Math Rock', 'Dreampop', 'Shoegaze', 'Contemporary R&B', 'Rhythm And Blues', 'Disco', 'Chicago Soul', 'Detroit Soul', 'Urban', 'Nu R&B', 'Neo Soul', 'Early Funk', 'Funk Rock', 'Folk Blues', 'Classics Blues', 'Blues Rock', 'Trap Music', 'Electro-hop', 'Hardcore Rap', 'Miami Bass & Bounce', 'Dirty South Rap', 'Turntablism', 'West Coast Gangsta Rap', 'East Coast Gangsta Rap', 'Roots-Reggae', 'Dub', 'Raggamuffin', 'Ska', 'Dancehall', 'Chicago House', 'Ambient House', 'Deep House', 'Tech House', 'Acid House', 'Dutch House', 'Progressive House', 'Funky House', 'Nu Disco', 'Minimal Techno', 'Hardcore Techno', 'IDM', 'Trance', 'Psytrance', 'Progressive Trance', 'Grime', 'Big Beat', 'Dub Step', 'Liquid Funk', 'Hard Step', 'Jump Up', 'Old School Jungle', 'Trip Hop', 'Gospel', 'Dancepop', 'Indietronica', 'Nu Rave', 'Emo-Rock', 'Post-Punk Revival', 'Nu Prog', 'Indie Folk', 'Audiobook', 'Audioplay', 'Relaxation', 'Ambient House / Chill-Out', 'Chemical Breaks & Big Beat', 'Chicago House & Garage House', 'Chicago Soul & Detroit Soul', 'Comedy', 'Dark Wave', 'Dreampop & Shoegaze', 'Electro House & Dutch House', 'French House & Funky House', 'Golden Age Rad & Hardcore Rap', 'Hard Step & Tech Step', 'Indietronica & Chillwave', 'Nu Disco & Funktronica', 'Doom Metal', 'Mathcore', 'Psy Trance', 'Roots Rock')")
        return value

    @validator('curateability')
    def curateability_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('curateable', 'uncurateable'):
            raise ValueError("must be one of enum values ('curateable', 'uncurateable')")
        return value

    @validator('use_case')
    def use_case_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('background', 'sport', 'focus', 'christmas', 'film', 'summer', 'adverts', 'party', 'relax'):
            raise ValueError("must be one of enum values ('background', 'sport', 'focus', 'christmas', 'film', 'summer', 'adverts', 'party', 'relax')")
        return value

    @validator('social_media')
    def social_media_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Spotify', 'TikTok', 'Unfitting', 'YouTube'):
            raise ValueError("must be one of enum values ('Spotify', 'TikTok', 'Unfitting', 'YouTube')")
        return value

    @validator('industry_suitability')
    def industry_suitability_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Automobiles and Parts', 'Consumer Products and Services', 'Financial Services', 'Food, Beverage and Tobacco', 'Health Care', 'Insurance', 'Media', 'Politics, Government and Organizations', 'Real Estate', 'Retail', 'Technology', 'Telecommunications', 'Travel and Leisure'):
            raise ValueError("must be one of enum values ('Automobiles and Parts', 'Consumer Products and Services', 'Financial Services', 'Food, Beverage and Tobacco', 'Health Care', 'Insurance', 'Media', 'Politics, Government and Organizations', 'Real Estate', 'Retail', 'Technology', 'Telecommunications', 'Travel and Leisure')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SaveFileRecordingDTO:
        """Create an instance of SaveFileRecordingDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of taggrams
        if self.taggrams:
            _dict['taggrams'] = self.taggrams.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in genres (list)
        _items = []
        if self.genres:
            for _item in self.genres:
                if _item:
                    _items.append(_item.to_dict())
            _dict['genres'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in parties (list)
        _items = []
        if self.parties:
            for _item in self.parties:
                if _item:
                    _items.append(_item.to_dict())
            _dict['parties'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SaveFileRecordingDTO:
        """Create an instance of SaveFileRecordingDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SaveFileRecordingDTO.parse_obj(obj)

        _obj = SaveFileRecordingDTO.parse_obj({
            "isrc": obj.get("isrc"),
            "name": obj.get("name"),
            "folder": obj.get("folder"),
            "primary_mood_cluster_affinity": obj.get("primaryMoodClusterAffinity"),
            "primary_mood_cluster": obj.get("primaryMoodCluster"),
            "secondary_mood_cluster_affinity": obj.get("secondaryMoodClusterAffinity"),
            "secondary_mood_cluster": obj.get("secondaryMoodCluster"),
            "tertiary_mood_cluster_affinity": obj.get("tertiaryMoodClusterAffinity"),
            "tertiary_mood_cluster": obj.get("tertiaryMoodCluster"),
            "valence_affinity": obj.get("valenceAffinity"),
            "arousal_affinity": obj.get("arousalAffinity"),
            "pleasantness_affinity": obj.get("pleasantnessAffinity"),
            "engagement_affinity": obj.get("engagementAffinity"),
            "valence": obj.get("valence"),
            "arousal": obj.get("arousal"),
            "pleasantness": obj.get("pleasantness"),
            "engagement": obj.get("engagement"),
            "vocals": obj.get("vocals"),
            "vocals_affinity": obj.get("vocalsAffinity"),
            "dominant_instrument": obj.get("dominantInstrument"),
            "dominant_instrument_affinity": obj.get("dominantInstrumentAffinity"),
            "secondary_instrument_affinity": obj.get("secondaryInstrumentAffinity"),
            "secondary_instrument": obj.get("secondaryInstrument"),
            "tertiary_instrument_affinity": obj.get("tertiaryInstrumentAffinity"),
            "tertiary_instrument": obj.get("tertiaryInstrument"),
            "energy": obj.get("energy"),
            "energy_affinity": obj.get("energyAffinity"),
            "sound_generation": obj.get("soundGeneration"),
            "sound_generation_affinity": obj.get("soundGenerationAffinity"),
            "tempo": obj.get("tempo"),
            "tempo_affinity": obj.get("tempoAffinity"),
            "scale": obj.get("scale"),
            "scale_affinity": obj.get("scaleAffinity"),
            "rhythm": obj.get("rhythm"),
            "rhythm_affinity": obj.get("rhythmAffinity"),
            "primary_sound_character": obj.get("primarySoundCharacter"),
            "primary_sound_character_affinity": obj.get("primarySoundCharacterAffinity"),
            "timbre_affinity": obj.get("timbreAffinity"),
            "roughness_affinity": obj.get("roughnessAffinity"),
            "tonality_affinity": obj.get("tonalityAffinity"),
            "harmony_affinity": obj.get("harmonyAffinity"),
            "texture_affinity": obj.get("textureAffinity"),
            "groovyness_affinity": obj.get("groovynessAffinity"),
            "space_affinity": obj.get("spaceAffinity"),
            "timbre": obj.get("timbre"),
            "roughness": obj.get("roughness"),
            "tonality": obj.get("tonality"),
            "harmony": obj.get("harmony"),
            "texture": obj.get("texture"),
            "groovyness": obj.get("groovyness"),
            "space": obj.get("space"),
            "bpm": obj.get("bpm"),
            "key": obj.get("key"),
            "key_affinity": obj.get("keyAffinity"),
            "production_rating": obj.get("productionRating"),
            "production_rating_affinity": obj.get("productionRatingAffinity"),
            "performance_rating": obj.get("performanceRating"),
            "performance_rating_affinity": obj.get("performanceRatingAffinity"),
            "song_rating": obj.get("songRating"),
            "song_rating_affinity": obj.get("songRatingAffinity"),
            "audience_gender": obj.get("audienceGender"),
            "audience_gender_affinity": obj.get("audienceGenderAffinity"),
            "audience_region": obj.get("audienceRegion"),
            "audience_region_affinity": obj.get("audienceRegionAffinity"),
            "secondary_audience_region_affinity": obj.get("secondaryAudienceRegionAffinity"),
            "secondary_audience_region": obj.get("secondaryAudienceRegion"),
            "tertiary_audience_region_affinity": obj.get("tertiaryAudienceRegionAffinity"),
            "tertiary_audience_region": obj.get("tertiaryAudienceRegion"),
            "audience_age": obj.get("audienceAge"),
            "audience_age_affinity": obj.get("audienceAgeAffinity"),
            "secondary_audience_age": obj.get("secondaryAudienceAge"),
            "secondary_audience_age_affinity": obj.get("secondaryAudienceAgeAffinity"),
            "tertiary_audience_age": obj.get("tertiaryAudienceAge"),
            "tertiary_audience_age_affinity": obj.get("tertiaryAudienceAgeAffinity"),
            "origin_decade": obj.get("originDecade"),
            "origin_decade_affinity": obj.get("originDecadeAffinity"),
            "language_of_performance": obj.get("languageOfPerformance"),
            "language_of_performance_affinity": obj.get("languageOfPerformanceAffinity"),
            "origin_region": obj.get("originRegion"),
            "origin_region_affinity": obj.get("originRegionAffinity"),
            "taggrams": SaveTaggramsDTO.from_dict(obj.get("taggrams")) if obj.get("taggrams") is not None else None,
            "embeddings": obj.get("embeddings"),
            "level1_genre": obj.get("level1Genre"),
            "level1_genre_affinity": obj.get("level1GenreAffinity"),
            "secondary_level1_genre": obj.get("secondaryLevel1Genre"),
            "secondary_level1_genre_affinity": obj.get("secondaryLevel1GenreAffinity"),
            "tertiary_level1_genre": obj.get("tertiaryLevel1Genre"),
            "tertiary_level1_genre_affinity": obj.get("tertiaryLevel1GenreAffinity"),
            "level2_genre": obj.get("level2Genre"),
            "level2_genre_affinity": obj.get("level2GenreAffinity"),
            "secondary_level2_genre": obj.get("secondaryLevel2Genre"),
            "secondary_level2_genre_affinity": obj.get("secondaryLevel2GenreAffinity"),
            "tertiary_level2_genre": obj.get("tertiaryLevel2Genre"),
            "tertiary_level2_genre_affinity": obj.get("tertiaryLevel2GenreAffinity"),
            "curateability": obj.get("curateability"),
            "curateability_affinity": obj.get("curateabilityAffinity"),
            "use_case": obj.get("useCase"),
            "use_case_affinity": obj.get("useCaseAffinity"),
            "social_media": obj.get("socialMedia"),
            "social_media_affinity": obj.get("socialMediaAffinity"),
            "industry_suitability": obj.get("industrySuitability"),
            "industry_suitability_affinity": obj.get("industrySuitabilityAffinity"),
            "created_by_version": obj.get("createdByVersion"),
            "tags": [SaveRecordingTagDTO.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None,
            "genres": [SaveRecordingGenreDTO.from_dict(_item) for _item in obj.get("genres")] if obj.get("genres") is not None else None,
            "parties": [SaveRecordingPartyDTO.from_dict(_item) for _item in obj.get("parties")] if obj.get("parties") is not None else None,
            "iswc": obj.get("iswc"),
            "proprietary_id_gema": obj.get("proprietaryIdGema"),
            "title": obj.get("title"),
            "version_title": obj.get("versionTitle")
        })
        return _obj


