# songtradr-api-client-python
This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.

You can also use the API to manage your account and musicube cloud data.

**Authentication**

1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.

2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.

3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.

**Rate Limiting**

The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.

**Getting Started with auto-tagging**

1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file.
2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint.
3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.

**Getting Started with search**

You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.

1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters.
2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.13.0
- Package version: 1.13.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://songtradr.com](https://songtradr.com)

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import songtradr_api_client_python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import songtradr_api_client_python
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import songtradr_api_client_python
from songtradr_api_client_python.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.songtradr.com
# See configuration.py for a list of all supported configuration parameters.
configuration = songtradr_api_client_python.Configuration(
    host = "https://api.songtradr.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): bearer-jwt
configuration = songtradr_api_client_python.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with songtradr_api_client_python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = songtradr_api_client_python.APIKeysApi(api_client)
    create_api_key_dto = songtradr_api_client_python.CreateApiKeyDTO() # CreateApiKeyDTO | 

    try:
        # create an API key
        api_response = api_instance.create_api_key(create_api_key_dto)
        print("The response of APIKeysApi->create_api_key:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling APIKeysApi->create_api_key: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.songtradr.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIKeysApi* | [**create_api_key**](docs/APIKeysApi.md#create_api_key) | **POST** /api/v1/user/apiKeys | create an API key
*APIKeysApi* | [**delete_api_key**](docs/APIKeysApi.md#delete_api_key) | **DELETE** /api/v1/user/apiKeys/{id} | delete an API key
*APIKeysApi* | [**get_api_keys**](docs/APIKeysApi.md#get_api_keys) | **GET** /api/v1/user/apiKeys | list API keys
*AllowedValuesApi* | [**allowed_musical_features**](docs/AllowedValuesApi.md#allowed_musical_features) | **GET** /api/v1/allowedValues/musicalFeatures | Allowed values for music descriptive parameters to be used in the searchAll endpoint.
*AllowedValuesApi* | [**genres**](docs/AllowedValuesApi.md#genres) | **GET** /api/v1/allowedValues/genre | Allowed values for genres.
*AllowedValuesApi* | [**tags**](docs/AllowedValuesApi.md#tags) | **GET** /api/v1/allowedValues/tag | All descriptive tags inside of tag-categories.
*PartyApi* | [**party**](docs/PartyApi.md#party) | **GET** /api/v1/party | Information on a person, group or company.
*PlaylistApi* | [**all_playlists**](docs/PlaylistApi.md#all_playlists) | **GET** /api/v1/playlist | All playlists.
*PlaylistApi* | [**create_or_update_playlist**](docs/PlaylistApi.md#create_or_update_playlist) | **POST** /api/v1/playlist | Create and edit playlist.
*PlaylistApi* | [**delete_playlist**](docs/PlaylistApi.md#delete_playlist) | **DELETE** /api/v1/playlist/{songtradrPlaylistGuid} | Delete playlist.
*RecordingApi* | [**recordings_by_ids_with_musical_features**](docs/RecordingApi.md#recordings_by_ids_with_musical_features) | **GET** /api/v1/public/recording/{ids}/musicalFeatures | AI generated moods, musical features and more for recordings.
*RecordingApi* | [**recordings_by_ids_with_similarities**](docs/RecordingApi.md#recordings_by_ids_with_similarities) | **GET** /api/v1/public/recording/{ids}/similarities | Similar recordings for a list of recordings.
*RecordingApi* | [**recordings_by_ids_with_taggrams**](docs/RecordingApi.md#recordings_by_ids_with_taggrams) | **GET** /api/v1/public/recording/{ids}/taggrams | Timeseries of AI generated moods, musical features and more for a list of recordings.
*RecordingApi* | [**recordings_by_ids_with_tagstrengths**](docs/RecordingApi.md#recordings_by_ids_with_tagstrengths) | **GET** /api/v1/public/recording/{ids}/tagstrengths | Strengths as numerical representations for AI generated moods, musical features and more for recordings.
*RecordingApi* | [**recordings_large_by_ids**](docs/RecordingApi.md#recordings_large_by_ids) | **GET** /api/v1/public/recording/l/{ids} | Recordings by IDs with a large response.
*RecordingApi* | [**recordings_medium_by_ids**](docs/RecordingApi.md#recordings_medium_by_ids) | **GET** /api/v1/public/recording/m/{ids} | Recordings by IDs with a medium sized response.
*RecordingApi* | [**recordings_small_by_ids**](docs/RecordingApi.md#recordings_small_by_ids) | **GET** /api/v1/public/recording/s/{ids} | Recordings by IDs with a small response.
*RecordingApi* | [**search_recordings**](docs/RecordingApi.md#search_recordings) | **GET** /api/v1/public/recording/search | Recordings by contributors, moods, musical features and more.
*RecordingApi* | [**search_recordings_granular**](docs/RecordingApi.md#search_recordings_granular) | **POST** /api/v1/public/recording/searchGranular | Recordings by granular search options.
*RecordingApi* | [**search_recordings_granular_abstraction**](docs/RecordingApi.md#search_recordings_granular_abstraction) | **POST** /api/v1/public/recording/searchGranularAbstraction | Recordings by abstracted wordings and granular search options.
*UserApi* | [**create_user_referrer**](docs/UserApi.md#create_user_referrer) | **POST** /api/v1/user/referrers/new | 
*UserApi* | [**delete_user_file**](docs/UserApi.md#delete_user_file) | **DELETE** /api/v1/user/file/{objectKey} | Delete file.
*UserApi* | [**edit_me**](docs/UserApi.md#edit_me) | **POST** /api/v1/user/me | Edit details for a logged-in user
*UserApi* | [**forgot_password**](docs/UserApi.md#forgot_password) | **POST** /api/v1/user/forgot-password | Send a password reset email
*UserApi* | [**initiate_user_file_upload**](docs/UserApi.md#initiate_user_file_upload) | **POST** /api/v1/user/file/{name}/initUpload | Initialize a file upload. Responds with an URL where the file can be uploaded.
*UserApi* | [**login**](docs/UserApi.md#login) | **POST** /api/v1/user/login | Login to generate a bearer token.
*UserApi* | [**me**](docs/UserApi.md#me) | **GET** /api/v1/user/me | Details for a logged-in user
*UserApi* | [**recordings_by_folder_with_taggrams**](docs/UserApi.md#recordings_by_folder_with_taggrams) | **GET** /api/v1/user/folder/{folderName}/taggrams | Timeseries of AI generated moods, musical features and more for recordings in your folder.
*UserApi* | [**recordings_by_folder_with_tagstrengths**](docs/UserApi.md#recordings_by_folder_with_tagstrengths) | **GET** /api/v1/user/folder/{folderName}/tagstrengths | Strengths as numerical representations for AI generated moods, musical features and more for recordings in your folder.
*UserApi* | [**save_playlist**](docs/UserApi.md#save_playlist) | **POST** /api/v1/user/savePlaylist | List, search and create playlist of your own files.
*UserApi* | [**sign_up**](docs/UserApi.md#sign_up) | **POST** /api/v1/user/sign-up | Sign up a new user.
*UserApi* | [**token**](docs/UserApi.md#token) | **POST** /api/v1/user/token | Generates a new JWT token for the given refresh token
*UserApi* | [**update_password**](docs/UserApi.md#update_password) | **POST** /api/v1/user/update-password | Update password by using the password reset token
*UserApi* | [**update_user_file_recording**](docs/UserApi.md#update_user_file_recording) | **POST** /api/v1/user/file/{objectKey} | Create and edit metadata of your files.
*UserApi* | [**user_file**](docs/UserApi.md#user_file) | **GET** /api/v1/user/file/{objectKey} | Details and a download link for a file.
*UserApi* | [**user_files**](docs/UserApi.md#user_files) | **GET** /api/v1/user/files | List and search your own files.
*UserApi* | [**user_files_download**](docs/UserApi.md#user_files_download) | **GET** /api/v1/user/filesDownload | Download links for your files
*UserApi* | [**user_files_status**](docs/UserApi.md#user_files_status) | **GET** /api/v1/user/filesStatus | Status details for files.
*UserApi* | [**user_files_summary**](docs/UserApi.md#user_files_summary) | **GET** /api/v1/user/filesSummary | Summary fo your files.
*UserApi* | [**user_folders**](docs/UserApi.md#user_folders) | **GET** /api/v1/user/folders | Your Folders
*UserApi* | [**user_referrers**](docs/UserApi.md#user_referrers) | **GET** /api/v1/user/referrers/{username} | 


## Documentation For Models

 - [AdminApiUserDTO](docs/AdminApiUserDTO.md)
 - [ApiKeyDTO](docs/ApiKeyDTO.md)
 - [CategoryMediumDTO](docs/CategoryMediumDTO.md)
 - [CategoryMinimalDTO](docs/CategoryMinimalDTO.md)
 - [ConfigAccessDTO](docs/ConfigAccessDTO.md)
 - [ConfigIdentifierDTO](docs/ConfigIdentifierDTO.md)
 - [ContributorTypeDTO](docs/ContributorTypeDTO.md)
 - [CreateApiKeyDTO](docs/CreateApiKeyDTO.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [FieldSummaryDTO](docs/FieldSummaryDTO.md)
 - [FileDTO](docs/FileDTO.md)
 - [FileListDTO](docs/FileListDTO.md)
 - [FileMinimalWithUrlDTO](docs/FileMinimalWithUrlDTO.md)
 - [FileSmallDTO](docs/FileSmallDTO.md)
 - [FileUploadDTO](docs/FileUploadDTO.md)
 - [FileWIthUrlDTO](docs/FileWIthUrlDTO.md)
 - [FilesSummaryDTO](docs/FilesSummaryDTO.md)
 - [ForgotPasswordDTO](docs/ForgotPasswordDTO.md)
 - [GenreDTO](docs/GenreDTO.md)
 - [GenreMinimalDTO](docs/GenreMinimalDTO.md)
 - [GenresSummaryDTO](docs/GenresSummaryDTO.md)
 - [InitPutRecordingAudioDTO](docs/InitPutRecordingAudioDTO.md)
 - [JwtTokenDTO](docs/JwtTokenDTO.md)
 - [LoginDTO](docs/LoginDTO.md)
 - [MusicalFeaturesDTO](docs/MusicalFeaturesDTO.md)
 - [PLineDTO](docs/PLineDTO.md)
 - [PartyLargeDTO](docs/PartyLargeDTO.md)
 - [PartySmallDTO](docs/PartySmallDTO.md)
 - [PlaylistLargeDTO](docs/PlaylistLargeDTO.md)
 - [ProductMediumDTO](docs/ProductMediumDTO.md)
 - [ProductPartyDTO](docs/ProductPartyDTO.md)
 - [RecordingForSimilaritySearchDTO](docs/RecordingForSimilaritySearchDTO.md)
 - [RecordingGenrePredictionDTO](docs/RecordingGenrePredictionDTO.md)
 - [RecordingLargeDTO](docs/RecordingLargeDTO.md)
 - [RecordingListDTO](docs/RecordingListDTO.md)
 - [RecordingMediumDTO](docs/RecordingMediumDTO.md)
 - [RecordingMinimalWithMusicalFeaturesDTO](docs/RecordingMinimalWithMusicalFeaturesDTO.md)
 - [RecordingMinimalWithTaggramsDTO](docs/RecordingMinimalWithTaggramsDTO.md)
 - [RecordingMinimalWithTagstrengthsDTO](docs/RecordingMinimalWithTagstrengthsDTO.md)
 - [RecordingPartyDTO](docs/RecordingPartyDTO.md)
 - [RecordingPlaylistDTO](docs/RecordingPlaylistDTO.md)
 - [RecordingSmallDTO](docs/RecordingSmallDTO.md)
 - [RecordingTagSmallDTO](docs/RecordingTagSmallDTO.md)
 - [SaveFileRecordingDTO](docs/SaveFileRecordingDTO.md)
 - [SavePlaylistDTO](docs/SavePlaylistDTO.md)
 - [SaveRecordingGenreDTO](docs/SaveRecordingGenreDTO.md)
 - [SaveRecordingPartyDTO](docs/SaveRecordingPartyDTO.md)
 - [SaveRecordingPlaylistDTO](docs/SaveRecordingPlaylistDTO.md)
 - [SaveRecordingTagDTO](docs/SaveRecordingTagDTO.md)
 - [SaveReferrerDTO](docs/SaveReferrerDTO.md)
 - [SaveTaggramsDTO](docs/SaveTaggramsDTO.md)
 - [SaveUserDTO](docs/SaveUserDTO.md)
 - [SearchFilterValuesDTO](docs/SearchFilterValuesDTO.md)
 - [SearchRecordingGranularAbstractionDTO](docs/SearchRecordingGranularAbstractionDTO.md)
 - [SearchRecordingGranularDTO](docs/SearchRecordingGranularDTO.md)
 - [SignUpDTO](docs/SignUpDTO.md)
 - [TagDTO](docs/TagDTO.md)
 - [TagSmallDTO](docs/TagSmallDTO.md)
 - [TaggramDTO](docs/TaggramDTO.md)
 - [TagsSummaryDTO](docs/TagsSummaryDTO.md)
 - [TagstrengthDTO](docs/TagstrengthDTO.md)
 - [TitleDTO](docs/TitleDTO.md)
 - [TokenRequest](docs/TokenRequest.md)
 - [TrackDTO](docs/TrackDTO.md)
 - [TrackToMediumProductDTO](docs/TrackToMediumProductDTO.md)
 - [UpdatePasswordDTO](docs/UpdatePasswordDTO.md)
 - [UsageDTO](docs/UsageDTO.md)
 - [UserDTO](docs/UserDTO.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="bearer-jwt"></a>
### bearer-jwt

- **Type**: Bearer authentication (JWT)


## Author

info@songtradr.com


