# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.0
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictStr

from typing import Any, Dict, List, Optional

from songtradr_api_client_python.models.playlist_large_dto import PlaylistLargeDTO
from songtradr_api_client_python.models.save_playlist_dto import SavePlaylistDTO

from songtradr_api_client_python.api_client import ApiClient
from songtradr_api_client_python.api_response import ApiResponse
from songtradr_api_client_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class PlaylistApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def all_playlists(self, include_recordings : Annotated[Optional[StrictBool], Field(description="Whether a playlist shall include recordings or not.")] = None, ignore_usages : Annotated[Optional[StrictBool], Field(description="Whether a playlist shall include all songs regardless of their track usages.")] = None, usage_filter_mode : Annotated[Optional[StrictStr], Field(description="Whether a playlist recordings shall include all playlist usages or not.")] = None, songtradr_playlist_guid : Optional[StrictStr] = None, **kwargs) -> List[PlaylistLargeDTO]:  # noqa: E501
        """All playlists.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.all_playlists(include_recordings, ignore_usages, usage_filter_mode, songtradr_playlist_guid, async_req=True)
        >>> result = thread.get()

        :param include_recordings: Whether a playlist shall include recordings or not.
        :type include_recordings: bool
        :param ignore_usages: Whether a playlist shall include all songs regardless of their track usages.
        :type ignore_usages: bool
        :param usage_filter_mode: Whether a playlist recordings shall include all playlist usages or not.
        :type usage_filter_mode: str
        :param songtradr_playlist_guid:
        :type songtradr_playlist_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[PlaylistLargeDTO]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the all_playlists_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.all_playlists_with_http_info(include_recordings, ignore_usages, usage_filter_mode, songtradr_playlist_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def all_playlists_with_http_info(self, include_recordings : Annotated[Optional[StrictBool], Field(description="Whether a playlist shall include recordings or not.")] = None, ignore_usages : Annotated[Optional[StrictBool], Field(description="Whether a playlist shall include all songs regardless of their track usages.")] = None, usage_filter_mode : Annotated[Optional[StrictStr], Field(description="Whether a playlist recordings shall include all playlist usages or not.")] = None, songtradr_playlist_guid : Optional[StrictStr] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """All playlists.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.all_playlists_with_http_info(include_recordings, ignore_usages, usage_filter_mode, songtradr_playlist_guid, async_req=True)
        >>> result = thread.get()

        :param include_recordings: Whether a playlist shall include recordings or not.
        :type include_recordings: bool
        :param ignore_usages: Whether a playlist shall include all songs regardless of their track usages.
        :type ignore_usages: bool
        :param usage_filter_mode: Whether a playlist recordings shall include all playlist usages or not.
        :type usage_filter_mode: str
        :param songtradr_playlist_guid:
        :type songtradr_playlist_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[PlaylistLargeDTO], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'include_recordings',
            'ignore_usages',
            'usage_filter_mode',
            'songtradr_playlist_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_playlists" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('include_recordings') is not None:  # noqa: E501
            _query_params.append(('includeRecordings', _params['include_recordings']))

        if _params.get('ignore_usages') is not None:  # noqa: E501
            _query_params.append(('ignoreUsages', _params['ignore_usages']))

        if _params.get('usage_filter_mode') is not None:  # noqa: E501
            _query_params.append(('usageFilterMode', _params['usage_filter_mode']))

        if _params.get('songtradr_playlist_guid') is not None:  # noqa: E501
            _query_params.append(('songtradrPlaylistGuid', _params['songtradr_playlist_guid']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "List[PlaylistLargeDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/playlist', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_or_update_playlist(self, save_playlist_dto : SavePlaylistDTO, **kwargs) -> object:  # noqa: E501
        """Create and edit playlist.  # noqa: E501

        This endpoint expects always the full amount of information including all recordings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_or_update_playlist(save_playlist_dto, async_req=True)
        >>> result = thread.get()

        :param save_playlist_dto: (required)
        :type save_playlist_dto: SavePlaylistDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_or_update_playlist_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_or_update_playlist_with_http_info(save_playlist_dto, **kwargs)  # noqa: E501

    @validate_arguments
    def create_or_update_playlist_with_http_info(self, save_playlist_dto : SavePlaylistDTO, **kwargs) -> ApiResponse:  # noqa: E501
        """Create and edit playlist.  # noqa: E501

        This endpoint expects always the full amount of information including all recordings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_or_update_playlist_with_http_info(save_playlist_dto, async_req=True)
        >>> result = thread.get()

        :param save_playlist_dto: (required)
        :type save_playlist_dto: SavePlaylistDTO
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'save_playlist_dto'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_or_update_playlist" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['save_playlist_dto'] is not None:
            _body_params = _params['save_playlist_dto']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '403': "ErrorResponse",
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/playlist', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_playlist(self, songtradr_playlist_guid : Annotated[StrictStr, Field(..., description="ID of the file that should be deleted.")], **kwargs) -> object:  # noqa: E501
        """Delete playlist.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_playlist(songtradr_playlist_guid, async_req=True)
        >>> result = thread.get()

        :param songtradr_playlist_guid: ID of the file that should be deleted. (required)
        :type songtradr_playlist_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_playlist_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_playlist_with_http_info(songtradr_playlist_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_playlist_with_http_info(self, songtradr_playlist_guid : Annotated[StrictStr, Field(..., description="ID of the file that should be deleted.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete playlist.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_playlist_with_http_info(songtradr_playlist_guid, async_req=True)
        >>> result = thread.get()

        :param songtradr_playlist_guid: ID of the file that should be deleted. (required)
        :type songtradr_playlist_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'songtradr_playlist_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_playlist" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['songtradr_playlist_guid']:
            _path_params['songtradrPlaylistGuid'] = _params['songtradr_playlist_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/playlist/{songtradrPlaylistGuid}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
