# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.0
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr

class AdminApiUserDTO(BaseModel):
    """
    AdminApiUserDTO
    """
    id: Optional[StrictInt] = None
    username: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    full_name: Optional[StrictStr] = Field(None, alias="fullName")
    language: Optional[StrictStr] = None
    is_admin: Optional[StrictBool] = Field(None, alias="isAdmin")
    widgets_allowed: Optional[StrictBool] = Field(None, alias="widgetsAllowed")
    full_search_allowed: Optional[StrictBool] = Field(None, alias="fullSearchAllowed")
    voice_search_allowed: Optional[StrictBool] = Field(None, alias="voiceSearchAllowed")
    recording_detail_allowed: Optional[StrictBool] = Field(None, alias="recordingDetailAllowed")
    artist_detail_allowed: Optional[StrictBool] = Field(None, alias="artistDetailAllowed")
    playlist_prediction_allowed: Optional[StrictBool] = Field(None, alias="playlistPredictionAllowed")
    signup_allowed: Optional[StrictBool] = Field(None, alias="signupAllowed")
    upload_allowed: Optional[StrictBool] = Field(None, alias="uploadAllowed")
    fingerprint_allowed: Optional[StrictBool] = Field(None, alias="fingerprintAllowed")
    audiotagging_allowed: Optional[StrictBool] = Field(None, alias="audiotaggingAllowed")
    b2b_allowed: Optional[StrictBool] = Field(None, alias="b2bAllowed")
    editor_allowed: Optional[StrictBool] = Field(None, alias="editorAllowed")
    reduced_musical_features: Optional[StrictBool] = Field(None, alias="reducedMusicalFeatures")
    confirmed: Optional[StrictBool] = None
    gdpr_confirmation_timestamp: Optional[datetime] = Field(None, alias="gdprConfirmationTimestamp")
    last_login: Optional[datetime] = Field(None, alias="lastLogin")
    total_logins: Optional[StrictInt] = Field(None, alias="totalLogins")
    total_searches: Optional[StrictInt] = Field(None, alias="totalSearches")
    total_uploads: Optional[StrictInt] = Field(None, alias="totalUploads")
    total_downloads: Optional[StrictInt] = Field(None, alias="totalDownloads")
    total_updates: Optional[StrictInt] = Field(None, alias="totalUpdates")
    __properties = ["id", "username", "email", "fullName", "language", "isAdmin", "widgetsAllowed", "fullSearchAllowed", "voiceSearchAllowed", "recordingDetailAllowed", "artistDetailAllowed", "playlistPredictionAllowed", "signupAllowed", "uploadAllowed", "fingerprintAllowed", "audiotaggingAllowed", "b2bAllowed", "editorAllowed", "reducedMusicalFeatures", "confirmed", "gdprConfirmationTimestamp", "lastLogin", "totalLogins", "totalSearches", "totalUploads", "totalDownloads", "totalUpdates"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AdminApiUserDTO:
        """Create an instance of AdminApiUserDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AdminApiUserDTO:
        """Create an instance of AdminApiUserDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AdminApiUserDTO.parse_obj(obj)

        _obj = AdminApiUserDTO.parse_obj({
            "id": obj.get("id"),
            "username": obj.get("username"),
            "email": obj.get("email"),
            "full_name": obj.get("fullName"),
            "language": obj.get("language"),
            "is_admin": obj.get("isAdmin"),
            "widgets_allowed": obj.get("widgetsAllowed"),
            "full_search_allowed": obj.get("fullSearchAllowed"),
            "voice_search_allowed": obj.get("voiceSearchAllowed"),
            "recording_detail_allowed": obj.get("recordingDetailAllowed"),
            "artist_detail_allowed": obj.get("artistDetailAllowed"),
            "playlist_prediction_allowed": obj.get("playlistPredictionAllowed"),
            "signup_allowed": obj.get("signupAllowed"),
            "upload_allowed": obj.get("uploadAllowed"),
            "fingerprint_allowed": obj.get("fingerprintAllowed"),
            "audiotagging_allowed": obj.get("audiotaggingAllowed"),
            "b2b_allowed": obj.get("b2bAllowed"),
            "editor_allowed": obj.get("editorAllowed"),
            "reduced_musical_features": obj.get("reducedMusicalFeatures"),
            "confirmed": obj.get("confirmed"),
            "gdpr_confirmation_timestamp": obj.get("gdprConfirmationTimestamp"),
            "last_login": obj.get("lastLogin"),
            "total_logins": obj.get("totalLogins"),
            "total_searches": obj.get("totalSearches"),
            "total_uploads": obj.get("totalUploads"),
            "total_downloads": obj.get("totalDownloads"),
            "total_updates": obj.get("totalUpdates")
        })
        return _obj


