# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.0
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, conlist

class SaveTaggramsDTO(BaseModel):
    """
    Timeseries of tags.
    """
    timestamps: Optional[conlist(Union[StrictFloat, StrictInt])] = None
    level1_genre: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="level1Genre")
    level2_genre: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="level2Genre")
    song_rating: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="songRating")
    performance_rating: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="performanceRating")
    production_rating: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="productionRating")
    mood_cluster: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="moodCluster")
    vocals: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    dominant_instrument: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="dominantInstrument")
    sound_generation: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="soundGeneration")
    rhythm: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    tonality: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    audience_age: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="audienceAge")
    audience_gender: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="audienceGender")
    audience_region: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="audienceRegion")
    origin_region: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="originRegion")
    origin_decade: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="originDecade")
    language_of_performance: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="languageOfPerformance")
    arousal: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    valence: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    pleasantness: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    engagement: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    energy: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    timbre: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    roughness: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    harmony: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    texture: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    groovyness: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    space: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    curateability: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = None
    use_case: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="useCase")
    social_media: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="socialMedia")
    industry_suitability: Optional[Dict[str, conlist(Union[StrictFloat, StrictInt])]] = Field(None, alias="industrySuitability")
    __properties = ["timestamps", "level1Genre", "level2Genre", "songRating", "performanceRating", "productionRating", "moodCluster", "vocals", "dominantInstrument", "soundGeneration", "rhythm", "tonality", "audienceAge", "audienceGender", "audienceRegion", "originRegion", "originDecade", "languageOfPerformance", "arousal", "valence", "pleasantness", "engagement", "energy", "timbre", "roughness", "harmony", "texture", "groovyness", "space", "curateability", "useCase", "socialMedia", "industrySuitability"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SaveTaggramsDTO:
        """Create an instance of SaveTaggramsDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in level1_genre (dict of array)
        _field_dict_of_array = {}
        if self.level1_genre:
            for _key in self.level1_genre:
                if self.level1_genre[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.level1_genre[_key]
                    ]
            _dict['level1Genre'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in level2_genre (dict of array)
        _field_dict_of_array = {}
        if self.level2_genre:
            for _key in self.level2_genre:
                if self.level2_genre[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.level2_genre[_key]
                    ]
            _dict['level2Genre'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in song_rating (dict of array)
        _field_dict_of_array = {}
        if self.song_rating:
            for _key in self.song_rating:
                if self.song_rating[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.song_rating[_key]
                    ]
            _dict['songRating'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in performance_rating (dict of array)
        _field_dict_of_array = {}
        if self.performance_rating:
            for _key in self.performance_rating:
                if self.performance_rating[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.performance_rating[_key]
                    ]
            _dict['performanceRating'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in production_rating (dict of array)
        _field_dict_of_array = {}
        if self.production_rating:
            for _key in self.production_rating:
                if self.production_rating[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.production_rating[_key]
                    ]
            _dict['productionRating'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in mood_cluster (dict of array)
        _field_dict_of_array = {}
        if self.mood_cluster:
            for _key in self.mood_cluster:
                if self.mood_cluster[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.mood_cluster[_key]
                    ]
            _dict['moodCluster'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in vocals (dict of array)
        _field_dict_of_array = {}
        if self.vocals:
            for _key in self.vocals:
                if self.vocals[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.vocals[_key]
                    ]
            _dict['vocals'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in dominant_instrument (dict of array)
        _field_dict_of_array = {}
        if self.dominant_instrument:
            for _key in self.dominant_instrument:
                if self.dominant_instrument[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.dominant_instrument[_key]
                    ]
            _dict['dominantInstrument'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in sound_generation (dict of array)
        _field_dict_of_array = {}
        if self.sound_generation:
            for _key in self.sound_generation:
                if self.sound_generation[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.sound_generation[_key]
                    ]
            _dict['soundGeneration'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in rhythm (dict of array)
        _field_dict_of_array = {}
        if self.rhythm:
            for _key in self.rhythm:
                if self.rhythm[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.rhythm[_key]
                    ]
            _dict['rhythm'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in tonality (dict of array)
        _field_dict_of_array = {}
        if self.tonality:
            for _key in self.tonality:
                if self.tonality[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.tonality[_key]
                    ]
            _dict['tonality'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in audience_age (dict of array)
        _field_dict_of_array = {}
        if self.audience_age:
            for _key in self.audience_age:
                if self.audience_age[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.audience_age[_key]
                    ]
            _dict['audienceAge'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in audience_gender (dict of array)
        _field_dict_of_array = {}
        if self.audience_gender:
            for _key in self.audience_gender:
                if self.audience_gender[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.audience_gender[_key]
                    ]
            _dict['audienceGender'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in audience_region (dict of array)
        _field_dict_of_array = {}
        if self.audience_region:
            for _key in self.audience_region:
                if self.audience_region[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.audience_region[_key]
                    ]
            _dict['audienceRegion'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in origin_region (dict of array)
        _field_dict_of_array = {}
        if self.origin_region:
            for _key in self.origin_region:
                if self.origin_region[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.origin_region[_key]
                    ]
            _dict['originRegion'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in origin_decade (dict of array)
        _field_dict_of_array = {}
        if self.origin_decade:
            for _key in self.origin_decade:
                if self.origin_decade[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.origin_decade[_key]
                    ]
            _dict['originDecade'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in language_of_performance (dict of array)
        _field_dict_of_array = {}
        if self.language_of_performance:
            for _key in self.language_of_performance:
                if self.language_of_performance[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.language_of_performance[_key]
                    ]
            _dict['languageOfPerformance'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in arousal (dict of array)
        _field_dict_of_array = {}
        if self.arousal:
            for _key in self.arousal:
                if self.arousal[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.arousal[_key]
                    ]
            _dict['arousal'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in valence (dict of array)
        _field_dict_of_array = {}
        if self.valence:
            for _key in self.valence:
                if self.valence[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.valence[_key]
                    ]
            _dict['valence'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in pleasantness (dict of array)
        _field_dict_of_array = {}
        if self.pleasantness:
            for _key in self.pleasantness:
                if self.pleasantness[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.pleasantness[_key]
                    ]
            _dict['pleasantness'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in engagement (dict of array)
        _field_dict_of_array = {}
        if self.engagement:
            for _key in self.engagement:
                if self.engagement[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.engagement[_key]
                    ]
            _dict['engagement'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in energy (dict of array)
        _field_dict_of_array = {}
        if self.energy:
            for _key in self.energy:
                if self.energy[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.energy[_key]
                    ]
            _dict['energy'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in timbre (dict of array)
        _field_dict_of_array = {}
        if self.timbre:
            for _key in self.timbre:
                if self.timbre[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.timbre[_key]
                    ]
            _dict['timbre'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in roughness (dict of array)
        _field_dict_of_array = {}
        if self.roughness:
            for _key in self.roughness:
                if self.roughness[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.roughness[_key]
                    ]
            _dict['roughness'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in harmony (dict of array)
        _field_dict_of_array = {}
        if self.harmony:
            for _key in self.harmony:
                if self.harmony[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.harmony[_key]
                    ]
            _dict['harmony'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in texture (dict of array)
        _field_dict_of_array = {}
        if self.texture:
            for _key in self.texture:
                if self.texture[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.texture[_key]
                    ]
            _dict['texture'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in groovyness (dict of array)
        _field_dict_of_array = {}
        if self.groovyness:
            for _key in self.groovyness:
                if self.groovyness[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.groovyness[_key]
                    ]
            _dict['groovyness'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in space (dict of array)
        _field_dict_of_array = {}
        if self.space:
            for _key in self.space:
                if self.space[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.space[_key]
                    ]
            _dict['space'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in curateability (dict of array)
        _field_dict_of_array = {}
        if self.curateability:
            for _key in self.curateability:
                if self.curateability[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.curateability[_key]
                    ]
            _dict['curateability'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in use_case (dict of array)
        _field_dict_of_array = {}
        if self.use_case:
            for _key in self.use_case:
                if self.use_case[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.use_case[_key]
                    ]
            _dict['useCase'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in social_media (dict of array)
        _field_dict_of_array = {}
        if self.social_media:
            for _key in self.social_media:
                if self.social_media[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.social_media[_key]
                    ]
            _dict['socialMedia'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each value in industry_suitability (dict of array)
        _field_dict_of_array = {}
        if self.industry_suitability:
            for _key in self.industry_suitability:
                if self.industry_suitability[_key]:
                    _field_dict_of_array[_key] = [
                        _item.to_dict() for _item in self.industry_suitability[_key]
                    ]
            _dict['industrySuitability'] = _field_dict_of_array
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SaveTaggramsDTO:
        """Create an instance of SaveTaggramsDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SaveTaggramsDTO.parse_obj(obj)

        _obj = SaveTaggramsDTO.parse_obj({
            "timestamps": obj.get("timestamps"),
            "level1_genre": obj.get("level1Genre"),
            "level2_genre": obj.get("level2Genre"),
            "song_rating": obj.get("songRating"),
            "performance_rating": obj.get("performanceRating"),
            "production_rating": obj.get("productionRating"),
            "mood_cluster": obj.get("moodCluster"),
            "vocals": obj.get("vocals"),
            "dominant_instrument": obj.get("dominantInstrument"),
            "sound_generation": obj.get("soundGeneration"),
            "rhythm": obj.get("rhythm"),
            "tonality": obj.get("tonality"),
            "audience_age": obj.get("audienceAge"),
            "audience_gender": obj.get("audienceGender"),
            "audience_region": obj.get("audienceRegion"),
            "origin_region": obj.get("originRegion"),
            "origin_decade": obj.get("originDecade"),
            "language_of_performance": obj.get("languageOfPerformance"),
            "arousal": obj.get("arousal"),
            "valence": obj.get("valence"),
            "pleasantness": obj.get("pleasantness"),
            "engagement": obj.get("engagement"),
            "energy": obj.get("energy"),
            "timbre": obj.get("timbre"),
            "roughness": obj.get("roughness"),
            "harmony": obj.get("harmony"),
            "texture": obj.get("texture"),
            "groovyness": obj.get("groovyness"),
            "space": obj.get("space"),
            "curateability": obj.get("curateability"),
            "use_case": obj.get("useCase"),
            "social_media": obj.get("socialMedia"),
            "industry_suitability": obj.get("industrySuitability")
        })
        return _obj


