# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.1
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from songtradr_api_client_python.api.user_api import UserApi  # noqa: E501


class TestUserApi(unittest.TestCase):
    """UserApi unit test stubs"""

    def setUp(self) -> None:
        self.api = UserApi()  # noqa: E501

    def tearDown(self) -> None:
        pass

    def test_create_user_referrer(self) -> None:
        """Test case for create_user_referrer

        """
        pass

    def test_delete_user_file(self) -> None:
        """Test case for delete_user_file

        Delete file.  # noqa: E501
        """
        pass

    def test_edit_me(self) -> None:
        """Test case for edit_me

        Edit details for a logged-in user  # noqa: E501
        """
        pass

    def test_forgot_password(self) -> None:
        """Test case for forgot_password

        Send a password reset email  # noqa: E501
        """
        pass

    def test_initiate_user_file_upload(self) -> None:
        """Test case for initiate_user_file_upload

        Initialize a file upload. Responds with an URL where the file can be uploaded.  # noqa: E501
        """
        pass

    def test_login(self) -> None:
        """Test case for login

        Login to generate a bearer token.  # noqa: E501
        """
        pass

    def test_me(self) -> None:
        """Test case for me

        Details for a logged-in user  # noqa: E501
        """
        pass

    def test_recordings_by_folder_with_taggrams(self) -> None:
        """Test case for recordings_by_folder_with_taggrams

        Timeseries of AI generated moods, musical features and more for recordings in your folder.  # noqa: E501
        """
        pass

    def test_recordings_by_folder_with_tagstrengths(self) -> None:
        """Test case for recordings_by_folder_with_tagstrengths

        Strengths as numerical representations for AI generated moods, musical features and more for recordings in your folder.  # noqa: E501
        """
        pass

    def test_save_playlist(self) -> None:
        """Test case for save_playlist

        List, search and create playlist of your own files.  # noqa: E501
        """
        pass

    def test_sign_up(self) -> None:
        """Test case for sign_up

        Sign up a new user.  # noqa: E501
        """
        pass

    def test_token(self) -> None:
        """Test case for token

        Generates a new JWT token for the given refresh token  # noqa: E501
        """
        pass

    def test_update_password(self) -> None:
        """Test case for update_password

        Update password by using the password reset token  # noqa: E501
        """
        pass

    def test_update_user_file_recording(self) -> None:
        """Test case for update_user_file_recording

        Create and edit metadata of your files.  # noqa: E501
        """
        pass

    def test_user_file(self) -> None:
        """Test case for user_file

        Details and a download link for a file.  # noqa: E501
        """
        pass

    def test_user_files(self) -> None:
        """Test case for user_files

        List and search your own files.  # noqa: E501
        """
        pass

    def test_user_files_download(self) -> None:
        """Test case for user_files_download

        Download links for your files  # noqa: E501
        """
        pass

    def test_user_files_status(self) -> None:
        """Test case for user_files_status

        Status details for files.  # noqa: E501
        """
        pass

    def test_user_files_summary(self) -> None:
        """Test case for user_files_summary

        Summary fo your files.  # noqa: E501
        """
        pass

    def test_user_folders(self) -> None:
        """Test case for user_folders

        Your Folders  # noqa: E501
        """
        pass

    def test_user_referrers(self) -> None:
        """Test case for user_referrers

        """
        pass


if __name__ == '__main__':
    unittest.main()
