# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.2
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, validator
from songtradr_api_client_python.models.recording_medium_dto import RecordingMediumDTO

class FileDTO(BaseModel):
    """
    Details on a file that has been uploaded for auto-tagging or audio-recognition purposes.
    """
    id: StrictInt = Field(...)
    name: StrictStr = Field(...)
    object_key: StrictStr = Field(..., alias="objectKey")
    folder: StrictStr = Field(...)
    extension: StrictStr = Field(..., description="extension of the file")
    url: Optional[StrictStr] = None
    upload_start_time: Optional[datetime] = Field(None, alias="uploadStartTime")
    upload_end_time: Optional[datetime] = Field(None, alias="uploadEndTime")
    fingerprint_status: Optional[StrictStr] = Field(None, alias="fingerprintStatus", description="status of the audio recognition")
    fingerprint_start_time: Optional[datetime] = Field(None, alias="fingerprintStartTime")
    fingerprint_end_time: Optional[datetime] = Field(None, alias="fingerprintEndTime")
    inference_status: Optional[StrictStr] = Field(None, alias="inferenceStatus", description="status of the auto-tagging")
    inference_start_time: Optional[datetime] = Field(None, alias="inferenceStartTime")
    inference_end_time: Optional[datetime] = Field(None, alias="inferenceEndTime")
    recording: Optional[RecordingMediumDTO] = None
    error_time: Optional[datetime] = None
    error_message: Optional[StrictStr] = None
    __properties = ["id", "name", "objectKey", "folder", "extension", "url", "uploadStartTime", "uploadEndTime", "fingerprintStatus", "fingerprintStartTime", "fingerprintEndTime", "inferenceStatus", "inferenceStartTime", "inferenceEndTime", "recording", "error_time", "error_message"]

    @validator('extension')
    def extension_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('mp3', 'wav', 'flac'):
            raise ValueError("must be one of enum values ('mp3', 'wav', 'flac')")
        return value

    @validator('fingerprint_status')
    def fingerprint_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('processing', 'error', 'found', 'not_found', 'not_started'):
            raise ValueError("must be one of enum values ('processing', 'error', 'found', 'not_found', 'not_started')")
        return value

    @validator('inference_status')
    def inference_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('processing', 'error', 'done', 'not_started'):
            raise ValueError("must be one of enum values ('processing', 'error', 'done', 'not_started')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FileDTO:
        """Create an instance of FileDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of recording
        if self.recording:
            _dict['recording'] = self.recording.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FileDTO:
        """Create an instance of FileDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FileDTO.parse_obj(obj)

        _obj = FileDTO.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "object_key": obj.get("objectKey"),
            "folder": obj.get("folder"),
            "extension": obj.get("extension"),
            "url": obj.get("url"),
            "upload_start_time": obj.get("uploadStartTime"),
            "upload_end_time": obj.get("uploadEndTime"),
            "fingerprint_status": obj.get("fingerprintStatus"),
            "fingerprint_start_time": obj.get("fingerprintStartTime"),
            "fingerprint_end_time": obj.get("fingerprintEndTime"),
            "inference_status": obj.get("inferenceStatus"),
            "inference_start_time": obj.get("inferenceStartTime"),
            "inference_end_time": obj.get("inferenceEndTime"),
            "recording": RecordingMediumDTO.from_dict(obj.get("recording")) if obj.get("recording") is not None else None,
            "error_time": obj.get("error_time"),
            "error_message": obj.get("error_message")
        })
        return _obj


