# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.4
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, validator
from songtradr_api_client_python.models.recording_playlist_dto import RecordingPlaylistDTO
from songtradr_api_client_python.models.usage_dto import UsageDTO

class PlaylistLargeDTO(BaseModel):
    """
    Details on a playlist  # noqa: E501
    """
    name: StrictStr = Field(...)
    state: Optional[StrictStr] = None
    usages: Optional[conlist(UsageDTO)] = None
    asset_url: Optional[StrictStr] = Field(None, alias="assetURL")
    pretzel_tier: Optional[StrictStr] = Field(None, alias="pretzelTier")
    usage: Optional[StrictStr] = None
    tracks: Optional[conlist(RecordingPlaylistDTO)] = None
    songtradr_playlist_guid: Optional[StrictStr] = Field(None, alias="songtradrPlaylistGuid")
    created: Optional[datetime] = None
    updated: Optional[datetime] = None
    description: Optional[StrictStr] = None
    __properties = ["name", "state", "usages", "assetURL", "pretzelTier", "usage", "tracks", "songtradrPlaylistGuid", "created", "updated", "description"]

    @validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('active', 'draft'):
            raise ValueError("must be one of enum values ('active', 'draft')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PlaylistLargeDTO:
        """Create an instance of PlaylistLargeDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in usages (list)
        _items = []
        if self.usages:
            for _item in self.usages:
                if _item:
                    _items.append(_item.to_dict())
            _dict['usages'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tracks (list)
        _items = []
        if self.tracks:
            for _item in self.tracks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tracks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PlaylistLargeDTO:
        """Create an instance of PlaylistLargeDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PlaylistLargeDTO.parse_obj(obj)

        _obj = PlaylistLargeDTO.parse_obj({
            "name": obj.get("name"),
            "state": obj.get("state"),
            "usages": [UsageDTO.from_dict(_item) for _item in obj.get("usages")] if obj.get("usages") is not None else None,
            "asset_url": obj.get("assetURL"),
            "pretzel_tier": obj.get("pretzelTier"),
            "usage": obj.get("usage"),
            "tracks": [RecordingPlaylistDTO.from_dict(_item) for _item in obj.get("tracks")] if obj.get("tracks") is not None else None,
            "songtradr_playlist_guid": obj.get("songtradrPlaylistGuid"),
            "created": obj.get("created"),
            "updated": obj.get("updated"),
            "description": obj.get("description")
        })
        return _obj


