# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.5
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt, StrictStr, field_validator
from pydantic import Field
from typing import Dict, Any
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class MusicalFeaturesDTO(BaseModel):
    """
    AI generated musical features of a recording.  # noqa: E501
    """
    space: Optional[StrictStr] = Field(default=None, description="Search for space")
    language_of_performance: Optional[StrictStr] = Field(default=None, alias="languageOfPerformance")
    arousal: Optional[StrictStr] = Field(default=None, description="Search for an arousal")
    dominant_instrument: Optional[StrictStr] = Field(default=None, description="Search for a dominant instrument", alias="dominantInstrument")
    energy: Optional[StrictStr] = Field(default=None, description="Search for energy")
    engagement: Optional[StrictStr] = Field(default=None, description="Search for an engagement")
    groovyness: Optional[StrictStr] = Field(default=None, description="Search for groovyness")
    harmony: Optional[StrictStr] = Field(default=None, description="Search for a degree of harmoniousness")
    pleasantness: Optional[StrictStr] = Field(default=None, description="Search for pleasantness")
    primary_mood_cluster: Optional[StrictStr] = Field(default=None, description="Search for a language of the lyrics", alias="primaryMoodCluster")
    primary_sound_character: Optional[StrictStr] = Field(default=None, description="Search for a sound character", alias="primarySoundCharacter")
    rhythm: Optional[StrictStr] = Field(default=None, description="Search for rhythm")
    roughness: Optional[StrictStr] = Field(default=None, description="Search for roughness")
    scale: Optional[StrictStr] = Field(default=None, description="Search for a tonal scale")
    sound_generation: Optional[StrictStr] = Field(default=None, description="Search for type of sound generation", alias="soundGeneration")
    tempo: Optional[StrictStr] = Field(default=None, description="Search for tempo")
    texture: Optional[StrictStr] = Field(default=None, description="Search for texture")
    timbre: Optional[StrictStr] = Field(default=None, description="Search for timbre")
    tonality: Optional[StrictStr] = Field(default=None, description="Search for tonality")
    valence: Optional[StrictStr] = Field(default=None, description="Search for a valence")
    vocals: Optional[StrictStr] = Field(default=None, description="Search for a vocal gender or instrumental songs")
    origin_decade: Optional[StrictStr] = Field(default=None, description="Search for origin decade", alias="originDecade")
    curateability: Optional[StrictStr] = Field(default=None, description="Search for curatebility")
    use_case: Optional[StrictStr] = Field(default=None, description="Search for use case", alias="useCase")
    channel_suitability: Optional[StrictStr] = Field(default=None, description="Search for social media suitability", alias="channelSuitability")
    primary_mood_cluster_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="primaryMoodClusterAffinity")
    secondary_mood_cluster: Optional[StrictStr] = Field(default=None, description="Search for a language of the lyrics", alias="secondaryMoodCluster")
    secondary_mood_cluster_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="secondaryMoodClusterAffinity")
    tertiary_mood_cluster: Optional[StrictStr] = Field(default=None, description="Search for a language of the lyrics", alias="tertiaryMoodCluster")
    tertiary_mood_cluster_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="tertiaryMoodClusterAffinity")
    vocals_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="vocalsAffinity")
    dominant_instrument_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="dominantInstrumentAffinity")
    secondary_instrument: Optional[StrictStr] = Field(default=None, description="Search for a dominant instrument", alias="secondaryInstrument")
    secondary_instrument_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="secondaryInstrumentAffinity")
    tertiary_instrument: Optional[StrictStr] = Field(default=None, description="Search for a dominant instrument", alias="tertiaryInstrument")
    tertiary_instrument_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="tertiaryInstrumentAffinity")
    sound_generation_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="soundGenerationAffinity")
    rhythm_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="rhythmAffinity")
    primary_sound_character_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="primarySoundCharacterAffinity")
    tonality_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="tonalityAffinity")
    bpm: Optional[Union[StrictFloat, StrictInt]] = None
    production_rating: Optional[StrictStr] = Field(default=None, alias="productionRating")
    production_rating_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="productionRatingAffinity")
    performance_rating: Optional[StrictStr] = Field(default=None, alias="performanceRating")
    performance_rating_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="performanceRatingAffinity")
    song_rating: Optional[StrictStr] = Field(default=None, alias="songRating")
    song_rating_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="songRatingAffinity")
    audience_age: Optional[StrictStr] = Field(default=None, alias="audienceAge")
    audience_age_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="audienceAgeAffinity")
    secondary_audience_age: Optional[StrictStr] = Field(default=None, alias="secondaryAudienceAge")
    secondary_audience_age_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="secondaryAudienceAgeAffinity")
    tertiary_audience_age: Optional[StrictStr] = Field(default=None, alias="tertiaryAudienceAge")
    tertiary_audience_age_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="tertiaryAudienceAgeAffinity")
    audience_gender: Optional[StrictStr] = Field(default=None, alias="audienceGender")
    audience_gender_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="audienceGenderAffinity")
    audience_region_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="audienceRegionAffinity")
    secondary_audience_region: Optional[StrictStr] = Field(default=None, alias="secondaryAudienceRegion")
    secondary_audience_region_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="secondaryAudienceRegionAffinity")
    tertiary_audience_region: Optional[StrictStr] = Field(default=None, alias="tertiaryAudienceRegion")
    tertiary_audience_region_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="tertiaryAudienceRegionAffinity")
    origin_region: Optional[StrictStr] = Field(default=None, alias="originRegion")
    origin_region_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="originRegionAffinity")
    origin_decade_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="originDecadeAffinity")
    language_of_performance_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="languageOfPerformanceAffinity")
    curateability_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="curateabilityAffinity")
    use_case_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="useCaseAffinity")
    industry_suitability: Optional[StrictStr] = Field(default=None, description="Search for Industry suitability", alias="industrySuitability")
    industry_suitability_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="industrySuitabilityAffinity")
    audience_region: Optional[StrictStr] = Field(default=None, alias="audienceRegion")
    valence_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="valenceAffinity")
    arousal_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="arousalAffinity")
    pleasantness_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="pleasantnessAffinity")
    engagement_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="engagementAffinity")
    energy_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="energyAffinity")
    tempo_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="tempoAffinity")
    scale_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="scaleAffinity")
    timbre_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="timbreAffinity")
    roughness_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="roughnessAffinity")
    harmony_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="harmonyAffinity")
    texture_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="textureAffinity")
    groovyness_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="groovynessAffinity")
    space_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="spaceAffinity")
    key_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="keyAffinity")
    channel_suitability_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="channelSuitabilityAffinity")
    key: Optional[StrictStr] = Field(default=None, description="Search for a harmonic key")
    __properties: ClassVar[List[str]] = ["space", "languageOfPerformance", "arousal", "dominantInstrument", "energy", "engagement", "groovyness", "harmony", "pleasantness", "primaryMoodCluster", "primarySoundCharacter", "rhythm", "roughness", "scale", "soundGeneration", "tempo", "texture", "timbre", "tonality", "valence", "vocals", "originDecade", "curateability", "useCase", "channelSuitability", "primaryMoodClusterAffinity", "secondaryMoodCluster", "secondaryMoodClusterAffinity", "tertiaryMoodCluster", "tertiaryMoodClusterAffinity", "vocalsAffinity", "dominantInstrumentAffinity", "secondaryInstrument", "secondaryInstrumentAffinity", "tertiaryInstrument", "tertiaryInstrumentAffinity", "soundGenerationAffinity", "rhythmAffinity", "primarySoundCharacterAffinity", "tonalityAffinity", "bpm", "productionRating", "productionRatingAffinity", "performanceRating", "performanceRatingAffinity", "songRating", "songRatingAffinity", "audienceAge", "audienceAgeAffinity", "secondaryAudienceAge", "secondaryAudienceAgeAffinity", "tertiaryAudienceAge", "tertiaryAudienceAgeAffinity", "audienceGender", "audienceGenderAffinity", "audienceRegionAffinity", "secondaryAudienceRegion", "secondaryAudienceRegionAffinity", "tertiaryAudienceRegion", "tertiaryAudienceRegionAffinity", "originRegion", "originRegionAffinity", "originDecadeAffinity", "languageOfPerformanceAffinity", "curateabilityAffinity", "useCaseAffinity", "industrySuitability", "industrySuitabilityAffinity", "audienceRegion", "valenceAffinity", "arousalAffinity", "pleasantnessAffinity", "engagementAffinity", "energyAffinity", "tempoAffinity", "scaleAffinity", "timbreAffinity", "roughnessAffinity", "harmonyAffinity", "textureAffinity", "groovynessAffinity", "spaceAffinity", "keyAffinity", "channelSuitabilityAffinity", "key"]

    @field_validator('space')
    def space_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very compact', 'compact', 'moderate space', 'wide', 'very wide'):
            raise ValueError("must be one of enum values ('very compact', 'compact', 'moderate space', 'wide', 'very wide')")
        return value

    @field_validator('language_of_performance')
    def language_of_performance_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('en', 'de', 'no', 'fr', 'es', 'pt', 'fi', 'ru', 'it', 'la', 'el', 'ar', 'nl', 'ja', 'pl', 'sv', 'zu', 'da', 'cs', 'hu', 'af', 'hi', 'tr', 'zh', 'ms', 'pa', 'id', 'ko', 'vi'):
            raise ValueError("must be one of enum values ('en', 'de', 'no', 'fr', 'es', 'pt', 'fi', 'ru', 'it', 'la', 'el', 'ar', 'nl', 'ja', 'pl', 'sv', 'zu', 'da', 'cs', 'hu', 'af', 'hi', 'tr', 'zh', 'ms', 'pa', 'id', 'ko', 'vi')")
        return value

    @field_validator('arousal')
    def arousal_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very calm', 'calm', 'moderate arousal', 'energetic', 'very energetic', 'varying arousal'):
            raise ValueError("must be one of enum values ('very calm', 'calm', 'moderate arousal', 'energetic', 'very energetic', 'varying arousal')")
        return value

    @field_validator('dominant_instrument')
    def dominant_instrument_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp'):
            raise ValueError("must be one of enum values ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp')")
        return value

    @field_validator('energy')
    def energy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very quiet', 'quiet', 'moderate', 'loud', 'very loud', 'dynamic'):
            raise ValueError("must be one of enum values ('very quiet', 'quiet', 'moderate', 'loud', 'very loud', 'dynamic')")
        return value

    @field_validator('engagement')
    def engagement_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very unengaging', 'unengaging', 'neutral engagement', 'engaging', 'very engaging', 'varying engagement'):
            raise ValueError("must be one of enum values ('very unengaging', 'unengaging', 'neutral engagement', 'engaging', 'very engaging', 'varying engagement')")
        return value

    @field_validator('groovyness')
    def groovyness_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very steady', 'steady', 'moderate rhythm feel', 'groovy', 'very groovy'):
            raise ValueError("must be one of enum values ('very steady', 'steady', 'moderate rhythm feel', 'groovy', 'very groovy')")
        return value

    @field_validator('harmony')
    def harmony_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very dissonant', 'dissonant', 'moderate harmonies', 'harmonious', 'very harmonious'):
            raise ValueError("must be one of enum values ('very dissonant', 'dissonant', 'moderate harmonies', 'harmonious', 'very harmonious')")
        return value

    @field_validator('pleasantness')
    def pleasantness_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very unpleasant', 'unpleasant', 'neutral pleasantness', 'pleasant', 'very pleasant', 'varying pleasantness'):
            raise ValueError("must be one of enum values ('very unpleasant', 'unpleasant', 'neutral pleasantness', 'pleasant', 'very pleasant', 'varying pleasantness')")
        return value

    @field_validator('primary_mood_cluster')
    def primary_mood_cluster_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild'):
            raise ValueError("must be one of enum values ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild')")
        return value

    @field_validator('primary_sound_character')
    def primary_sound_character_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('brassy', 'bright', 'clear', 'deep', 'distorted', 'flat', 'full', 'groovy', 'melodious', 'natural', 'resonant', 'shrill', 'steady', 'thin', 'warm'):
            raise ValueError("must be one of enum values ('brassy', 'bright', 'clear', 'deep', 'distorted', 'flat', 'full', 'groovy', 'melodious', 'natural', 'resonant', 'shrill', 'steady', 'thin', 'warm')")
        return value

    @field_validator('rhythm')
    def rhythm_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('common time', 'triple meter', 'complex time signature', 'binary rhythm', 'ternary rhythm'):
            raise ValueError("must be one of enum values ('common time', 'triple meter', 'complex time signature', 'binary rhythm', 'ternary rhythm')")
        return value

    @field_validator('roughness')
    def roughness_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very clear', 'clear', 'moderate roughness', 'distorted', 'very distorted'):
            raise ValueError("must be one of enum values ('very clear', 'clear', 'moderate roughness', 'distorted', 'very distorted')")
        return value

    @field_validator('scale')
    def scale_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('major key', 'minor key', 'neutral key'):
            raise ValueError("must be one of enum values ('major key', 'minor key', 'neutral key')")
        return value

    @field_validator('sound_generation')
    def sound_generation_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('acoustic', 'electric', 'electronic', 'mixed sound generation'):
            raise ValueError("must be one of enum values ('acoustic', 'electric', 'electronic', 'mixed sound generation')")
        return value

    @field_validator('tempo')
    def tempo_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very slow', 'slow', 'mid-tempo', 'fast', 'very fast', 'varying tempo'):
            raise ValueError("must be one of enum values ('very slow', 'slow', 'mid-tempo', 'fast', 'very fast', 'varying tempo')")
        return value

    @field_validator('texture')
    def texture_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very thin', 'thin', 'moderate texture', 'full', 'very full'):
            raise ValueError("must be one of enum values ('very thin', 'thin', 'moderate texture', 'full', 'very full')")
        return value

    @field_validator('timbre')
    def timbre_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very warm', 'warm', 'moderate timbre', 'bright', 'very bright'):
            raise ValueError("must be one of enum values ('very warm', 'warm', 'moderate timbre', 'bright', 'very bright')")
        return value

    @field_validator('tonality')
    def tonality_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('monotonous', 'moderate melodiousness', 'melodious', 'atonal'):
            raise ValueError("must be one of enum values ('monotonous', 'moderate melodiousness', 'melodious', 'atonal')")
        return value

    @field_validator('valence')
    def valence_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very sad', 'sad', 'moderate valence', 'positive', 'very positive', 'varying valence'):
            raise ValueError("must be one of enum values ('very sad', 'sad', 'moderate valence', 'positive', 'very positive', 'varying valence')")
        return value

    @field_validator('vocals')
    def vocals_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('instrumental', 'female vocals', 'male vocals', 'mixed vocals', 'diverse gender vocals'):
            raise ValueError("must be one of enum values ('instrumental', 'female vocals', 'male vocals', 'mixed vocals', 'diverse gender vocals')")
        return value

    @field_validator('origin_decade')
    def origin_decade_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('pre-1950s', '1950s', '1960s', '1970s', '1980s', '1990s', '2000s', '2010s', '2020s'):
            raise ValueError("must be one of enum values ('pre-1950s', '1950s', '1960s', '1970s', '1980s', '1990s', '2000s', '2010s', '2020s')")
        return value

    @field_validator('curateability')
    def curateability_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('curateable', 'uncurateable'):
            raise ValueError("must be one of enum values ('curateable', 'uncurateable')")
        return value

    @field_validator('use_case')
    def use_case_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('background', 'sport', 'focus', 'christmas', 'film', 'summer', 'adverts', 'party', 'relax'):
            raise ValueError("must be one of enum values ('background', 'sport', 'focus', 'christmas', 'film', 'summer', 'adverts', 'party', 'relax')")
        return value

    @field_validator('channel_suitability')
    def channel_suitability_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Spotify', 'TikTok', 'Unfitting', 'YouTube'):
            raise ValueError("must be one of enum values ('Spotify', 'TikTok', 'Unfitting', 'YouTube')")
        return value

    @field_validator('secondary_mood_cluster')
    def secondary_mood_cluster_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild'):
            raise ValueError("must be one of enum values ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild')")
        return value

    @field_validator('tertiary_mood_cluster')
    def tertiary_mood_cluster_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild'):
            raise ValueError("must be one of enum values ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild')")
        return value

    @field_validator('secondary_instrument')
    def secondary_instrument_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp'):
            raise ValueError("must be one of enum values ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp')")
        return value

    @field_validator('tertiary_instrument')
    def tertiary_instrument_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp'):
            raise ValueError("must be one of enum values ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp')")
        return value

    @field_validator('production_rating')
    def production_rating_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('low production quality', 'medium production quality', 'high production quality'):
            raise ValueError("must be one of enum values ('low production quality', 'medium production quality', 'high production quality')")
        return value

    @field_validator('performance_rating')
    def performance_rating_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('low performance quality', 'medium performance quality', 'high performance quality'):
            raise ValueError("must be one of enum values ('low performance quality', 'medium performance quality', 'high performance quality')")
        return value

    @field_validator('song_rating')
    def song_rating_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('low song quality', 'medium song quality', 'high song quality'):
            raise ValueError("must be one of enum values ('low song quality', 'medium song quality', 'high song quality')")
        return value

    @field_validator('audience_age')
    def audience_age_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B'):
            raise ValueError("must be one of enum values ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B')")
        return value

    @field_validator('secondary_audience_age')
    def secondary_audience_age_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B'):
            raise ValueError("must be one of enum values ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B')")
        return value

    @field_validator('tertiary_audience_age')
    def tertiary_audience_age_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B'):
            raise ValueError("must be one of enum values ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B')")
        return value

    @field_validator('audience_gender')
    def audience_gender_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('male', 'female'):
            raise ValueError("must be one of enum values ('male', 'female')")
        return value

    @field_validator('secondary_audience_region')
    def secondary_audience_region_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe'):
            raise ValueError("must be one of enum values ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe')")
        return value

    @field_validator('tertiary_audience_region')
    def tertiary_audience_region_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe'):
            raise ValueError("must be one of enum values ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe')")
        return value

    @field_validator('origin_region')
    def origin_region_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe'):
            raise ValueError("must be one of enum values ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe')")
        return value

    @field_validator('industry_suitability')
    def industry_suitability_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Automobiles and Parts', 'Consumer Products and Services', 'Financial Services', 'Food, Beverage and Tobacco', 'Health Care', 'Insurance', 'Media', 'Politics, Government and Organizations', 'Real Estate', 'Retail', 'Technology', 'Telecommunications', 'Travel and Leisure'):
            raise ValueError("must be one of enum values ('Automobiles and Parts', 'Consumer Products and Services', 'Financial Services', 'Food, Beverage and Tobacco', 'Health Care', 'Insurance', 'Media', 'Politics, Government and Organizations', 'Real Estate', 'Retail', 'Technology', 'Telecommunications', 'Travel and Leisure')")
        return value

    @field_validator('audience_region')
    def audience_region_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe'):
            raise ValueError("must be one of enum values ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe')")
        return value

    @field_validator('key')
    def key_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('C', 'C#', 'D', 'D#', 'E', 'F', 'F#', 'G', 'G#', 'A', 'A#', 'B', 'unclear'):
            raise ValueError("must be one of enum values ('C', 'C#', 'D', 'D#', 'E', 'F', 'F#', 'G', 'G#', 'A', 'A#', 'B', 'unclear')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of MusicalFeaturesDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Self:
        """Create an instance of MusicalFeaturesDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "space": obj.get("space"),
            "languageOfPerformance": obj.get("languageOfPerformance"),
            "arousal": obj.get("arousal"),
            "dominantInstrument": obj.get("dominantInstrument"),
            "energy": obj.get("energy"),
            "engagement": obj.get("engagement"),
            "groovyness": obj.get("groovyness"),
            "harmony": obj.get("harmony"),
            "pleasantness": obj.get("pleasantness"),
            "primaryMoodCluster": obj.get("primaryMoodCluster"),
            "primarySoundCharacter": obj.get("primarySoundCharacter"),
            "rhythm": obj.get("rhythm"),
            "roughness": obj.get("roughness"),
            "scale": obj.get("scale"),
            "soundGeneration": obj.get("soundGeneration"),
            "tempo": obj.get("tempo"),
            "texture": obj.get("texture"),
            "timbre": obj.get("timbre"),
            "tonality": obj.get("tonality"),
            "valence": obj.get("valence"),
            "vocals": obj.get("vocals"),
            "originDecade": obj.get("originDecade"),
            "curateability": obj.get("curateability"),
            "useCase": obj.get("useCase"),
            "channelSuitability": obj.get("channelSuitability"),
            "primaryMoodClusterAffinity": obj.get("primaryMoodClusterAffinity"),
            "secondaryMoodCluster": obj.get("secondaryMoodCluster"),
            "secondaryMoodClusterAffinity": obj.get("secondaryMoodClusterAffinity"),
            "tertiaryMoodCluster": obj.get("tertiaryMoodCluster"),
            "tertiaryMoodClusterAffinity": obj.get("tertiaryMoodClusterAffinity"),
            "vocalsAffinity": obj.get("vocalsAffinity"),
            "dominantInstrumentAffinity": obj.get("dominantInstrumentAffinity"),
            "secondaryInstrument": obj.get("secondaryInstrument"),
            "secondaryInstrumentAffinity": obj.get("secondaryInstrumentAffinity"),
            "tertiaryInstrument": obj.get("tertiaryInstrument"),
            "tertiaryInstrumentAffinity": obj.get("tertiaryInstrumentAffinity"),
            "soundGenerationAffinity": obj.get("soundGenerationAffinity"),
            "rhythmAffinity": obj.get("rhythmAffinity"),
            "primarySoundCharacterAffinity": obj.get("primarySoundCharacterAffinity"),
            "tonalityAffinity": obj.get("tonalityAffinity"),
            "bpm": obj.get("bpm"),
            "productionRating": obj.get("productionRating"),
            "productionRatingAffinity": obj.get("productionRatingAffinity"),
            "performanceRating": obj.get("performanceRating"),
            "performanceRatingAffinity": obj.get("performanceRatingAffinity"),
            "songRating": obj.get("songRating"),
            "songRatingAffinity": obj.get("songRatingAffinity"),
            "audienceAge": obj.get("audienceAge"),
            "audienceAgeAffinity": obj.get("audienceAgeAffinity"),
            "secondaryAudienceAge": obj.get("secondaryAudienceAge"),
            "secondaryAudienceAgeAffinity": obj.get("secondaryAudienceAgeAffinity"),
            "tertiaryAudienceAge": obj.get("tertiaryAudienceAge"),
            "tertiaryAudienceAgeAffinity": obj.get("tertiaryAudienceAgeAffinity"),
            "audienceGender": obj.get("audienceGender"),
            "audienceGenderAffinity": obj.get("audienceGenderAffinity"),
            "audienceRegionAffinity": obj.get("audienceRegionAffinity"),
            "secondaryAudienceRegion": obj.get("secondaryAudienceRegion"),
            "secondaryAudienceRegionAffinity": obj.get("secondaryAudienceRegionAffinity"),
            "tertiaryAudienceRegion": obj.get("tertiaryAudienceRegion"),
            "tertiaryAudienceRegionAffinity": obj.get("tertiaryAudienceRegionAffinity"),
            "originRegion": obj.get("originRegion"),
            "originRegionAffinity": obj.get("originRegionAffinity"),
            "originDecadeAffinity": obj.get("originDecadeAffinity"),
            "languageOfPerformanceAffinity": obj.get("languageOfPerformanceAffinity"),
            "curateabilityAffinity": obj.get("curateabilityAffinity"),
            "useCaseAffinity": obj.get("useCaseAffinity"),
            "industrySuitability": obj.get("industrySuitability"),
            "industrySuitabilityAffinity": obj.get("industrySuitabilityAffinity"),
            "audienceRegion": obj.get("audienceRegion"),
            "valenceAffinity": obj.get("valenceAffinity"),
            "arousalAffinity": obj.get("arousalAffinity"),
            "pleasantnessAffinity": obj.get("pleasantnessAffinity"),
            "engagementAffinity": obj.get("engagementAffinity"),
            "energyAffinity": obj.get("energyAffinity"),
            "tempoAffinity": obj.get("tempoAffinity"),
            "scaleAffinity": obj.get("scaleAffinity"),
            "timbreAffinity": obj.get("timbreAffinity"),
            "roughnessAffinity": obj.get("roughnessAffinity"),
            "harmonyAffinity": obj.get("harmonyAffinity"),
            "textureAffinity": obj.get("textureAffinity"),
            "groovynessAffinity": obj.get("groovynessAffinity"),
            "spaceAffinity": obj.get("spaceAffinity"),
            "keyAffinity": obj.get("keyAffinity"),
            "channelSuitabilityAffinity": obj.get("channelSuitabilityAffinity"),
            "key": obj.get("key")
        })
        return _obj


