# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.6
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt
from pydantic import Field
from songtradr_api_client_python.models.age_range import AgeRange
from songtradr_api_client_python.models.beard import Beard
from songtradr_api_client_python.models.bounding_box import BoundingBox
from songtradr_api_client_python.models.emotion import Emotion
from songtradr_api_client_python.models.eye_direction import EyeDirection
from songtradr_api_client_python.models.eye_open import EyeOpen
from songtradr_api_client_python.models.eyeglasses import Eyeglasses
from songtradr_api_client_python.models.face_occluded import FaceOccluded
from songtradr_api_client_python.models.gender import Gender
from songtradr_api_client_python.models.image_quality import ImageQuality
from songtradr_api_client_python.models.landmark import Landmark
from songtradr_api_client_python.models.mouth_open import MouthOpen
from songtradr_api_client_python.models.mustache import Mustache
from songtradr_api_client_python.models.pose import Pose
from songtradr_api_client_python.models.smile import Smile
from songtradr_api_client_python.models.sunglasses import Sunglasses
from typing import Dict, Any
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class FaceDetail(BaseModel):
    """
    FaceDetail
    """
    bounding_box: Optional[BoundingBox] = Field(default=None, alias="boundingBox")
    age_range: Optional[AgeRange] = Field(default=None, alias="ageRange")
    smile: Optional[Smile] = None
    eyeglasses: Optional[Eyeglasses] = None
    sunglasses: Optional[Sunglasses] = None
    gender: Optional[Gender] = None
    beard: Optional[Beard] = None
    mustache: Optional[Mustache] = None
    eyes_open: Optional[EyeOpen] = Field(default=None, alias="eyesOpen")
    mouth_open: Optional[MouthOpen] = Field(default=None, alias="mouthOpen")
    emotions: Optional[List[Emotion]] = None
    landmarks: Optional[List[Landmark]] = None
    pose: Optional[Pose] = None
    quality: Optional[ImageQuality] = None
    confidence: Optional[Union[StrictFloat, StrictInt]] = None
    face_occluded: Optional[FaceOccluded] = Field(default=None, alias="faceOccluded")
    eye_direction: Optional[EyeDirection] = Field(default=None, alias="eyeDirection")
    __properties: ClassVar[List[str]] = ["boundingBox", "ageRange", "smile", "eyeglasses", "sunglasses", "gender", "beard", "mustache", "eyesOpen", "mouthOpen", "emotions", "landmarks", "pose", "quality", "confidence", "faceOccluded", "eyeDirection"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of FaceDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of bounding_box
        if self.bounding_box:
            _dict['boundingBox'] = self.bounding_box.to_dict()
        # override the default output from pydantic by calling `to_dict()` of age_range
        if self.age_range:
            _dict['ageRange'] = self.age_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of smile
        if self.smile:
            _dict['smile'] = self.smile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of eyeglasses
        if self.eyeglasses:
            _dict['eyeglasses'] = self.eyeglasses.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sunglasses
        if self.sunglasses:
            _dict['sunglasses'] = self.sunglasses.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gender
        if self.gender:
            _dict['gender'] = self.gender.to_dict()
        # override the default output from pydantic by calling `to_dict()` of beard
        if self.beard:
            _dict['beard'] = self.beard.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mustache
        if self.mustache:
            _dict['mustache'] = self.mustache.to_dict()
        # override the default output from pydantic by calling `to_dict()` of eyes_open
        if self.eyes_open:
            _dict['eyesOpen'] = self.eyes_open.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mouth_open
        if self.mouth_open:
            _dict['mouthOpen'] = self.mouth_open.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in emotions (list)
        _items = []
        if self.emotions:
            for _item in self.emotions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['emotions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in landmarks (list)
        _items = []
        if self.landmarks:
            for _item in self.landmarks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['landmarks'] = _items
        # override the default output from pydantic by calling `to_dict()` of pose
        if self.pose:
            _dict['pose'] = self.pose.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quality
        if self.quality:
            _dict['quality'] = self.quality.to_dict()
        # override the default output from pydantic by calling `to_dict()` of face_occluded
        if self.face_occluded:
            _dict['faceOccluded'] = self.face_occluded.to_dict()
        # override the default output from pydantic by calling `to_dict()` of eye_direction
        if self.eye_direction:
            _dict['eyeDirection'] = self.eye_direction.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Self:
        """Create an instance of FaceDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "boundingBox": BoundingBox.from_dict(obj.get("boundingBox")) if obj.get("boundingBox") is not None else None,
            "ageRange": AgeRange.from_dict(obj.get("ageRange")) if obj.get("ageRange") is not None else None,
            "smile": Smile.from_dict(obj.get("smile")) if obj.get("smile") is not None else None,
            "eyeglasses": Eyeglasses.from_dict(obj.get("eyeglasses")) if obj.get("eyeglasses") is not None else None,
            "sunglasses": Sunglasses.from_dict(obj.get("sunglasses")) if obj.get("sunglasses") is not None else None,
            "gender": Gender.from_dict(obj.get("gender")) if obj.get("gender") is not None else None,
            "beard": Beard.from_dict(obj.get("beard")) if obj.get("beard") is not None else None,
            "mustache": Mustache.from_dict(obj.get("mustache")) if obj.get("mustache") is not None else None,
            "eyesOpen": EyeOpen.from_dict(obj.get("eyesOpen")) if obj.get("eyesOpen") is not None else None,
            "mouthOpen": MouthOpen.from_dict(obj.get("mouthOpen")) if obj.get("mouthOpen") is not None else None,
            "emotions": [Emotion.from_dict(_item) for _item in obj.get("emotions")] if obj.get("emotions") is not None else None,
            "landmarks": [Landmark.from_dict(_item) for _item in obj.get("landmarks")] if obj.get("landmarks") is not None else None,
            "pose": Pose.from_dict(obj.get("pose")) if obj.get("pose") is not None else None,
            "quality": ImageQuality.from_dict(obj.get("quality")) if obj.get("quality") is not None else None,
            "confidence": obj.get("confidence"),
            "faceOccluded": FaceOccluded.from_dict(obj.get("faceOccluded")) if obj.get("faceOccluded") is not None else None,
            "eyeDirection": EyeDirection.from_dict(obj.get("eyeDirection")) if obj.get("eyeDirection") is not None else None
        })
        return _obj


