# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.6
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, StrictStr
from pydantic import Field
from songtradr_api_client_python.models.genre_minimal_dto import GenreMinimalDTO
from songtradr_api_client_python.models.p_line_dto import PLineDTO
from songtradr_api_client_python.models.product_party_dto import ProductPartyDTO
from songtradr_api_client_python.models.title_dto import TitleDTO
from typing import Dict, Any
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class ProductMediumDTO(BaseModel):
    """
    Product details with a mid-sized field-set.  # noqa: E501
    """
    duration: Optional[datetime] = None
    genres: Optional[List[GenreMinimalDTO]] = None
    titles: Optional[List[TitleDTO]] = None
    grid: Optional[StrictStr] = None
    release_date: Optional[datetime] = Field(default=None, alias="releaseDate")
    takedown_date: Optional[datetime] = Field(default=None, alias="takedownDate")
    parties: Optional[List[ProductPartyDTO]] = None
    gtin: Optional[StrictStr] = None
    pline: Optional[PLineDTO] = None
    __properties: ClassVar[List[str]] = ["duration", "genres", "titles", "grid", "releaseDate", "takedownDate", "parties", "gtin", "pline"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ProductMediumDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in genres (list)
        _items = []
        if self.genres:
            for _item in self.genres:
                if _item:
                    _items.append(_item.to_dict())
            _dict['genres'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in titles (list)
        _items = []
        if self.titles:
            for _item in self.titles:
                if _item:
                    _items.append(_item.to_dict())
            _dict['titles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in parties (list)
        _items = []
        if self.parties:
            for _item in self.parties:
                if _item:
                    _items.append(_item.to_dict())
            _dict['parties'] = _items
        # override the default output from pydantic by calling `to_dict()` of pline
        if self.pline:
            _dict['pline'] = self.pline.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Self:
        """Create an instance of ProductMediumDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "duration": obj.get("duration"),
            "genres": [GenreMinimalDTO.from_dict(_item) for _item in obj.get("genres")] if obj.get("genres") is not None else None,
            "titles": [TitleDTO.from_dict(_item) for _item in obj.get("titles")] if obj.get("titles") is not None else None,
            "grid": obj.get("grid"),
            "releaseDate": obj.get("releaseDate"),
            "takedownDate": obj.get("takedownDate"),
            "parties": [ProductPartyDTO.from_dict(_item) for _item in obj.get("parties")] if obj.get("parties") is not None else None,
            "gtin": obj.get("gtin"),
            "pline": PLineDTO.from_dict(obj.get("pline")) if obj.get("pline") is not None else None
        })
        return _obj


