# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.7
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt, StrictStr, field_validator
from pydantic import Field
from songtradr_api_client_python.models.context_value import ContextValue
from songtradr_api_client_python.models.save_recording_genre_dto import SaveRecordingGenreDTO
from songtradr_api_client_python.models.save_recording_party_dto import SaveRecordingPartyDTO
from songtradr_api_client_python.models.save_recording_tag_dto import SaveRecordingTagDTO
from songtradr_api_client_python.models.save_taggrams_dto import SaveTaggramsDTO
from typing import Dict, Any
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class SaveFileRecordingDTO(BaseModel):
    """
    Data crafted by AI or users.  # noqa: E501
    """
    isrc: StrictStr
    name: Optional[StrictStr] = None
    folder: Optional[StrictStr] = None
    primary_mood_cluster_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="primaryMoodClusterAffinity")
    primary_mood_cluster: Optional[StrictStr] = Field(default=None, description="Search for a language of the lyrics", alias="primaryMoodCluster")
    secondary_mood_cluster_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="secondaryMoodClusterAffinity")
    secondary_mood_cluster: Optional[StrictStr] = Field(default=None, description="Search for a language of the lyrics", alias="secondaryMoodCluster")
    tertiary_mood_cluster_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="tertiaryMoodClusterAffinity")
    tertiary_mood_cluster: Optional[StrictStr] = Field(default=None, description="Search for a language of the lyrics", alias="tertiaryMoodCluster")
    valence_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="valenceAffinity")
    arousal_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="arousalAffinity")
    pleasantness_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="pleasantnessAffinity")
    engagement_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="engagementAffinity")
    valence: Optional[StrictStr] = Field(default=None, description="Search for a valence")
    arousal: Optional[StrictStr] = Field(default=None, description="Search for an arousal")
    pleasantness: Optional[StrictStr] = Field(default=None, description="Search for pleasantness")
    engagement: Optional[StrictStr] = Field(default=None, description="Search for an engagement")
    vocals: Optional[StrictStr] = Field(default=None, description="Search for a vocal gender or instrumental songs")
    vocals_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="vocalsAffinity")
    dominant_instrument: Optional[StrictStr] = Field(default=None, description="Search for a dominant instrument", alias="dominantInstrument")
    dominant_instrument_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="dominantInstrumentAffinity")
    secondary_instrument_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="secondaryInstrumentAffinity")
    secondary_instrument: Optional[StrictStr] = Field(default=None, description="Search for a dominant instrument", alias="secondaryInstrument")
    tertiary_instrument_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="tertiaryInstrumentAffinity")
    tertiary_instrument: Optional[StrictStr] = Field(default=None, description="Search for a dominant instrument", alias="tertiaryInstrument")
    energy: Optional[StrictStr] = Field(default=None, description="Search for energy")
    energy_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="energyAffinity")
    sound_generation: Optional[StrictStr] = Field(default=None, description="Search for type of sound generation", alias="soundGeneration")
    sound_generation_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="soundGenerationAffinity")
    tempo: Optional[StrictStr] = Field(default=None, description="Search for tempo")
    tempo_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="tempoAffinity")
    scale: Optional[StrictStr] = Field(default=None, description="Search for a tonal scale")
    scale_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="scaleAffinity")
    rhythm: Optional[StrictStr] = Field(default=None, description="Search for rhythm")
    rhythm_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="rhythmAffinity")
    primary_sound_character: Optional[StrictStr] = Field(default=None, description="Search for a sound character", alias="primarySoundCharacter")
    primary_sound_character_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="primarySoundCharacterAffinity")
    timbre_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="timbreAffinity")
    roughness_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="roughnessAffinity")
    tonality_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="tonalityAffinity")
    harmony_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="harmonyAffinity")
    texture_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="textureAffinity")
    groovyness_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="groovynessAffinity")
    space_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="spaceAffinity")
    timbre: Optional[StrictStr] = Field(default=None, description="Search for timbre")
    roughness: Optional[StrictStr] = Field(default=None, description="Search for roughness")
    tonality: Optional[StrictStr] = Field(default=None, description="Search for tonality")
    harmony: Optional[StrictStr] = Field(default=None, description="Search for a degree of harmoniousness")
    texture: Optional[StrictStr] = Field(default=None, description="Search for texture")
    groovyness: Optional[StrictStr] = Field(default=None, description="Search for groovyness")
    space: Optional[StrictStr] = Field(default=None, description="Search for space")
    bpm: Optional[Union[StrictFloat, StrictInt]] = None
    key: Optional[StrictStr] = Field(default=None, description="Search for a harmonic key")
    key_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="keyAffinity")
    production_rating: Optional[StrictStr] = Field(default=None, alias="productionRating")
    production_rating_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="productionRatingAffinity")
    performance_rating: Optional[StrictStr] = Field(default=None, alias="performanceRating")
    performance_rating_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="performanceRatingAffinity")
    song_rating: Optional[StrictStr] = Field(default=None, alias="songRating")
    song_rating_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="songRatingAffinity")
    audience_gender: Optional[StrictStr] = Field(default=None, alias="audienceGender")
    audience_gender_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="audienceGenderAffinity")
    audience_region: Optional[StrictStr] = Field(default=None, alias="audienceRegion")
    audience_region_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="audienceRegionAffinity")
    secondary_audience_region_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="secondaryAudienceRegionAffinity")
    secondary_audience_region: Optional[StrictStr] = Field(default=None, alias="secondaryAudienceRegion")
    tertiary_audience_region_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="tertiaryAudienceRegionAffinity")
    tertiary_audience_region: Optional[StrictStr] = Field(default=None, alias="tertiaryAudienceRegion")
    audience_age: Optional[StrictStr] = Field(default=None, alias="audienceAge")
    audience_age_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="audienceAgeAffinity")
    secondary_audience_age: Optional[StrictStr] = Field(default=None, alias="secondaryAudienceAge")
    secondary_audience_age_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="secondaryAudienceAgeAffinity")
    tertiary_audience_age: Optional[StrictStr] = Field(default=None, alias="tertiaryAudienceAge")
    tertiary_audience_age_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="tertiaryAudienceAgeAffinity")
    origin_decade: Optional[StrictStr] = Field(default=None, description="Search for origin decade", alias="originDecade")
    origin_decade_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="originDecadeAffinity")
    language_of_performance: Optional[StrictStr] = Field(default=None, alias="languageOfPerformance")
    language_of_performance_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="languageOfPerformanceAffinity")
    origin_region: Optional[StrictStr] = Field(default=None, alias="originRegion")
    origin_region_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="originRegionAffinity")
    taggrams: Optional[SaveTaggramsDTO] = None
    embeddings: Optional[List[Union[StrictFloat, StrictInt]]] = None
    level1_genre: Optional[StrictStr] = Field(default=None, alias="level1Genre")
    level1_genre_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="level1GenreAffinity")
    secondary_level1_genre: Optional[StrictStr] = Field(default=None, alias="secondaryLevel1Genre")
    secondary_level1_genre_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="secondaryLevel1GenreAffinity")
    tertiary_level1_genre: Optional[StrictStr] = Field(default=None, alias="tertiaryLevel1Genre")
    tertiary_level1_genre_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="tertiaryLevel1GenreAffinity")
    level2_genre: Optional[StrictStr] = Field(default=None, alias="level2Genre")
    level2_genre_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="level2GenreAffinity")
    secondary_level2_genre: Optional[StrictStr] = Field(default=None, alias="secondaryLevel2Genre")
    secondary_level2_genre_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="secondaryLevel2GenreAffinity")
    tertiary_level2_genre: Optional[StrictStr] = Field(default=None, alias="tertiaryLevel2Genre")
    tertiary_level2_genre_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="tertiaryLevel2GenreAffinity")
    curateability: Optional[StrictStr] = Field(default=None, description="Search for curatebility")
    curateability_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="curateabilityAffinity")
    use_case: Optional[StrictStr] = Field(default=None, description="Search for use case", alias="useCase")
    use_case_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="useCaseAffinity")
    social_media: Optional[StrictStr] = Field(default=None, description="Search for social media suitability", alias="socialMedia")
    social_media_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="socialMediaAffinity")
    industry_suitability: Optional[StrictStr] = Field(default=None, description="Search for Industry suitability", alias="industrySuitability")
    industry_suitability_affinity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="industrySuitabilityAffinity")
    created_by_version: StrictStr = Field(alias="createdByVersion")
    tags: Optional[List[SaveRecordingTagDTO]] = None
    genres: Optional[List[SaveRecordingGenreDTO]] = None
    parties: Optional[List[SaveRecordingPartyDTO]] = None
    iswc: Optional[StrictStr] = None
    proprietary_id_gema: Optional[StrictStr] = Field(default=None, alias="proprietaryIdGema")
    title: Optional[StrictStr] = None
    version_title: Optional[StrictStr] = Field(default=None, alias="versionTitle")
    context_kind: Optional[StrictStr] = Field(default=None, alias="contextKind")
    context_value: Optional[ContextValue] = Field(default=None, alias="contextValue")
    __properties: ClassVar[List[str]] = ["isrc", "name", "folder", "primaryMoodClusterAffinity", "primaryMoodCluster", "secondaryMoodClusterAffinity", "secondaryMoodCluster", "tertiaryMoodClusterAffinity", "tertiaryMoodCluster", "valenceAffinity", "arousalAffinity", "pleasantnessAffinity", "engagementAffinity", "valence", "arousal", "pleasantness", "engagement", "vocals", "vocalsAffinity", "dominantInstrument", "dominantInstrumentAffinity", "secondaryInstrumentAffinity", "secondaryInstrument", "tertiaryInstrumentAffinity", "tertiaryInstrument", "energy", "energyAffinity", "soundGeneration", "soundGenerationAffinity", "tempo", "tempoAffinity", "scale", "scaleAffinity", "rhythm", "rhythmAffinity", "primarySoundCharacter", "primarySoundCharacterAffinity", "timbreAffinity", "roughnessAffinity", "tonalityAffinity", "harmonyAffinity", "textureAffinity", "groovynessAffinity", "spaceAffinity", "timbre", "roughness", "tonality", "harmony", "texture", "groovyness", "space", "bpm", "key", "keyAffinity", "productionRating", "productionRatingAffinity", "performanceRating", "performanceRatingAffinity", "songRating", "songRatingAffinity", "audienceGender", "audienceGenderAffinity", "audienceRegion", "audienceRegionAffinity", "secondaryAudienceRegionAffinity", "secondaryAudienceRegion", "tertiaryAudienceRegionAffinity", "tertiaryAudienceRegion", "audienceAge", "audienceAgeAffinity", "secondaryAudienceAge", "secondaryAudienceAgeAffinity", "tertiaryAudienceAge", "tertiaryAudienceAgeAffinity", "originDecade", "originDecadeAffinity", "languageOfPerformance", "languageOfPerformanceAffinity", "originRegion", "originRegionAffinity", "taggrams", "embeddings", "level1Genre", "level1GenreAffinity", "secondaryLevel1Genre", "secondaryLevel1GenreAffinity", "tertiaryLevel1Genre", "tertiaryLevel1GenreAffinity", "level2Genre", "level2GenreAffinity", "secondaryLevel2Genre", "secondaryLevel2GenreAffinity", "tertiaryLevel2Genre", "tertiaryLevel2GenreAffinity", "curateability", "curateabilityAffinity", "useCase", "useCaseAffinity", "socialMedia", "socialMediaAffinity", "industrySuitability", "industrySuitabilityAffinity", "createdByVersion", "tags", "genres", "parties", "iswc", "proprietaryIdGema", "title", "versionTitle", "contextKind", "contextValue"]

    @field_validator('primary_mood_cluster')
    def primary_mood_cluster_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild'):
            raise ValueError("must be one of enum values ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild')")
        return value

    @field_validator('secondary_mood_cluster')
    def secondary_mood_cluster_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild'):
            raise ValueError("must be one of enum values ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild')")
        return value

    @field_validator('tertiary_mood_cluster')
    def tertiary_mood_cluster_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild'):
            raise ValueError("must be one of enum values ('aggressive', 'amusing', 'anxious', 'calm', 'devotional', 'dreamy', 'energetic', 'enigmatic', 'epic', 'erotic', 'positive', 'sad', 'scary', 'wild')")
        return value

    @field_validator('valence')
    def valence_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very sad', 'sad', 'moderate valence', 'positive', 'very positive', 'varying valence'):
            raise ValueError("must be one of enum values ('very sad', 'sad', 'moderate valence', 'positive', 'very positive', 'varying valence')")
        return value

    @field_validator('arousal')
    def arousal_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very calm', 'calm', 'moderate arousal', 'energetic', 'very energetic', 'varying arousal'):
            raise ValueError("must be one of enum values ('very calm', 'calm', 'moderate arousal', 'energetic', 'very energetic', 'varying arousal')")
        return value

    @field_validator('pleasantness')
    def pleasantness_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very unpleasant', 'unpleasant', 'neutral pleasantness', 'pleasant', 'very pleasant', 'varying pleasantness'):
            raise ValueError("must be one of enum values ('very unpleasant', 'unpleasant', 'neutral pleasantness', 'pleasant', 'very pleasant', 'varying pleasantness')")
        return value

    @field_validator('engagement')
    def engagement_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very unengaging', 'unengaging', 'neutral engagement', 'engaging', 'very engaging', 'varying engagement'):
            raise ValueError("must be one of enum values ('very unengaging', 'unengaging', 'neutral engagement', 'engaging', 'very engaging', 'varying engagement')")
        return value

    @field_validator('vocals')
    def vocals_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('instrumental', 'female vocals', 'male vocals', 'mixed vocals', 'diverse gender vocals'):
            raise ValueError("must be one of enum values ('instrumental', 'female vocals', 'male vocals', 'mixed vocals', 'diverse gender vocals')")
        return value

    @field_validator('dominant_instrument')
    def dominant_instrument_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp'):
            raise ValueError("must be one of enum values ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp')")
        return value

    @field_validator('secondary_instrument')
    def secondary_instrument_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp'):
            raise ValueError("must be one of enum values ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp')")
        return value

    @field_validator('tertiary_instrument')
    def tertiary_instrument_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp'):
            raise ValueError("must be one of enum values ('electric guitar', 'piano', 'electronics', 'guitar', 'strings', 'synthesizer', 'wind', 'saxophone', 'flute', 'trumpet', 'drum kit', 'keys', 'accordion', 'violin', 'harpsichord', 'choir', 'cello', 'electric bass', 'organ', 'brass', 'percussion', 'vocals', 'double bass', 'harp')")
        return value

    @field_validator('energy')
    def energy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very quiet', 'quiet', 'moderate', 'loud', 'very loud', 'dynamic'):
            raise ValueError("must be one of enum values ('very quiet', 'quiet', 'moderate', 'loud', 'very loud', 'dynamic')")
        return value

    @field_validator('sound_generation')
    def sound_generation_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('acoustic', 'electric', 'electronic', 'mixed sound generation'):
            raise ValueError("must be one of enum values ('acoustic', 'electric', 'electronic', 'mixed sound generation')")
        return value

    @field_validator('tempo')
    def tempo_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very slow', 'slow', 'mid-tempo', 'fast', 'very fast', 'varying tempo'):
            raise ValueError("must be one of enum values ('very slow', 'slow', 'mid-tempo', 'fast', 'very fast', 'varying tempo')")
        return value

    @field_validator('scale')
    def scale_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('major key', 'minor key', 'neutral key'):
            raise ValueError("must be one of enum values ('major key', 'minor key', 'neutral key')")
        return value

    @field_validator('rhythm')
    def rhythm_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('common time', 'triple meter', 'complex time signature', 'binary rhythm', 'ternary rhythm'):
            raise ValueError("must be one of enum values ('common time', 'triple meter', 'complex time signature', 'binary rhythm', 'ternary rhythm')")
        return value

    @field_validator('primary_sound_character')
    def primary_sound_character_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('brassy', 'bright', 'clear', 'deep', 'distorted', 'flat', 'full', 'groovy', 'melodious', 'natural', 'resonant', 'shrill', 'steady', 'thin', 'warm'):
            raise ValueError("must be one of enum values ('brassy', 'bright', 'clear', 'deep', 'distorted', 'flat', 'full', 'groovy', 'melodious', 'natural', 'resonant', 'shrill', 'steady', 'thin', 'warm')")
        return value

    @field_validator('timbre')
    def timbre_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very warm', 'warm', 'moderate timbre', 'bright', 'very bright'):
            raise ValueError("must be one of enum values ('very warm', 'warm', 'moderate timbre', 'bright', 'very bright')")
        return value

    @field_validator('roughness')
    def roughness_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very clear', 'clear', 'moderate roughness', 'distorted', 'very distorted'):
            raise ValueError("must be one of enum values ('very clear', 'clear', 'moderate roughness', 'distorted', 'very distorted')")
        return value

    @field_validator('tonality')
    def tonality_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('monotonous', 'moderate melodiousness', 'melodious', 'atonal'):
            raise ValueError("must be one of enum values ('monotonous', 'moderate melodiousness', 'melodious', 'atonal')")
        return value

    @field_validator('harmony')
    def harmony_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very dissonant', 'dissonant', 'moderate harmonies', 'harmonious', 'very harmonious'):
            raise ValueError("must be one of enum values ('very dissonant', 'dissonant', 'moderate harmonies', 'harmonious', 'very harmonious')")
        return value

    @field_validator('texture')
    def texture_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very thin', 'thin', 'moderate texture', 'full', 'very full'):
            raise ValueError("must be one of enum values ('very thin', 'thin', 'moderate texture', 'full', 'very full')")
        return value

    @field_validator('groovyness')
    def groovyness_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very steady', 'steady', 'moderate rhythm feel', 'groovy', 'very groovy'):
            raise ValueError("must be one of enum values ('very steady', 'steady', 'moderate rhythm feel', 'groovy', 'very groovy')")
        return value

    @field_validator('space')
    def space_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('very compact', 'compact', 'moderate space', 'wide', 'very wide'):
            raise ValueError("must be one of enum values ('very compact', 'compact', 'moderate space', 'wide', 'very wide')")
        return value

    @field_validator('key')
    def key_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('C', 'C#', 'D', 'D#', 'E', 'F', 'F#', 'G', 'G#', 'A', 'A#', 'B', 'unclear'):
            raise ValueError("must be one of enum values ('C', 'C#', 'D', 'D#', 'E', 'F', 'F#', 'G', 'G#', 'A', 'A#', 'B', 'unclear')")
        return value

    @field_validator('production_rating')
    def production_rating_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('low production quality', 'medium production quality', 'high production quality'):
            raise ValueError("must be one of enum values ('low production quality', 'medium production quality', 'high production quality')")
        return value

    @field_validator('performance_rating')
    def performance_rating_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('low performance quality', 'medium performance quality', 'high performance quality'):
            raise ValueError("must be one of enum values ('low performance quality', 'medium performance quality', 'high performance quality')")
        return value

    @field_validator('song_rating')
    def song_rating_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('low song quality', 'medium song quality', 'high song quality'):
            raise ValueError("must be one of enum values ('low song quality', 'medium song quality', 'high song quality')")
        return value

    @field_validator('audience_gender')
    def audience_gender_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('male', 'female'):
            raise ValueError("must be one of enum values ('male', 'female')")
        return value

    @field_validator('audience_region')
    def audience_region_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe'):
            raise ValueError("must be one of enum values ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe')")
        return value

    @field_validator('secondary_audience_region')
    def secondary_audience_region_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe'):
            raise ValueError("must be one of enum values ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe')")
        return value

    @field_validator('tertiary_audience_region')
    def tertiary_audience_region_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe'):
            raise ValueError("must be one of enum values ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe')")
        return value

    @field_validator('audience_age')
    def audience_age_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B'):
            raise ValueError("must be one of enum values ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B')")
        return value

    @field_validator('secondary_audience_age')
    def secondary_audience_age_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B'):
            raise ValueError("must be one of enum values ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B')")
        return value

    @field_validator('tertiary_audience_age')
    def tertiary_audience_age_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B'):
            raise ValueError("must be one of enum values ('Generation Z', 'Younger Generation Y', 'Older Generation Y', 'Generation X', 'Younger Generation B', 'Older Generation B')")
        return value

    @field_validator('origin_decade')
    def origin_decade_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('pre-1950s', '1950s', '1960s', '1970s', '1980s', '1990s', '2000s', '2010s', '2020s'):
            raise ValueError("must be one of enum values ('pre-1950s', '1950s', '1960s', '1970s', '1980s', '1990s', '2000s', '2010s', '2020s')")
        return value

    @field_validator('language_of_performance')
    def language_of_performance_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('en', 'de', 'no', 'fr', 'es', 'pt', 'fi', 'ru', 'it', 'la', 'el', 'ar', 'nl', 'ja', 'pl', 'sv', 'zu', 'da', 'cs', 'hu', 'af', 'hi', 'tr', 'zh', 'ms', 'pa', 'id', 'ko', 'vi'):
            raise ValueError("must be one of enum values ('en', 'de', 'no', 'fr', 'es', 'pt', 'fi', 'ru', 'it', 'la', 'el', 'ar', 'nl', 'ja', 'pl', 'sv', 'zu', 'da', 'cs', 'hu', 'af', 'hi', 'tr', 'zh', 'ms', 'pa', 'id', 'ko', 'vi')")
        return value

    @field_validator('origin_region')
    def origin_region_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe'):
            raise ValueError("must be one of enum values ('Australia and New Zealand', 'Central America and the Carribean', 'Central and Southern Asia', 'Eastern Asia', 'Eastern Europe', 'Northern Africa and Western Asia', 'Northern America', 'Oceania', 'South America', 'South-Eastern Asia', 'Southern Europe', 'Sub-Saharan Africa', 'Western and Northern Europe')")
        return value

    @field_validator('level1_genre')
    def level1_genre_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Pop', 'Rock', 'Metal', 'Jazz', 'World', 'Country', 'Functional Music', 'Classical', 'Alternative', 'R&B', 'Blues', 'Hip Hop', 'Reggae', 'Electronic', 'Spoken Word', 'Folk', 'Latin'):
            raise ValueError("must be one of enum values ('Pop', 'Rock', 'Metal', 'Jazz', 'World', 'Country', 'Functional Music', 'Classical', 'Alternative', 'R&B', 'Blues', 'Hip Hop', 'Reggae', 'Electronic', 'Spoken Word', 'Folk', 'Latin')")
        return value

    @field_validator('secondary_level1_genre')
    def secondary_level1_genre_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Pop', 'Rock', 'Metal', 'Jazz', 'World', 'Country', 'Functional Music', 'Classical', 'Alternative', 'R&B', 'Blues', 'Hip Hop', 'Reggae', 'Electronic', 'Spoken Word', 'Folk', 'Latin'):
            raise ValueError("must be one of enum values ('Pop', 'Rock', 'Metal', 'Jazz', 'World', 'Country', 'Functional Music', 'Classical', 'Alternative', 'R&B', 'Blues', 'Hip Hop', 'Reggae', 'Electronic', 'Spoken Word', 'Folk', 'Latin')")
        return value

    @field_validator('tertiary_level1_genre')
    def tertiary_level1_genre_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Pop', 'Rock', 'Metal', 'Jazz', 'World', 'Country', 'Functional Music', 'Classical', 'Alternative', 'R&B', 'Blues', 'Hip Hop', 'Reggae', 'Electronic', 'Spoken Word', 'Folk', 'Latin'):
            raise ValueError("must be one of enum values ('Pop', 'Rock', 'Metal', 'Jazz', 'World', 'Country', 'Functional Music', 'Classical', 'Alternative', 'R&B', 'Blues', 'Hip Hop', 'Reggae', 'Electronic', 'Spoken Word', 'Folk', 'Latin')")
        return value

    @field_validator('level2_genre')
    def level2_genre_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Electro Pop', 'Indie Pop', 'Indie Rock', 'Electroclash', 'Adult Contemporary', 'Easy Listening', 'Comedy Music', 'New Age', 'Chanson', 'Singer/Songwriter', 'Schlager', 'Volksmusik', 'Rock'n'Roll', 'Rockabilly', 'Psychobilly', 'Surf', 'Doo Wop', 'Mainstream Rock', 'Mersey Beat', 'Glamrock', 'Latin Rock', 'Melodic Rock', 'Progressive Rock', 'Psychedelic Rock', 'Hard Rock', 'Krautrock', 'Power Metal', 'Nu Metal', 'Grind Core', 'Gothic Metal', 'Death Metal', 'Melodic Death Metal', 'Thrash Metal', 'Folk Metal', 'Heavy Metal', 'Doom Metal', 'Black Metal', 'Glam Metal', 'Sleaze Metal', 'Metalcore', 'Progressive Metal', 'Screamo', 'Symphonic Metal', 'Swing', 'Ragtime', 'Dixieland', 'Boogie Woogie', 'Bebop', 'Cool Jazz', 'Free Jazz', 'Fusion', 'Smooth Jazz', 'Acid Jazz', 'Bossa Nova', 'Latin Jazz', 'Nu-Jazz', 'Tango', 'Samba', 'Salsa', 'Axé', 'Sertanejo', 'Forró', 'Choro', 'Fado', 'Flamenco', 'Blasmusik', 'American Folk', 'Irish Folk', 'Folk Rock', 'Folk Pop', 'Medieval Folk', 'Americana', 'Bluegrass', 'Red Dirt', 'Outlaw Country', 'Country Pop', 'Country Rock', 'Nashville', 'Honkytonk', 'Production Music', 'Soundtrack', 'Musical', 'Medieval', 'Renaissance', 'Baroque', 'Classical Period', 'Romanticism', 'Neue Musik', 'Minimal Music', 'Neoklassik', 'Contemporary Classical', 'Postmoderne Musik', 'Punk', 'Noise Rock', 'Garage', 'Grunge', 'Industrial', 'New Wave', 'Post Punk', 'Gothic Rock', 'Stoner Rock', 'Pop Punk', 'Post Hardcore', 'Post Rock', 'Post Metal', 'Post-Grunge', 'Britpop', 'Ska Punk', 'Math Rock', 'Dreampop', 'Shoegaze', 'Contemporary R&B', 'Rhythm And Blues', 'Disco', 'Chicago Soul', 'Detroit Soul', 'Urban', 'Nu R&B', 'Old School Soul', 'Neo Soul', 'Early Funk', 'Funk', 'Contemporary Funk', 'Funk Rock', 'Folk Blues', 'Classics Blues', 'Contemporary Blues', 'Blues Rock', 'Trap Music', 'Electro-hop', 'Hardcore Rap', 'Old School Hip Hop', 'British Hip Hop', 'Alternative Hip Hop', 'Pop Rap', 'Miami Bass & Bounce', 'Dirty South Rap', 'Turntablism', 'West Coast Gangsta Rap', 'East Coast Gangsta Rap', 'Roots-Reggae', 'Dub', 'Raggamuffin', 'Ska', 'Dancehall', 'House Music', 'Drum and Bass', 'Techno', 'Chiptune', 'Hard Dance', 'Experimental Electronic', 'Chicago House', 'Ambient House', 'Deep House', 'Tech House', 'Acid House', 'Dutch House', 'Progressive House', 'Funky House', 'Nu Disco', 'Euro Disco', 'Minimal Techno', 'Hardcore Techno', 'IDM', 'Trance', 'Psytrance', 'Progressive Trance', 'Grime', 'Big Beat', 'Dub Step', 'Liquid Funk', 'Hard Step', 'Old School Jungle', 'Trip Hop', 'Gospel', 'Dancepop', 'Indietronica', 'Nu Rave', 'Emo-Rock', 'Soft-Rock', 'Post-Punk Revival', 'Nu Prog', 'Indie Folk', 'Audiobook', 'Audioplay', 'Relaxation', 'Acapella', 'Latin Hip Hop', 'Reggaeton', 'Synthwave', 'Lofi Hip Hop'):
            raise ValueError("must be one of enum values ('Electro Pop', 'Indie Pop', 'Indie Rock', 'Electroclash', 'Adult Contemporary', 'Easy Listening', 'Comedy Music', 'New Age', 'Chanson', 'Singer/Songwriter', 'Schlager', 'Volksmusik', 'Rock'n'Roll', 'Rockabilly', 'Psychobilly', 'Surf', 'Doo Wop', 'Mainstream Rock', 'Mersey Beat', 'Glamrock', 'Latin Rock', 'Melodic Rock', 'Progressive Rock', 'Psychedelic Rock', 'Hard Rock', 'Krautrock', 'Power Metal', 'Nu Metal', 'Grind Core', 'Gothic Metal', 'Death Metal', 'Melodic Death Metal', 'Thrash Metal', 'Folk Metal', 'Heavy Metal', 'Doom Metal', 'Black Metal', 'Glam Metal', 'Sleaze Metal', 'Metalcore', 'Progressive Metal', 'Screamo', 'Symphonic Metal', 'Swing', 'Ragtime', 'Dixieland', 'Boogie Woogie', 'Bebop', 'Cool Jazz', 'Free Jazz', 'Fusion', 'Smooth Jazz', 'Acid Jazz', 'Bossa Nova', 'Latin Jazz', 'Nu-Jazz', 'Tango', 'Samba', 'Salsa', 'Axé', 'Sertanejo', 'Forró', 'Choro', 'Fado', 'Flamenco', 'Blasmusik', 'American Folk', 'Irish Folk', 'Folk Rock', 'Folk Pop', 'Medieval Folk', 'Americana', 'Bluegrass', 'Red Dirt', 'Outlaw Country', 'Country Pop', 'Country Rock', 'Nashville', 'Honkytonk', 'Production Music', 'Soundtrack', 'Musical', 'Medieval', 'Renaissance', 'Baroque', 'Classical Period', 'Romanticism', 'Neue Musik', 'Minimal Music', 'Neoklassik', 'Contemporary Classical', 'Postmoderne Musik', 'Punk', 'Noise Rock', 'Garage', 'Grunge', 'Industrial', 'New Wave', 'Post Punk', 'Gothic Rock', 'Stoner Rock', 'Pop Punk', 'Post Hardcore', 'Post Rock', 'Post Metal', 'Post-Grunge', 'Britpop', 'Ska Punk', 'Math Rock', 'Dreampop', 'Shoegaze', 'Contemporary R&B', 'Rhythm And Blues', 'Disco', 'Chicago Soul', 'Detroit Soul', 'Urban', 'Nu R&B', 'Old School Soul', 'Neo Soul', 'Early Funk', 'Funk', 'Contemporary Funk', 'Funk Rock', 'Folk Blues', 'Classics Blues', 'Contemporary Blues', 'Blues Rock', 'Trap Music', 'Electro-hop', 'Hardcore Rap', 'Old School Hip Hop', 'British Hip Hop', 'Alternative Hip Hop', 'Pop Rap', 'Miami Bass & Bounce', 'Dirty South Rap', 'Turntablism', 'West Coast Gangsta Rap', 'East Coast Gangsta Rap', 'Roots-Reggae', 'Dub', 'Raggamuffin', 'Ska', 'Dancehall', 'House Music', 'Drum and Bass', 'Techno', 'Chiptune', 'Hard Dance', 'Experimental Electronic', 'Chicago House', 'Ambient House', 'Deep House', 'Tech House', 'Acid House', 'Dutch House', 'Progressive House', 'Funky House', 'Nu Disco', 'Euro Disco', 'Minimal Techno', 'Hardcore Techno', 'IDM', 'Trance', 'Psytrance', 'Progressive Trance', 'Grime', 'Big Beat', 'Dub Step', 'Liquid Funk', 'Hard Step', 'Old School Jungle', 'Trip Hop', 'Gospel', 'Dancepop', 'Indietronica', 'Nu Rave', 'Emo-Rock', 'Soft-Rock', 'Post-Punk Revival', 'Nu Prog', 'Indie Folk', 'Audiobook', 'Audioplay', 'Relaxation', 'Acapella', 'Latin Hip Hop', 'Reggaeton', 'Synthwave', 'Lofi Hip Hop')")
        return value

    @field_validator('secondary_level2_genre')
    def secondary_level2_genre_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Electro Pop', 'Indie Pop', 'Indie Rock', 'Electroclash', 'Adult Contemporary', 'Easy Listening', 'Comedy Music', 'New Age', 'Chanson', 'Singer/Songwriter', 'Schlager', 'Volksmusik', 'Rock'n'Roll', 'Rockabilly', 'Psychobilly', 'Surf', 'Doo Wop', 'Mainstream Rock', 'Mersey Beat', 'Glamrock', 'Latin Rock', 'Melodic Rock', 'Progressive Rock', 'Psychedelic Rock', 'Hard Rock', 'Krautrock', 'Power Metal', 'Nu Metal', 'Grind Core', 'Gothic Metal', 'Death Metal', 'Melodic Death Metal', 'Thrash Metal', 'Folk Metal', 'Heavy Metal', 'Doom Metal', 'Black Metal', 'Glam Metal', 'Sleaze Metal', 'Metalcore', 'Progressive Metal', 'Screamo', 'Symphonic Metal', 'Swing', 'Ragtime', 'Dixieland', 'Boogie Woogie', 'Bebop', 'Cool Jazz', 'Free Jazz', 'Fusion', 'Smooth Jazz', 'Acid Jazz', 'Bossa Nova', 'Latin Jazz', 'Nu-Jazz', 'Tango', 'Samba', 'Salsa', 'Axé', 'Sertanejo', 'Forró', 'Choro', 'Fado', 'Flamenco', 'Blasmusik', 'American Folk', 'Irish Folk', 'Folk Rock', 'Folk Pop', 'Medieval Folk', 'Americana', 'Bluegrass', 'Red Dirt', 'Outlaw Country', 'Country Pop', 'Country Rock', 'Nashville', 'Honkytonk', 'Production Music', 'Soundtrack', 'Musical', 'Medieval', 'Renaissance', 'Baroque', 'Classical Period', 'Romanticism', 'Neue Musik', 'Minimal Music', 'Neoklassik', 'Contemporary Classical', 'Postmoderne Musik', 'Punk', 'Noise Rock', 'Garage', 'Grunge', 'Industrial', 'New Wave', 'Post Punk', 'Gothic Rock', 'Stoner Rock', 'Pop Punk', 'Post Hardcore', 'Post Rock', 'Post Metal', 'Post-Grunge', 'Britpop', 'Ska Punk', 'Math Rock', 'Dreampop', 'Shoegaze', 'Contemporary R&B', 'Rhythm And Blues', 'Disco', 'Chicago Soul', 'Detroit Soul', 'Urban', 'Nu R&B', 'Old School Soul', 'Neo Soul', 'Early Funk', 'Funk', 'Contemporary Funk', 'Funk Rock', 'Folk Blues', 'Classics Blues', 'Contemporary Blues', 'Blues Rock', 'Trap Music', 'Electro-hop', 'Hardcore Rap', 'Old School Hip Hop', 'British Hip Hop', 'Alternative Hip Hop', 'Pop Rap', 'Miami Bass & Bounce', 'Dirty South Rap', 'Turntablism', 'West Coast Gangsta Rap', 'East Coast Gangsta Rap', 'Roots-Reggae', 'Dub', 'Raggamuffin', 'Ska', 'Dancehall', 'House Music', 'Drum and Bass', 'Techno', 'Chiptune', 'Hard Dance', 'Experimental Electronic', 'Chicago House', 'Ambient House', 'Deep House', 'Tech House', 'Acid House', 'Dutch House', 'Progressive House', 'Funky House', 'Nu Disco', 'Euro Disco', 'Minimal Techno', 'Hardcore Techno', 'IDM', 'Trance', 'Psytrance', 'Progressive Trance', 'Grime', 'Big Beat', 'Dub Step', 'Liquid Funk', 'Hard Step', 'Old School Jungle', 'Trip Hop', 'Gospel', 'Dancepop', 'Indietronica', 'Nu Rave', 'Emo-Rock', 'Soft-Rock', 'Post-Punk Revival', 'Nu Prog', 'Indie Folk', 'Audiobook', 'Audioplay', 'Relaxation', 'Acapella', 'Latin Hip Hop', 'Reggaeton', 'Synthwave', 'Lofi Hip Hop'):
            raise ValueError("must be one of enum values ('Electro Pop', 'Indie Pop', 'Indie Rock', 'Electroclash', 'Adult Contemporary', 'Easy Listening', 'Comedy Music', 'New Age', 'Chanson', 'Singer/Songwriter', 'Schlager', 'Volksmusik', 'Rock'n'Roll', 'Rockabilly', 'Psychobilly', 'Surf', 'Doo Wop', 'Mainstream Rock', 'Mersey Beat', 'Glamrock', 'Latin Rock', 'Melodic Rock', 'Progressive Rock', 'Psychedelic Rock', 'Hard Rock', 'Krautrock', 'Power Metal', 'Nu Metal', 'Grind Core', 'Gothic Metal', 'Death Metal', 'Melodic Death Metal', 'Thrash Metal', 'Folk Metal', 'Heavy Metal', 'Doom Metal', 'Black Metal', 'Glam Metal', 'Sleaze Metal', 'Metalcore', 'Progressive Metal', 'Screamo', 'Symphonic Metal', 'Swing', 'Ragtime', 'Dixieland', 'Boogie Woogie', 'Bebop', 'Cool Jazz', 'Free Jazz', 'Fusion', 'Smooth Jazz', 'Acid Jazz', 'Bossa Nova', 'Latin Jazz', 'Nu-Jazz', 'Tango', 'Samba', 'Salsa', 'Axé', 'Sertanejo', 'Forró', 'Choro', 'Fado', 'Flamenco', 'Blasmusik', 'American Folk', 'Irish Folk', 'Folk Rock', 'Folk Pop', 'Medieval Folk', 'Americana', 'Bluegrass', 'Red Dirt', 'Outlaw Country', 'Country Pop', 'Country Rock', 'Nashville', 'Honkytonk', 'Production Music', 'Soundtrack', 'Musical', 'Medieval', 'Renaissance', 'Baroque', 'Classical Period', 'Romanticism', 'Neue Musik', 'Minimal Music', 'Neoklassik', 'Contemporary Classical', 'Postmoderne Musik', 'Punk', 'Noise Rock', 'Garage', 'Grunge', 'Industrial', 'New Wave', 'Post Punk', 'Gothic Rock', 'Stoner Rock', 'Pop Punk', 'Post Hardcore', 'Post Rock', 'Post Metal', 'Post-Grunge', 'Britpop', 'Ska Punk', 'Math Rock', 'Dreampop', 'Shoegaze', 'Contemporary R&B', 'Rhythm And Blues', 'Disco', 'Chicago Soul', 'Detroit Soul', 'Urban', 'Nu R&B', 'Old School Soul', 'Neo Soul', 'Early Funk', 'Funk', 'Contemporary Funk', 'Funk Rock', 'Folk Blues', 'Classics Blues', 'Contemporary Blues', 'Blues Rock', 'Trap Music', 'Electro-hop', 'Hardcore Rap', 'Old School Hip Hop', 'British Hip Hop', 'Alternative Hip Hop', 'Pop Rap', 'Miami Bass & Bounce', 'Dirty South Rap', 'Turntablism', 'West Coast Gangsta Rap', 'East Coast Gangsta Rap', 'Roots-Reggae', 'Dub', 'Raggamuffin', 'Ska', 'Dancehall', 'House Music', 'Drum and Bass', 'Techno', 'Chiptune', 'Hard Dance', 'Experimental Electronic', 'Chicago House', 'Ambient House', 'Deep House', 'Tech House', 'Acid House', 'Dutch House', 'Progressive House', 'Funky House', 'Nu Disco', 'Euro Disco', 'Minimal Techno', 'Hardcore Techno', 'IDM', 'Trance', 'Psytrance', 'Progressive Trance', 'Grime', 'Big Beat', 'Dub Step', 'Liquid Funk', 'Hard Step', 'Old School Jungle', 'Trip Hop', 'Gospel', 'Dancepop', 'Indietronica', 'Nu Rave', 'Emo-Rock', 'Soft-Rock', 'Post-Punk Revival', 'Nu Prog', 'Indie Folk', 'Audiobook', 'Audioplay', 'Relaxation', 'Acapella', 'Latin Hip Hop', 'Reggaeton', 'Synthwave', 'Lofi Hip Hop')")
        return value

    @field_validator('tertiary_level2_genre')
    def tertiary_level2_genre_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Electro Pop', 'Indie Pop', 'Indie Rock', 'Electroclash', 'Adult Contemporary', 'Easy Listening', 'Comedy Music', 'New Age', 'Chanson', 'Singer/Songwriter', 'Schlager', 'Volksmusik', 'Rock'n'Roll', 'Rockabilly', 'Psychobilly', 'Surf', 'Doo Wop', 'Mainstream Rock', 'Mersey Beat', 'Glamrock', 'Latin Rock', 'Melodic Rock', 'Progressive Rock', 'Psychedelic Rock', 'Hard Rock', 'Krautrock', 'Power Metal', 'Nu Metal', 'Grind Core', 'Gothic Metal', 'Death Metal', 'Melodic Death Metal', 'Thrash Metal', 'Folk Metal', 'Heavy Metal', 'Doom Metal', 'Black Metal', 'Glam Metal', 'Sleaze Metal', 'Metalcore', 'Progressive Metal', 'Screamo', 'Symphonic Metal', 'Swing', 'Ragtime', 'Dixieland', 'Boogie Woogie', 'Bebop', 'Cool Jazz', 'Free Jazz', 'Fusion', 'Smooth Jazz', 'Acid Jazz', 'Bossa Nova', 'Latin Jazz', 'Nu-Jazz', 'Tango', 'Samba', 'Salsa', 'Axé', 'Sertanejo', 'Forró', 'Choro', 'Fado', 'Flamenco', 'Blasmusik', 'American Folk', 'Irish Folk', 'Folk Rock', 'Folk Pop', 'Medieval Folk', 'Americana', 'Bluegrass', 'Red Dirt', 'Outlaw Country', 'Country Pop', 'Country Rock', 'Nashville', 'Honkytonk', 'Production Music', 'Soundtrack', 'Musical', 'Medieval', 'Renaissance', 'Baroque', 'Classical Period', 'Romanticism', 'Neue Musik', 'Minimal Music', 'Neoklassik', 'Contemporary Classical', 'Postmoderne Musik', 'Punk', 'Noise Rock', 'Garage', 'Grunge', 'Industrial', 'New Wave', 'Post Punk', 'Gothic Rock', 'Stoner Rock', 'Pop Punk', 'Post Hardcore', 'Post Rock', 'Post Metal', 'Post-Grunge', 'Britpop', 'Ska Punk', 'Math Rock', 'Dreampop', 'Shoegaze', 'Contemporary R&B', 'Rhythm And Blues', 'Disco', 'Chicago Soul', 'Detroit Soul', 'Urban', 'Nu R&B', 'Old School Soul', 'Neo Soul', 'Early Funk', 'Funk', 'Contemporary Funk', 'Funk Rock', 'Folk Blues', 'Classics Blues', 'Contemporary Blues', 'Blues Rock', 'Trap Music', 'Electro-hop', 'Hardcore Rap', 'Old School Hip Hop', 'British Hip Hop', 'Alternative Hip Hop', 'Pop Rap', 'Miami Bass & Bounce', 'Dirty South Rap', 'Turntablism', 'West Coast Gangsta Rap', 'East Coast Gangsta Rap', 'Roots-Reggae', 'Dub', 'Raggamuffin', 'Ska', 'Dancehall', 'House Music', 'Drum and Bass', 'Techno', 'Chiptune', 'Hard Dance', 'Experimental Electronic', 'Chicago House', 'Ambient House', 'Deep House', 'Tech House', 'Acid House', 'Dutch House', 'Progressive House', 'Funky House', 'Nu Disco', 'Euro Disco', 'Minimal Techno', 'Hardcore Techno', 'IDM', 'Trance', 'Psytrance', 'Progressive Trance', 'Grime', 'Big Beat', 'Dub Step', 'Liquid Funk', 'Hard Step', 'Old School Jungle', 'Trip Hop', 'Gospel', 'Dancepop', 'Indietronica', 'Nu Rave', 'Emo-Rock', 'Soft-Rock', 'Post-Punk Revival', 'Nu Prog', 'Indie Folk', 'Audiobook', 'Audioplay', 'Relaxation', 'Acapella', 'Latin Hip Hop', 'Reggaeton', 'Synthwave', 'Lofi Hip Hop'):
            raise ValueError("must be one of enum values ('Electro Pop', 'Indie Pop', 'Indie Rock', 'Electroclash', 'Adult Contemporary', 'Easy Listening', 'Comedy Music', 'New Age', 'Chanson', 'Singer/Songwriter', 'Schlager', 'Volksmusik', 'Rock'n'Roll', 'Rockabilly', 'Psychobilly', 'Surf', 'Doo Wop', 'Mainstream Rock', 'Mersey Beat', 'Glamrock', 'Latin Rock', 'Melodic Rock', 'Progressive Rock', 'Psychedelic Rock', 'Hard Rock', 'Krautrock', 'Power Metal', 'Nu Metal', 'Grind Core', 'Gothic Metal', 'Death Metal', 'Melodic Death Metal', 'Thrash Metal', 'Folk Metal', 'Heavy Metal', 'Doom Metal', 'Black Metal', 'Glam Metal', 'Sleaze Metal', 'Metalcore', 'Progressive Metal', 'Screamo', 'Symphonic Metal', 'Swing', 'Ragtime', 'Dixieland', 'Boogie Woogie', 'Bebop', 'Cool Jazz', 'Free Jazz', 'Fusion', 'Smooth Jazz', 'Acid Jazz', 'Bossa Nova', 'Latin Jazz', 'Nu-Jazz', 'Tango', 'Samba', 'Salsa', 'Axé', 'Sertanejo', 'Forró', 'Choro', 'Fado', 'Flamenco', 'Blasmusik', 'American Folk', 'Irish Folk', 'Folk Rock', 'Folk Pop', 'Medieval Folk', 'Americana', 'Bluegrass', 'Red Dirt', 'Outlaw Country', 'Country Pop', 'Country Rock', 'Nashville', 'Honkytonk', 'Production Music', 'Soundtrack', 'Musical', 'Medieval', 'Renaissance', 'Baroque', 'Classical Period', 'Romanticism', 'Neue Musik', 'Minimal Music', 'Neoklassik', 'Contemporary Classical', 'Postmoderne Musik', 'Punk', 'Noise Rock', 'Garage', 'Grunge', 'Industrial', 'New Wave', 'Post Punk', 'Gothic Rock', 'Stoner Rock', 'Pop Punk', 'Post Hardcore', 'Post Rock', 'Post Metal', 'Post-Grunge', 'Britpop', 'Ska Punk', 'Math Rock', 'Dreampop', 'Shoegaze', 'Contemporary R&B', 'Rhythm And Blues', 'Disco', 'Chicago Soul', 'Detroit Soul', 'Urban', 'Nu R&B', 'Old School Soul', 'Neo Soul', 'Early Funk', 'Funk', 'Contemporary Funk', 'Funk Rock', 'Folk Blues', 'Classics Blues', 'Contemporary Blues', 'Blues Rock', 'Trap Music', 'Electro-hop', 'Hardcore Rap', 'Old School Hip Hop', 'British Hip Hop', 'Alternative Hip Hop', 'Pop Rap', 'Miami Bass & Bounce', 'Dirty South Rap', 'Turntablism', 'West Coast Gangsta Rap', 'East Coast Gangsta Rap', 'Roots-Reggae', 'Dub', 'Raggamuffin', 'Ska', 'Dancehall', 'House Music', 'Drum and Bass', 'Techno', 'Chiptune', 'Hard Dance', 'Experimental Electronic', 'Chicago House', 'Ambient House', 'Deep House', 'Tech House', 'Acid House', 'Dutch House', 'Progressive House', 'Funky House', 'Nu Disco', 'Euro Disco', 'Minimal Techno', 'Hardcore Techno', 'IDM', 'Trance', 'Psytrance', 'Progressive Trance', 'Grime', 'Big Beat', 'Dub Step', 'Liquid Funk', 'Hard Step', 'Old School Jungle', 'Trip Hop', 'Gospel', 'Dancepop', 'Indietronica', 'Nu Rave', 'Emo-Rock', 'Soft-Rock', 'Post-Punk Revival', 'Nu Prog', 'Indie Folk', 'Audiobook', 'Audioplay', 'Relaxation', 'Acapella', 'Latin Hip Hop', 'Reggaeton', 'Synthwave', 'Lofi Hip Hop')")
        return value

    @field_validator('curateability')
    def curateability_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('curateable', 'uncurateable'):
            raise ValueError("must be one of enum values ('curateable', 'uncurateable')")
        return value

    @field_validator('use_case')
    def use_case_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('background', 'sport', 'focus', 'christmas', 'film', 'summer', 'adverts', 'party', 'relax'):
            raise ValueError("must be one of enum values ('background', 'sport', 'focus', 'christmas', 'film', 'summer', 'adverts', 'party', 'relax')")
        return value

    @field_validator('social_media')
    def social_media_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Spotify', 'TikTok', 'Unfitting', 'YouTube'):
            raise ValueError("must be one of enum values ('Spotify', 'TikTok', 'Unfitting', 'YouTube')")
        return value

    @field_validator('industry_suitability')
    def industry_suitability_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Automobiles and Parts', 'Consumer Products and Services', 'Financial Services', 'Food, Beverage and Tobacco', 'Health Care', 'Insurance', 'Media', 'Politics, Government and Organizations', 'Real Estate', 'Retail', 'Technology', 'Telecommunications', 'Travel and Leisure'):
            raise ValueError("must be one of enum values ('Automobiles and Parts', 'Consumer Products and Services', 'Financial Services', 'Food, Beverage and Tobacco', 'Health Care', 'Insurance', 'Media', 'Politics, Government and Organizations', 'Real Estate', 'Retail', 'Technology', 'Telecommunications', 'Travel and Leisure')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of SaveFileRecordingDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of taggrams
        if self.taggrams:
            _dict['taggrams'] = self.taggrams.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in genres (list)
        _items = []
        if self.genres:
            for _item in self.genres:
                if _item:
                    _items.append(_item.to_dict())
            _dict['genres'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in parties (list)
        _items = []
        if self.parties:
            for _item in self.parties:
                if _item:
                    _items.append(_item.to_dict())
            _dict['parties'] = _items
        # override the default output from pydantic by calling `to_dict()` of context_value
        if self.context_value:
            _dict['contextValue'] = self.context_value.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Self:
        """Create an instance of SaveFileRecordingDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "isrc": obj.get("isrc"),
            "name": obj.get("name"),
            "folder": obj.get("folder"),
            "primaryMoodClusterAffinity": obj.get("primaryMoodClusterAffinity"),
            "primaryMoodCluster": obj.get("primaryMoodCluster"),
            "secondaryMoodClusterAffinity": obj.get("secondaryMoodClusterAffinity"),
            "secondaryMoodCluster": obj.get("secondaryMoodCluster"),
            "tertiaryMoodClusterAffinity": obj.get("tertiaryMoodClusterAffinity"),
            "tertiaryMoodCluster": obj.get("tertiaryMoodCluster"),
            "valenceAffinity": obj.get("valenceAffinity"),
            "arousalAffinity": obj.get("arousalAffinity"),
            "pleasantnessAffinity": obj.get("pleasantnessAffinity"),
            "engagementAffinity": obj.get("engagementAffinity"),
            "valence": obj.get("valence"),
            "arousal": obj.get("arousal"),
            "pleasantness": obj.get("pleasantness"),
            "engagement": obj.get("engagement"),
            "vocals": obj.get("vocals"),
            "vocalsAffinity": obj.get("vocalsAffinity"),
            "dominantInstrument": obj.get("dominantInstrument"),
            "dominantInstrumentAffinity": obj.get("dominantInstrumentAffinity"),
            "secondaryInstrumentAffinity": obj.get("secondaryInstrumentAffinity"),
            "secondaryInstrument": obj.get("secondaryInstrument"),
            "tertiaryInstrumentAffinity": obj.get("tertiaryInstrumentAffinity"),
            "tertiaryInstrument": obj.get("tertiaryInstrument"),
            "energy": obj.get("energy"),
            "energyAffinity": obj.get("energyAffinity"),
            "soundGeneration": obj.get("soundGeneration"),
            "soundGenerationAffinity": obj.get("soundGenerationAffinity"),
            "tempo": obj.get("tempo"),
            "tempoAffinity": obj.get("tempoAffinity"),
            "scale": obj.get("scale"),
            "scaleAffinity": obj.get("scaleAffinity"),
            "rhythm": obj.get("rhythm"),
            "rhythmAffinity": obj.get("rhythmAffinity"),
            "primarySoundCharacter": obj.get("primarySoundCharacter"),
            "primarySoundCharacterAffinity": obj.get("primarySoundCharacterAffinity"),
            "timbreAffinity": obj.get("timbreAffinity"),
            "roughnessAffinity": obj.get("roughnessAffinity"),
            "tonalityAffinity": obj.get("tonalityAffinity"),
            "harmonyAffinity": obj.get("harmonyAffinity"),
            "textureAffinity": obj.get("textureAffinity"),
            "groovynessAffinity": obj.get("groovynessAffinity"),
            "spaceAffinity": obj.get("spaceAffinity"),
            "timbre": obj.get("timbre"),
            "roughness": obj.get("roughness"),
            "tonality": obj.get("tonality"),
            "harmony": obj.get("harmony"),
            "texture": obj.get("texture"),
            "groovyness": obj.get("groovyness"),
            "space": obj.get("space"),
            "bpm": obj.get("bpm"),
            "key": obj.get("key"),
            "keyAffinity": obj.get("keyAffinity"),
            "productionRating": obj.get("productionRating"),
            "productionRatingAffinity": obj.get("productionRatingAffinity"),
            "performanceRating": obj.get("performanceRating"),
            "performanceRatingAffinity": obj.get("performanceRatingAffinity"),
            "songRating": obj.get("songRating"),
            "songRatingAffinity": obj.get("songRatingAffinity"),
            "audienceGender": obj.get("audienceGender"),
            "audienceGenderAffinity": obj.get("audienceGenderAffinity"),
            "audienceRegion": obj.get("audienceRegion"),
            "audienceRegionAffinity": obj.get("audienceRegionAffinity"),
            "secondaryAudienceRegionAffinity": obj.get("secondaryAudienceRegionAffinity"),
            "secondaryAudienceRegion": obj.get("secondaryAudienceRegion"),
            "tertiaryAudienceRegionAffinity": obj.get("tertiaryAudienceRegionAffinity"),
            "tertiaryAudienceRegion": obj.get("tertiaryAudienceRegion"),
            "audienceAge": obj.get("audienceAge"),
            "audienceAgeAffinity": obj.get("audienceAgeAffinity"),
            "secondaryAudienceAge": obj.get("secondaryAudienceAge"),
            "secondaryAudienceAgeAffinity": obj.get("secondaryAudienceAgeAffinity"),
            "tertiaryAudienceAge": obj.get("tertiaryAudienceAge"),
            "tertiaryAudienceAgeAffinity": obj.get("tertiaryAudienceAgeAffinity"),
            "originDecade": obj.get("originDecade"),
            "originDecadeAffinity": obj.get("originDecadeAffinity"),
            "languageOfPerformance": obj.get("languageOfPerformance"),
            "languageOfPerformanceAffinity": obj.get("languageOfPerformanceAffinity"),
            "originRegion": obj.get("originRegion"),
            "originRegionAffinity": obj.get("originRegionAffinity"),
            "taggrams": SaveTaggramsDTO.from_dict(obj.get("taggrams")) if obj.get("taggrams") is not None else None,
            "embeddings": obj.get("embeddings"),
            "level1Genre": obj.get("level1Genre"),
            "level1GenreAffinity": obj.get("level1GenreAffinity"),
            "secondaryLevel1Genre": obj.get("secondaryLevel1Genre"),
            "secondaryLevel1GenreAffinity": obj.get("secondaryLevel1GenreAffinity"),
            "tertiaryLevel1Genre": obj.get("tertiaryLevel1Genre"),
            "tertiaryLevel1GenreAffinity": obj.get("tertiaryLevel1GenreAffinity"),
            "level2Genre": obj.get("level2Genre"),
            "level2GenreAffinity": obj.get("level2GenreAffinity"),
            "secondaryLevel2Genre": obj.get("secondaryLevel2Genre"),
            "secondaryLevel2GenreAffinity": obj.get("secondaryLevel2GenreAffinity"),
            "tertiaryLevel2Genre": obj.get("tertiaryLevel2Genre"),
            "tertiaryLevel2GenreAffinity": obj.get("tertiaryLevel2GenreAffinity"),
            "curateability": obj.get("curateability"),
            "curateabilityAffinity": obj.get("curateabilityAffinity"),
            "useCase": obj.get("useCase"),
            "useCaseAffinity": obj.get("useCaseAffinity"),
            "socialMedia": obj.get("socialMedia"),
            "socialMediaAffinity": obj.get("socialMediaAffinity"),
            "industrySuitability": obj.get("industrySuitability"),
            "industrySuitabilityAffinity": obj.get("industrySuitabilityAffinity"),
            "createdByVersion": obj.get("createdByVersion"),
            "tags": [SaveRecordingTagDTO.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None,
            "genres": [SaveRecordingGenreDTO.from_dict(_item) for _item in obj.get("genres")] if obj.get("genres") is not None else None,
            "parties": [SaveRecordingPartyDTO.from_dict(_item) for _item in obj.get("parties")] if obj.get("parties") is not None else None,
            "iswc": obj.get("iswc"),
            "proprietaryIdGema": obj.get("proprietaryIdGema"),
            "title": obj.get("title"),
            "versionTitle": obj.get("versionTitle"),
            "contextKind": obj.get("contextKind"),
            "contextValue": ContextValue.from_dict(obj.get("contextValue")) if obj.get("contextValue") is not None else None
        })
        return _obj


