# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.7
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt
from pydantic import Field
from typing import Dict, Any
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class SaveTaggramsDTO(BaseModel):
    """
    Timeseries of tags.  # noqa: E501
    """
    timestamps: Optional[List[Union[StrictFloat, StrictInt]]] = None
    level1_genre: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="level1Genre")
    level2_genre: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="level2Genre")
    song_rating: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="songRating")
    performance_rating: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="performanceRating")
    production_rating: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="productionRating")
    mood_cluster: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="moodCluster")
    vocals: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = None
    dominant_instrument: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="dominantInstrument")
    sound_generation: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="soundGeneration")
    rhythm: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = None
    tonality: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = None
    audience_age: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="audienceAge")
    audience_gender: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="audienceGender")
    audience_region: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="audienceRegion")
    origin_region: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="originRegion")
    origin_decade: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="originDecade")
    language_of_performance: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="languageOfPerformance")
    arousal: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = None
    valence: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = None
    pleasantness: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = None
    engagement: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = None
    energy: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = None
    timbre: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = None
    roughness: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = None
    harmony: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = None
    texture: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = None
    groovyness: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = None
    space: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = None
    curateability: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = None
    use_case: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="useCase")
    social_media: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="socialMedia")
    industry_suitability: Optional[Dict[str, List[Union[StrictFloat, StrictInt]]]] = Field(default=None, alias="industrySuitability")
    __properties: ClassVar[List[str]] = ["timestamps", "level1Genre", "level2Genre", "songRating", "performanceRating", "productionRating", "moodCluster", "vocals", "dominantInstrument", "soundGeneration", "rhythm", "tonality", "audienceAge", "audienceGender", "audienceRegion", "originRegion", "originDecade", "languageOfPerformance", "arousal", "valence", "pleasantness", "engagement", "energy", "timbre", "roughness", "harmony", "texture", "groovyness", "space", "curateability", "useCase", "socialMedia", "industrySuitability"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of SaveTaggramsDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Self:
        """Create an instance of SaveTaggramsDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "timestamps": obj.get("timestamps"),
            "level1Genre": obj.get("level1Genre"),
            "level2Genre": obj.get("level2Genre"),
            "songRating": obj.get("songRating"),
            "performanceRating": obj.get("performanceRating"),
            "productionRating": obj.get("productionRating"),
            "moodCluster": obj.get("moodCluster"),
            "vocals": obj.get("vocals"),
            "dominantInstrument": obj.get("dominantInstrument"),
            "soundGeneration": obj.get("soundGeneration"),
            "rhythm": obj.get("rhythm"),
            "tonality": obj.get("tonality"),
            "audienceAge": obj.get("audienceAge"),
            "audienceGender": obj.get("audienceGender"),
            "audienceRegion": obj.get("audienceRegion"),
            "originRegion": obj.get("originRegion"),
            "originDecade": obj.get("originDecade"),
            "languageOfPerformance": obj.get("languageOfPerformance"),
            "arousal": obj.get("arousal"),
            "valence": obj.get("valence"),
            "pleasantness": obj.get("pleasantness"),
            "engagement": obj.get("engagement"),
            "energy": obj.get("energy"),
            "timbre": obj.get("timbre"),
            "roughness": obj.get("roughness"),
            "harmony": obj.get("harmony"),
            "texture": obj.get("texture"),
            "groovyness": obj.get("groovyness"),
            "space": obj.get("space"),
            "curateability": obj.get("curateability"),
            "useCase": obj.get("useCase"),
            "socialMedia": obj.get("socialMedia"),
            "industrySuitability": obj.get("industrySuitability")
        })
        return _obj


