# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.7
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictBool, StrictStr
from pydantic import Field
from typing import Dict, Any
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class UserDTO(BaseModel):
    """
    All details on a user.  # noqa: E501
    """
    username: StrictStr
    email_address: StrictStr = Field(alias="emailAddress")
    company_name: Optional[StrictStr] = Field(default=None, alias="companyName")
    is_admin: StrictBool = Field(alias="isAdmin")
    full_search_allowed: StrictBool = Field(alias="fullSearchAllowed")
    voice_search_allowed: StrictBool = Field(alias="voiceSearchAllowed")
    recording_detail_allowed: StrictBool = Field(alias="recordingDetailAllowed")
    artist_detail_allowed: StrictBool = Field(alias="artistDetailAllowed")
    playlist_prediction_allowed: StrictBool = Field(alias="playlistPredictionAllowed")
    widgets_allowed: StrictBool = Field(alias="widgetsAllowed")
    signup_allowed: StrictBool = Field(alias="signupAllowed")
    upload_allowed: StrictBool = Field(alias="uploadAllowed")
    fingerprint_allowed: StrictBool = Field(alias="fingerprintAllowed")
    audiotagging_allowed: StrictBool = Field(alias="audiotaggingAllowed")
    b2b_allowed: StrictBool = Field(alias="b2bAllowed")
    editor_allowed: StrictBool = Field(alias="editorAllowed")
    insights_allowed: StrictBool = Field(alias="insightsAllowed")
    genres_allowed: StrictBool = Field(alias="genresAllowed")
    moods_allowed: StrictBool = Field(alias="moodsAllowed")
    instrumentation_allowed: StrictBool = Field(alias="instrumentationAllowed")
    sound_features_allowed: StrictBool = Field(alias="soundFeaturesAllowed")
    tonal_features_allowed: StrictBool = Field(alias="tonalFeaturesAllowed")
    rhythm_features_allowed: StrictBool = Field(alias="rhythmFeaturesAllowed")
    audience_allowed: StrictBool = Field(alias="audienceAllowed")
    origin_allowed: StrictBool = Field(alias="originAllowed")
    quality_allowed: StrictBool = Field(alias="qualityAllowed")
    reduced_musical_features: StrictBool = Field(alias="reducedMusicalFeatures")
    confirmed: StrictBool
    language: StrictStr
    admin: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["username", "emailAddress", "companyName", "isAdmin", "fullSearchAllowed", "voiceSearchAllowed", "recordingDetailAllowed", "artistDetailAllowed", "playlistPredictionAllowed", "widgetsAllowed", "signupAllowed", "uploadAllowed", "fingerprintAllowed", "audiotaggingAllowed", "b2bAllowed", "editorAllowed", "insightsAllowed", "genresAllowed", "moodsAllowed", "instrumentationAllowed", "soundFeaturesAllowed", "tonalFeaturesAllowed", "rhythmFeaturesAllowed", "audienceAllowed", "originAllowed", "qualityAllowed", "reducedMusicalFeatures", "confirmed", "language", "admin"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of UserDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Self:
        """Create an instance of UserDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "username": obj.get("username"),
            "emailAddress": obj.get("emailAddress"),
            "companyName": obj.get("companyName"),
            "isAdmin": obj.get("isAdmin"),
            "fullSearchAllowed": obj.get("fullSearchAllowed"),
            "voiceSearchAllowed": obj.get("voiceSearchAllowed"),
            "recordingDetailAllowed": obj.get("recordingDetailAllowed"),
            "artistDetailAllowed": obj.get("artistDetailAllowed"),
            "playlistPredictionAllowed": obj.get("playlistPredictionAllowed"),
            "widgetsAllowed": obj.get("widgetsAllowed"),
            "signupAllowed": obj.get("signupAllowed"),
            "uploadAllowed": obj.get("uploadAllowed"),
            "fingerprintAllowed": obj.get("fingerprintAllowed"),
            "audiotaggingAllowed": obj.get("audiotaggingAllowed"),
            "b2bAllowed": obj.get("b2bAllowed"),
            "editorAllowed": obj.get("editorAllowed"),
            "insightsAllowed": obj.get("insightsAllowed"),
            "genresAllowed": obj.get("genresAllowed"),
            "moodsAllowed": obj.get("moodsAllowed"),
            "instrumentationAllowed": obj.get("instrumentationAllowed"),
            "soundFeaturesAllowed": obj.get("soundFeaturesAllowed"),
            "tonalFeaturesAllowed": obj.get("tonalFeaturesAllowed"),
            "rhythmFeaturesAllowed": obj.get("rhythmFeaturesAllowed"),
            "audienceAllowed": obj.get("audienceAllowed"),
            "originAllowed": obj.get("originAllowed"),
            "qualityAllowed": obj.get("qualityAllowed"),
            "reducedMusicalFeatures": obj.get("reducedMusicalFeatures"),
            "confirmed": obj.get("confirmed"),
            "language": obj.get("language"),
            "admin": obj.get("admin")
        })
        return _obj


