# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.16.0
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List
from pydantic import BaseModel, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class SearchFilterValuesDTO(BaseModel):
    """
    Categories of musical features that can be used as search filters.
    """ # noqa: E501
    primary_mood_cluster: List[StrictStr] = Field(alias="primaryMoodCluster")
    secondary_mood_cluster: List[StrictStr] = Field(alias="secondaryMoodCluster")
    tertiary_mood_cluster: List[StrictStr] = Field(alias="tertiaryMoodCluster")
    valence: List[StrictStr]
    arousal: List[StrictStr]
    pleasantness: List[StrictStr]
    engagement: List[StrictStr]
    vocals: List[StrictStr]
    dominant_instrument: List[StrictStr] = Field(alias="dominantInstrument")
    secondary_instrument: List[StrictStr] = Field(alias="secondaryInstrument")
    tertiary_instrument: List[StrictStr] = Field(alias="tertiaryInstrument")
    energy: List[StrictStr]
    sound_generation: List[StrictStr] = Field(alias="soundGeneration")
    tempo: List[StrictStr]
    scale: List[StrictStr]
    key: List[StrictStr]
    rhythm: List[StrictStr]
    primary_sound_character: List[StrictStr] = Field(alias="primarySoundCharacter")
    timbre: List[StrictStr]
    roughness: List[StrictStr]
    tonality: List[StrictStr]
    harmony: List[StrictStr]
    texture: List[StrictStr]
    groovyness: List[StrictStr]
    space: List[StrictStr]
    production_rating: List[StrictStr] = Field(alias="productionRating")
    performance_rating: List[StrictStr] = Field(alias="performanceRating")
    song_rating: List[StrictStr] = Field(alias="songRating")
    audience_age: List[StrictStr] = Field(alias="audienceAge")
    secondary_audience_age: List[StrictStr] = Field(alias="secondaryAudienceAge")
    tertiary_audience_age: List[StrictStr] = Field(alias="tertiaryAudienceAge")
    audience_gender: List[StrictStr] = Field(alias="audienceGender")
    audience_region: List[StrictStr] = Field(alias="audienceRegion")
    secondary_audience_region: List[StrictStr] = Field(alias="secondaryAudienceRegion")
    tertiary_audience_region: List[StrictStr] = Field(alias="tertiaryAudienceRegion")
    origin_decade: List[StrictStr] = Field(alias="originDecade")
    origin_region: List[StrictStr] = Field(alias="originRegion")
    language_of_performance: List[StrictStr] = Field(alias="languageOfPerformance")
    curateability: List[StrictStr]
    use_case: List[StrictStr] = Field(alias="useCase")
    channel_suitability: List[StrictStr] = Field(alias="channelSuitability")
    __properties: ClassVar[List[str]] = ["primaryMoodCluster", "secondaryMoodCluster", "tertiaryMoodCluster", "valence", "arousal", "pleasantness", "engagement", "vocals", "dominantInstrument", "secondaryInstrument", "tertiaryInstrument", "energy", "soundGeneration", "tempo", "scale", "key", "rhythm", "primarySoundCharacter", "timbre", "roughness", "tonality", "harmony", "texture", "groovyness", "space", "productionRating", "performanceRating", "songRating", "audienceAge", "secondaryAudienceAge", "tertiaryAudienceAge", "audienceGender", "audienceRegion", "secondaryAudienceRegion", "tertiaryAudienceRegion", "originDecade", "originRegion", "languageOfPerformance", "curateability", "useCase", "channelSuitability"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of SearchFilterValuesDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of SearchFilterValuesDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "primaryMoodCluster": obj.get("primaryMoodCluster"),
            "secondaryMoodCluster": obj.get("secondaryMoodCluster"),
            "tertiaryMoodCluster": obj.get("tertiaryMoodCluster"),
            "valence": obj.get("valence"),
            "arousal": obj.get("arousal"),
            "pleasantness": obj.get("pleasantness"),
            "engagement": obj.get("engagement"),
            "vocals": obj.get("vocals"),
            "dominantInstrument": obj.get("dominantInstrument"),
            "secondaryInstrument": obj.get("secondaryInstrument"),
            "tertiaryInstrument": obj.get("tertiaryInstrument"),
            "energy": obj.get("energy"),
            "soundGeneration": obj.get("soundGeneration"),
            "tempo": obj.get("tempo"),
            "scale": obj.get("scale"),
            "key": obj.get("key"),
            "rhythm": obj.get("rhythm"),
            "primarySoundCharacter": obj.get("primarySoundCharacter"),
            "timbre": obj.get("timbre"),
            "roughness": obj.get("roughness"),
            "tonality": obj.get("tonality"),
            "harmony": obj.get("harmony"),
            "texture": obj.get("texture"),
            "groovyness": obj.get("groovyness"),
            "space": obj.get("space"),
            "productionRating": obj.get("productionRating"),
            "performanceRating": obj.get("performanceRating"),
            "songRating": obj.get("songRating"),
            "audienceAge": obj.get("audienceAge"),
            "secondaryAudienceAge": obj.get("secondaryAudienceAge"),
            "tertiaryAudienceAge": obj.get("tertiaryAudienceAge"),
            "audienceGender": obj.get("audienceGender"),
            "audienceRegion": obj.get("audienceRegion"),
            "secondaryAudienceRegion": obj.get("secondaryAudienceRegion"),
            "tertiaryAudienceRegion": obj.get("tertiaryAudienceRegion"),
            "originDecade": obj.get("originDecade"),
            "originRegion": obj.get("originRegion"),
            "languageOfPerformance": obj.get("languageOfPerformance"),
            "curateability": obj.get("curateability"),
            "useCase": obj.get("useCase"),
            "channelSuitability": obj.get("channelSuitability")
        })
        return _obj


