# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.17.0
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import List, Optional, Union
from typing_extensions import Annotated
from songtradr_api_client_python.models.file_list_dto import FileListDTO
from songtradr_api_client_python.models.file_small_dto import FileSmallDTO
from songtradr_api_client_python.models.file_upload_dto import FileUploadDTO
from songtradr_api_client_python.models.file_w_ith_url_dto import FileWIthUrlDTO
from songtradr_api_client_python.models.files_summary_dto import FilesSummaryDTO
from songtradr_api_client_python.models.forgot_password_dto import ForgotPasswordDTO
from songtradr_api_client_python.models.image_recognition_response import ImageRecognitionResponse
from songtradr_api_client_python.models.init_put_recording_audio_dto import InitPutRecordingAudioDTO
from songtradr_api_client_python.models.jwt_token_dto import JwtTokenDTO
from songtradr_api_client_python.models.login_dto import LoginDTO
from songtradr_api_client_python.models.recording_minimal_with_taggrams_dto import RecordingMinimalWithTaggramsDTO
from songtradr_api_client_python.models.recording_minimal_with_tagstrengths_dto import RecordingMinimalWithTagstrengthsDTO
from songtradr_api_client_python.models.save_user_dto import SaveUserDTO
from songtradr_api_client_python.models.sign_up_dto import SignUpDTO
from songtradr_api_client_python.models.token_request import TokenRequest
from songtradr_api_client_python.models.update_password_dto import UpdatePasswordDTO
from songtradr_api_client_python.models.user_dto import UserDTO
from songtradr_api_client_python.models.video_recognition_response import VideoRecognitionResponse

from songtradr_api_client_python.api_client import ApiClient
from songtradr_api_client_python.api_response import ApiResponse
from songtradr_api_client_python.rest import RESTResponseType


class UserApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def delete_user_file(
        self,
        object_key: Annotated[StrictStr, Field(description="ObjectKey of the file that should be deleted.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Delete file.


        :param object_key: ObjectKey of the file that should be deleted. (required)
        :type object_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_file_serialize(
            object_key=object_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_user_file_with_http_info(
        self,
        object_key: Annotated[StrictStr, Field(description="ObjectKey of the file that should be deleted.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Delete file.


        :param object_key: ObjectKey of the file that should be deleted. (required)
        :type object_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_file_serialize(
            object_key=object_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_user_file_without_preload_content(
        self,
        object_key: Annotated[StrictStr, Field(description="ObjectKey of the file that should be deleted.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete file.


        :param object_key: ObjectKey of the file that should be deleted. (required)
        :type object_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_file_serialize(
            object_key=object_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_user_file_serialize(
        self,
        object_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if object_key is not None:
            _path_params['objectKey'] = object_key
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/hal+json', 
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v1/user/file/{objectKey}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def edit_me(
        self,
        save_user_dto: SaveUserDTO,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Edit details for a logged-in user


        :param save_user_dto: (required)
        :type save_user_dto: SaveUserDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_me_serialize(
            save_user_dto=save_user_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def edit_me_with_http_info(
        self,
        save_user_dto: SaveUserDTO,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Edit details for a logged-in user


        :param save_user_dto: (required)
        :type save_user_dto: SaveUserDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_me_serialize(
            save_user_dto=save_user_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def edit_me_without_preload_content(
        self,
        save_user_dto: SaveUserDTO,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Edit details for a logged-in user


        :param save_user_dto: (required)
        :type save_user_dto: SaveUserDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_me_serialize(
            save_user_dto=save_user_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _edit_me_serialize(
        self,
        save_user_dto,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if save_user_dto is not None:
            _body_params = save_user_dto


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/user/me',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def forgot_password(
        self,
        forgot_password_dto: ForgotPasswordDTO,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Send a password reset email


        :param forgot_password_dto: (required)
        :type forgot_password_dto: ForgotPasswordDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._forgot_password_serialize(
            forgot_password_dto=forgot_password_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def forgot_password_with_http_info(
        self,
        forgot_password_dto: ForgotPasswordDTO,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Send a password reset email


        :param forgot_password_dto: (required)
        :type forgot_password_dto: ForgotPasswordDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._forgot_password_serialize(
            forgot_password_dto=forgot_password_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def forgot_password_without_preload_content(
        self,
        forgot_password_dto: ForgotPasswordDTO,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Send a password reset email


        :param forgot_password_dto: (required)
        :type forgot_password_dto: ForgotPasswordDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._forgot_password_serialize(
            forgot_password_dto=forgot_password_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _forgot_password_serialize(
        self,
        forgot_password_dto,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if forgot_password_dto is not None:
            _body_params = forgot_password_dto


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/hal+json', 
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/user/forgot-password',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def init_video_upload(
        self,
        name: Annotated[StrictStr, Field(description="The Name of the image that will be uploaded")],
        url: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> VideoRecognitionResponse:
        """Recognise and upload video. Responds with an object with recognition result.


        :param name: The Name of the image that will be uploaded (required)
        :type name: str
        :param url: (required)
        :type url: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._init_video_upload_serialize(
            name=name,
            url=url,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VideoRecognitionResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def init_video_upload_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="The Name of the image that will be uploaded")],
        url: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[VideoRecognitionResponse]:
        """Recognise and upload video. Responds with an object with recognition result.


        :param name: The Name of the image that will be uploaded (required)
        :type name: str
        :param url: (required)
        :type url: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._init_video_upload_serialize(
            name=name,
            url=url,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VideoRecognitionResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def init_video_upload_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="The Name of the image that will be uploaded")],
        url: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Recognise and upload video. Responds with an object with recognition result.


        :param name: The Name of the image that will be uploaded (required)
        :type name: str
        :param url: (required)
        :type url: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._init_video_upload_serialize(
            name=name,
            url=url,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VideoRecognitionResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _init_video_upload_serialize(
        self,
        name,
        url,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        # process the query parameters
        if url is not None:
            
            _query_params.append(('url', url))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/user/file/{name}/initVideoUpload',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def initiate_user_file_upload(
        self,
        name: Annotated[StrictStr, Field(description="The Name of the file that will be uploaded")],
        folder: Annotated[StrictStr, Field(description="The Name of the folder that the file will be placed in")],
        file_upload_dto: Optional[FileUploadDTO] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> InitPutRecordingAudioDTO:
        """Initialize a file upload. Responds with an URL where the file can be uploaded.


        :param name: The Name of the file that will be uploaded (required)
        :type name: str
        :param folder: The Name of the folder that the file will be placed in (required)
        :type folder: str
        :param file_upload_dto:
        :type file_upload_dto: FileUploadDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._initiate_user_file_upload_serialize(
            name=name,
            folder=folder,
            file_upload_dto=file_upload_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InitPutRecordingAudioDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def initiate_user_file_upload_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="The Name of the file that will be uploaded")],
        folder: Annotated[StrictStr, Field(description="The Name of the folder that the file will be placed in")],
        file_upload_dto: Optional[FileUploadDTO] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[InitPutRecordingAudioDTO]:
        """Initialize a file upload. Responds with an URL where the file can be uploaded.


        :param name: The Name of the file that will be uploaded (required)
        :type name: str
        :param folder: The Name of the folder that the file will be placed in (required)
        :type folder: str
        :param file_upload_dto:
        :type file_upload_dto: FileUploadDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._initiate_user_file_upload_serialize(
            name=name,
            folder=folder,
            file_upload_dto=file_upload_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InitPutRecordingAudioDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def initiate_user_file_upload_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="The Name of the file that will be uploaded")],
        folder: Annotated[StrictStr, Field(description="The Name of the folder that the file will be placed in")],
        file_upload_dto: Optional[FileUploadDTO] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Initialize a file upload. Responds with an URL where the file can be uploaded.


        :param name: The Name of the file that will be uploaded (required)
        :type name: str
        :param folder: The Name of the folder that the file will be placed in (required)
        :type folder: str
        :param file_upload_dto:
        :type file_upload_dto: FileUploadDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._initiate_user_file_upload_serialize(
            name=name,
            folder=folder,
            file_upload_dto=file_upload_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InitPutRecordingAudioDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _initiate_user_file_upload_serialize(
        self,
        name,
        folder,
        file_upload_dto,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        # process the query parameters
        if folder is not None:
            
            _query_params.append(('folder', folder))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if file_upload_dto is not None:
            _body_params = file_upload_dto


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/user/file/{name}/initUpload',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def initiate_user_image_upload(
        self,
        name: Annotated[StrictStr, Field(description="The Name of the image that will be uploaded")],
        url: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ImageRecognitionResponse:
        """Recognise and upload image. Responds with an object with recognition result.


        :param name: The Name of the image that will be uploaded (required)
        :type name: str
        :param url: (required)
        :type url: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._initiate_user_image_upload_serialize(
            name=name,
            url=url,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ImageRecognitionResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def initiate_user_image_upload_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="The Name of the image that will be uploaded")],
        url: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ImageRecognitionResponse]:
        """Recognise and upload image. Responds with an object with recognition result.


        :param name: The Name of the image that will be uploaded (required)
        :type name: str
        :param url: (required)
        :type url: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._initiate_user_image_upload_serialize(
            name=name,
            url=url,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ImageRecognitionResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def initiate_user_image_upload_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="The Name of the image that will be uploaded")],
        url: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Recognise and upload image. Responds with an object with recognition result.


        :param name: The Name of the image that will be uploaded (required)
        :type name: str
        :param url: (required)
        :type url: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._initiate_user_image_upload_serialize(
            name=name,
            url=url,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ImageRecognitionResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _initiate_user_image_upload_serialize(
        self,
        name,
        url,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        # process the query parameters
        if url is not None:
            
            _query_params.append(('url', url))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/user/file/{name}/initImageUpload',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def login(
        self,
        login_dto: LoginDTO,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> JwtTokenDTO:
        """Login to generate a bearer token.


        :param login_dto: (required)
        :type login_dto: LoginDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._login_serialize(
            login_dto=login_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JwtTokenDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def login_with_http_info(
        self,
        login_dto: LoginDTO,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[JwtTokenDTO]:
        """Login to generate a bearer token.


        :param login_dto: (required)
        :type login_dto: LoginDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._login_serialize(
            login_dto=login_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JwtTokenDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def login_without_preload_content(
        self,
        login_dto: LoginDTO,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Login to generate a bearer token.


        :param login_dto: (required)
        :type login_dto: LoginDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._login_serialize(
            login_dto=login_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JwtTokenDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _login_serialize(
        self,
        login_dto,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if login_dto is not None:
            _body_params = login_dto


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/user/login',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def me(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UserDTO:
        """Details for a logged-in user


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._me_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def me_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UserDTO]:
        """Details for a logged-in user


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._me_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def me_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Details for a logged-in user


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._me_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _me_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/user/me',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def recordings_by_folder_with_taggrams(
        self,
        folder_name: Annotated[StrictStr, Field(description="Folder name")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        from_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data starting from from this timestamp in seconds.")] = None,
        to_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data before this timestamp in seconds.")] = None,
        fill_with_zero: Annotated[Optional[StrictBool], Field(description="If set to true, empty timeseries are filled with timeseries of 0.0 values.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[RecordingMinimalWithTaggramsDTO]:
        """Timeseries of AI generated moods, musical features and more for recordings in your folder.


        :param folder_name: Folder name (required)
        :type folder_name: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param from_timestamp: Show only taggrams data starting from from this timestamp in seconds.
        :type from_timestamp: float
        :param to_timestamp: Show only taggrams data before this timestamp in seconds.
        :type to_timestamp: float
        :param fill_with_zero: If set to true, empty timeseries are filled with timeseries of 0.0 values.
        :type fill_with_zero: bool
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._recordings_by_folder_with_taggrams_serialize(
            folder_name=folder_name,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            from_timestamp=from_timestamp,
            to_timestamp=to_timestamp,
            fill_with_zero=fill_with_zero,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTaggramsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def recordings_by_folder_with_taggrams_with_http_info(
        self,
        folder_name: Annotated[StrictStr, Field(description="Folder name")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        from_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data starting from from this timestamp in seconds.")] = None,
        to_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data before this timestamp in seconds.")] = None,
        fill_with_zero: Annotated[Optional[StrictBool], Field(description="If set to true, empty timeseries are filled with timeseries of 0.0 values.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[RecordingMinimalWithTaggramsDTO]]:
        """Timeseries of AI generated moods, musical features and more for recordings in your folder.


        :param folder_name: Folder name (required)
        :type folder_name: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param from_timestamp: Show only taggrams data starting from from this timestamp in seconds.
        :type from_timestamp: float
        :param to_timestamp: Show only taggrams data before this timestamp in seconds.
        :type to_timestamp: float
        :param fill_with_zero: If set to true, empty timeseries are filled with timeseries of 0.0 values.
        :type fill_with_zero: bool
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._recordings_by_folder_with_taggrams_serialize(
            folder_name=folder_name,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            from_timestamp=from_timestamp,
            to_timestamp=to_timestamp,
            fill_with_zero=fill_with_zero,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTaggramsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def recordings_by_folder_with_taggrams_without_preload_content(
        self,
        folder_name: Annotated[StrictStr, Field(description="Folder name")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        from_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data starting from from this timestamp in seconds.")] = None,
        to_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data before this timestamp in seconds.")] = None,
        fill_with_zero: Annotated[Optional[StrictBool], Field(description="If set to true, empty timeseries are filled with timeseries of 0.0 values.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Timeseries of AI generated moods, musical features and more for recordings in your folder.


        :param folder_name: Folder name (required)
        :type folder_name: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param from_timestamp: Show only taggrams data starting from from this timestamp in seconds.
        :type from_timestamp: float
        :param to_timestamp: Show only taggrams data before this timestamp in seconds.
        :type to_timestamp: float
        :param fill_with_zero: If set to true, empty timeseries are filled with timeseries of 0.0 values.
        :type fill_with_zero: bool
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._recordings_by_folder_with_taggrams_serialize(
            folder_name=folder_name,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            from_timestamp=from_timestamp,
            to_timestamp=to_timestamp,
            fill_with_zero=fill_with_zero,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTaggramsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _recordings_by_folder_with_taggrams_serialize(
        self,
        folder_name,
        category_name,
        tag_name,
        genre_name,
        from_timestamp,
        to_timestamp,
        fill_with_zero,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if folder_name is not None:
            _path_params['folderName'] = folder_name
        # process the query parameters
        if category_name is not None:
            
            _query_params.append(('categoryName', category_name))
            
        if tag_name is not None:
            
            _query_params.append(('tagName', tag_name))
            
        if genre_name is not None:
            
            _query_params.append(('genreName', genre_name))
            
        if from_timestamp is not None:
            
            _query_params.append(('fromTimestamp', from_timestamp))
            
        if to_timestamp is not None:
            
            _query_params.append(('toTimestamp', to_timestamp))
            
        if fill_with_zero is not None:
            
            _query_params.append(('fillWithZero', fill_with_zero))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if size is not None:
            
            _query_params.append(('size', size))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/user/folder/{folderName}/taggrams',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def recordings_by_folder_with_tagstrengths(
        self,
        folder_name: Annotated[StrictStr, Field(description="Folder name")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[RecordingMinimalWithTagstrengthsDTO]:
        """Strengths as numerical representations for AI generated moods, musical features and more for recordings in your folder.


        :param folder_name: Folder name (required)
        :type folder_name: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._recordings_by_folder_with_tagstrengths_serialize(
            folder_name=folder_name,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTagstrengthsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def recordings_by_folder_with_tagstrengths_with_http_info(
        self,
        folder_name: Annotated[StrictStr, Field(description="Folder name")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[RecordingMinimalWithTagstrengthsDTO]]:
        """Strengths as numerical representations for AI generated moods, musical features and more for recordings in your folder.


        :param folder_name: Folder name (required)
        :type folder_name: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._recordings_by_folder_with_tagstrengths_serialize(
            folder_name=folder_name,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTagstrengthsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def recordings_by_folder_with_tagstrengths_without_preload_content(
        self,
        folder_name: Annotated[StrictStr, Field(description="Folder name")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Strengths as numerical representations for AI generated moods, musical features and more for recordings in your folder.


        :param folder_name: Folder name (required)
        :type folder_name: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._recordings_by_folder_with_tagstrengths_serialize(
            folder_name=folder_name,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTagstrengthsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _recordings_by_folder_with_tagstrengths_serialize(
        self,
        folder_name,
        category_name,
        tag_name,
        genre_name,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if folder_name is not None:
            _path_params['folderName'] = folder_name
        # process the query parameters
        if category_name is not None:
            
            _query_params.append(('categoryName', category_name))
            
        if tag_name is not None:
            
            _query_params.append(('tagName', tag_name))
            
        if genre_name is not None:
            
            _query_params.append(('genreName', genre_name))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if size is not None:
            
            _query_params.append(('size', size))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/user/folder/{folderName}/tagstrengths',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def save_playlist(
        self,
        isrc: Annotated[Optional[StrictStr], Field(description="Search for a ISRC")] = None,
        contributor: Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None,
        main_artist: Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None,
        composer: Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None,
        party_and_title: Annotated[Optional[StrictStr], Field(description="Search for party and title.")] = None,
        language: Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None,
        genre_names: Optional[List[StrictStr]] = None,
        tag_names: Optional[List[StrictStr]] = None,
        release_date: Optional[datetime] = None,
        primary_mood_cluster: Optional[StrictStr] = None,
        secondary_mood_cluster: Optional[StrictStr] = None,
        tertiary_mood_cluster: Optional[StrictStr] = None,
        valence: Optional[StrictStr] = None,
        arousal: Optional[StrictStr] = None,
        pleasantness: Optional[StrictStr] = None,
        engagement: Optional[StrictStr] = None,
        vocals: Optional[StrictStr] = None,
        dominant_instrument: Optional[StrictStr] = None,
        secondary_instrument: Optional[StrictStr] = None,
        tertiary_instrument: Optional[StrictStr] = None,
        energy: Optional[StrictStr] = None,
        sound_generation: Optional[StrictStr] = None,
        tempo: Optional[StrictStr] = None,
        scale: Optional[StrictStr] = None,
        key: Optional[StrictStr] = None,
        rhythm: Optional[StrictStr] = None,
        primary_sound_character: Optional[StrictStr] = None,
        timbre: Optional[StrictStr] = None,
        roughness: Optional[StrictStr] = None,
        tonality: Optional[StrictStr] = None,
        harmony: Optional[StrictStr] = None,
        texture: Optional[StrictStr] = None,
        groovyness: Optional[StrictStr] = None,
        space: Optional[StrictStr] = None,
        production_rating: Optional[StrictStr] = None,
        performance_rating: Optional[StrictStr] = None,
        song_rating: Optional[StrictStr] = None,
        audience_age: Optional[StrictStr] = None,
        audience_region: Optional[StrictStr] = None,
        audience_gender: Optional[StrictStr] = None,
        origin_decade: Optional[StrictStr] = None,
        curateability: Optional[StrictStr] = None,
        use_case: Optional[StrictStr] = None,
        channel_suitability: Optional[StrictStr] = None,
        similar_to_recording: Optional[StrictStr] = None,
        create_playlist_with_name: Optional[StrictStr] = None,
        songtradr_track_id: Optional[StrictStr] = None,
        usage_name: Optional[StrictStr] = None,
        bpm_min: Annotated[Optional[StrictInt], Field(description="Search for a minimal bpm.")] = None,
        bpm_max: Annotated[Optional[StrictInt], Field(description="Search for a maximal bpm.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Search for a file name.")] = None,
        folder: Annotated[Optional[StrictStr], Field(description="Search for a folder.")] = None,
        extension: Annotated[Optional[StrictStr], Field(description="Search for a file extension.")] = None,
        upload_end_time: Optional[datetime] = None,
        min_upload_end_time: Optional[datetime] = None,
        max_upload_end_time: Optional[datetime] = None,
        fingerprint_status: Annotated[Optional[StrictStr], Field(description="Search for a fingerprint status.")] = None,
        inference_status: Annotated[Optional[StrictStr], Field(description="Search for a inference status.")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FileListDTO:
        """List, search and create playlist of your own files.


        :param isrc: Search for a ISRC
        :type isrc: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param party_and_title: Search for party and title.
        :type party_and_title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param key:
        :type key: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param origin_decade:
        :type origin_decade: str
        :param curateability:
        :type curateability: str
        :param use_case:
        :type use_case: str
        :param channel_suitability:
        :type channel_suitability: str
        :param similar_to_recording:
        :type similar_to_recording: str
        :param create_playlist_with_name:
        :type create_playlist_with_name: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min: Search for a minimal bpm.
        :type bpm_min: int
        :param bpm_max: Search for a maximal bpm.
        :type bpm_max: int
        :param name: Search for a file name.
        :type name: str
        :param folder: Search for a folder.
        :type folder: str
        :param extension: Search for a file extension.
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status: Search for a fingerprint status.
        :type fingerprint_status: str
        :param inference_status: Search for a inference status.
        :type inference_status: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._save_playlist_serialize(
            isrc=isrc,
            contributor=contributor,
            main_artist=main_artist,
            composer=composer,
            title=title,
            party_and_title=party_and_title,
            language=language,
            genre_names=genre_names,
            tag_names=tag_names,
            release_date=release_date,
            primary_mood_cluster=primary_mood_cluster,
            secondary_mood_cluster=secondary_mood_cluster,
            tertiary_mood_cluster=tertiary_mood_cluster,
            valence=valence,
            arousal=arousal,
            pleasantness=pleasantness,
            engagement=engagement,
            vocals=vocals,
            dominant_instrument=dominant_instrument,
            secondary_instrument=secondary_instrument,
            tertiary_instrument=tertiary_instrument,
            energy=energy,
            sound_generation=sound_generation,
            tempo=tempo,
            scale=scale,
            key=key,
            rhythm=rhythm,
            primary_sound_character=primary_sound_character,
            timbre=timbre,
            roughness=roughness,
            tonality=tonality,
            harmony=harmony,
            texture=texture,
            groovyness=groovyness,
            space=space,
            production_rating=production_rating,
            performance_rating=performance_rating,
            song_rating=song_rating,
            audience_age=audience_age,
            audience_region=audience_region,
            audience_gender=audience_gender,
            origin_decade=origin_decade,
            curateability=curateability,
            use_case=use_case,
            channel_suitability=channel_suitability,
            similar_to_recording=similar_to_recording,
            create_playlist_with_name=create_playlist_with_name,
            songtradr_track_id=songtradr_track_id,
            usage_name=usage_name,
            bpm_min=bpm_min,
            bpm_max=bpm_max,
            name=name,
            folder=folder,
            extension=extension,
            upload_end_time=upload_end_time,
            min_upload_end_time=min_upload_end_time,
            max_upload_end_time=max_upload_end_time,
            fingerprint_status=fingerprint_status,
            inference_status=inference_status,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FileListDTO",
            '403': "ErrorResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def save_playlist_with_http_info(
        self,
        isrc: Annotated[Optional[StrictStr], Field(description="Search for a ISRC")] = None,
        contributor: Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None,
        main_artist: Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None,
        composer: Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None,
        party_and_title: Annotated[Optional[StrictStr], Field(description="Search for party and title.")] = None,
        language: Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None,
        genre_names: Optional[List[StrictStr]] = None,
        tag_names: Optional[List[StrictStr]] = None,
        release_date: Optional[datetime] = None,
        primary_mood_cluster: Optional[StrictStr] = None,
        secondary_mood_cluster: Optional[StrictStr] = None,
        tertiary_mood_cluster: Optional[StrictStr] = None,
        valence: Optional[StrictStr] = None,
        arousal: Optional[StrictStr] = None,
        pleasantness: Optional[StrictStr] = None,
        engagement: Optional[StrictStr] = None,
        vocals: Optional[StrictStr] = None,
        dominant_instrument: Optional[StrictStr] = None,
        secondary_instrument: Optional[StrictStr] = None,
        tertiary_instrument: Optional[StrictStr] = None,
        energy: Optional[StrictStr] = None,
        sound_generation: Optional[StrictStr] = None,
        tempo: Optional[StrictStr] = None,
        scale: Optional[StrictStr] = None,
        key: Optional[StrictStr] = None,
        rhythm: Optional[StrictStr] = None,
        primary_sound_character: Optional[StrictStr] = None,
        timbre: Optional[StrictStr] = None,
        roughness: Optional[StrictStr] = None,
        tonality: Optional[StrictStr] = None,
        harmony: Optional[StrictStr] = None,
        texture: Optional[StrictStr] = None,
        groovyness: Optional[StrictStr] = None,
        space: Optional[StrictStr] = None,
        production_rating: Optional[StrictStr] = None,
        performance_rating: Optional[StrictStr] = None,
        song_rating: Optional[StrictStr] = None,
        audience_age: Optional[StrictStr] = None,
        audience_region: Optional[StrictStr] = None,
        audience_gender: Optional[StrictStr] = None,
        origin_decade: Optional[StrictStr] = None,
        curateability: Optional[StrictStr] = None,
        use_case: Optional[StrictStr] = None,
        channel_suitability: Optional[StrictStr] = None,
        similar_to_recording: Optional[StrictStr] = None,
        create_playlist_with_name: Optional[StrictStr] = None,
        songtradr_track_id: Optional[StrictStr] = None,
        usage_name: Optional[StrictStr] = None,
        bpm_min: Annotated[Optional[StrictInt], Field(description="Search for a minimal bpm.")] = None,
        bpm_max: Annotated[Optional[StrictInt], Field(description="Search for a maximal bpm.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Search for a file name.")] = None,
        folder: Annotated[Optional[StrictStr], Field(description="Search for a folder.")] = None,
        extension: Annotated[Optional[StrictStr], Field(description="Search for a file extension.")] = None,
        upload_end_time: Optional[datetime] = None,
        min_upload_end_time: Optional[datetime] = None,
        max_upload_end_time: Optional[datetime] = None,
        fingerprint_status: Annotated[Optional[StrictStr], Field(description="Search for a fingerprint status.")] = None,
        inference_status: Annotated[Optional[StrictStr], Field(description="Search for a inference status.")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FileListDTO]:
        """List, search and create playlist of your own files.


        :param isrc: Search for a ISRC
        :type isrc: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param party_and_title: Search for party and title.
        :type party_and_title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param key:
        :type key: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param origin_decade:
        :type origin_decade: str
        :param curateability:
        :type curateability: str
        :param use_case:
        :type use_case: str
        :param channel_suitability:
        :type channel_suitability: str
        :param similar_to_recording:
        :type similar_to_recording: str
        :param create_playlist_with_name:
        :type create_playlist_with_name: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min: Search for a minimal bpm.
        :type bpm_min: int
        :param bpm_max: Search for a maximal bpm.
        :type bpm_max: int
        :param name: Search for a file name.
        :type name: str
        :param folder: Search for a folder.
        :type folder: str
        :param extension: Search for a file extension.
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status: Search for a fingerprint status.
        :type fingerprint_status: str
        :param inference_status: Search for a inference status.
        :type inference_status: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._save_playlist_serialize(
            isrc=isrc,
            contributor=contributor,
            main_artist=main_artist,
            composer=composer,
            title=title,
            party_and_title=party_and_title,
            language=language,
            genre_names=genre_names,
            tag_names=tag_names,
            release_date=release_date,
            primary_mood_cluster=primary_mood_cluster,
            secondary_mood_cluster=secondary_mood_cluster,
            tertiary_mood_cluster=tertiary_mood_cluster,
            valence=valence,
            arousal=arousal,
            pleasantness=pleasantness,
            engagement=engagement,
            vocals=vocals,
            dominant_instrument=dominant_instrument,
            secondary_instrument=secondary_instrument,
            tertiary_instrument=tertiary_instrument,
            energy=energy,
            sound_generation=sound_generation,
            tempo=tempo,
            scale=scale,
            key=key,
            rhythm=rhythm,
            primary_sound_character=primary_sound_character,
            timbre=timbre,
            roughness=roughness,
            tonality=tonality,
            harmony=harmony,
            texture=texture,
            groovyness=groovyness,
            space=space,
            production_rating=production_rating,
            performance_rating=performance_rating,
            song_rating=song_rating,
            audience_age=audience_age,
            audience_region=audience_region,
            audience_gender=audience_gender,
            origin_decade=origin_decade,
            curateability=curateability,
            use_case=use_case,
            channel_suitability=channel_suitability,
            similar_to_recording=similar_to_recording,
            create_playlist_with_name=create_playlist_with_name,
            songtradr_track_id=songtradr_track_id,
            usage_name=usage_name,
            bpm_min=bpm_min,
            bpm_max=bpm_max,
            name=name,
            folder=folder,
            extension=extension,
            upload_end_time=upload_end_time,
            min_upload_end_time=min_upload_end_time,
            max_upload_end_time=max_upload_end_time,
            fingerprint_status=fingerprint_status,
            inference_status=inference_status,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FileListDTO",
            '403': "ErrorResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def save_playlist_without_preload_content(
        self,
        isrc: Annotated[Optional[StrictStr], Field(description="Search for a ISRC")] = None,
        contributor: Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None,
        main_artist: Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None,
        composer: Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None,
        party_and_title: Annotated[Optional[StrictStr], Field(description="Search for party and title.")] = None,
        language: Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None,
        genre_names: Optional[List[StrictStr]] = None,
        tag_names: Optional[List[StrictStr]] = None,
        release_date: Optional[datetime] = None,
        primary_mood_cluster: Optional[StrictStr] = None,
        secondary_mood_cluster: Optional[StrictStr] = None,
        tertiary_mood_cluster: Optional[StrictStr] = None,
        valence: Optional[StrictStr] = None,
        arousal: Optional[StrictStr] = None,
        pleasantness: Optional[StrictStr] = None,
        engagement: Optional[StrictStr] = None,
        vocals: Optional[StrictStr] = None,
        dominant_instrument: Optional[StrictStr] = None,
        secondary_instrument: Optional[StrictStr] = None,
        tertiary_instrument: Optional[StrictStr] = None,
        energy: Optional[StrictStr] = None,
        sound_generation: Optional[StrictStr] = None,
        tempo: Optional[StrictStr] = None,
        scale: Optional[StrictStr] = None,
        key: Optional[StrictStr] = None,
        rhythm: Optional[StrictStr] = None,
        primary_sound_character: Optional[StrictStr] = None,
        timbre: Optional[StrictStr] = None,
        roughness: Optional[StrictStr] = None,
        tonality: Optional[StrictStr] = None,
        harmony: Optional[StrictStr] = None,
        texture: Optional[StrictStr] = None,
        groovyness: Optional[StrictStr] = None,
        space: Optional[StrictStr] = None,
        production_rating: Optional[StrictStr] = None,
        performance_rating: Optional[StrictStr] = None,
        song_rating: Optional[StrictStr] = None,
        audience_age: Optional[StrictStr] = None,
        audience_region: Optional[StrictStr] = None,
        audience_gender: Optional[StrictStr] = None,
        origin_decade: Optional[StrictStr] = None,
        curateability: Optional[StrictStr] = None,
        use_case: Optional[StrictStr] = None,
        channel_suitability: Optional[StrictStr] = None,
        similar_to_recording: Optional[StrictStr] = None,
        create_playlist_with_name: Optional[StrictStr] = None,
        songtradr_track_id: Optional[StrictStr] = None,
        usage_name: Optional[StrictStr] = None,
        bpm_min: Annotated[Optional[StrictInt], Field(description="Search for a minimal bpm.")] = None,
        bpm_max: Annotated[Optional[StrictInt], Field(description="Search for a maximal bpm.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Search for a file name.")] = None,
        folder: Annotated[Optional[StrictStr], Field(description="Search for a folder.")] = None,
        extension: Annotated[Optional[StrictStr], Field(description="Search for a file extension.")] = None,
        upload_end_time: Optional[datetime] = None,
        min_upload_end_time: Optional[datetime] = None,
        max_upload_end_time: Optional[datetime] = None,
        fingerprint_status: Annotated[Optional[StrictStr], Field(description="Search for a fingerprint status.")] = None,
        inference_status: Annotated[Optional[StrictStr], Field(description="Search for a inference status.")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List, search and create playlist of your own files.


        :param isrc: Search for a ISRC
        :type isrc: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param party_and_title: Search for party and title.
        :type party_and_title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param key:
        :type key: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param origin_decade:
        :type origin_decade: str
        :param curateability:
        :type curateability: str
        :param use_case:
        :type use_case: str
        :param channel_suitability:
        :type channel_suitability: str
        :param similar_to_recording:
        :type similar_to_recording: str
        :param create_playlist_with_name:
        :type create_playlist_with_name: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min: Search for a minimal bpm.
        :type bpm_min: int
        :param bpm_max: Search for a maximal bpm.
        :type bpm_max: int
        :param name: Search for a file name.
        :type name: str
        :param folder: Search for a folder.
        :type folder: str
        :param extension: Search for a file extension.
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status: Search for a fingerprint status.
        :type fingerprint_status: str
        :param inference_status: Search for a inference status.
        :type inference_status: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._save_playlist_serialize(
            isrc=isrc,
            contributor=contributor,
            main_artist=main_artist,
            composer=composer,
            title=title,
            party_and_title=party_and_title,
            language=language,
            genre_names=genre_names,
            tag_names=tag_names,
            release_date=release_date,
            primary_mood_cluster=primary_mood_cluster,
            secondary_mood_cluster=secondary_mood_cluster,
            tertiary_mood_cluster=tertiary_mood_cluster,
            valence=valence,
            arousal=arousal,
            pleasantness=pleasantness,
            engagement=engagement,
            vocals=vocals,
            dominant_instrument=dominant_instrument,
            secondary_instrument=secondary_instrument,
            tertiary_instrument=tertiary_instrument,
            energy=energy,
            sound_generation=sound_generation,
            tempo=tempo,
            scale=scale,
            key=key,
            rhythm=rhythm,
            primary_sound_character=primary_sound_character,
            timbre=timbre,
            roughness=roughness,
            tonality=tonality,
            harmony=harmony,
            texture=texture,
            groovyness=groovyness,
            space=space,
            production_rating=production_rating,
            performance_rating=performance_rating,
            song_rating=song_rating,
            audience_age=audience_age,
            audience_region=audience_region,
            audience_gender=audience_gender,
            origin_decade=origin_decade,
            curateability=curateability,
            use_case=use_case,
            channel_suitability=channel_suitability,
            similar_to_recording=similar_to_recording,
            create_playlist_with_name=create_playlist_with_name,
            songtradr_track_id=songtradr_track_id,
            usage_name=usage_name,
            bpm_min=bpm_min,
            bpm_max=bpm_max,
            name=name,
            folder=folder,
            extension=extension,
            upload_end_time=upload_end_time,
            min_upload_end_time=min_upload_end_time,
            max_upload_end_time=max_upload_end_time,
            fingerprint_status=fingerprint_status,
            inference_status=inference_status,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FileListDTO",
            '403': "ErrorResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _save_playlist_serialize(
        self,
        isrc,
        contributor,
        main_artist,
        composer,
        title,
        party_and_title,
        language,
        genre_names,
        tag_names,
        release_date,
        primary_mood_cluster,
        secondary_mood_cluster,
        tertiary_mood_cluster,
        valence,
        arousal,
        pleasantness,
        engagement,
        vocals,
        dominant_instrument,
        secondary_instrument,
        tertiary_instrument,
        energy,
        sound_generation,
        tempo,
        scale,
        key,
        rhythm,
        primary_sound_character,
        timbre,
        roughness,
        tonality,
        harmony,
        texture,
        groovyness,
        space,
        production_rating,
        performance_rating,
        song_rating,
        audience_age,
        audience_region,
        audience_gender,
        origin_decade,
        curateability,
        use_case,
        channel_suitability,
        similar_to_recording,
        create_playlist_with_name,
        songtradr_track_id,
        usage_name,
        bpm_min,
        bpm_max,
        name,
        folder,
        extension,
        upload_end_time,
        min_upload_end_time,
        max_upload_end_time,
        fingerprint_status,
        inference_status,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            'genreNames': 'multi',
            'tagNames': 'multi',
            'sort': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if isrc is not None:
            
            _query_params.append(('ISRC', isrc))
            
        if contributor is not None:
            
            _query_params.append(('contributor', contributor))
            
        if main_artist is not None:
            
            _query_params.append(('mainArtist', main_artist))
            
        if composer is not None:
            
            _query_params.append(('composer', composer))
            
        if title is not None:
            
            _query_params.append(('title', title))
            
        if party_and_title is not None:
            
            _query_params.append(('partyAndTitle', party_and_title))
            
        if language is not None:
            
            _query_params.append(('language', language))
            
        if genre_names is not None:
            
            _query_params.append(('genreNames', genre_names))
            
        if tag_names is not None:
            
            _query_params.append(('tagNames', tag_names))
            
        if release_date is not None:
            if isinstance(release_date, datetime):
                _query_params.append(
                    (
                        'releaseDate',
                        release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('releaseDate', release_date))
            
        if primary_mood_cluster is not None:
            
            _query_params.append(('primaryMoodCluster', primary_mood_cluster))
            
        if secondary_mood_cluster is not None:
            
            _query_params.append(('secondaryMoodCluster', secondary_mood_cluster))
            
        if tertiary_mood_cluster is not None:
            
            _query_params.append(('tertiaryMoodCluster', tertiary_mood_cluster))
            
        if valence is not None:
            
            _query_params.append(('valence', valence))
            
        if arousal is not None:
            
            _query_params.append(('arousal', arousal))
            
        if pleasantness is not None:
            
            _query_params.append(('pleasantness', pleasantness))
            
        if engagement is not None:
            
            _query_params.append(('engagement', engagement))
            
        if vocals is not None:
            
            _query_params.append(('vocals', vocals))
            
        if dominant_instrument is not None:
            
            _query_params.append(('dominantInstrument', dominant_instrument))
            
        if secondary_instrument is not None:
            
            _query_params.append(('secondaryInstrument', secondary_instrument))
            
        if tertiary_instrument is not None:
            
            _query_params.append(('tertiaryInstrument', tertiary_instrument))
            
        if energy is not None:
            
            _query_params.append(('energy', energy))
            
        if sound_generation is not None:
            
            _query_params.append(('soundGeneration', sound_generation))
            
        if tempo is not None:
            
            _query_params.append(('tempo', tempo))
            
        if scale is not None:
            
            _query_params.append(('scale', scale))
            
        if key is not None:
            
            _query_params.append(('key', key))
            
        if rhythm is not None:
            
            _query_params.append(('rhythm', rhythm))
            
        if primary_sound_character is not None:
            
            _query_params.append(('primarySoundCharacter', primary_sound_character))
            
        if timbre is not None:
            
            _query_params.append(('timbre', timbre))
            
        if roughness is not None:
            
            _query_params.append(('roughness', roughness))
            
        if tonality is not None:
            
            _query_params.append(('tonality', tonality))
            
        if harmony is not None:
            
            _query_params.append(('harmony', harmony))
            
        if texture is not None:
            
            _query_params.append(('texture', texture))
            
        if groovyness is not None:
            
            _query_params.append(('groovyness', groovyness))
            
        if space is not None:
            
            _query_params.append(('space', space))
            
        if production_rating is not None:
            
            _query_params.append(('productionRating', production_rating))
            
        if performance_rating is not None:
            
            _query_params.append(('performanceRating', performance_rating))
            
        if song_rating is not None:
            
            _query_params.append(('songRating', song_rating))
            
        if audience_age is not None:
            
            _query_params.append(('audienceAge', audience_age))
            
        if audience_region is not None:
            
            _query_params.append(('audienceRegion', audience_region))
            
        if audience_gender is not None:
            
            _query_params.append(('audienceGender', audience_gender))
            
        if origin_decade is not None:
            
            _query_params.append(('originDecade', origin_decade))
            
        if curateability is not None:
            
            _query_params.append(('curateability', curateability))
            
        if use_case is not None:
            
            _query_params.append(('useCase', use_case))
            
        if channel_suitability is not None:
            
            _query_params.append(('channelSuitability', channel_suitability))
            
        if similar_to_recording is not None:
            
            _query_params.append(('similarToRecording', similar_to_recording))
            
        if create_playlist_with_name is not None:
            
            _query_params.append(('createPlaylistWithName', create_playlist_with_name))
            
        if songtradr_track_id is not None:
            
            _query_params.append(('songtradrTrackId', songtradr_track_id))
            
        if usage_name is not None:
            
            _query_params.append(('usageName', usage_name))
            
        if bpm_min is not None:
            
            _query_params.append(('bpmMin', bpm_min))
            
        if bpm_max is not None:
            
            _query_params.append(('bpmMax', bpm_max))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if folder is not None:
            
            _query_params.append(('folder', folder))
            
        if extension is not None:
            
            _query_params.append(('extension', extension))
            
        if upload_end_time is not None:
            if isinstance(upload_end_time, datetime):
                _query_params.append(
                    (
                        'uploadEndTime',
                        upload_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('uploadEndTime', upload_end_time))
            
        if min_upload_end_time is not None:
            if isinstance(min_upload_end_time, datetime):
                _query_params.append(
                    (
                        'minUploadEndTime',
                        min_upload_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('minUploadEndTime', min_upload_end_time))
            
        if max_upload_end_time is not None:
            if isinstance(max_upload_end_time, datetime):
                _query_params.append(
                    (
                        'maxUploadEndTime',
                        max_upload_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('maxUploadEndTime', max_upload_end_time))
            
        if fingerprint_status is not None:
            
            _query_params.append(('fingerprintStatus', fingerprint_status))
            
        if inference_status is not None:
            
            _query_params.append(('inferenceStatus', inference_status))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if size is not None:
            
            _query_params.append(('size', size))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/user/savePlaylist',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def sign_up(
        self,
        save_user_dto: SaveUserDTO,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SignUpDTO:
        """Sign up a new user.


        :param save_user_dto: (required)
        :type save_user_dto: SaveUserDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sign_up_serialize(
            save_user_dto=save_user_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '409': "ErrorResponse",
            '200': "SignUpDTO",
            '403': "ErrorResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def sign_up_with_http_info(
        self,
        save_user_dto: SaveUserDTO,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SignUpDTO]:
        """Sign up a new user.


        :param save_user_dto: (required)
        :type save_user_dto: SaveUserDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sign_up_serialize(
            save_user_dto=save_user_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '409': "ErrorResponse",
            '200': "SignUpDTO",
            '403': "ErrorResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def sign_up_without_preload_content(
        self,
        save_user_dto: SaveUserDTO,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Sign up a new user.


        :param save_user_dto: (required)
        :type save_user_dto: SaveUserDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sign_up_serialize(
            save_user_dto=save_user_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '409': "ErrorResponse",
            '200': "SignUpDTO",
            '403': "ErrorResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _sign_up_serialize(
        self,
        save_user_dto,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if save_user_dto is not None:
            _body_params = save_user_dto


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/user/sign-up',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def token(
        self,
        token_request: TokenRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> JwtTokenDTO:
        """Generates a new JWT token for the given refresh token


        :param token_request: (required)
        :type token_request: TokenRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._token_serialize(
            token_request=token_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JwtTokenDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def token_with_http_info(
        self,
        token_request: TokenRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[JwtTokenDTO]:
        """Generates a new JWT token for the given refresh token


        :param token_request: (required)
        :type token_request: TokenRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._token_serialize(
            token_request=token_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JwtTokenDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def token_without_preload_content(
        self,
        token_request: TokenRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Generates a new JWT token for the given refresh token


        :param token_request: (required)
        :type token_request: TokenRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._token_serialize(
            token_request=token_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "JwtTokenDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _token_serialize(
        self,
        token_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if token_request is not None:
            _body_params = token_request


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/user/token',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_password(
        self,
        update_password_dto: UpdatePasswordDTO,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Update password by using the password reset token


        :param update_password_dto: (required)
        :type update_password_dto: UpdatePasswordDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_password_serialize(
            update_password_dto=update_password_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_password_with_http_info(
        self,
        update_password_dto: UpdatePasswordDTO,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Update password by using the password reset token


        :param update_password_dto: (required)
        :type update_password_dto: UpdatePasswordDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_password_serialize(
            update_password_dto=update_password_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_password_without_preload_content(
        self,
        update_password_dto: UpdatePasswordDTO,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update password by using the password reset token


        :param update_password_dto: (required)
        :type update_password_dto: UpdatePasswordDTO
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_password_serialize(
            update_password_dto=update_password_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': "object",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_password_serialize(
        self,
        update_password_dto,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_password_dto is not None:
            _body_params = update_password_dto


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/hal+json', 
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/user/update-password',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def user_file(
        self,
        object_key: Annotated[StrictStr, Field(description="ObjectKey of the file that should be edited.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FileWIthUrlDTO:
        """Details and a download link for a file.


        :param object_key: ObjectKey of the file that should be edited. (required)
        :type object_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._user_file_serialize(
            object_key=object_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FileWIthUrlDTO",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def user_file_with_http_info(
        self,
        object_key: Annotated[StrictStr, Field(description="ObjectKey of the file that should be edited.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FileWIthUrlDTO]:
        """Details and a download link for a file.


        :param object_key: ObjectKey of the file that should be edited. (required)
        :type object_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._user_file_serialize(
            object_key=object_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FileWIthUrlDTO",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def user_file_without_preload_content(
        self,
        object_key: Annotated[StrictStr, Field(description="ObjectKey of the file that should be edited.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Details and a download link for a file.


        :param object_key: ObjectKey of the file that should be edited. (required)
        :type object_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._user_file_serialize(
            object_key=object_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FileWIthUrlDTO",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _user_file_serialize(
        self,
        object_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if object_key is not None:
            _path_params['objectKey'] = object_key
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/user/file/{objectKey}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def user_files(
        self,
        isrc: Annotated[Optional[StrictStr], Field(description="Search for a ISRC")] = None,
        contributor: Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None,
        main_artist: Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None,
        composer: Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None,
        party_and_title: Annotated[Optional[StrictStr], Field(description="Search for party and title.")] = None,
        language: Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None,
        genre_names: Optional[List[StrictStr]] = None,
        tag_names: Optional[List[StrictStr]] = None,
        release_date: Optional[datetime] = None,
        primary_mood_cluster: Optional[StrictStr] = None,
        secondary_mood_cluster: Optional[StrictStr] = None,
        tertiary_mood_cluster: Optional[StrictStr] = None,
        valence: Optional[StrictStr] = None,
        arousal: Optional[StrictStr] = None,
        pleasantness: Optional[StrictStr] = None,
        engagement: Optional[StrictStr] = None,
        vocals: Optional[StrictStr] = None,
        dominant_instrument: Optional[StrictStr] = None,
        secondary_instrument: Optional[StrictStr] = None,
        tertiary_instrument: Optional[StrictStr] = None,
        energy: Optional[StrictStr] = None,
        sound_generation: Optional[StrictStr] = None,
        tempo: Optional[StrictStr] = None,
        scale: Optional[StrictStr] = None,
        key: Optional[StrictStr] = None,
        rhythm: Optional[StrictStr] = None,
        primary_sound_character: Optional[StrictStr] = None,
        timbre: Optional[StrictStr] = None,
        roughness: Optional[StrictStr] = None,
        tonality: Optional[StrictStr] = None,
        harmony: Optional[StrictStr] = None,
        texture: Optional[StrictStr] = None,
        groovyness: Optional[StrictStr] = None,
        space: Optional[StrictStr] = None,
        production_rating: Optional[StrictStr] = None,
        performance_rating: Optional[StrictStr] = None,
        song_rating: Optional[StrictStr] = None,
        audience_age: Optional[StrictStr] = None,
        audience_region: Optional[StrictStr] = None,
        audience_gender: Optional[StrictStr] = None,
        origin_decade: Optional[StrictStr] = None,
        curateability: Optional[StrictStr] = None,
        use_case: Optional[StrictStr] = None,
        channel_suitability: Optional[StrictStr] = None,
        similar_to_recording: Optional[StrictStr] = None,
        songtradr_track_id: Optional[StrictStr] = None,
        usage_name: Optional[StrictStr] = None,
        bpm_min: Annotated[Optional[StrictInt], Field(description="Search for a minimal bpm.")] = None,
        bpm_max: Annotated[Optional[StrictInt], Field(description="Search for a maximal bpm.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Search for a file name.")] = None,
        folder: Annotated[Optional[StrictStr], Field(description="Search for a folder.")] = None,
        extension: Annotated[Optional[StrictStr], Field(description="Search for a file extension.")] = None,
        upload_end_time: Optional[datetime] = None,
        min_upload_end_time: Optional[datetime] = None,
        max_upload_end_time: Optional[datetime] = None,
        fingerprint_status: Annotated[Optional[StrictStr], Field(description="Search for a fingerprint status.")] = None,
        inference_status: Annotated[Optional[StrictStr], Field(description="Search for a inference status.")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FileListDTO:
        """List and search your own files.


        :param isrc: Search for a ISRC
        :type isrc: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param party_and_title: Search for party and title.
        :type party_and_title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param key:
        :type key: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param origin_decade:
        :type origin_decade: str
        :param curateability:
        :type curateability: str
        :param use_case:
        :type use_case: str
        :param channel_suitability:
        :type channel_suitability: str
        :param similar_to_recording:
        :type similar_to_recording: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min: Search for a minimal bpm.
        :type bpm_min: int
        :param bpm_max: Search for a maximal bpm.
        :type bpm_max: int
        :param name: Search for a file name.
        :type name: str
        :param folder: Search for a folder.
        :type folder: str
        :param extension: Search for a file extension.
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status: Search for a fingerprint status.
        :type fingerprint_status: str
        :param inference_status: Search for a inference status.
        :type inference_status: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._user_files_serialize(
            isrc=isrc,
            contributor=contributor,
            main_artist=main_artist,
            composer=composer,
            title=title,
            party_and_title=party_and_title,
            language=language,
            genre_names=genre_names,
            tag_names=tag_names,
            release_date=release_date,
            primary_mood_cluster=primary_mood_cluster,
            secondary_mood_cluster=secondary_mood_cluster,
            tertiary_mood_cluster=tertiary_mood_cluster,
            valence=valence,
            arousal=arousal,
            pleasantness=pleasantness,
            engagement=engagement,
            vocals=vocals,
            dominant_instrument=dominant_instrument,
            secondary_instrument=secondary_instrument,
            tertiary_instrument=tertiary_instrument,
            energy=energy,
            sound_generation=sound_generation,
            tempo=tempo,
            scale=scale,
            key=key,
            rhythm=rhythm,
            primary_sound_character=primary_sound_character,
            timbre=timbre,
            roughness=roughness,
            tonality=tonality,
            harmony=harmony,
            texture=texture,
            groovyness=groovyness,
            space=space,
            production_rating=production_rating,
            performance_rating=performance_rating,
            song_rating=song_rating,
            audience_age=audience_age,
            audience_region=audience_region,
            audience_gender=audience_gender,
            origin_decade=origin_decade,
            curateability=curateability,
            use_case=use_case,
            channel_suitability=channel_suitability,
            similar_to_recording=similar_to_recording,
            songtradr_track_id=songtradr_track_id,
            usage_name=usage_name,
            bpm_min=bpm_min,
            bpm_max=bpm_max,
            name=name,
            folder=folder,
            extension=extension,
            upload_end_time=upload_end_time,
            min_upload_end_time=min_upload_end_time,
            max_upload_end_time=max_upload_end_time,
            fingerprint_status=fingerprint_status,
            inference_status=inference_status,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FileListDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def user_files_with_http_info(
        self,
        isrc: Annotated[Optional[StrictStr], Field(description="Search for a ISRC")] = None,
        contributor: Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None,
        main_artist: Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None,
        composer: Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None,
        party_and_title: Annotated[Optional[StrictStr], Field(description="Search for party and title.")] = None,
        language: Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None,
        genre_names: Optional[List[StrictStr]] = None,
        tag_names: Optional[List[StrictStr]] = None,
        release_date: Optional[datetime] = None,
        primary_mood_cluster: Optional[StrictStr] = None,
        secondary_mood_cluster: Optional[StrictStr] = None,
        tertiary_mood_cluster: Optional[StrictStr] = None,
        valence: Optional[StrictStr] = None,
        arousal: Optional[StrictStr] = None,
        pleasantness: Optional[StrictStr] = None,
        engagement: Optional[StrictStr] = None,
        vocals: Optional[StrictStr] = None,
        dominant_instrument: Optional[StrictStr] = None,
        secondary_instrument: Optional[StrictStr] = None,
        tertiary_instrument: Optional[StrictStr] = None,
        energy: Optional[StrictStr] = None,
        sound_generation: Optional[StrictStr] = None,
        tempo: Optional[StrictStr] = None,
        scale: Optional[StrictStr] = None,
        key: Optional[StrictStr] = None,
        rhythm: Optional[StrictStr] = None,
        primary_sound_character: Optional[StrictStr] = None,
        timbre: Optional[StrictStr] = None,
        roughness: Optional[StrictStr] = None,
        tonality: Optional[StrictStr] = None,
        harmony: Optional[StrictStr] = None,
        texture: Optional[StrictStr] = None,
        groovyness: Optional[StrictStr] = None,
        space: Optional[StrictStr] = None,
        production_rating: Optional[StrictStr] = None,
        performance_rating: Optional[StrictStr] = None,
        song_rating: Optional[StrictStr] = None,
        audience_age: Optional[StrictStr] = None,
        audience_region: Optional[StrictStr] = None,
        audience_gender: Optional[StrictStr] = None,
        origin_decade: Optional[StrictStr] = None,
        curateability: Optional[StrictStr] = None,
        use_case: Optional[StrictStr] = None,
        channel_suitability: Optional[StrictStr] = None,
        similar_to_recording: Optional[StrictStr] = None,
        songtradr_track_id: Optional[StrictStr] = None,
        usage_name: Optional[StrictStr] = None,
        bpm_min: Annotated[Optional[StrictInt], Field(description="Search for a minimal bpm.")] = None,
        bpm_max: Annotated[Optional[StrictInt], Field(description="Search for a maximal bpm.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Search for a file name.")] = None,
        folder: Annotated[Optional[StrictStr], Field(description="Search for a folder.")] = None,
        extension: Annotated[Optional[StrictStr], Field(description="Search for a file extension.")] = None,
        upload_end_time: Optional[datetime] = None,
        min_upload_end_time: Optional[datetime] = None,
        max_upload_end_time: Optional[datetime] = None,
        fingerprint_status: Annotated[Optional[StrictStr], Field(description="Search for a fingerprint status.")] = None,
        inference_status: Annotated[Optional[StrictStr], Field(description="Search for a inference status.")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FileListDTO]:
        """List and search your own files.


        :param isrc: Search for a ISRC
        :type isrc: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param party_and_title: Search for party and title.
        :type party_and_title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param key:
        :type key: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param origin_decade:
        :type origin_decade: str
        :param curateability:
        :type curateability: str
        :param use_case:
        :type use_case: str
        :param channel_suitability:
        :type channel_suitability: str
        :param similar_to_recording:
        :type similar_to_recording: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min: Search for a minimal bpm.
        :type bpm_min: int
        :param bpm_max: Search for a maximal bpm.
        :type bpm_max: int
        :param name: Search for a file name.
        :type name: str
        :param folder: Search for a folder.
        :type folder: str
        :param extension: Search for a file extension.
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status: Search for a fingerprint status.
        :type fingerprint_status: str
        :param inference_status: Search for a inference status.
        :type inference_status: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._user_files_serialize(
            isrc=isrc,
            contributor=contributor,
            main_artist=main_artist,
            composer=composer,
            title=title,
            party_and_title=party_and_title,
            language=language,
            genre_names=genre_names,
            tag_names=tag_names,
            release_date=release_date,
            primary_mood_cluster=primary_mood_cluster,
            secondary_mood_cluster=secondary_mood_cluster,
            tertiary_mood_cluster=tertiary_mood_cluster,
            valence=valence,
            arousal=arousal,
            pleasantness=pleasantness,
            engagement=engagement,
            vocals=vocals,
            dominant_instrument=dominant_instrument,
            secondary_instrument=secondary_instrument,
            tertiary_instrument=tertiary_instrument,
            energy=energy,
            sound_generation=sound_generation,
            tempo=tempo,
            scale=scale,
            key=key,
            rhythm=rhythm,
            primary_sound_character=primary_sound_character,
            timbre=timbre,
            roughness=roughness,
            tonality=tonality,
            harmony=harmony,
            texture=texture,
            groovyness=groovyness,
            space=space,
            production_rating=production_rating,
            performance_rating=performance_rating,
            song_rating=song_rating,
            audience_age=audience_age,
            audience_region=audience_region,
            audience_gender=audience_gender,
            origin_decade=origin_decade,
            curateability=curateability,
            use_case=use_case,
            channel_suitability=channel_suitability,
            similar_to_recording=similar_to_recording,
            songtradr_track_id=songtradr_track_id,
            usage_name=usage_name,
            bpm_min=bpm_min,
            bpm_max=bpm_max,
            name=name,
            folder=folder,
            extension=extension,
            upload_end_time=upload_end_time,
            min_upload_end_time=min_upload_end_time,
            max_upload_end_time=max_upload_end_time,
            fingerprint_status=fingerprint_status,
            inference_status=inference_status,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FileListDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def user_files_without_preload_content(
        self,
        isrc: Annotated[Optional[StrictStr], Field(description="Search for a ISRC")] = None,
        contributor: Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None,
        main_artist: Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None,
        composer: Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None,
        party_and_title: Annotated[Optional[StrictStr], Field(description="Search for party and title.")] = None,
        language: Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None,
        genre_names: Optional[List[StrictStr]] = None,
        tag_names: Optional[List[StrictStr]] = None,
        release_date: Optional[datetime] = None,
        primary_mood_cluster: Optional[StrictStr] = None,
        secondary_mood_cluster: Optional[StrictStr] = None,
        tertiary_mood_cluster: Optional[StrictStr] = None,
        valence: Optional[StrictStr] = None,
        arousal: Optional[StrictStr] = None,
        pleasantness: Optional[StrictStr] = None,
        engagement: Optional[StrictStr] = None,
        vocals: Optional[StrictStr] = None,
        dominant_instrument: Optional[StrictStr] = None,
        secondary_instrument: Optional[StrictStr] = None,
        tertiary_instrument: Optional[StrictStr] = None,
        energy: Optional[StrictStr] = None,
        sound_generation: Optional[StrictStr] = None,
        tempo: Optional[StrictStr] = None,
        scale: Optional[StrictStr] = None,
        key: Optional[StrictStr] = None,
        rhythm: Optional[StrictStr] = None,
        primary_sound_character: Optional[StrictStr] = None,
        timbre: Optional[StrictStr] = None,
        roughness: Optional[StrictStr] = None,
        tonality: Optional[StrictStr] = None,
        harmony: Optional[StrictStr] = None,
        texture: Optional[StrictStr] = None,
        groovyness: Optional[StrictStr] = None,
        space: Optional[StrictStr] = None,
        production_rating: Optional[StrictStr] = None,
        performance_rating: Optional[StrictStr] = None,
        song_rating: Optional[StrictStr] = None,
        audience_age: Optional[StrictStr] = None,
        audience_region: Optional[StrictStr] = None,
        audience_gender: Optional[StrictStr] = None,
        origin_decade: Optional[StrictStr] = None,
        curateability: Optional[StrictStr] = None,
        use_case: Optional[StrictStr] = None,
        channel_suitability: Optional[StrictStr] = None,
        similar_to_recording: Optional[StrictStr] = None,
        songtradr_track_id: Optional[StrictStr] = None,
        usage_name: Optional[StrictStr] = None,
        bpm_min: Annotated[Optional[StrictInt], Field(description="Search for a minimal bpm.")] = None,
        bpm_max: Annotated[Optional[StrictInt], Field(description="Search for a maximal bpm.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Search for a file name.")] = None,
        folder: Annotated[Optional[StrictStr], Field(description="Search for a folder.")] = None,
        extension: Annotated[Optional[StrictStr], Field(description="Search for a file extension.")] = None,
        upload_end_time: Optional[datetime] = None,
        min_upload_end_time: Optional[datetime] = None,
        max_upload_end_time: Optional[datetime] = None,
        fingerprint_status: Annotated[Optional[StrictStr], Field(description="Search for a fingerprint status.")] = None,
        inference_status: Annotated[Optional[StrictStr], Field(description="Search for a inference status.")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List and search your own files.


        :param isrc: Search for a ISRC
        :type isrc: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param party_and_title: Search for party and title.
        :type party_and_title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param key:
        :type key: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param origin_decade:
        :type origin_decade: str
        :param curateability:
        :type curateability: str
        :param use_case:
        :type use_case: str
        :param channel_suitability:
        :type channel_suitability: str
        :param similar_to_recording:
        :type similar_to_recording: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min: Search for a minimal bpm.
        :type bpm_min: int
        :param bpm_max: Search for a maximal bpm.
        :type bpm_max: int
        :param name: Search for a file name.
        :type name: str
        :param folder: Search for a folder.
        :type folder: str
        :param extension: Search for a file extension.
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status: Search for a fingerprint status.
        :type fingerprint_status: str
        :param inference_status: Search for a inference status.
        :type inference_status: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._user_files_serialize(
            isrc=isrc,
            contributor=contributor,
            main_artist=main_artist,
            composer=composer,
            title=title,
            party_and_title=party_and_title,
            language=language,
            genre_names=genre_names,
            tag_names=tag_names,
            release_date=release_date,
            primary_mood_cluster=primary_mood_cluster,
            secondary_mood_cluster=secondary_mood_cluster,
            tertiary_mood_cluster=tertiary_mood_cluster,
            valence=valence,
            arousal=arousal,
            pleasantness=pleasantness,
            engagement=engagement,
            vocals=vocals,
            dominant_instrument=dominant_instrument,
            secondary_instrument=secondary_instrument,
            tertiary_instrument=tertiary_instrument,
            energy=energy,
            sound_generation=sound_generation,
            tempo=tempo,
            scale=scale,
            key=key,
            rhythm=rhythm,
            primary_sound_character=primary_sound_character,
            timbre=timbre,
            roughness=roughness,
            tonality=tonality,
            harmony=harmony,
            texture=texture,
            groovyness=groovyness,
            space=space,
            production_rating=production_rating,
            performance_rating=performance_rating,
            song_rating=song_rating,
            audience_age=audience_age,
            audience_region=audience_region,
            audience_gender=audience_gender,
            origin_decade=origin_decade,
            curateability=curateability,
            use_case=use_case,
            channel_suitability=channel_suitability,
            similar_to_recording=similar_to_recording,
            songtradr_track_id=songtradr_track_id,
            usage_name=usage_name,
            bpm_min=bpm_min,
            bpm_max=bpm_max,
            name=name,
            folder=folder,
            extension=extension,
            upload_end_time=upload_end_time,
            min_upload_end_time=min_upload_end_time,
            max_upload_end_time=max_upload_end_time,
            fingerprint_status=fingerprint_status,
            inference_status=inference_status,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FileListDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _user_files_serialize(
        self,
        isrc,
        contributor,
        main_artist,
        composer,
        title,
        party_and_title,
        language,
        genre_names,
        tag_names,
        release_date,
        primary_mood_cluster,
        secondary_mood_cluster,
        tertiary_mood_cluster,
        valence,
        arousal,
        pleasantness,
        engagement,
        vocals,
        dominant_instrument,
        secondary_instrument,
        tertiary_instrument,
        energy,
        sound_generation,
        tempo,
        scale,
        key,
        rhythm,
        primary_sound_character,
        timbre,
        roughness,
        tonality,
        harmony,
        texture,
        groovyness,
        space,
        production_rating,
        performance_rating,
        song_rating,
        audience_age,
        audience_region,
        audience_gender,
        origin_decade,
        curateability,
        use_case,
        channel_suitability,
        similar_to_recording,
        songtradr_track_id,
        usage_name,
        bpm_min,
        bpm_max,
        name,
        folder,
        extension,
        upload_end_time,
        min_upload_end_time,
        max_upload_end_time,
        fingerprint_status,
        inference_status,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            'genreNames': 'multi',
            'tagNames': 'multi',
            'sort': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if isrc is not None:
            
            _query_params.append(('ISRC', isrc))
            
        if contributor is not None:
            
            _query_params.append(('contributor', contributor))
            
        if main_artist is not None:
            
            _query_params.append(('mainArtist', main_artist))
            
        if composer is not None:
            
            _query_params.append(('composer', composer))
            
        if title is not None:
            
            _query_params.append(('title', title))
            
        if party_and_title is not None:
            
            _query_params.append(('partyAndTitle', party_and_title))
            
        if language is not None:
            
            _query_params.append(('language', language))
            
        if genre_names is not None:
            
            _query_params.append(('genreNames', genre_names))
            
        if tag_names is not None:
            
            _query_params.append(('tagNames', tag_names))
            
        if release_date is not None:
            if isinstance(release_date, datetime):
                _query_params.append(
                    (
                        'releaseDate',
                        release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('releaseDate', release_date))
            
        if primary_mood_cluster is not None:
            
            _query_params.append(('primaryMoodCluster', primary_mood_cluster))
            
        if secondary_mood_cluster is not None:
            
            _query_params.append(('secondaryMoodCluster', secondary_mood_cluster))
            
        if tertiary_mood_cluster is not None:
            
            _query_params.append(('tertiaryMoodCluster', tertiary_mood_cluster))
            
        if valence is not None:
            
            _query_params.append(('valence', valence))
            
        if arousal is not None:
            
            _query_params.append(('arousal', arousal))
            
        if pleasantness is not None:
            
            _query_params.append(('pleasantness', pleasantness))
            
        if engagement is not None:
            
            _query_params.append(('engagement', engagement))
            
        if vocals is not None:
            
            _query_params.append(('vocals', vocals))
            
        if dominant_instrument is not None:
            
            _query_params.append(('dominantInstrument', dominant_instrument))
            
        if secondary_instrument is not None:
            
            _query_params.append(('secondaryInstrument', secondary_instrument))
            
        if tertiary_instrument is not None:
            
            _query_params.append(('tertiaryInstrument', tertiary_instrument))
            
        if energy is not None:
            
            _query_params.append(('energy', energy))
            
        if sound_generation is not None:
            
            _query_params.append(('soundGeneration', sound_generation))
            
        if tempo is not None:
            
            _query_params.append(('tempo', tempo))
            
        if scale is not None:
            
            _query_params.append(('scale', scale))
            
        if key is not None:
            
            _query_params.append(('key', key))
            
        if rhythm is not None:
            
            _query_params.append(('rhythm', rhythm))
            
        if primary_sound_character is not None:
            
            _query_params.append(('primarySoundCharacter', primary_sound_character))
            
        if timbre is not None:
            
            _query_params.append(('timbre', timbre))
            
        if roughness is not None:
            
            _query_params.append(('roughness', roughness))
            
        if tonality is not None:
            
            _query_params.append(('tonality', tonality))
            
        if harmony is not None:
            
            _query_params.append(('harmony', harmony))
            
        if texture is not None:
            
            _query_params.append(('texture', texture))
            
        if groovyness is not None:
            
            _query_params.append(('groovyness', groovyness))
            
        if space is not None:
            
            _query_params.append(('space', space))
            
        if production_rating is not None:
            
            _query_params.append(('productionRating', production_rating))
            
        if performance_rating is not None:
            
            _query_params.append(('performanceRating', performance_rating))
            
        if song_rating is not None:
            
            _query_params.append(('songRating', song_rating))
            
        if audience_age is not None:
            
            _query_params.append(('audienceAge', audience_age))
            
        if audience_region is not None:
            
            _query_params.append(('audienceRegion', audience_region))
            
        if audience_gender is not None:
            
            _query_params.append(('audienceGender', audience_gender))
            
        if origin_decade is not None:
            
            _query_params.append(('originDecade', origin_decade))
            
        if curateability is not None:
            
            _query_params.append(('curateability', curateability))
            
        if use_case is not None:
            
            _query_params.append(('useCase', use_case))
            
        if channel_suitability is not None:
            
            _query_params.append(('channelSuitability', channel_suitability))
            
        if similar_to_recording is not None:
            
            _query_params.append(('similarToRecording', similar_to_recording))
            
        if songtradr_track_id is not None:
            
            _query_params.append(('songtradrTrackId', songtradr_track_id))
            
        if usage_name is not None:
            
            _query_params.append(('usageName', usage_name))
            
        if bpm_min is not None:
            
            _query_params.append(('bpmMin', bpm_min))
            
        if bpm_max is not None:
            
            _query_params.append(('bpmMax', bpm_max))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if folder is not None:
            
            _query_params.append(('folder', folder))
            
        if extension is not None:
            
            _query_params.append(('extension', extension))
            
        if upload_end_time is not None:
            if isinstance(upload_end_time, datetime):
                _query_params.append(
                    (
                        'uploadEndTime',
                        upload_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('uploadEndTime', upload_end_time))
            
        if min_upload_end_time is not None:
            if isinstance(min_upload_end_time, datetime):
                _query_params.append(
                    (
                        'minUploadEndTime',
                        min_upload_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('minUploadEndTime', min_upload_end_time))
            
        if max_upload_end_time is not None:
            if isinstance(max_upload_end_time, datetime):
                _query_params.append(
                    (
                        'maxUploadEndTime',
                        max_upload_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('maxUploadEndTime', max_upload_end_time))
            
        if fingerprint_status is not None:
            
            _query_params.append(('fingerprintStatus', fingerprint_status))
            
        if inference_status is not None:
            
            _query_params.append(('inferenceStatus', inference_status))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if size is not None:
            
            _query_params.append(('size', size))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/user/files',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def user_files_status(
        self,
        object_keys: Annotated[StrictStr, Field(description="Comma-separated  list of objectKeys of the files.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[FileSmallDTO]:
        """Status details for files.


        :param object_keys: Comma-separated  list of objectKeys of the files. (required)
        :type object_keys: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._user_files_status_serialize(
            object_keys=object_keys,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '400': "ErrorResponse",
            '200': "List[FileSmallDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def user_files_status_with_http_info(
        self,
        object_keys: Annotated[StrictStr, Field(description="Comma-separated  list of objectKeys of the files.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[FileSmallDTO]]:
        """Status details for files.


        :param object_keys: Comma-separated  list of objectKeys of the files. (required)
        :type object_keys: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._user_files_status_serialize(
            object_keys=object_keys,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '400': "ErrorResponse",
            '200': "List[FileSmallDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def user_files_status_without_preload_content(
        self,
        object_keys: Annotated[StrictStr, Field(description="Comma-separated  list of objectKeys of the files.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Status details for files.


        :param object_keys: Comma-separated  list of objectKeys of the files. (required)
        :type object_keys: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._user_files_status_serialize(
            object_keys=object_keys,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '400': "ErrorResponse",
            '200': "List[FileSmallDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _user_files_status_serialize(
        self,
        object_keys,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if object_keys is not None:
            
            _query_params.append(('objectKeys', object_keys))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/user/filesStatus',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def user_files_summary(
        self,
        isrc: Annotated[Optional[StrictStr], Field(description="Search for a ISRC")] = None,
        contributor: Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None,
        main_artist: Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None,
        composer: Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None,
        language: Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None,
        genre_names: Optional[List[StrictStr]] = None,
        tag_names: Optional[List[StrictStr]] = None,
        release_date: Optional[datetime] = None,
        primary_mood_cluster: Optional[StrictStr] = None,
        secondary_mood_cluster: Optional[StrictStr] = None,
        tertiary_mood_cluster: Optional[StrictStr] = None,
        valence: Optional[StrictStr] = None,
        arousal: Optional[StrictStr] = None,
        pleasantness: Optional[StrictStr] = None,
        engagement: Optional[StrictStr] = None,
        vocals: Optional[StrictStr] = None,
        dominant_instrument: Optional[StrictStr] = None,
        secondary_instrument: Optional[StrictStr] = None,
        tertiary_instrument: Optional[StrictStr] = None,
        energy: Optional[StrictStr] = None,
        sound_generation: Optional[StrictStr] = None,
        tempo: Optional[StrictStr] = None,
        scale: Optional[StrictStr] = None,
        key: Optional[StrictStr] = None,
        rhythm: Optional[StrictStr] = None,
        primary_sound_character: Optional[StrictStr] = None,
        timbre: Optional[StrictStr] = None,
        roughness: Optional[StrictStr] = None,
        tonality: Optional[StrictStr] = None,
        harmony: Optional[StrictStr] = None,
        texture: Optional[StrictStr] = None,
        groovyness: Optional[StrictStr] = None,
        space: Optional[StrictStr] = None,
        production_rating: Optional[StrictStr] = None,
        performance_rating: Optional[StrictStr] = None,
        song_rating: Optional[StrictStr] = None,
        audience_age: Optional[StrictStr] = None,
        audience_region: Optional[StrictStr] = None,
        audience_gender: Optional[StrictStr] = None,
        origin_decade: Optional[StrictStr] = None,
        curateability: Optional[StrictStr] = None,
        use_case: Optional[StrictStr] = None,
        channel_suitability: Optional[StrictStr] = None,
        similar_to_recording: Optional[StrictStr] = None,
        songtradr_track_id: Optional[StrictStr] = None,
        usage_name: Optional[StrictStr] = None,
        bpm_min: Annotated[Optional[StrictInt], Field(description="Search for a minimal bpm.")] = None,
        bpm_max: Annotated[Optional[StrictInt], Field(description="Search for a maximal bpm.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Search for a file name.")] = None,
        folder: Annotated[Optional[StrictStr], Field(description="Search for a folder.")] = None,
        extension: Annotated[Optional[StrictStr], Field(description="Search for a file extension.")] = None,
        upload_end_time: Optional[datetime] = None,
        min_upload_end_time: Optional[datetime] = None,
        max_upload_end_time: Optional[datetime] = None,
        fingerprint_status: Annotated[Optional[StrictStr], Field(description="Search for a fingerprint status.")] = None,
        inference_status: Annotated[Optional[StrictStr], Field(description="Search for a inference status.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FilesSummaryDTO:
        """Summary fo your files.


        :param isrc: Search for a ISRC
        :type isrc: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param key:
        :type key: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param origin_decade:
        :type origin_decade: str
        :param curateability:
        :type curateability: str
        :param use_case:
        :type use_case: str
        :param channel_suitability:
        :type channel_suitability: str
        :param similar_to_recording:
        :type similar_to_recording: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min: Search for a minimal bpm.
        :type bpm_min: int
        :param bpm_max: Search for a maximal bpm.
        :type bpm_max: int
        :param name: Search for a file name.
        :type name: str
        :param folder: Search for a folder.
        :type folder: str
        :param extension: Search for a file extension.
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status: Search for a fingerprint status.
        :type fingerprint_status: str
        :param inference_status: Search for a inference status.
        :type inference_status: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._user_files_summary_serialize(
            isrc=isrc,
            contributor=contributor,
            main_artist=main_artist,
            composer=composer,
            title=title,
            language=language,
            genre_names=genre_names,
            tag_names=tag_names,
            release_date=release_date,
            primary_mood_cluster=primary_mood_cluster,
            secondary_mood_cluster=secondary_mood_cluster,
            tertiary_mood_cluster=tertiary_mood_cluster,
            valence=valence,
            arousal=arousal,
            pleasantness=pleasantness,
            engagement=engagement,
            vocals=vocals,
            dominant_instrument=dominant_instrument,
            secondary_instrument=secondary_instrument,
            tertiary_instrument=tertiary_instrument,
            energy=energy,
            sound_generation=sound_generation,
            tempo=tempo,
            scale=scale,
            key=key,
            rhythm=rhythm,
            primary_sound_character=primary_sound_character,
            timbre=timbre,
            roughness=roughness,
            tonality=tonality,
            harmony=harmony,
            texture=texture,
            groovyness=groovyness,
            space=space,
            production_rating=production_rating,
            performance_rating=performance_rating,
            song_rating=song_rating,
            audience_age=audience_age,
            audience_region=audience_region,
            audience_gender=audience_gender,
            origin_decade=origin_decade,
            curateability=curateability,
            use_case=use_case,
            channel_suitability=channel_suitability,
            similar_to_recording=similar_to_recording,
            songtradr_track_id=songtradr_track_id,
            usage_name=usage_name,
            bpm_min=bpm_min,
            bpm_max=bpm_max,
            name=name,
            folder=folder,
            extension=extension,
            upload_end_time=upload_end_time,
            min_upload_end_time=min_upload_end_time,
            max_upload_end_time=max_upload_end_time,
            fingerprint_status=fingerprint_status,
            inference_status=inference_status,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FilesSummaryDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def user_files_summary_with_http_info(
        self,
        isrc: Annotated[Optional[StrictStr], Field(description="Search for a ISRC")] = None,
        contributor: Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None,
        main_artist: Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None,
        composer: Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None,
        language: Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None,
        genre_names: Optional[List[StrictStr]] = None,
        tag_names: Optional[List[StrictStr]] = None,
        release_date: Optional[datetime] = None,
        primary_mood_cluster: Optional[StrictStr] = None,
        secondary_mood_cluster: Optional[StrictStr] = None,
        tertiary_mood_cluster: Optional[StrictStr] = None,
        valence: Optional[StrictStr] = None,
        arousal: Optional[StrictStr] = None,
        pleasantness: Optional[StrictStr] = None,
        engagement: Optional[StrictStr] = None,
        vocals: Optional[StrictStr] = None,
        dominant_instrument: Optional[StrictStr] = None,
        secondary_instrument: Optional[StrictStr] = None,
        tertiary_instrument: Optional[StrictStr] = None,
        energy: Optional[StrictStr] = None,
        sound_generation: Optional[StrictStr] = None,
        tempo: Optional[StrictStr] = None,
        scale: Optional[StrictStr] = None,
        key: Optional[StrictStr] = None,
        rhythm: Optional[StrictStr] = None,
        primary_sound_character: Optional[StrictStr] = None,
        timbre: Optional[StrictStr] = None,
        roughness: Optional[StrictStr] = None,
        tonality: Optional[StrictStr] = None,
        harmony: Optional[StrictStr] = None,
        texture: Optional[StrictStr] = None,
        groovyness: Optional[StrictStr] = None,
        space: Optional[StrictStr] = None,
        production_rating: Optional[StrictStr] = None,
        performance_rating: Optional[StrictStr] = None,
        song_rating: Optional[StrictStr] = None,
        audience_age: Optional[StrictStr] = None,
        audience_region: Optional[StrictStr] = None,
        audience_gender: Optional[StrictStr] = None,
        origin_decade: Optional[StrictStr] = None,
        curateability: Optional[StrictStr] = None,
        use_case: Optional[StrictStr] = None,
        channel_suitability: Optional[StrictStr] = None,
        similar_to_recording: Optional[StrictStr] = None,
        songtradr_track_id: Optional[StrictStr] = None,
        usage_name: Optional[StrictStr] = None,
        bpm_min: Annotated[Optional[StrictInt], Field(description="Search for a minimal bpm.")] = None,
        bpm_max: Annotated[Optional[StrictInt], Field(description="Search for a maximal bpm.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Search for a file name.")] = None,
        folder: Annotated[Optional[StrictStr], Field(description="Search for a folder.")] = None,
        extension: Annotated[Optional[StrictStr], Field(description="Search for a file extension.")] = None,
        upload_end_time: Optional[datetime] = None,
        min_upload_end_time: Optional[datetime] = None,
        max_upload_end_time: Optional[datetime] = None,
        fingerprint_status: Annotated[Optional[StrictStr], Field(description="Search for a fingerprint status.")] = None,
        inference_status: Annotated[Optional[StrictStr], Field(description="Search for a inference status.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FilesSummaryDTO]:
        """Summary fo your files.


        :param isrc: Search for a ISRC
        :type isrc: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param key:
        :type key: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param origin_decade:
        :type origin_decade: str
        :param curateability:
        :type curateability: str
        :param use_case:
        :type use_case: str
        :param channel_suitability:
        :type channel_suitability: str
        :param similar_to_recording:
        :type similar_to_recording: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min: Search for a minimal bpm.
        :type bpm_min: int
        :param bpm_max: Search for a maximal bpm.
        :type bpm_max: int
        :param name: Search for a file name.
        :type name: str
        :param folder: Search for a folder.
        :type folder: str
        :param extension: Search for a file extension.
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status: Search for a fingerprint status.
        :type fingerprint_status: str
        :param inference_status: Search for a inference status.
        :type inference_status: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._user_files_summary_serialize(
            isrc=isrc,
            contributor=contributor,
            main_artist=main_artist,
            composer=composer,
            title=title,
            language=language,
            genre_names=genre_names,
            tag_names=tag_names,
            release_date=release_date,
            primary_mood_cluster=primary_mood_cluster,
            secondary_mood_cluster=secondary_mood_cluster,
            tertiary_mood_cluster=tertiary_mood_cluster,
            valence=valence,
            arousal=arousal,
            pleasantness=pleasantness,
            engagement=engagement,
            vocals=vocals,
            dominant_instrument=dominant_instrument,
            secondary_instrument=secondary_instrument,
            tertiary_instrument=tertiary_instrument,
            energy=energy,
            sound_generation=sound_generation,
            tempo=tempo,
            scale=scale,
            key=key,
            rhythm=rhythm,
            primary_sound_character=primary_sound_character,
            timbre=timbre,
            roughness=roughness,
            tonality=tonality,
            harmony=harmony,
            texture=texture,
            groovyness=groovyness,
            space=space,
            production_rating=production_rating,
            performance_rating=performance_rating,
            song_rating=song_rating,
            audience_age=audience_age,
            audience_region=audience_region,
            audience_gender=audience_gender,
            origin_decade=origin_decade,
            curateability=curateability,
            use_case=use_case,
            channel_suitability=channel_suitability,
            similar_to_recording=similar_to_recording,
            songtradr_track_id=songtradr_track_id,
            usage_name=usage_name,
            bpm_min=bpm_min,
            bpm_max=bpm_max,
            name=name,
            folder=folder,
            extension=extension,
            upload_end_time=upload_end_time,
            min_upload_end_time=min_upload_end_time,
            max_upload_end_time=max_upload_end_time,
            fingerprint_status=fingerprint_status,
            inference_status=inference_status,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FilesSummaryDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def user_files_summary_without_preload_content(
        self,
        isrc: Annotated[Optional[StrictStr], Field(description="Search for a ISRC")] = None,
        contributor: Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None,
        main_artist: Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None,
        composer: Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None,
        language: Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None,
        genre_names: Optional[List[StrictStr]] = None,
        tag_names: Optional[List[StrictStr]] = None,
        release_date: Optional[datetime] = None,
        primary_mood_cluster: Optional[StrictStr] = None,
        secondary_mood_cluster: Optional[StrictStr] = None,
        tertiary_mood_cluster: Optional[StrictStr] = None,
        valence: Optional[StrictStr] = None,
        arousal: Optional[StrictStr] = None,
        pleasantness: Optional[StrictStr] = None,
        engagement: Optional[StrictStr] = None,
        vocals: Optional[StrictStr] = None,
        dominant_instrument: Optional[StrictStr] = None,
        secondary_instrument: Optional[StrictStr] = None,
        tertiary_instrument: Optional[StrictStr] = None,
        energy: Optional[StrictStr] = None,
        sound_generation: Optional[StrictStr] = None,
        tempo: Optional[StrictStr] = None,
        scale: Optional[StrictStr] = None,
        key: Optional[StrictStr] = None,
        rhythm: Optional[StrictStr] = None,
        primary_sound_character: Optional[StrictStr] = None,
        timbre: Optional[StrictStr] = None,
        roughness: Optional[StrictStr] = None,
        tonality: Optional[StrictStr] = None,
        harmony: Optional[StrictStr] = None,
        texture: Optional[StrictStr] = None,
        groovyness: Optional[StrictStr] = None,
        space: Optional[StrictStr] = None,
        production_rating: Optional[StrictStr] = None,
        performance_rating: Optional[StrictStr] = None,
        song_rating: Optional[StrictStr] = None,
        audience_age: Optional[StrictStr] = None,
        audience_region: Optional[StrictStr] = None,
        audience_gender: Optional[StrictStr] = None,
        origin_decade: Optional[StrictStr] = None,
        curateability: Optional[StrictStr] = None,
        use_case: Optional[StrictStr] = None,
        channel_suitability: Optional[StrictStr] = None,
        similar_to_recording: Optional[StrictStr] = None,
        songtradr_track_id: Optional[StrictStr] = None,
        usage_name: Optional[StrictStr] = None,
        bpm_min: Annotated[Optional[StrictInt], Field(description="Search for a minimal bpm.")] = None,
        bpm_max: Annotated[Optional[StrictInt], Field(description="Search for a maximal bpm.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Search for a file name.")] = None,
        folder: Annotated[Optional[StrictStr], Field(description="Search for a folder.")] = None,
        extension: Annotated[Optional[StrictStr], Field(description="Search for a file extension.")] = None,
        upload_end_time: Optional[datetime] = None,
        min_upload_end_time: Optional[datetime] = None,
        max_upload_end_time: Optional[datetime] = None,
        fingerprint_status: Annotated[Optional[StrictStr], Field(description="Search for a fingerprint status.")] = None,
        inference_status: Annotated[Optional[StrictStr], Field(description="Search for a inference status.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Summary fo your files.


        :param isrc: Search for a ISRC
        :type isrc: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre_names:
        :type genre_names: List[str]
        :param tag_names:
        :type tag_names: List[str]
        :param release_date:
        :type release_date: datetime
        :param primary_mood_cluster:
        :type primary_mood_cluster: str
        :param secondary_mood_cluster:
        :type secondary_mood_cluster: str
        :param tertiary_mood_cluster:
        :type tertiary_mood_cluster: str
        :param valence:
        :type valence: str
        :param arousal:
        :type arousal: str
        :param pleasantness:
        :type pleasantness: str
        :param engagement:
        :type engagement: str
        :param vocals:
        :type vocals: str
        :param dominant_instrument:
        :type dominant_instrument: str
        :param secondary_instrument:
        :type secondary_instrument: str
        :param tertiary_instrument:
        :type tertiary_instrument: str
        :param energy:
        :type energy: str
        :param sound_generation:
        :type sound_generation: str
        :param tempo:
        :type tempo: str
        :param scale:
        :type scale: str
        :param key:
        :type key: str
        :param rhythm:
        :type rhythm: str
        :param primary_sound_character:
        :type primary_sound_character: str
        :param timbre:
        :type timbre: str
        :param roughness:
        :type roughness: str
        :param tonality:
        :type tonality: str
        :param harmony:
        :type harmony: str
        :param texture:
        :type texture: str
        :param groovyness:
        :type groovyness: str
        :param space:
        :type space: str
        :param production_rating:
        :type production_rating: str
        :param performance_rating:
        :type performance_rating: str
        :param song_rating:
        :type song_rating: str
        :param audience_age:
        :type audience_age: str
        :param audience_region:
        :type audience_region: str
        :param audience_gender:
        :type audience_gender: str
        :param origin_decade:
        :type origin_decade: str
        :param curateability:
        :type curateability: str
        :param use_case:
        :type use_case: str
        :param channel_suitability:
        :type channel_suitability: str
        :param similar_to_recording:
        :type similar_to_recording: str
        :param songtradr_track_id:
        :type songtradr_track_id: str
        :param usage_name:
        :type usage_name: str
        :param bpm_min: Search for a minimal bpm.
        :type bpm_min: int
        :param bpm_max: Search for a maximal bpm.
        :type bpm_max: int
        :param name: Search for a file name.
        :type name: str
        :param folder: Search for a folder.
        :type folder: str
        :param extension: Search for a file extension.
        :type extension: str
        :param upload_end_time:
        :type upload_end_time: datetime
        :param min_upload_end_time:
        :type min_upload_end_time: datetime
        :param max_upload_end_time:
        :type max_upload_end_time: datetime
        :param fingerprint_status: Search for a fingerprint status.
        :type fingerprint_status: str
        :param inference_status: Search for a inference status.
        :type inference_status: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._user_files_summary_serialize(
            isrc=isrc,
            contributor=contributor,
            main_artist=main_artist,
            composer=composer,
            title=title,
            language=language,
            genre_names=genre_names,
            tag_names=tag_names,
            release_date=release_date,
            primary_mood_cluster=primary_mood_cluster,
            secondary_mood_cluster=secondary_mood_cluster,
            tertiary_mood_cluster=tertiary_mood_cluster,
            valence=valence,
            arousal=arousal,
            pleasantness=pleasantness,
            engagement=engagement,
            vocals=vocals,
            dominant_instrument=dominant_instrument,
            secondary_instrument=secondary_instrument,
            tertiary_instrument=tertiary_instrument,
            energy=energy,
            sound_generation=sound_generation,
            tempo=tempo,
            scale=scale,
            key=key,
            rhythm=rhythm,
            primary_sound_character=primary_sound_character,
            timbre=timbre,
            roughness=roughness,
            tonality=tonality,
            harmony=harmony,
            texture=texture,
            groovyness=groovyness,
            space=space,
            production_rating=production_rating,
            performance_rating=performance_rating,
            song_rating=song_rating,
            audience_age=audience_age,
            audience_region=audience_region,
            audience_gender=audience_gender,
            origin_decade=origin_decade,
            curateability=curateability,
            use_case=use_case,
            channel_suitability=channel_suitability,
            similar_to_recording=similar_to_recording,
            songtradr_track_id=songtradr_track_id,
            usage_name=usage_name,
            bpm_min=bpm_min,
            bpm_max=bpm_max,
            name=name,
            folder=folder,
            extension=extension,
            upload_end_time=upload_end_time,
            min_upload_end_time=min_upload_end_time,
            max_upload_end_time=max_upload_end_time,
            fingerprint_status=fingerprint_status,
            inference_status=inference_status,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FilesSummaryDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _user_files_summary_serialize(
        self,
        isrc,
        contributor,
        main_artist,
        composer,
        title,
        language,
        genre_names,
        tag_names,
        release_date,
        primary_mood_cluster,
        secondary_mood_cluster,
        tertiary_mood_cluster,
        valence,
        arousal,
        pleasantness,
        engagement,
        vocals,
        dominant_instrument,
        secondary_instrument,
        tertiary_instrument,
        energy,
        sound_generation,
        tempo,
        scale,
        key,
        rhythm,
        primary_sound_character,
        timbre,
        roughness,
        tonality,
        harmony,
        texture,
        groovyness,
        space,
        production_rating,
        performance_rating,
        song_rating,
        audience_age,
        audience_region,
        audience_gender,
        origin_decade,
        curateability,
        use_case,
        channel_suitability,
        similar_to_recording,
        songtradr_track_id,
        usage_name,
        bpm_min,
        bpm_max,
        name,
        folder,
        extension,
        upload_end_time,
        min_upload_end_time,
        max_upload_end_time,
        fingerprint_status,
        inference_status,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            'genreNames': 'multi',
            'tagNames': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if isrc is not None:
            
            _query_params.append(('ISRC', isrc))
            
        if contributor is not None:
            
            _query_params.append(('contributor', contributor))
            
        if main_artist is not None:
            
            _query_params.append(('mainArtist', main_artist))
            
        if composer is not None:
            
            _query_params.append(('composer', composer))
            
        if title is not None:
            
            _query_params.append(('title', title))
            
        if language is not None:
            
            _query_params.append(('language', language))
            
        if genre_names is not None:
            
            _query_params.append(('genreNames', genre_names))
            
        if tag_names is not None:
            
            _query_params.append(('tagNames', tag_names))
            
        if release_date is not None:
            if isinstance(release_date, datetime):
                _query_params.append(
                    (
                        'releaseDate',
                        release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('releaseDate', release_date))
            
        if primary_mood_cluster is not None:
            
            _query_params.append(('primaryMoodCluster', primary_mood_cluster))
            
        if secondary_mood_cluster is not None:
            
            _query_params.append(('secondaryMoodCluster', secondary_mood_cluster))
            
        if tertiary_mood_cluster is not None:
            
            _query_params.append(('tertiaryMoodCluster', tertiary_mood_cluster))
            
        if valence is not None:
            
            _query_params.append(('valence', valence))
            
        if arousal is not None:
            
            _query_params.append(('arousal', arousal))
            
        if pleasantness is not None:
            
            _query_params.append(('pleasantness', pleasantness))
            
        if engagement is not None:
            
            _query_params.append(('engagement', engagement))
            
        if vocals is not None:
            
            _query_params.append(('vocals', vocals))
            
        if dominant_instrument is not None:
            
            _query_params.append(('dominantInstrument', dominant_instrument))
            
        if secondary_instrument is not None:
            
            _query_params.append(('secondaryInstrument', secondary_instrument))
            
        if tertiary_instrument is not None:
            
            _query_params.append(('tertiaryInstrument', tertiary_instrument))
            
        if energy is not None:
            
            _query_params.append(('energy', energy))
            
        if sound_generation is not None:
            
            _query_params.append(('soundGeneration', sound_generation))
            
        if tempo is not None:
            
            _query_params.append(('tempo', tempo))
            
        if scale is not None:
            
            _query_params.append(('scale', scale))
            
        if key is not None:
            
            _query_params.append(('key', key))
            
        if rhythm is not None:
            
            _query_params.append(('rhythm', rhythm))
            
        if primary_sound_character is not None:
            
            _query_params.append(('primarySoundCharacter', primary_sound_character))
            
        if timbre is not None:
            
            _query_params.append(('timbre', timbre))
            
        if roughness is not None:
            
            _query_params.append(('roughness', roughness))
            
        if tonality is not None:
            
            _query_params.append(('tonality', tonality))
            
        if harmony is not None:
            
            _query_params.append(('harmony', harmony))
            
        if texture is not None:
            
            _query_params.append(('texture', texture))
            
        if groovyness is not None:
            
            _query_params.append(('groovyness', groovyness))
            
        if space is not None:
            
            _query_params.append(('space', space))
            
        if production_rating is not None:
            
            _query_params.append(('productionRating', production_rating))
            
        if performance_rating is not None:
            
            _query_params.append(('performanceRating', performance_rating))
            
        if song_rating is not None:
            
            _query_params.append(('songRating', song_rating))
            
        if audience_age is not None:
            
            _query_params.append(('audienceAge', audience_age))
            
        if audience_region is not None:
            
            _query_params.append(('audienceRegion', audience_region))
            
        if audience_gender is not None:
            
            _query_params.append(('audienceGender', audience_gender))
            
        if origin_decade is not None:
            
            _query_params.append(('originDecade', origin_decade))
            
        if curateability is not None:
            
            _query_params.append(('curateability', curateability))
            
        if use_case is not None:
            
            _query_params.append(('useCase', use_case))
            
        if channel_suitability is not None:
            
            _query_params.append(('channelSuitability', channel_suitability))
            
        if similar_to_recording is not None:
            
            _query_params.append(('similarToRecording', similar_to_recording))
            
        if songtradr_track_id is not None:
            
            _query_params.append(('songtradrTrackId', songtradr_track_id))
            
        if usage_name is not None:
            
            _query_params.append(('usageName', usage_name))
            
        if bpm_min is not None:
            
            _query_params.append(('bpmMin', bpm_min))
            
        if bpm_max is not None:
            
            _query_params.append(('bpmMax', bpm_max))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if folder is not None:
            
            _query_params.append(('folder', folder))
            
        if extension is not None:
            
            _query_params.append(('extension', extension))
            
        if upload_end_time is not None:
            if isinstance(upload_end_time, datetime):
                _query_params.append(
                    (
                        'uploadEndTime',
                        upload_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('uploadEndTime', upload_end_time))
            
        if min_upload_end_time is not None:
            if isinstance(min_upload_end_time, datetime):
                _query_params.append(
                    (
                        'minUploadEndTime',
                        min_upload_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('minUploadEndTime', min_upload_end_time))
            
        if max_upload_end_time is not None:
            if isinstance(max_upload_end_time, datetime):
                _query_params.append(
                    (
                        'maxUploadEndTime',
                        max_upload_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('maxUploadEndTime', max_upload_end_time))
            
        if fingerprint_status is not None:
            
            _query_params.append(('fingerprintStatus', fingerprint_status))
            
        if inference_status is not None:
            
            _query_params.append(('inferenceStatus', inference_status))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/user/filesSummary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


