# songtradr-api-client-python
This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.

You can also use the API to manage your account and musicube cloud data.

**Authentication**

1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.

2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.

3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.

**Rate Limiting**

The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.

**Getting Started with auto-tagging**

1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file.
2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint.
3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.

**Getting Started with search**

You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.

1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters.
2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0.0
- Package version: 2.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://songtradr.com](https://songtradr.com)

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import songtradr_api_client_python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import songtradr_api_client_python
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import songtradr_api_client_python
from songtradr_api_client_python.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.songtradr.com
# See configuration.py for a list of all supported configuration parameters.
configuration = songtradr_api_client_python.Configuration(
    host = "https://api.songtradr.com"
)



# Enter a context with an instance of the API client
with songtradr_api_client_python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = songtradr_api_client_python.AllowedValuesApi(api_client)
    response_size = 's' # str | Size the response should have. (optional) (default to 's')

    try:
        # Allowed values for music descriptive parameters to be used in the searchAll endpoint.
        api_response = api_instance.allowed_musical_features(response_size=response_size)
        print("The response of AllowedValuesApi->allowed_musical_features:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AllowedValuesApi->allowed_musical_features: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.songtradr.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AllowedValuesApi* | [**allowed_musical_features**](docs/AllowedValuesApi.md#allowed_musical_features) | **GET** /api/v1/allowedValues/musicalFeatures | Allowed values for music descriptive parameters to be used in the searchAll endpoint.
*AllowedValuesApi* | [**genres**](docs/AllowedValuesApi.md#genres) | **GET** /api/v1/allowedValues/genre | Allowed values for genres.
*AllowedValuesApi* | [**tags**](docs/AllowedValuesApi.md#tags) | **GET** /api/v1/allowedValues/tag | All descriptive tags inside of tag-categories.
*RecordingApi* | [**prompt_search_recordings**](docs/RecordingApi.md#prompt_search_recordings) | **GET** /api/v1/public/recording/promptSearch | Recordings for query.
*RecordingApi* | [**recordings_by_ids_with_musical_features**](docs/RecordingApi.md#recordings_by_ids_with_musical_features) | **GET** /api/v1/public/recording/{ids}/musicalFeatures | AI generated moods, musical features and more for recordings.
*RecordingApi* | [**recordings_by_ids_with_similarities**](docs/RecordingApi.md#recordings_by_ids_with_similarities) | **GET** /api/v1/public/recording/{ids}/similarities | Similar recordings for a list of recordings.
*RecordingApi* | [**recordings_by_ids_with_taggrams**](docs/RecordingApi.md#recordings_by_ids_with_taggrams) | **GET** /api/v1/public/recording/{ids}/taggrams | Timeseries of AI generated moods, musical features and more for a list of recordings.
*RecordingApi* | [**recordings_by_ids_with_tagstrengths**](docs/RecordingApi.md#recordings_by_ids_with_tagstrengths) | **GET** /api/v1/public/recording/{ids}/tagstrengths | Strengths as numerical representations for AI generated moods, musical features and more for recordings.
*RecordingApi* | [**recordings_medium_by_ids**](docs/RecordingApi.md#recordings_medium_by_ids) | **GET** /api/v1/public/recording/m/{ids} | Recordings by IDs with a medium sized response.
*RecordingApi* | [**search_recordings**](docs/RecordingApi.md#search_recordings) | **GET** /api/v1/public/recording/search | Recordings by contributors, moods, musical features and more.
*UserApi* | [**delete_user_file**](docs/UserApi.md#delete_user_file) | **DELETE** /api/v1/user/file/{objectKey} | Delete file.
*UserApi* | [**edit_me**](docs/UserApi.md#edit_me) | **POST** /api/v1/user/me | Edit details for a logged-in user
*UserApi* | [**forgot_password**](docs/UserApi.md#forgot_password) | **POST** /api/v1/user/forgot-password | Send a password reset email
*UserApi* | [**init_video_upload**](docs/UserApi.md#init_video_upload) | **POST** /api/v1/user/file/{name}/initVideoUpload | Recognise and upload video. Responds with an object with recognition result.
*UserApi* | [**initiate_user_file_upload**](docs/UserApi.md#initiate_user_file_upload) | **POST** /api/v1/user/file/{name}/initUpload | Initialize a file upload. Responds with an URL where the file can be uploaded.
*UserApi* | [**initiate_user_image_upload**](docs/UserApi.md#initiate_user_image_upload) | **POST** /api/v1/user/file/{name}/initImageUpload | Recognise and upload image. Responds with an object with recognition result.
*UserApi* | [**login**](docs/UserApi.md#login) | **POST** /api/v1/user/login | Login to generate a bearer token.
*UserApi* | [**me**](docs/UserApi.md#me) | **GET** /api/v1/user/me | Details for a logged-in user
*UserApi* | [**prompt_search_user_files**](docs/UserApi.md#prompt_search_user_files) | **GET** /api/v1/user/promptSearch | Files for query.
*UserApi* | [**recordings_by_folder_with_taggrams**](docs/UserApi.md#recordings_by_folder_with_taggrams) | **GET** /api/v1/user/folder/{folderName}/taggrams | Timeseries of AI generated moods, musical features and more for recordings in your folder.
*UserApi* | [**recordings_by_folder_with_tagstrengths**](docs/UserApi.md#recordings_by_folder_with_tagstrengths) | **GET** /api/v1/user/folder/{folderName}/tagstrengths | Strengths as numerical representations for AI generated moods, musical features and more for recordings in your folder.
*UserApi* | [**sign_up**](docs/UserApi.md#sign_up) | **POST** /api/v1/user/sign-up | Sign up a new user.
*UserApi* | [**token**](docs/UserApi.md#token) | **POST** /api/v1/user/token | Generates a new JWT token for the given refresh token
*UserApi* | [**update_password**](docs/UserApi.md#update_password) | **POST** /api/v1/user/update-password | Update password by using the password reset token
*UserApi* | [**user_file**](docs/UserApi.md#user_file) | **GET** /api/v1/user/file/{objectKey} | Details and a download link for a file.
*UserApi* | [**user_files**](docs/UserApi.md#user_files) | **GET** /api/v1/user/files | List and search your own files.
*UserApi* | [**user_files_status**](docs/UserApi.md#user_files_status) | **GET** /api/v1/user/filesStatus | Status details for files.
*UserApi* | [**user_files_summary**](docs/UserApi.md#user_files_summary) | **GET** /api/v1/user/filesSummary | Summary fo your files.


## Documentation For Models

 - [CategoryMediumDTO](docs/CategoryMediumDTO.md)
 - [CategoryMinimalDTO](docs/CategoryMinimalDTO.md)
 - [ConfigAccessDTO](docs/ConfigAccessDTO.md)
 - [ConfigIdentifierDTO](docs/ConfigIdentifierDTO.md)
 - [ContributorTypeDTO](docs/ContributorTypeDTO.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [FieldSummaryDTO](docs/FieldSummaryDTO.md)
 - [FileDTO](docs/FileDTO.md)
 - [FileListDTO](docs/FileListDTO.md)
 - [FileSmallDTO](docs/FileSmallDTO.md)
 - [FileUploadDTO](docs/FileUploadDTO.md)
 - [FileWIthUrlDTO](docs/FileWIthUrlDTO.md)
 - [FilesSummaryDTO](docs/FilesSummaryDTO.md)
 - [ForgotPasswordDTO](docs/ForgotPasswordDTO.md)
 - [GenreDTO](docs/GenreDTO.md)
 - [GenreMinimalDTO](docs/GenreMinimalDTO.md)
 - [GenresSummaryDTO](docs/GenresSummaryDTO.md)
 - [ImageRecognitionResponse](docs/ImageRecognitionResponse.md)
 - [InitPutRecordingAudioDTO](docs/InitPutRecordingAudioDTO.md)
 - [JwtTokenDTO](docs/JwtTokenDTO.md)
 - [LoginDTO](docs/LoginDTO.md)
 - [MusicalFeaturesDTO](docs/MusicalFeaturesDTO.md)
 - [PartySmallDTO](docs/PartySmallDTO.md)
 - [RecordingForSimilaritySearchDTO](docs/RecordingForSimilaritySearchDTO.md)
 - [RecordingGenrePredictionDTO](docs/RecordingGenrePredictionDTO.md)
 - [RecordingListDTO](docs/RecordingListDTO.md)
 - [RecordingMediumDTO](docs/RecordingMediumDTO.md)
 - [RecordingMinimalWithMusicalFeaturesDTO](docs/RecordingMinimalWithMusicalFeaturesDTO.md)
 - [RecordingMinimalWithTaggramsDTO](docs/RecordingMinimalWithTaggramsDTO.md)
 - [RecordingMinimalWithTagstrengthsDTO](docs/RecordingMinimalWithTagstrengthsDTO.md)
 - [RecordingPartyDTO](docs/RecordingPartyDTO.md)
 - [RecordingSmallDTO](docs/RecordingSmallDTO.md)
 - [RecordingTagSmallDTO](docs/RecordingTagSmallDTO.md)
 - [SaveUserDTO](docs/SaveUserDTO.md)
 - [SearchFilterValuesDTO](docs/SearchFilterValuesDTO.md)
 - [SignUpDTO](docs/SignUpDTO.md)
 - [TagDTO](docs/TagDTO.md)
 - [TagSmallDTO](docs/TagSmallDTO.md)
 - [TaggramDTO](docs/TaggramDTO.md)
 - [TagsSummaryDTO](docs/TagsSummaryDTO.md)
 - [TagstrengthDTO](docs/TagstrengthDTO.md)
 - [TitleDTO](docs/TitleDTO.md)
 - [TokenRequest](docs/TokenRequest.md)
 - [TrackDTO](docs/TrackDTO.md)
 - [UpdatePasswordDTO](docs/UpdatePasswordDTO.md)
 - [UserDTO](docs/UserDTO.md)
 - [VideoRecognitionResponse](docs/VideoRecognitionResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="bearer-jwt"></a>
### bearer-jwt

- **Type**: Bearer authentication (JWT)


## Author

info@songtradr.com


