# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 2.0.0
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from songtradr_api_client_python.models.genre_dto import GenreDTO
from songtradr_api_client_python.models.musical_features_dto import MusicalFeaturesDTO
from songtradr_api_client_python.models.recording_genre_prediction_dto import RecordingGenrePredictionDTO
from songtradr_api_client_python.models.recording_party_dto import RecordingPartyDTO
from songtradr_api_client_python.models.recording_tag_small_dto import RecordingTagSmallDTO
from songtradr_api_client_python.models.title_dto import TitleDTO
from songtradr_api_client_python.models.track_dto import TrackDTO
from typing import Optional, Set
from typing_extensions import Self

class RecordingMediumDTO(BaseModel):
    """
    Recording with a mid-sized field set.
    """ # noqa: E501
    isrc: StrictStr
    genres: Optional[List[GenreDTO]] = None
    language_of_performance: Optional[StrictStr] = Field(default=None, alias="languageOfPerformance")
    release_date: Optional[datetime] = Field(default=None, alias="releaseDate")
    titles: Optional[List[TitleDTO]] = None
    tracks: Optional[List[TrackDTO]] = None
    musical_features: Optional[MusicalFeaturesDTO] = Field(default=None, alias="musicalFeatures")
    recording_party_entities: Optional[List[RecordingPartyDTO]] = Field(default=None, alias="recordingPartyEntities")
    spotify_id: Optional[StrictStr] = Field(default=None, alias="spotifyId")
    tags: Optional[List[RecordingTagSmallDTO]] = None
    genre_predictions: Optional[List[RecordingGenrePredictionDTO]] = Field(default=None, alias="genrePredictions")
    __properties: ClassVar[List[str]] = ["isrc", "genres", "languageOfPerformance", "releaseDate", "titles", "tracks", "musicalFeatures", "recordingPartyEntities", "spotifyId", "tags", "genrePredictions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RecordingMediumDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in genres (list)
        _items = []
        if self.genres:
            for _item in self.genres:
                if _item:
                    _items.append(_item.to_dict())
            _dict['genres'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in titles (list)
        _items = []
        if self.titles:
            for _item in self.titles:
                if _item:
                    _items.append(_item.to_dict())
            _dict['titles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tracks (list)
        _items = []
        if self.tracks:
            for _item in self.tracks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tracks'] = _items
        # override the default output from pydantic by calling `to_dict()` of musical_features
        if self.musical_features:
            _dict['musicalFeatures'] = self.musical_features.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in recording_party_entities (list)
        _items = []
        if self.recording_party_entities:
            for _item in self.recording_party_entities:
                if _item:
                    _items.append(_item.to_dict())
            _dict['recordingPartyEntities'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in genre_predictions (list)
        _items = []
        if self.genre_predictions:
            for _item in self.genre_predictions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['genrePredictions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RecordingMediumDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "isrc": obj.get("isrc"),
            "genres": [GenreDTO.from_dict(_item) for _item in obj["genres"]] if obj.get("genres") is not None else None,
            "languageOfPerformance": obj.get("languageOfPerformance"),
            "releaseDate": obj.get("releaseDate"),
            "titles": [TitleDTO.from_dict(_item) for _item in obj["titles"]] if obj.get("titles") is not None else None,
            "tracks": [TrackDTO.from_dict(_item) for _item in obj["tracks"]] if obj.get("tracks") is not None else None,
            "musicalFeatures": MusicalFeaturesDTO.from_dict(obj["musicalFeatures"]) if obj.get("musicalFeatures") is not None else None,
            "recordingPartyEntities": [RecordingPartyDTO.from_dict(_item) for _item in obj["recordingPartyEntities"]] if obj.get("recordingPartyEntities") is not None else None,
            "spotifyId": obj.get("spotifyId"),
            "tags": [RecordingTagSmallDTO.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "genrePredictions": [RecordingGenrePredictionDTO.from_dict(_item) for _item in obj["genrePredictions"]] if obj.get("genrePredictions") is not None else None
        })
        return _obj


