# coding: utf-8

"""
    Computations Management API

    This API is responsible for managing computations. 

    The version of the OpenAPI document: 0.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Computation(BaseModel):
    """
    Computation
    """ # noqa: E501
    id: StrictStr = Field(description="The computation ID")
    service: StrictStr = Field(description="The service name")
    version: StrictStr = Field(description="The service version")
    endpoint: StrictStr = Field(description="The service endpoint")
    payload: Dict[str, Any] = Field(description="The computation payload")
    status: StrictStr = Field(description="The computation status")
    creation_date: str = Field(description="The computation creation date", alias="creationDate")
    start_date: Optional[str] = Field(default=None, description="The computation start date", alias="startDate")
    end_date: Optional[str] = Field(default=None, description="The computation end date", alias="endDate")
    request_payload: Optional[Dict[str, Any]] = Field(default=None, description="The request payload", alias="requestPayload")
    response_payload: Optional[Dict[str, Any]] = Field(default=None, description="The response payload", alias="responsePayload")
    __properties: ClassVar[List[str]] = ["id", "service", "version", "endpoint", "payload", "status", "creationDate", "startDate", "endDate", "requestPayload", "responsePayload"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['PENDING', 'RUNNING', 'SUCCESS', 'FAILED', 'CANCELLED']):
            raise ValueError("must be one of enum values ('PENDING', 'RUNNING', 'SUCCESS', 'FAILED', 'CANCELLED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Computation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Computation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "service": obj.get("service"),
            "version": obj.get("version"),
            "endpoint": obj.get("endpoint"),
            "payload": obj.get("payload"),
            "status": obj.get("status"),
            "creationDate": obj.get("creationDate"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "requestPayload": obj.get("requestPayload"),
            "responsePayload": obj.get("responsePayload")
        })
        return _obj


