# spacetower_data_management_python_client
The <b>Data Management</b> component provides facilities to store space
data such as leap second, EOP (Earth Orientation Parameters) or space weather
forcecasts in a centralized way, such that these data can be used by all the 
components of the FDS.

The following main concepts are used:

<ul>
  <li><b>Repositories</b>are folders in which all the data belonging to a same
  type (e.g. LEAP_SECOND) are stored</li>
  <li><b>References data</b> represents the data that will be used by default
  by all the components of the system</li>
</ul>

A reference data is always an existing data stored in a repository, but only one 
data stored in a repository (for a given type) can be a reference data.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.1.0
- Package version: 1.1.0
- Generator version: 7.6.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import spacetower_data_management_python_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import spacetower_data_management_python_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import spacetower_data_management_python_client
from spacetower_data_management_python_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://api.exoops.exotrail.space/data-management
# See configuration.py for a list of all supported configuration parameters.
configuration = spacetower_data_management_python_client.Configuration(
    host = "http://api.exoops.exotrail.space/data-management"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: BearerAuth
configuration = spacetower_data_management_python_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with spacetower_data_management_python_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = spacetower_data_management_python_client.DefaultApi(api_client)
    type = 'type_example' # str | The data type (e.g. EOP)
    id = 'id_example' # str | The data identifier

    try:
        # Retrieve data by identifier
        api_instance.get_data_by_id(type, id)
    except ApiException as e:
        print("Exception when calling DefaultApi->get_data_by_id: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://api.exoops.exotrail.space/data-management*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**get_data_by_id**](docs/DefaultApi.md#get_data_by_id) | **GET** /repositories/{type}/{id} | Retrieve data by identifier
*DefaultApi* | [**get_reference_data**](docs/DefaultApi.md#get_reference_data) | **GET** /references/{type} | Get reference data
*DefaultApi* | [**store_data**](docs/DefaultApi.md#store_data) | **POST** /repositories/{type} | Store data
*DefaultApi* | [**update_reference_data**](docs/DefaultApi.md#update_reference_data) | **PUT** /references/{type} | Update reference data


## Documentation For Models

 - [StoreData200Response](docs/StoreData200Response.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="BearerAuth"></a>
### BearerAuth

- **Type**: Bearer authentication


## Author




