# coding: utf-8

"""
    Data Management API

    The <b>Data Management</b> component provides facilities to store space data such as leap second, EOP (Earth Orientation Parameters) or space weather forcecasts in a centralized way, such that these data can be used by all the  components of the FDS.  The following main concepts are used:  <ul>   <li><b>Repositories</b>are folders in which all the data belonging to a same   type (e.g. LEAP_SECOND) are stored</li>   <li><b>References data</b> represents the data that will be used by default   by all the components of the system</li> </ul>  A reference data is always an existing data stored in a repository, but only one  data stored in a repository (for a given type) can be a reference data. 

    The version of the OpenAPI document: 1.2.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class StoreData200Response(BaseModel):
    """
    StoreData200Response
    """ # noqa: E501
    id: StrictStr = Field(description="The data identifier")
    type: StrictStr = Field(description="The data type")
    creation_date: str = Field(description="The data creation date/time", alias="creationDate")
    __properties: ClassVar[List[str]] = ["id", "type", "creationDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StoreData200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StoreData200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "creationDate": obj.get("creationDate")
        })
        return _obj


