# coding: utf-8

"""
    Data Management API

    The <b>Data Management</b> component provides facilities to store space data such as leap second, EOP (Earth Orientation Parameters) or space weather forcecasts in a centralized way, such that these data can be used by all the  components of the FDS.  The following main concepts are used:  <ul>   <li><b>Repositories</b>are folders in which all the data belonging to a same   type (e.g. LEAP_SECOND) are stored</li>   <li><b>References data</b> represents the data that will be used by default   by all the components of the system</li> </ul>  A reference data is always an existing data stored in a repository, but only one  data stored in a repository (for a given type) can be a reference data. 

    The version of the OpenAPI document: 1.2.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from setuptools import setup, find_packages  # noqa: H301

# To install the library, run the following
#
# python setup.py install
#
# prerequisite: setuptools
# http://pypi.python.org/pypi/setuptools
NAME = "spacetower_data_management_python_client"
VERSION = "1.2.4"
PYTHON_REQUIRES = ">=3.7"
REQUIRES = [
    "urllib3 >= 1.25.3, < 2.1.0",
    "python-dateutil",
    "pydantic >= 2",
    "typing-extensions >= 4.7.1",
]

setup(
    name=NAME,
    version=VERSION,
    description="Data Management API",
    author="OpenAPI Generator community",
    author_email="team@openapitools.org",
    url="",
    keywords=["OpenAPI", "OpenAPI-Generator", "Data Management API"],
    install_requires=REQUIRES,
    packages=find_packages(exclude=["test", "tests"]),
    include_package_data=True,
    license="Exotrail",
    long_description_content_type='text/markdown',
    long_description="""\
    The &lt;b&gt;Data Management&lt;/b&gt; component provides facilities to store space data such as leap second, EOP (Earth Orientation Parameters) or space weather forcecasts in a centralized way, such that these data can be used by all the  components of the FDS.  The following main concepts are used:  &lt;ul&gt;   &lt;li&gt;&lt;b&gt;Repositories&lt;/b&gt;are folders in which all the data belonging to a same   type (e.g. LEAP_SECOND) are stored&lt;/li&gt;   &lt;li&gt;&lt;b&gt;References data&lt;/b&gt; represents the data that will be used by default   by all the components of the system&lt;/li&gt; &lt;/ul&gt;  A reference data is always an existing data stored in a repository, but only one  data stored in a repository (for a given type) can be a reference data. 
    """,  # noqa: E501
    package_data={"spacetower_data_management_python_client": ["py.typed"]},
)
