# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Union
from spacetower_orbit_determination_python_client.models.attitude_law_type import AttitudeLawType
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from spacetower_orbit_determination_python_client.models.earth_oriented_maneuver_attitude_law import EarthOrientedManeuverAttitudeLaw
    from spacetower_orbit_determination_python_client.models.lof_attitude_law import LofAttitudeLaw
    from spacetower_orbit_determination_python_client.models.nadir_pointing_law import NadirPointingLaw
    from spacetower_orbit_determination_python_client.models.sun_enhanced_maneuver_attitude_law import SunEnhancedManeuverAttitudeLaw
    from spacetower_orbit_determination_python_client.models.sun_pointing_law import SunPointingLaw

class AttitudeLaw(BaseModel):
    """
    Definition of the rotational state of the object
    """ # noqa: E501
    attitude_law_type: AttitudeLawType = Field(alias="attitudeLawType")
    __properties: ClassVar[List[str]] = ["attitudeLawType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'attitudeLawType'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'EARTH_ORIENTED_MANEUVER': 'EarthOrientedManeuverAttitudeLaw','LOF_ATTITUDE': 'LofAttitudeLaw','NADIR_POINTING': 'NadirPointingLaw','SUN_ENHANCED_MANEUVER': 'SunEnhancedManeuverAttitudeLaw','SUN_POINTING': 'SunPointingLaw'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[EarthOrientedManeuverAttitudeLaw, LofAttitudeLaw, NadirPointingLaw, SunEnhancedManeuverAttitudeLaw, SunPointingLaw]]:
        """Create an instance of AttitudeLaw from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[EarthOrientedManeuverAttitudeLaw, LofAttitudeLaw, NadirPointingLaw, SunEnhancedManeuverAttitudeLaw, SunPointingLaw]]:
        """Create an instance of AttitudeLaw from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'EarthOrientedManeuverAttitudeLaw':
            return import_module("spacetower_orbit_determination_python_client.models.earth_oriented_maneuver_attitude_law").EarthOrientedManeuverAttitudeLaw.from_dict(obj)
        if object_type ==  'LofAttitudeLaw':
            return import_module("spacetower_orbit_determination_python_client.models.lof_attitude_law").LofAttitudeLaw.from_dict(obj)
        if object_type ==  'NadirPointingLaw':
            return import_module("spacetower_orbit_determination_python_client.models.nadir_pointing_law").NadirPointingLaw.from_dict(obj)
        if object_type ==  'SunEnhancedManeuverAttitudeLaw':
            return import_module("spacetower_orbit_determination_python_client.models.sun_enhanced_maneuver_attitude_law").SunEnhancedManeuverAttitudeLaw.from_dict(obj)
        if object_type ==  'SunPointingLaw':
            return import_module("spacetower_orbit_determination_python_client.models.sun_pointing_law").SunPointingLaw.from_dict(obj)

        raise ValueError("AttitudeLaw failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


