# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_determination_python_client.models.attitude_sequence import AttitudeSequence
from spacetower_orbit_determination_python_client.models.estimator_type import EstimatorType
from spacetower_orbit_determination_python_client.models.input_measurements import InputMeasurements
from spacetower_orbit_determination_python_client.models.numerical_estimation_parameters import NumericalEstimationParameters
from spacetower_orbit_determination_python_client.models.post_process_configuration import PostProcessConfiguration
from spacetower_orbit_determination_python_client.models.propagation_configuration import PropagationConfiguration
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from spacetower_orbit_determination_python_client.models.batch_filter_orbit_determination import BatchFilterOrbitDetermination
    from spacetower_orbit_determination_python_client.models.unscented_kalman_filter_orbit_determination import UnscentedKalmanFilterOrbitDetermination

class NumericalEstimationRequest(BaseModel):
    """
    Configuration for orbit determination based on numerical propagation
    """ # noqa: E501
    attitude_sequence: Optional[AttitudeSequence] = Field(default=None, alias="attitudeSequence")
    estimator_type: Optional[EstimatorType] = Field(default=None, alias="estimatorType")
    input_measurements_set: Optional[List[InputMeasurements]] = Field(default=None, description="Mixed set of generic dated-weighted measurement series with field descriptions", alias="inputMeasurementsSet")
    dynamics_and_frames_configuration: Optional[PropagationConfiguration] = Field(default=None, alias="dynamicsAndFramesConfiguration")
    estimation_configuration: Optional[NumericalEstimationParameters] = Field(default=None, alias="estimationConfiguration")
    post_process_configuration: Optional[PostProcessConfiguration] = Field(default=None, alias="postProcessConfiguration")
    __properties: ClassVar[List[str]] = ["attitudeSequence", "estimatorType", "inputMeasurementsSet", "dynamicsAndFramesConfiguration", "estimationConfiguration", "postProcessConfiguration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'estimatorType'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'BATCH_FILTER': 'BatchFilterOrbitDetermination','UNSCENTED_KALMAN_FILTER': 'UnscentedKalmanFilterOrbitDetermination'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[BatchFilterOrbitDetermination, UnscentedKalmanFilterOrbitDetermination]]:
        """Create an instance of NumericalEstimationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of attitude_sequence
        if self.attitude_sequence:
            _dict['attitudeSequence'] = self.attitude_sequence.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in input_measurements_set (list)
        _items = []
        if self.input_measurements_set:
            for _item in self.input_measurements_set:
                if _item:
                    _items.append(_item.to_dict())
            _dict['inputMeasurementsSet'] = _items
        # override the default output from pydantic by calling `to_dict()` of dynamics_and_frames_configuration
        if self.dynamics_and_frames_configuration:
            _dict['dynamicsAndFramesConfiguration'] = self.dynamics_and_frames_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of estimation_configuration
        if self.estimation_configuration:
            _dict['estimationConfiguration'] = self.estimation_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of post_process_configuration
        if self.post_process_configuration:
            _dict['postProcessConfiguration'] = self.post_process_configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[BatchFilterOrbitDetermination, UnscentedKalmanFilterOrbitDetermination]]:
        """Create an instance of NumericalEstimationRequest from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'BatchFilterOrbitDetermination':
            return import_module("spacetower_orbit_determination_python_client.models.batch_filter_orbit_determination").BatchFilterOrbitDetermination.from_dict(obj)
        if object_type ==  'UnscentedKalmanFilterOrbitDetermination':
            return import_module("spacetower_orbit_determination_python_client.models.unscented_kalman_filter_orbit_determination").UnscentedKalmanFilterOrbitDetermination.from_dict(obj)

        raise ValueError("NumericalEstimationRequest failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


