# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from spacetower_orbit_determination_python_client.models.cartesian_process_noise_diagonal_matrix import CartesianProcessNoiseDiagonalMatrix
from spacetower_orbit_determination_python_client.models.orbital_process_noise_provider import OrbitalProcessNoiseProvider
from spacetower_orbit_determination_python_client.models.orbital_process_noise_provider_type import OrbitalProcessNoiseProviderType
from typing import Optional, Set
from typing_extensions import Self

class TimeLinearNoiseProvider(OrbitalProcessNoiseProvider):
    """
    The user specifies a constant diagonal matrix Q that can be seen as the increment of state covariance per unit of time because of un-modelled effects. The units are of position and velocity covariance coefficients per unit time. <br> This amounts to consider un-modelled accelerations as white noise, with the following assumptions:<br> - The matrix Q does not not depend on time<br> - The duration between a measurement and the next is such that the state transition matrix can be approximated with the identity<br> From these, a linear increment ```Q*deltaT``` of the covariance matrix during the measurement interval follows. 
    """ # noqa: E501
    cartesian_covariance_matrix_per_unit_time: CartesianProcessNoiseDiagonalMatrix = Field(alias="cartesianCovarianceMatrixPerUnitTime")
    __properties: ClassVar[List[str]] = ["orbitalProcessNoiseProviderType", "cartesianCovarianceMatrixPerUnitTime"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TimeLinearNoiseProvider from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cartesian_covariance_matrix_per_unit_time
        if self.cartesian_covariance_matrix_per_unit_time:
            _dict['cartesianCovarianceMatrixPerUnitTime'] = self.cartesian_covariance_matrix_per_unit_time.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TimeLinearNoiseProvider from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orbitalProcessNoiseProviderType": obj.get("orbitalProcessNoiseProviderType"),
            "cartesianCovarianceMatrixPerUnitTime": CartesianProcessNoiseDiagonalMatrix.from_dict(obj["cartesianCovarianceMatrixPerUnitTime"]) if obj.get("cartesianCovarianceMatrixPerUnitTime") is not None else None
        })
        return _obj


