# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.drag_coefficient_estimation_request import DragCoefficientEstimationRequest
from spacetower_orbit_determination_python_client.models.reflectivity_coefficient_estimation_request import ReflectivityCoefficientEstimationRequest
from spacetower_orbit_determination_python_client.models.satellite_clock_offset_estimation_request import SatelliteClockOffsetEstimationRequest
from spacetower_orbit_determination_python_client.models.thrust_scale_factor_estimation_request import ThrustScaleFactorEstimationRequest
from typing import Optional, Set
from typing_extensions import Self

class EstimatedModelParametersConfiguration(BaseModel):
    """
    Configuration for estimation of non orbital parameters.<br> These can be model parameters like drag or reflection coefficient. By default these are not estimated 
    """ # noqa: E501
    thrust_scale_factors_estimation: Optional[ThrustScaleFactorEstimationRequest] = Field(default=None, alias="thrustScaleFactorsEstimation")
    satellite_clock_offset_estimation: Optional[SatelliteClockOffsetEstimationRequest] = Field(default=None, alias="satelliteClockOffsetEstimation")
    drag_coefficient_estimation: Optional[DragCoefficientEstimationRequest] = Field(default=None, alias="dragCoefficientEstimation")
    reflectivity_coefficient_estimation: Optional[ReflectivityCoefficientEstimationRequest] = Field(default=None, alias="reflectivityCoefficientEstimation")
    __properties: ClassVar[List[str]] = ["thrustScaleFactorsEstimation", "satelliteClockOffsetEstimation", "dragCoefficientEstimation", "reflectivityCoefficientEstimation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EstimatedModelParametersConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of thrust_scale_factors_estimation
        if self.thrust_scale_factors_estimation:
            _dict['thrustScaleFactorsEstimation'] = self.thrust_scale_factors_estimation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of satellite_clock_offset_estimation
        if self.satellite_clock_offset_estimation:
            _dict['satelliteClockOffsetEstimation'] = self.satellite_clock_offset_estimation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of drag_coefficient_estimation
        if self.drag_coefficient_estimation:
            _dict['dragCoefficientEstimation'] = self.drag_coefficient_estimation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reflectivity_coefficient_estimation
        if self.reflectivity_coefficient_estimation:
            _dict['reflectivityCoefficientEstimation'] = self.reflectivity_coefficient_estimation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EstimatedModelParametersConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "thrustScaleFactorsEstimation": ThrustScaleFactorEstimationRequest.from_dict(obj["thrustScaleFactorsEstimation"]) if obj.get("thrustScaleFactorsEstimation") is not None else None,
            "satelliteClockOffsetEstimation": SatelliteClockOffsetEstimationRequest.from_dict(obj["satelliteClockOffsetEstimation"]) if obj.get("satelliteClockOffsetEstimation") is not None else None,
            "dragCoefficientEstimation": DragCoefficientEstimationRequest.from_dict(obj["dragCoefficientEstimation"]) if obj.get("dragCoefficientEstimation") is not None else None,
            "reflectivityCoefficientEstimation": ReflectivityCoefficientEstimationRequest.from_dict(obj["reflectivityCoefficientEstimation"]) if obj.get("reflectivityCoefficientEstimation") is not None else None
        })
        return _obj


