# spacetower_orbit_determination_python_client
Orbit Determination API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.2
- Package version: 0.1.2
- Generator version: 7.6.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import spacetower_orbit_determination_python_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import spacetower_orbit_determination_python_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import spacetower_orbit_determination_python_client
from spacetower_orbit_determination_python_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://orbit-determination.exoops.57.128.40.142.sslip.io
# See configuration.py for a list of all supported configuration parameters.
configuration = spacetower_orbit_determination_python_client.Configuration(
    host = "http://orbit-determination.exoops.57.128.40.142.sslip.io"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: BearerAuth
configuration = spacetower_orbit_determination_python_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with spacetower_orbit_determination_python_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = spacetower_orbit_determination_python_client.DefaultApi(api_client)
    numerical_estimation_request = spacetower_orbit_determination_python_client.NumericalEstimationRequest() # NumericalEstimationRequest |  (optional)

    try:
        # Orbit determination with numerical propagation
        api_response = api_instance.determine_orbit(numerical_estimation_request=numerical_estimation_request)
        print("The response of DefaultApi->determine_orbit:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->determine_orbit: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://orbit-determination.exoops.57.128.40.142.sslip.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**determine_orbit**](docs/DefaultApi.md#determine_orbit) | **POST** /estimation/numerical | Orbit determination with numerical propagation
*DefaultApi* | [**determine_tle**](docs/DefaultApi.md#determine_tle) | **POST** /estimation/tle | Orbit determination with SGP4 model


## Documentation For Models

 - [AnomalyType](docs/AnomalyType.md)
 - [AtmosphereModel](docs/AtmosphereModel.md)
 - [AtmosphereType](docs/AtmosphereType.md)
 - [AtmosphericDragPerturbation](docs/AtmosphericDragPerturbation.md)
 - [AttitudeBasedFiniteThrustSchedule](docs/AttitudeBasedFiniteThrustSchedule.md)
 - [AttitudeLaw](docs/AttitudeLaw.md)
 - [AttitudeLawType](docs/AttitudeLawType.md)
 - [AttitudeSequence](docs/AttitudeSequence.md)
 - [AttitudeSequenceType](docs/AttitudeSequenceType.md)
 - [BatchFilterInitialGuessConfiguration](docs/BatchFilterInitialGuessConfiguration.md)
 - [BatchFilterOrbitDetermination](docs/BatchFilterOrbitDetermination.md)
 - [BoxObject](docs/BoxObject.md)
 - [CartesianCovarianceAllowedFrame](docs/CartesianCovarianceAllowedFrame.md)
 - [CartesianCovarianceMatrix](docs/CartesianCovarianceMatrix.md)
 - [CartesianOrbit](docs/CartesianOrbit.md)
 - [CartesianProcessNoiseDiagonalMatrix](docs/CartesianProcessNoiseDiagonalMatrix.md)
 - [CelestialBody](docs/CelestialBody.md)
 - [CelestialBodyConfiguration](docs/CelestialBodyConfiguration.md)
 - [CelestialBodyName](docs/CelestialBodyName.md)
 - [CircularOrbit](docs/CircularOrbit.md)
 - [ConstantNoiseProvider](docs/ConstantNoiseProvider.md)
 - [DateTriggeredAttitude](docs/DateTriggeredAttitude.md)
 - [DateTriggeredAttitudeSequence](docs/DateTriggeredAttitudeSequence.md)
 - [DatedCovarianceMatrix](docs/DatedCovarianceMatrix.md)
 - [DatedCovarianceMatrixSet](docs/DatedCovarianceMatrixSet.md)
 - [DatedLofFiniteThrustDirection](docs/DatedLofFiniteThrustDirection.md)
 - [DatedResiduals](docs/DatedResiduals.md)
 - [DragCoefficientEstimationRequest](docs/DragCoefficientEstimationRequest.md)
 - [EarthCenteredFrameType](docs/EarthCenteredFrameType.md)
 - [EarthFixedFrameIdentifier](docs/EarthFixedFrameIdentifier.md)
 - [EarthOrientedManeuverAttitudeLaw](docs/EarthOrientedManeuverAttitudeLaw.md)
 - [EarthPotentialPerturbation](docs/EarthPotentialPerturbation.md)
 - [EllipsoidIdentifier](docs/EllipsoidIdentifier.md)
 - [EquinoctialOrbit](docs/EquinoctialOrbit.md)
 - [EstimatedModelParametersConfiguration](docs/EstimatedModelParametersConfiguration.md)
 - [EstimatedOrbitType](docs/EstimatedOrbitType.md)
 - [EstimatorType](docs/EstimatorType.md)
 - [FieldDescription](docs/FieldDescription.md)
 - [FiniteThrustDefinition](docs/FiniteThrustDefinition.md)
 - [FixedIntegratorType](docs/FixedIntegratorType.md)
 - [FixedStepIntegratorConfiguration](docs/FixedStepIntegratorConfiguration.md)
 - [FrameIdentifier](docs/FrameIdentifier.md)
 - [GpsNmeaInputMeasurements](docs/GpsNmeaInputMeasurements.md)
 - [GroundStation](docs/GroundStation.md)
 - [HarrisPriesterAtmosphere](docs/HarrisPriesterAtmosphere.md)
 - [InertialFrameIdentifier](docs/InertialFrameIdentifier.md)
 - [InputMeasurements](docs/InputMeasurements.md)
 - [IntegratorConfiguration](docs/IntegratorConfiguration.md)
 - [IntegratorType](docs/IntegratorType.md)
 - [IsotropicObject](docs/IsotropicObject.md)
 - [KalmanResiduals](docs/KalmanResiduals.md)
 - [KalmanResult](docs/KalmanResult.md)
 - [KeplerianOrbit](docs/KeplerianOrbit.md)
 - [LofAttitudeLaw](docs/LofAttitudeLaw.md)
 - [LofBasedFiniteThrustSequence](docs/LofBasedFiniteThrustSequence.md)
 - [LofBasedManeuverSchedule](docs/LofBasedManeuverSchedule.md)
 - [LofType](docs/LofType.md)
 - [ManeuverDirectionType](docs/ManeuverDirectionType.md)
 - [ManeuverSchedule](docs/ManeuverSchedule.md)
 - [ManeuverScheduleType](docs/ManeuverScheduleType.md)
 - [MeanOsculatingOrbitType](docs/MeanOsculatingOrbitType.md)
 - [MeasurementType](docs/MeasurementType.md)
 - [Moon](docs/Moon.md)
 - [NadirPointingLaw](docs/NadirPointingLaw.md)
 - [NrlMsise00Atmosphere](docs/NrlMsise00Atmosphere.md)
 - [NumericalEstimationParameters](docs/NumericalEstimationParameters.md)
 - [NumericalEstimationRequest](docs/NumericalEstimationRequest.md)
 - [NumericalEstimationResult](docs/NumericalEstimationResult.md)
 - [Orbit](docs/Orbit.md)
 - [OrbitType](docs/OrbitType.md)
 - [OrbitalCovarianceMatrix](docs/OrbitalCovarianceMatrix.md)
 - [OrbitalElementsCovarianceMatrix](docs/OrbitalElementsCovarianceMatrix.md)
 - [OrbitalParameterType](docs/OrbitalParameterType.md)
 - [OrbitalProcessNoiseProvider](docs/OrbitalProcessNoiseProvider.md)
 - [OrbitalProcessNoiseProviderType](docs/OrbitalProcessNoiseProviderType.md)
 - [OsculatingToMeanConfiguration](docs/OsculatingToMeanConfiguration.md)
 - [OutputModelParameters](docs/OutputModelParameters.md)
 - [ParameterEstimationRequest](docs/ParameterEstimationRequest.md)
 - [Perturbation](docs/Perturbation.md)
 - [PerturbationType](docs/PerturbationType.md)
 - [PerturbationsConfiguration](docs/PerturbationsConfiguration.md)
 - [PositionInputMeasurements](docs/PositionInputMeasurements.md)
 - [PositionVelocityInputMeasurements](docs/PositionVelocityInputMeasurements.md)
 - [PostProcessConfiguration](docs/PostProcessConfiguration.md)
 - [PropagationConfiguration](docs/PropagationConfiguration.md)
 - [PropulsionSystem](docs/PropulsionSystem.md)
 - [RadiationCoefficients](docs/RadiationCoefficients.md)
 - [RadiationCoefficientsType](docs/RadiationCoefficientsType.md)
 - [ReferenceFramesConfiguration](docs/ReferenceFramesConfiguration.md)
 - [ReflectionAbsorptionCoefficients](docs/ReflectionAbsorptionCoefficients.md)
 - [ReflectivityCoefficientEstimationRequest](docs/ReflectivityCoefficientEstimationRequest.md)
 - [Residuals](docs/Residuals.md)
 - [SatelliteClockOffsetEstimationRequest](docs/SatelliteClockOffsetEstimationRequest.md)
 - [SequentialFilterType](docs/SequentialFilterType.md)
 - [ShadowModelType](docs/ShadowModelType.md)
 - [SingleRadiationCoefficient](docs/SingleRadiationCoefficient.md)
 - [SolarArrayGeometry](docs/SolarArrayGeometry.md)
 - [SolarArraySystem](docs/SolarArraySystem.md)
 - [SolarRadiationPressurePerturbation](docs/SolarRadiationPressurePerturbation.md)
 - [SolidTidesPerturbation](docs/SolidTidesPerturbation.md)
 - [SpaceObject](docs/SpaceObject.md)
 - [SpaceObjectType](docs/SpaceObjectType.md)
 - [SpectralDensityMatrix](docs/SpectralDensityMatrix.md)
 - [StateNoiseCompensationProvider](docs/StateNoiseCompensationProvider.md)
 - [StaticOutlierFilter](docs/StaticOutlierFilter.md)
 - [StationMask](docs/StationMask.md)
 - [Sun](docs/Sun.md)
 - [SunEnhancedManeuverAttitudeLaw](docs/SunEnhancedManeuverAttitudeLaw.md)
 - [SunPointingLaw](docs/SunPointingLaw.md)
 - [TLE](docs/TLE.md)
 - [ThirdBodiesGravityPerturbation](docs/ThirdBodiesGravityPerturbation.md)
 - [ThrustScaleFactorEstimationRequest](docs/ThrustScaleFactorEstimationRequest.md)
 - [Thruster](docs/Thruster.md)
 - [TimeLinearNoiseProvider](docs/TimeLinearNoiseProvider.md)
 - [TimestampedOutputData](docs/TimestampedOutputData.md)
 - [TleEstimationRequest](docs/TleEstimationRequest.md)
 - [TleEstimationResult](docs/TleEstimationResult.md)
 - [TwoLineElementOrbit](docs/TwoLineElementOrbit.md)
 - [UnscentedKalmanFilterConfiguration](docs/UnscentedKalmanFilterConfiguration.md)
 - [UnscentedKalmanFilterInitialGuessConfiguration](docs/UnscentedKalmanFilterInitialGuessConfiguration.md)
 - [UnscentedKalmanFilterOrbitDetermination](docs/UnscentedKalmanFilterOrbitDetermination.md)
 - [UnscentedTransformConfiguration](docs/UnscentedTransformConfiguration.md)
 - [VariableStepIntegratorConfiguration](docs/VariableStepIntegratorConfiguration.md)
 - [VariableStepIntegratorType](docs/VariableStepIntegratorType.md)
 - [Vector3D](docs/Vector3D.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="BearerAuth"></a>
### BearerAuth

- **Type**: Bearer authentication


## Author




