# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.1.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from spacetower_orbit_determination_python_client.models.attitude_sequence import AttitudeSequence
from spacetower_orbit_determination_python_client.models.batch_filter_initial_guess_configuration import BatchFilterInitialGuessConfiguration
from spacetower_orbit_determination_python_client.models.estimator_type import EstimatorType
from spacetower_orbit_determination_python_client.models.input_measurements import InputMeasurements
from spacetower_orbit_determination_python_client.models.numerical_estimation_parameters import NumericalEstimationParameters
from spacetower_orbit_determination_python_client.models.numerical_estimation_request import NumericalEstimationRequest
from spacetower_orbit_determination_python_client.models.post_process_configuration import PostProcessConfiguration
from spacetower_orbit_determination_python_client.models.propagation_configuration import PropagationConfiguration
from typing import Optional, Set
from typing_extensions import Self

class BatchFilterOrbitDetermination(NumericalEstimationRequest):
    """
    Configuration for batch filters
    """ # noqa: E501
    initial_guess_configuration: BatchFilterInitialGuessConfiguration = Field(alias="initialGuessConfiguration")
    __properties: ClassVar[List[str]] = ["attitudeSequence", "estimatorType", "inputMeasurementsSet", "dynamicsAndFramesConfiguration", "estimationConfiguration", "postProcessConfiguration", "data", "initialGuessConfiguration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BatchFilterOrbitDetermination from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of attitude_sequence
        if self.attitude_sequence:
            _dict['attitudeSequence'] = self.attitude_sequence.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in input_measurements_set (list)
        _items = []
        if self.input_measurements_set:
            for _item in self.input_measurements_set:
                if _item:
                    _items.append(_item.to_dict())
            _dict['inputMeasurementsSet'] = _items
        # override the default output from pydantic by calling `to_dict()` of dynamics_and_frames_configuration
        if self.dynamics_and_frames_configuration:
            _dict['dynamicsAndFramesConfiguration'] = self.dynamics_and_frames_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of estimation_configuration
        if self.estimation_configuration:
            _dict['estimationConfiguration'] = self.estimation_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of post_process_configuration
        if self.post_process_configuration:
            _dict['postProcessConfiguration'] = self.post_process_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of initial_guess_configuration
        if self.initial_guess_configuration:
            _dict['initialGuessConfiguration'] = self.initial_guess_configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BatchFilterOrbitDetermination from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attitudeSequence": AttitudeSequence.from_dict(obj["attitudeSequence"]) if obj.get("attitudeSequence") is not None else None,
            "estimatorType": obj.get("estimatorType"),
            "inputMeasurementsSet": [InputMeasurements.from_dict(_item) for _item in obj["inputMeasurementsSet"]] if obj.get("inputMeasurementsSet") is not None else None,
            "dynamicsAndFramesConfiguration": PropagationConfiguration.from_dict(obj["dynamicsAndFramesConfiguration"]) if obj.get("dynamicsAndFramesConfiguration") is not None else None,
            "estimationConfiguration": NumericalEstimationParameters.from_dict(obj["estimationConfiguration"]) if obj.get("estimationConfiguration") is not None else None,
            "postProcessConfiguration": PostProcessConfiguration.from_dict(obj["postProcessConfiguration"]) if obj.get("postProcessConfiguration") is not None else None,
            "data": obj.get("data"),
            "initialGuessConfiguration": BatchFilterInitialGuessConfiguration.from_dict(obj["initialGuessConfiguration"]) if obj.get("initialGuessConfiguration") is not None else None
        })
        return _obj


