# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.1.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_determination_python_client.models.station_mask import StationMask
from typing import Optional, Set
from typing_extensions import Self

class GroundStation(BaseModel):
    """
    A point on the Earth's surface representing a ground station
    """ # noqa: E501
    name: StrictStr
    longitude: Union[StrictFloat, StrictInt] = Field(description="Units [rad]")
    latitude: Union[StrictFloat, StrictInt] = Field(description="Geodetic latitude. Units [rad]")
    altitude: Union[StrictFloat, StrictInt] = Field(description="Geodetic altitude. Units [m]")
    minimum_elevation: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Minimum elevation. Units [rad]", alias="minimumElevation")
    station_mask: Optional[StationMask] = Field(default=None, alias="stationMask")
    __properties: ClassVar[List[str]] = ["name", "longitude", "latitude", "altitude", "minimumElevation", "stationMask"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GroundStation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of station_mask
        if self.station_mask:
            _dict['stationMask'] = self.station_mask.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GroundStation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "longitude": obj.get("longitude"),
            "latitude": obj.get("latitude"),
            "altitude": obj.get("altitude"),
            "minimumElevation": obj.get("minimumElevation") if obj.get("minimumElevation") is not None else 0.0,
            "stationMask": StationMask.from_dict(obj["stationMask"]) if obj.get("stationMask") is not None else None
        })
        return _obj


