# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.1.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_determination_python_client.models.field_description import FieldDescription
from spacetower_orbit_determination_python_client.models.measurement_type import MeasurementType
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from spacetower_orbit_determination_python_client.models.gps_nmea_input_measurements import GpsNmeaInputMeasurements
    from spacetower_orbit_determination_python_client.models.position_input_measurements import PositionInputMeasurements
    from spacetower_orbit_determination_python_client.models.position_velocity_input_measurements import PositionVelocityInputMeasurements

class InputMeasurements(BaseModel):
    """
    Generic dated-weighted measurement series with field descriptions
    """ # noqa: E501
    dates: List[str]
    description: Optional[List[FieldDescription]] = None
    measurement_type: MeasurementType = Field(alias="measurementType")
    __properties: ClassVar[List[str]] = ["dates", "description", "measurementType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'measurementType'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'GPS_NMEA': 'GpsNmeaInputMeasurements','POSITION': 'PositionInputMeasurements','POSITION_VELOCITY': 'PositionVelocityInputMeasurements'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[GpsNmeaInputMeasurements, PositionInputMeasurements, PositionVelocityInputMeasurements]]:
        """Create an instance of InputMeasurements from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in description (list)
        _items = []
        if self.description:
            for _item in self.description:
                if _item:
                    _items.append(_item.to_dict())
            _dict['description'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[GpsNmeaInputMeasurements, PositionInputMeasurements, PositionVelocityInputMeasurements]]:
        """Create an instance of InputMeasurements from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'GpsNmeaInputMeasurements':
            return import_module("spacetower_orbit_determination_python_client.models.gps_nmea_input_measurements").GpsNmeaInputMeasurements.from_dict(obj)
        if object_type ==  'PositionInputMeasurements':
            return import_module("spacetower_orbit_determination_python_client.models.position_input_measurements").PositionInputMeasurements.from_dict(obj)
        if object_type ==  'PositionVelocityInputMeasurements':
            return import_module("spacetower_orbit_determination_python_client.models.position_velocity_input_measurements").PositionVelocityInputMeasurements.from_dict(obj)

        raise ValueError("InputMeasurements failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


