# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.1.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class OutputModelParameters(BaseModel):
    """
    The values of the estimate for the different model parameters. Their uncertainties are in the  ```outputDatedCovarianceMatrices```. 
    """ # noqa: E501
    dates: Optional[List[str]] = Field(default=None, description="Dates of provided estimated values")
    estimated_drag_coefficients: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="Estimated values for the drag coefficient. Different entries correspond to the estimates at the different   measurement dates. Units [-] ", alias="estimatedDragCoefficients")
    estimated_reflection_coefficients: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="Estimated values for the reflection coefficient. Different entries correspond to the estimates at the different measurement dates. Units [-] ", alias="estimatedReflectionCoefficients")
    estimated_satellite_clock_offsets: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="Estimated values for the satellite clock offset. Different entries correspond to the estimates at the different measurement dates. Units [-] ", alias="estimatedSatelliteClockOffsets")
    estimated_thrust_scale_factors_result: Optional[List[List[Union[StrictFloat, StrictInt]]]] = Field(default=None, description="Estimated values for the thrust scale factors (x, y, z). Different entries correspond to the estimates at the different measurement dates. Units [-] ", alias="estimatedThrustScaleFactorsResult")
    __properties: ClassVar[List[str]] = ["dates", "estimatedDragCoefficients", "estimatedReflectionCoefficients", "estimatedSatelliteClockOffsets", "estimatedThrustScaleFactorsResult"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OutputModelParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OutputModelParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dates": obj.get("dates"),
            "estimatedDragCoefficients": obj.get("estimatedDragCoefficients"),
            "estimatedReflectionCoefficients": obj.get("estimatedReflectionCoefficients"),
            "estimatedSatelliteClockOffsets": obj.get("estimatedSatelliteClockOffsets"),
            "estimatedThrustScaleFactorsResult": obj.get("estimatedThrustScaleFactorsResult")
        })
        return _obj


