# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.1.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.integrator_configuration import IntegratorConfiguration
from spacetower_orbit_determination_python_client.models.maneuver_schedule import ManeuverSchedule
from spacetower_orbit_determination_python_client.models.perturbations_configuration import PerturbationsConfiguration
from spacetower_orbit_determination_python_client.models.reference_frames_configuration import ReferenceFramesConfiguration
from typing import Optional, Set
from typing_extensions import Self

class PropagationConfiguration(BaseModel):
    """
    
    """ # noqa: E501
    perturbations_configuration: Optional[PerturbationsConfiguration] = Field(default=None, alias="perturbationsConfiguration")
    maneuver_schedule: Optional[ManeuverSchedule] = Field(default=None, alias="maneuverSchedule")
    reference_frames_configuration: Optional[ReferenceFramesConfiguration] = Field(default=None, alias="referenceFramesConfiguration")
    integrator_configuration: Optional[IntegratorConfiguration] = Field(default=None, alias="integratorConfiguration")
    __properties: ClassVar[List[str]] = ["perturbationsConfiguration", "maneuverSchedule", "referenceFramesConfiguration", "integratorConfiguration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PropagationConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of perturbations_configuration
        if self.perturbations_configuration:
            _dict['perturbationsConfiguration'] = self.perturbations_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of maneuver_schedule
        if self.maneuver_schedule:
            _dict['maneuverSchedule'] = self.maneuver_schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reference_frames_configuration
        if self.reference_frames_configuration:
            _dict['referenceFramesConfiguration'] = self.reference_frames_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of integrator_configuration
        if self.integrator_configuration:
            _dict['integratorConfiguration'] = self.integrator_configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PropagationConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "perturbationsConfiguration": PerturbationsConfiguration.from_dict(obj["perturbationsConfiguration"]) if obj.get("perturbationsConfiguration") is not None else None,
            "maneuverSchedule": ManeuverSchedule.from_dict(obj["maneuverSchedule"]) if obj.get("maneuverSchedule") is not None else None,
            "referenceFramesConfiguration": ReferenceFramesConfiguration.from_dict(obj["referenceFramesConfiguration"]) if obj.get("referenceFramesConfiguration") is not None else None,
            "integratorConfiguration": IntegratorConfiguration.from_dict(obj["integratorConfiguration"]) if obj.get("integratorConfiguration") is not None else None
        })
        return _obj


