# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.1.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.earth_fixed_frame_identifier import EarthFixedFrameIdentifier
from spacetower_orbit_determination_python_client.models.ellipsoid_identifier import EllipsoidIdentifier
from spacetower_orbit_determination_python_client.models.inertial_frame_identifier import InertialFrameIdentifier
from typing import Optional, Set
from typing_extensions import Self

class ReferenceFramesConfiguration(BaseModel):
    """
    Configuration of reference frames and model options that are used throughout the simulation
    """ # noqa: E501
    earth_centered_inertial_frame: InertialFrameIdentifier = Field(alias="earthCenteredInertialFrame")
    earth_centered_fixed_frame: Optional[EarthFixedFrameIdentifier] = Field(default=None, alias="earthCenteredFixedFrame")
    ellipsoid_model: Optional[EllipsoidIdentifier] = Field(default=None, alias="ellipsoidModel")
    include_tidal_effects_in_eop_interpolation: Optional[StrictBool] = Field(default=False, description="Flag to include tidal effects when interpolation Earth Orientation Parameters (comes with a higher computational cost, so default is false)", alias="includeTidalEffectsInEopInterpolation")
    __properties: ClassVar[List[str]] = ["earthCenteredInertialFrame", "earthCenteredFixedFrame", "ellipsoidModel", "includeTidalEffectsInEopInterpolation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReferenceFramesConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReferenceFramesConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "earthCenteredInertialFrame": obj.get("earthCenteredInertialFrame"),
            "earthCenteredFixedFrame": obj.get("earthCenteredFixedFrame"),
            "ellipsoidModel": obj.get("ellipsoidModel"),
            "includeTidalEffectsInEopInterpolation": obj.get("includeTidalEffectsInEopInterpolation") if obj.get("includeTidalEffectsInEopInterpolation") is not None else False
        })
        return _obj


