# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.1.3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from spacetower_orbit_determination_python_client.models.mean_osculating_orbit_type import MeanOsculatingOrbitType
from spacetower_orbit_determination_python_client.models.orbit_type import OrbitType
from typing import Optional, Set
from typing_extensions import Self

class PostProcessConfiguration(BaseModel):
    """
    Configuration for post processing of estimation results. If mean orbits are requested, the following theories should be used to average them, considering an non-normalized gravity field with order and degree equal to 6:<br> Select:<br> - ```MEAN_ECKSTEIN_HECHLER``` theory for ```CIRCULAR``` outputOrbitType - ```MEAN_DSST_6X0``` theory for ```EQUINOCTIAL``` outputOrbitType - ```MEAN_BROUWER_LYDDANE``` theory for ```KEPLERIAN``` outputOrbitType 
    """ # noqa: E501
    output_orbit_type: OrbitType = Field(alias="outputOrbitType")
    output_mean_osc_type: MeanOsculatingOrbitType = Field(alias="outputMeanOscType")
    __properties: ClassVar[List[str]] = ["outputOrbitType", "outputMeanOscType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostProcessConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostProcessConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "outputOrbitType": obj.get("outputOrbitType"),
            "outputMeanOscType": obj.get("outputMeanOscType")
        })
        return _obj


