# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.1.3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.orbit import Orbit
from spacetower_orbit_determination_python_client.models.orbital_covariance_matrix import OrbitalCovarianceMatrix
from spacetower_orbit_determination_python_client.models.space_object import SpaceObject
from typing import Optional, Set
from typing_extensions import Self

class UnscentedKalmanFilterInitialGuessConfiguration(BaseModel):
    """
    
    """ # noqa: E501
    initial_orbit: Orbit = Field(alias="initialOrbit")
    space_object: Optional[SpaceObject] = Field(default=None, alias="spaceObject")
    initial_orbital_covariance: Optional[OrbitalCovarianceMatrix] = Field(default=None, alias="initialOrbitalCovariance")
    __properties: ClassVar[List[str]] = ["initialOrbit", "spaceObject", "initialOrbitalCovariance"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UnscentedKalmanFilterInitialGuessConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of initial_orbit
        if self.initial_orbit:
            _dict['initialOrbit'] = self.initial_orbit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of space_object
        if self.space_object:
            _dict['spaceObject'] = self.space_object.to_dict()
        # override the default output from pydantic by calling `to_dict()` of initial_orbital_covariance
        if self.initial_orbital_covariance:
            _dict['initialOrbitalCovariance'] = self.initial_orbital_covariance.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UnscentedKalmanFilterInitialGuessConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "initialOrbit": Orbit.from_dict(obj["initialOrbit"]) if obj.get("initialOrbit") is not None else None,
            "spaceObject": SpaceObject.from_dict(obj["spaceObject"]) if obj.get("spaceObject") is not None else None,
            "initialOrbitalCovariance": OrbitalCovarianceMatrix.from_dict(obj["initialOrbitalCovariance"]) if obj.get("initialOrbitalCovariance") is not None else None
        })
        return _obj


