# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.perturbation import Perturbation
from spacetower_orbit_determination_python_client.models.perturbation_type import PerturbationType
from typing import Optional, Set
from typing_extensions import Self

class EarthPotentialPerturbation(Perturbation):
    """
    A mathematical model of the Earth gravitational potential (with spherical harmonics)
    """ # noqa: E501
    degree: Optional[StrictInt] = 2
    order: Optional[StrictInt] = Field(default=0, description="Cannot be greater than the degree")
    __properties: ClassVar[List[str]] = ["perturbationType", "degree", "order"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EarthPotentialPerturbation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EarthPotentialPerturbation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "perturbationType": obj.get("perturbationType"),
            "degree": obj.get("degree") if obj.get("degree") is not None else 2,
            "order": obj.get("order") if obj.get("order") is not None else 0
        })
        return _obj


