# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.dated_residuals import DatedResiduals
from spacetower_orbit_determination_python_client.models.estimator_type import EstimatorType
from spacetower_orbit_determination_python_client.models.field_description import FieldDescription
from spacetower_orbit_determination_python_client.models.residuals import Residuals
from typing import Optional, Set
from typing_extensions import Self

class KalmanResiduals(DatedResiduals):
    """
    Kalman lists of pre-fit and post-fit residual datasets
    """ # noqa: E501
    pre_fit_residuals: Optional[Residuals] = Field(default=None, alias="preFitResiduals")
    post_fit_residuals: Optional[Residuals] = Field(default=None, alias="postFitResiduals")
    __properties: ClassVar[List[str]] = ["estimatorType", "dates", "rejectionStatus", "description", "preFitResiduals", "postFitResiduals"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KalmanResiduals from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in description (list)
        _items = []
        if self.description:
            for _item in self.description:
                if _item:
                    _items.append(_item.to_dict())
            _dict['description'] = _items
        # override the default output from pydantic by calling `to_dict()` of pre_fit_residuals
        if self.pre_fit_residuals:
            _dict['preFitResiduals'] = self.pre_fit_residuals.to_dict()
        # override the default output from pydantic by calling `to_dict()` of post_fit_residuals
        if self.post_fit_residuals:
            _dict['postFitResiduals'] = self.post_fit_residuals.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KalmanResiduals from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "estimatorType": obj.get("estimatorType"),
            "dates": obj.get("dates"),
            "rejectionStatus": obj.get("rejectionStatus"),
            "description": [FieldDescription.from_dict(_item) for _item in obj["description"]] if obj.get("description") is not None else None,
            "preFitResiduals": Residuals.from_dict(obj["preFitResiduals"]) if obj.get("preFitResiduals") is not None else None,
            "postFitResiduals": Residuals.from_dict(obj["postFitResiduals"]) if obj.get("postFitResiduals") is not None else None
        })
        return _obj


