# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class KalmanThrustScaleFactorsEstimationRequest(BaseModel):
    """
    If activated, three scale factors (one per direction component) are added to the estimated parameters. If one of the direction component is set to zero by the suer, then it is replaced by a very small value and the scale factor weights on it
    """ # noqa: E501
    scale_factor_x_initial_standard_deviation: Union[StrictFloat, StrictInt] = Field(alias="scaleFactorXInitialStandardDeviation")
    scale_factor_y_initial_standard_deviation: Union[StrictFloat, StrictInt] = Field(alias="scaleFactorYInitialStandardDeviation")
    scale_factor_z_initial_standard_deviation: Union[StrictFloat, StrictInt] = Field(alias="scaleFactorZInitialStandardDeviation")
    scale_factor_x_process_noise_standard_deviation: Union[StrictFloat, StrictInt] = Field(alias="scaleFactorXProcessNoiseStandardDeviation")
    scale_factor_y_process_noise_standard_deviation: Union[StrictFloat, StrictInt] = Field(alias="scaleFactorYProcessNoiseStandardDeviation")
    scale_factor_z_process_noise_standard_deviation: Union[StrictFloat, StrictInt] = Field(alias="scaleFactorZProcessNoiseStandardDeviation")
    __properties: ClassVar[List[str]] = ["scaleFactorXInitialStandardDeviation", "scaleFactorYInitialStandardDeviation", "scaleFactorZInitialStandardDeviation", "scaleFactorXProcessNoiseStandardDeviation", "scaleFactorYProcessNoiseStandardDeviation", "scaleFactorZProcessNoiseStandardDeviation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KalmanThrustScaleFactorsEstimationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KalmanThrustScaleFactorsEstimationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "scaleFactorXInitialStandardDeviation": obj.get("scaleFactorXInitialStandardDeviation"),
            "scaleFactorYInitialStandardDeviation": obj.get("scaleFactorYInitialStandardDeviation"),
            "scaleFactorZInitialStandardDeviation": obj.get("scaleFactorZInitialStandardDeviation"),
            "scaleFactorXProcessNoiseStandardDeviation": obj.get("scaleFactorXProcessNoiseStandardDeviation"),
            "scaleFactorYProcessNoiseStandardDeviation": obj.get("scaleFactorYProcessNoiseStandardDeviation"),
            "scaleFactorZProcessNoiseStandardDeviation": obj.get("scaleFactorZProcessNoiseStandardDeviation")
        })
        return _obj


